/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.ve.internal.cde.core.ContentPaneFigure;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.VisualComponentsLayoutPolicy;
import org.eclipse.ve.internal.cde.emf.EditPartAdapterRunnable;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.jfc.core.ComponentGraphicalEditPart;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.JSplitPaneLayoutEditPolicy;
import org.eclipse.ve.internal.jfc.core.NonBoundsBeanPropertySource;

public class JSplitPaneGraphicalEditPart
extends ComponentGraphicalEditPart {
    private Adapter containerAdapter = new EditPartAdapterRunnable((EditPart)this){

        protected void doRun() {
            JSplitPaneGraphicalEditPart.this.refreshChildren();
        }

        public void notifyChanged(Notification msg) {
            Object feature = msg.getFeature();
            if (feature == JSplitPaneGraphicalEditPart.this.sfLeftComponent || feature == JSplitPaneGraphicalEditPart.this.sfRightComponent || feature == JSplitPaneGraphicalEditPart.this.sfTopComponent || feature == JSplitPaneGraphicalEditPart.this.sfBottomComponent || feature == JSplitPaneGraphicalEditPart.this.sf_containerComponents) {
                this.queueExec((EditPart)JSplitPaneGraphicalEditPart.this, "COMPONENTS");
            }
        }
    };
    protected EStructuralFeature sfLeftComponent;
    protected EStructuralFeature sfRightComponent;
    protected EStructuralFeature sfTopComponent;
    protected EStructuralFeature sfBottomComponent;
    protected EStructuralFeature sf_constraintComponent;
    protected EStructuralFeature sf_containerComponents;

    public JSplitPaneGraphicalEditPart(Object model) {
        super(model);
    }

    protected EditPart createChild(Object model) {
        EditPart ep = super.createChild(model);
        ((ComponentGraphicalEditPart)ep).setPropertySource(new NonBoundsBeanPropertySource((Notifier)((EObject)model)));
        ((ComponentGraphicalEditPart)ep).setTransparent(true);
        return ep;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("com.ibm.etools.visualcomponentslayoutpolicy", (EditPolicy)new VisualComponentsLayoutPolicy(false));
        this.createLayoutEditPolicy();
    }

    protected void createLayoutEditPolicy() {
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new JSplitPaneLayoutEditPolicy(EditDomain.getEditDomain((EditPart)this)));
    }

    protected IFigure createFigure() {
        ContentPaneFigure cf = (ContentPaneFigure)super.createFigure();
        cf.getContentPane().setLayoutManager((LayoutManager)new XYLayout());
        return cf;
    }

    public void activate() {
        super.activate();
        ((EObject)this.getModel()).eAdapters().add((Object)this.containerAdapter);
    }

    public void deactivate() {
        super.deactivate();
        ((EObject)this.getModel()).eAdapters().remove((Object)this.containerAdapter);
    }

    public List getModelChildren() {
        ArrayList<Object> result = new ArrayList<Object>();
        Object leftComponent = ((EObject)this.getModel()).eGet(this.sfLeftComponent);
        Object topComponent = ((EObject)this.getModel()).eGet(this.sfTopComponent);
        Object rightComponent = ((EObject)this.getModel()).eGet(this.sfRightComponent);
        Object bottomComponent = ((EObject)this.getModel()).eGet(this.sfBottomComponent);
        if (leftComponent != null) {
            result.add(leftComponent);
        } else if (topComponent != null) {
            result.add(topComponent);
        }
        if (rightComponent != null) {
            result.add(rightComponent);
        } else if (bottomComponent != null) {
            result.add(bottomComponent);
        }
        List componentList = this.getConstraintComponentsModelChildren();
        if (!componentList.isEmpty()) {
            int i = 0;
            while (i < componentList.size()) {
                result.add(componentList.get(i));
                ++i;
            }
        }
        return result;
    }

    protected List getConstraintComponentsModelChildren() {
        List constraintChildren = (List)((EObject)this.getModel()).eGet(this.sf_containerComponents);
        ArrayList<Object> children = new ArrayList<Object>(constraintChildren.size());
        Iterator itr = constraintChildren.iterator();
        while (itr.hasNext()) {
            EObject con = (EObject)itr.next();
            IJavaInstance component = (IJavaInstance)con.eGet(this.sf_constraintComponent);
            if (!BeanProxyUtilities.getBeanProxyHost((IJavaInstance)component).isBeanProxyInstantiated()) continue;
            children.add(con.eGet(this.sf_constraintComponent));
        }
        return children;
    }

    public void setModel(Object model) {
        super.setModel(model);
        ResourceSet rset = ((EObject)model).eResource().getResourceSet();
        this.sfLeftComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_LEFTCOMPONENT);
        this.sfRightComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_RIGHTCOMPONENT);
        this.sfBottomComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_BOTTOMCOMPONENT);
        this.sfTopComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_JSPLITPANE_TOPCOMPONENT);
        this.sf_constraintComponent = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_CONSTRAINT_COMPONENT);
        this.sf_containerComponents = JavaInstantiation.getSFeature((ResourceSet)rset, (URI)JFCConstants.SF_CONTAINER_COMPONENTS);
    }
}

