/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class JTableColumnLayout
extends AbstractLayout {
    protected Map constraints = new HashMap();

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            this.constraints.put(figure, newConstraint);
        }
    }

    protected Dimension calculatePreferredSize(IFigure f, int wHint, int hHint) {
        Dimension dim = new Dimension(0, f.getBounds().height);
        ListIterator children = f.getChildren().listIterator();
        while (children.hasNext()) {
            IFigure child = (IFigure)children.next();
            Integer i = (Integer)this.constraints.get(child);
            if (i == null) continue;
            dim.width += i.intValue();
        }
        Insets insets = f.getInsets();
        return new Dimension(dim.width + insets.getWidth(), dim.height + insets.getHeight()).union(this.getBorderPreferredSize(f));
    }

    public void layout(IFigure parent) {
        Iterator children = parent.getChildren().iterator();
        Rectangle bounds = new Rectangle(0, 0, 0, parent.getBounds().height);
        while (children.hasNext()) {
            IFigure f = (IFigure)children.next();
            Integer widthI = (Integer)this.getConstraint(f);
            if (widthI == null) continue;
            int width = widthI;
            bounds.width += width;
            f.setBounds(bounds.getCopy());
            bounds.x += width;
        }
    }

    public Object getConstraint(IFigure figure) {
        return (Rectangle)this.constraints.get(figure);
    }

    public void remove(IFigure figure) {
        super.remove(figure);
        this.constraints.remove(figure);
    }
}

