/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.ContainerPolicy;
import org.eclipse.ve.internal.cde.core.ContentPaneFigure;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.EditPartRunnable;
import org.eclipse.ve.internal.cde.core.FlowLayoutEditPolicy;
import org.eclipse.ve.internal.cde.core.IImageListener;
import org.eclipse.ve.internal.cde.emf.EditPartAdapterRunnable;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.ComponentGraphicalEditPart;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.jfc.core.JScrollPaneGraphicalEditPart;
import org.eclipse.ve.internal.jfc.core.JTableContainerPolicy;
import org.eclipse.ve.internal.jfc.core.TableColumnGraphicalEditPart;
import org.eclipse.ve.internal.jfc.core.TableColumnProxyAdapter;

public class JTableGraphicalEditPart
extends ComponentGraphicalEditPart {
    private EStructuralFeature sfColumns;
    private boolean isOnScrollPane = false;
    private JTableImageListener fImageListener;
    protected FigureListener hostFigureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            if (JTableGraphicalEditPart.this.isOnScrollPane) {
                JTableGraphicalEditPart.this.refreshColumns();
            }
        }
    };
    private Adapter jTableAdapter = new EditPartAdapterRunnable((EditPart)this){

        protected void doRun() {
            JTableGraphicalEditPart.this.refreshChildren();
        }

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == JTableGraphicalEditPart.this.sfColumns && !notification.isTouch()) {
                this.queueExec((EditPart)JTableGraphicalEditPart.this, "COLUMNS");
            }
        }
    };
    private Runnable fRefreshColumnsRunnable = new EditPartRunnable((EditPart)this){

        protected void doRun() {
            IArrayBeanProxy columnRectsProxy;
            if (JTableGraphicalEditPart.this.getComponentProxy().isBeanProxyInstantiated() && (columnRectsProxy = BeanAwtUtilities.invoke_JTable_getAllColumnRects(JTableGraphicalEditPart.this.getComponentProxy().getBeanProxy())) != null) {
                try {
                    IBeanProxy[] columnRects = columnRectsProxy.getSnapshot();
                    List children = JTableGraphicalEditPart.this.getChildren();
                    int i = 0;
                    while (i < children.size()) {
                        TableColumnGraphicalEditPart columnEP = (TableColumnGraphicalEditPart)((Object)children.get(i));
                        TableColumnProxyAdapter columnProxyHost = (TableColumnProxyAdapter)BeanProxyUtilities.getBeanProxyHost((IJavaInstance)((IJavaInstance)columnEP.getModel()));
                        if (columnProxyHost.isBeanProxyInstantiated()) {
                            IBeanProxy cpProxy = columnProxyHost.getBeanProxy();
                            int cpi = 0;
                            while (cpi < columnRects.length) {
                                if (columnRects[cpi].sameAs(cpProxy)) {
                                    int ii = cpi;
                                    Rectangle bounds = new Rectangle();
                                    bounds.x = ((IIntegerBeanProxy)columnRects[++ii]).intValue();
                                    bounds.y = ((IIntegerBeanProxy)columnRects[++ii]).intValue();
                                    bounds.width = ((IIntegerBeanProxy)columnRects[++ii]).intValue();
                                    bounds.height = ((IIntegerBeanProxy)columnRects[++ii]).intValue();
                                    JTableGraphicalEditPart.this.setLayoutConstraint((EditPart)columnEP, columnEP.getFigure(), bounds);
                                    break;
                                }
                                cpi += 5;
                            }
                        }
                        ++i;
                    }
                }
                catch (ThrowableProxy e) {
                    JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                }
            }
        }
    };

    public JTableGraphicalEditPart(Object aModel) {
        super(aModel);
    }

    protected JTableImageListener getJTableImageListener() {
        if (this.fImageListener == null) {
            this.fImageListener = new JTableImageListener();
        }
        return this.fImageListener;
    }

    protected void refreshChildren() {
        this.isOnScrollPane = this.getParent() instanceof JScrollPaneGraphicalEditPart;
        super.refreshChildren();
        if (this.isOnScrollPane) {
            this.refreshColumns();
        }
    }

    public void activate() {
        super.activate();
        ((EObject)this.getModel()).eAdapters().add((Object)this.jTableAdapter);
        this.getFigure().addFigureListener(this.hostFigureListener);
        this.getVisualComponent().addImageListener((IImageListener)this.getJTableImageListener());
    }

    public void deactivate() {
        super.deactivate();
        ((EObject)this.getModel()).eAdapters().remove((Object)this.jTableAdapter);
        this.getFigure().removeFigureListener(this.hostFigureListener);
        this.getVisualComponent().removeImageListener((IImageListener)this.getJTableImageListener());
    }

    protected void createEditPolicies() {
        EditDomain domain = EditDomain.getEditDomain((EditPart)this);
        this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new FlowLayoutEditPolicy((ContainerPolicy)new JTableContainerPolicy(domain), Boolean.TRUE));
        super.createEditPolicies();
    }

    protected IFigure createFigure() {
        ContentPaneFigure cfig = (ContentPaneFigure)super.createFigure();
        cfig.getContentPane().setLayoutManager((LayoutManager)new XYLayout());
        return cfig;
    }

    private void refreshColumns() {
        if (!this.isOnScrollPane || this.getChildren().size() == 0) {
            return;
        }
        CDEUtilities.displayExec((EditPart)this, (Object)"REFRESH_COLUMNS", (Runnable)this.fRefreshColumnsRunnable);
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.refreshColumns();
    }

    protected List getModelChildren() {
        if (this.isOnScrollPane) {
            return (List)((EObject)this.getModel()).eGet(this.sfColumns);
        }
        return Collections.EMPTY_LIST;
    }

    protected EditPart createChild(Object child) {
        if (this.isOnScrollPane) {
            return new TableColumnGraphicalEditPart(child);
        }
        return null;
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.sfColumns = JavaInstantiation.getSFeature((ResourceSet)((EObject)model).eClass().eResource().getResourceSet(), (URI)JFCConstants.SF_JTABLE_COLUMNS);
    }

    protected class JTableImageListener
    implements IImageListener {
        protected JTableImageListener() {
        }

        public void imageChanged(ImageData imageData) {
            if (JTableGraphicalEditPart.this.isOnScrollPane) {
                JTableGraphicalEditPart.this.refreshColumns();
            }
        }
    }
}

