/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jface;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.IProxyBeanType;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.ForExpression;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.IErrorHolder;
import org.eclipse.ve.internal.cde.core.IImageListener;
import org.eclipse.ve.internal.cde.core.IVisualComponent;
import org.eclipse.ve.internal.cde.core.IVisualComponentListener;
import org.eclipse.ve.internal.java.core.CompositionProxyAdapter;
import org.eclipse.ve.internal.java.core.IAllocationProcesser;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IInternalBeanProxyHost;
import org.eclipse.ve.internal.java.vce.PDEUtilities;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.ControlManager;
import org.eclipse.ve.internal.swt.FreeFormComponentsHost;
import org.eclipse.ve.internal.swt.SWTMessages;
import org.eclipse.ve.internal.swt.SwtPlugin;
import org.eclipse.ve.internal.swt.UIThreadOnlyProxyAdapter;

public class WorkbenchPartProxyAdapter
extends UIThreadOnlyProxyAdapter
implements IVisualComponent {
    protected IProxy workbenchHost;
    protected IProxy workbenchParent;
    private ControlManager controlManager;
    private static final Object IMAGE_DATA_COLLECTION_ERROR_KEY = new Object();
    private EStructuralFeature sf_delegate_control;
    protected FreeFormComponentsHost ffHost;
    public static final String TARGETVM_WORKBENCHPARTHOST = "org.eclipse.ve.internal.jface.targetvm.WorkbenchPartHost";
    private IImageListener imageListener;
    static /* synthetic */ Class class$0;

    public WorkbenchPartProxyAdapter(IBeanProxyDomain domain) {
        super(domain);
    }

    public void setTarget(Notifier newTarget) {
        super.setTarget(newTarget);
        if (newTarget != null) {
            this.sf_delegate_control = ((EObject)newTarget).eClass().getEStructuralFeature(SwtPlugin.DELEGATE_CONTROL);
        }
    }

    protected IProxyBeanType getValidSuperClass(IExpression expression) {
        this.notInstantiatedClasses = new ArrayList(2);
        JavaClass thisClass = (JavaClass)((IJavaInstance)this.getTarget()).getJavaType();
        this.notInstantiatedClasses.add(thisClass);
        JavaClass superclass = thisClass.getSupertype();
        while (superclass != null && superclass.isAbstract()) {
            if ("org.eclipse.ui.part.ViewPart".equals(superclass.getQualifiedName())) {
                return this.getBeanTypeProxy("org.eclipse.ve.internal.jface.targetvm.ConcreteViewPart", expression);
            }
            if ("org.eclipse.ui.part.EditorPart".equals(superclass.getQualifiedName())) {
                return this.getBeanTypeProxy("org.eclipse.ve.internal.jface.targetvm.ConcreteEditorPart", expression);
            }
            this.notInstantiatedClasses.add(superclass);
            superclass = superclass.getSupertype();
        }
        if (superclass != null) {
            return this.getBeanTypeProxy(superclass.getQualifiedNameForReflection(), expression);
        }
        return this.getBeanTypeProxy("java.lang.Object", expression);
    }

    public void addToFreeForm(CompositionProxyAdapter compositionAdapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ve.internal.swt.FreeFormComponentsHost");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.ffHost = (FreeFormComponentsHost)compositionAdapter.getFreeForm((Object)clazz);
        if (this.ffHost == null) {
            this.ffHost = new FreeFormComponentsHost(compositionAdapter);
        }
    }

    public void removeFromFreeForm() {
        this.ffHost = null;
    }

    protected IProxy primInstantiateThisPart(IProxyBeanType targetClass, IExpression expression) throws IAllocationProcesser.AllocationException {
        if (this.ffHost != null) {
            String javaTypeName;
            IProxy workbenchPart = super.primInstantiateThisPart(targetClass, expression);
            PDEUtilities pdeUtilities = PDEUtilities.getUtilities((EditDomain)this.getBeanProxyDomain().getEditDomain());
            String viewTitle = pdeUtilities.getViewName(javaTypeName = this.getJavaObject().getJavaType().getQualifiedName());
            if (viewTitle == null) {
                viewTitle = ((IJavaInstance)this.getTarget()).getJavaType().getName();
            }
            String iconLocation = pdeUtilities.getIconPath(javaTypeName);
            IProxyBeanType workbenchPartHostTypeProxy = this.getBeanTypeProxy(TARGETVM_WORKBENCHPARTHOST, expression);
            boolean traditionalTabStyle = PlatformUI.getPreferenceStore().getBoolean("SHOW_TRADITIONAL_STYLE_TABS");
            int tabPosition = WorkbenchPlugin.getDefault().getPreferenceStore().getInt("VIEW_TAB_POSITION");
            IProxy ffParent = this.ffHost.add(false, expression);
            ExpressionProxy methodResult = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            expression.createMethodInvocation(ForExpression.ASSIGNMENT_RIGHT, workbenchPartHostTypeProxy.getMethodProxy(expression, "createWorkbenchPart", new String[]{"org.eclipse.swt.widgets.Composite", "org.eclipse.ui.IWorkbenchPart", "java.lang.String", "java.lang.String", "boolean", "int"}), false, 6);
            expression.createProxyExpression(ForExpression.METHOD_ARGUMENT, ffParent);
            expression.createProxyExpression(ForExpression.METHOD_ARGUMENT, workbenchPart);
            expression.createStringLiteral(ForExpression.METHOD_ARGUMENT, viewTitle);
            if (iconLocation != null) {
                expression.createStringLiteral(ForExpression.METHOD_ARGUMENT, iconLocation);
            } else {
                expression.createNull(ForExpression.METHOD_ARGUMENT);
            }
            expression.createPrimitiveLiteral(ForExpression.METHOD_ARGUMENT, traditionalTabStyle);
            expression.createPrimitiveLiteral(ForExpression.METHOD_ARGUMENT, tabPosition);
            this.workbenchHost = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            expression.createArrayAccess(ForExpression.ASSIGNMENT_RIGHT, 1);
            expression.createProxyExpression(ForExpression.ARRAYACCESS_ARRAY, (IProxy)methodResult);
            expression.createPrimitiveLiteral(ForExpression.ARRAYACCESS_INDEX, 0);
            this.workbenchParent = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            expression.createArrayAccess(ForExpression.ASSIGNMENT_RIGHT, 1);
            expression.createProxyExpression(ForExpression.ARRAYACCESS_ARRAY, (IProxy)methodResult);
            expression.createPrimitiveLiteral(ForExpression.ARRAYACCESS_INDEX, 1);
            ((ExpressionProxy)this.workbenchHost).addProxyListener(new ExpressionProxy.ProxyListener(){

                public void proxyVoid(ExpressionProxy.ProxyEvent event) {
                    WorkbenchPartProxyAdapter.this.workbenchHost = null;
                }

                public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                    WorkbenchPartProxyAdapter.this.workbenchHost = null;
                }

                public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                    WorkbenchPartProxyAdapter.this.workbenchHost = event.getProxy();
                }
            });
            ((ExpressionProxy)this.workbenchParent).addProxyListener(new ExpressionProxy.ProxyListener(){

                public void proxyVoid(ExpressionProxy.ProxyEvent event) {
                    WorkbenchPartProxyAdapter.this.workbenchParent = null;
                }

                public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                    WorkbenchPartProxyAdapter.this.workbenchParent = null;
                }

                public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                    WorkbenchPartProxyAdapter.this.workbenchParent = event.getProxy();
                }
            });
            return workbenchPart;
        }
        return null;
    }

    protected IProxy primInstantiateBeanProxy(IExpression expression) throws IAllocationProcesser.AllocationException {
        IProxy newbean = super.primInstantiateBeanProxy(expression);
        if (this.workbenchHost != null) {
            this.getControlManager().setControlBeanProxy(this.workbenchHost, expression, this.getModelChangeController());
        }
        return newbean;
    }

    protected void primPrimReleaseBeanProxy(IExpression expression) {
        if (this.isOwnsProxy() && this.isBeanProxyInstantiated()) {
            if (this.workbenchHost != null) {
                BeanSWTUtilities.invoke_WidgetDispose(this.workbenchHost, expression);
            }
            this.workbenchParent = null;
            this.workbenchHost = null;
            IBeanProxyHost value = (IBeanProxyHost)EcoreUtil.getExistingAdapter((Notifier)((IJavaInstance)this.getJavaObject().eGet(this.sf_delegate_control)), (Object)IBeanProxyHost.BEAN_PROXY_TYPE);
            if (value != null) {
                value.releaseBeanProxy(expression);
            }
        }
        if (this.imageListener != null) {
            this.clearError(IMAGE_DATA_COLLECTION_ERROR_KEY);
        }
        if (this.controlManager != null) {
            if (expression != null) {
                expression.createTry();
                this.controlManager.dispose(expression);
                expression.createTryCatchClause("java.lang.RuntimeException", false);
                expression.createTryEnd();
            } else {
                this.controlManager.dispose(null);
            }
        }
    }

    protected final ControlManager getControlManager() {
        if (this.controlManager == null) {
            this.controlManager = new ControlManager();
        }
        return this.controlManager;
    }

    public synchronized void addComponentListener(IVisualComponentListener aListener) {
        this.getControlManager().addComponentListener(aListener);
    }

    public void removeComponentListener(IVisualComponentListener aListener) {
        if (this.controlManager != null) {
            this.getControlManager().removeComponentListener(aListener);
        }
    }

    public synchronized void addImageListener(IImageListener aListener) {
        if (this.imageListener == null) {
            this.imageListener = new ControlManager.IControlImageListener(){

                public void imageStatus(int status) {
                    switch (status) {
                        case 2: {
                            IErrorHolder.MessageError err = new IErrorHolder.MessageError(SWTMessages.ControlProxyAdapter_Picture_too_large_WARN_, 1);
                            WorkbenchPartProxyAdapter.this.processError((IErrorHolder.ErrorType)err, IMAGE_DATA_COLLECTION_ERROR_KEY);
                            break;
                        }
                        default: {
                            WorkbenchPartProxyAdapter.this.clearError(IMAGE_DATA_COLLECTION_ERROR_KEY);
                        }
                    }
                }

                public void imageException(ThrowableProxy exception) {
                    String eMsg = exception.getProxyLocalizedMessage();
                    if (eMsg == null) {
                        IBeanTypeProxy eType = exception.getTypeProxy();
                        eMsg = MessageFormat.format(SWTMessages.ControlProxyAdapter_Image_collection_exception_EXC_, eType.getTypeName());
                    }
                    IErrorHolder.MessageError err = new IErrorHolder.MessageError(MessageFormat.format(SWTMessages.ControlProxyAdapter_Image_collection_failed_ERROR_, eMsg), 1);
                    WorkbenchPartProxyAdapter.this.processError((IErrorHolder.ErrorType)err, IMAGE_DATA_COLLECTION_ERROR_KEY);
                }

                public void imageChanged(ImageData imageData) {
                }
            };
        }
        this.getControlManager().addImageListener(this.imageListener);
        this.getControlManager().addImageListener(aListener);
    }

    public synchronized void removeImageListener(IImageListener aListener) {
        if (this.controlManager != null) {
            if (this.imageListener != null) {
                this.getControlManager().removeImageListener(this.imageListener);
            }
            this.getControlManager().removeImageListener(aListener);
            if (this.imageListener != null && this.getControlManager().hasImageListeners()) {
                this.getControlManager().addImageListener(this.imageListener);
            }
        }
    }

    public Rectangle getBounds() {
        if (this.controlManager != null) {
            return this.controlManager.getBounds();
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public Point getAbsoluteLocation() {
        if (this.controlManager != null) {
            return this.controlManager.getAbsoluteLocation();
        }
        return new Point();
    }

    public Point getLocation() {
        if (this.controlManager != null) {
            return this.controlManager.getLocation();
        }
        return new Point();
    }

    public Dimension getSize() {
        if (this.controlManager != null) {
            return this.controlManager.getSize();
        }
        return new Dimension();
    }

    public boolean hasImageListeners() {
        return this.controlManager != null && this.getControlManager().hasImageListeners();
    }

    public void invalidateImage() {
        if (this.controlManager != null) {
            this.getControlManager().invalidateImage();
        }
    }

    public void refreshImage() {
        if (this.isBeanProxyInstantiated() && this.controlManager != null) {
            this.clearError(IMAGE_DATA_COLLECTION_ERROR_KEY);
            this.getControlManager().refreshImage();
        }
    }

    public void revalidateBeanProxy() {
        if (this.isBeanProxyInstantiated()) {
            this.getControlManager().invalidate(this.getModelChangeController());
        }
    }

    public IProxy getBeanPropertyProxyValue(EStructuralFeature aBeanPropertyFeature, IExpression expression, ForExpression forExpression) {
        if (aBeanPropertyFeature == this.sf_delegate_control) {
            return this.workbenchParent;
        }
        return super.getBeanPropertyProxyValue(aBeanPropertyFeature, expression, forExpression);
    }

    protected void applySetting(EStructuralFeature feature, Object value, int index, IExpression expression) {
        if (feature == this.sf_delegate_control) {
            IInternalBeanProxyHost settingBean = this.getSettingBeanProxyHost((IJavaInstance)value);
            if (settingBean != null) {
                expression.createTry();
                this.instantiateSettingBean(settingBean, expression, feature, value, null);
                expression.createTryCatchClause(this.getBeanInstantiationExceptionTypeProxy(expression), false);
                expression.createTryEnd();
            }
        } else {
            super.applySetting(feature, value, index, expression);
        }
    }
}

