/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.ve.internal.swt.CBannerLayoutEditPolicy;
import org.eclipse.ve.internal.swt.CBannerLayoutPolicyHelper;

public class CBannerLayoutFeedback
extends RectangleFigure {
    protected int fLineWidth = 1;
    protected int fLineStyle = 4;
    private String[] filledRegions;
    private static final String LEFT_CONTROL = "Left";
    private static final String RIGHT_CONTROL = "Right";
    private static final String BOTTOM_CONTROL = "Bottom";

    public void fillShape(Graphics g) {
        Rectangle r = this.getBounds().getCopy();
        if (this.getFilledRegions() != null) {
            Rectangle leftRect = new Rectangle(r.x, r.y, r.width / 2, r.height / 2);
            Rectangle rightRect = new Rectangle(r.x + r.width / 2, r.y, r.width / 2, r.height / 2);
            Rectangle bottomRect = new Rectangle(r.x, r.y + r.height / 2, r.width, r.height / 2);
            g.setBackgroundColor(ColorConstants.gray);
            g.setXORMode(true);
            int i = 0;
            while (i < this.getFilledRegions().length) {
                if (this.getFilledRegions()[i].equals(CBannerLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(0))) {
                    g.fillRectangle(leftRect);
                }
                if (this.getFilledRegions()[i].equals(CBannerLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(1))) {
                    g.fillRectangle(rightRect);
                }
                if (this.getFilledRegions()[i].equals(CBannerLayoutPolicyHelper.REAL_INTERNAL_TAGS.get(2))) {
                    g.fillRectangle(bottomRect);
                }
                ++i;
            }
        }
        g.setForegroundColor(ColorConstants.green);
        boolean simple = CBannerLayoutEditPolicy.isSimple();
        int h = r.height / 2 - 1;
        int half_width = r.width / 2;
        int quarter_width = r.width / 4;
        int curve_width = r.width / 6;
        g.drawRectangle(r.x, r.y, r.width - 1, r.height - 1);
        g.drawLine(r.x, r.y + r.height / 2, r.x + half_width, r.y + r.height / 2);
        if (simple) {
            g.drawLine(r.x + r.width / 2 - 1, r.y, r.x + r.width / 2 - 1, r.y + r.height / 2);
        } else {
            int[] curve = this.bezier(r.x + half_width, r.y + h, r.x + half_width + curve_width, r.y + h - 1, r.x + r.width - quarter_width - curve_width, r.y + 1, r.x + r.width - curve_width, r.y, curve_width);
            g.drawPolyline(curve);
        }
        g.setLineStyle(2);
        g.drawLine(r.x + half_width, r.y + r.height / 2, r.x + r.width - 1, r.y + r.height / 2);
    }

    public String getCurrentConstraint(Point p) {
        if (p == null) {
            return null;
        }
        Rectangle r = this.getBounds().getCopy();
        Rectangle leftRect = new Rectangle(r.x, r.y, r.width / 2, r.height / 2);
        Rectangle rightRect = new Rectangle(r.x + r.width / 2, r.y, r.width / 2, r.height / 2);
        Rectangle bottomRect = new Rectangle(r.x, r.y + r.height / 2, r.width, r.height / 2);
        if (leftRect.contains(p)) {
            return LEFT_CONTROL;
        }
        if (rightRect.contains(p)) {
            return RIGHT_CONTROL;
        }
        if (bottomRect.contains(p)) {
            return BOTTOM_CONTROL;
        }
        return null;
    }

    public Rectangle getCurrentRectangle(Point p) {
        if (p == null) {
            return null;
        }
        Rectangle r = this.getBounds().getCopy();
        Rectangle leftRect = new Rectangle(r.x, r.y, r.width / 2, r.height / 2);
        Rectangle rightRect = new Rectangle(r.x + r.width / 2, r.y, r.width / 2, r.height / 2);
        Rectangle bottomRect = new Rectangle(r.x, r.y + r.height / 2, r.width, r.height / 2);
        if (leftRect.contains(p)) {
            return leftRect;
        }
        if (rightRect.contains(p)) {
            return rightRect;
        }
        if (bottomRect.contains(p)) {
            return bottomRect;
        }
        return null;
    }

    public static String getDisplayConstraint(String constraint) {
        int ndx = CBannerLayoutPolicyHelper.REAL_INTERNAL_TAGS.indexOf(constraint);
        return ndx > -1 ? (String)CBannerLayoutPolicyHelper.DISPLAY_TAGS.get(ndx) : "";
    }

    protected String[] getFilledRegions() {
        return this.filledRegions;
    }

    public int getLineWidth() {
        return this.fLineWidth;
    }

    public void setFilledRegions(String[] newFilledRegions) {
        this.filledRegions = newFilledRegions;
        this.invalidate();
    }

    public void setLineStyle(int newLineStyle) {
        this.fLineStyle = newLineStyle;
    }

    public void setLineWidth(int newLineWidth) {
        this.fLineWidth = newLineWidth;
    }

    private int[] bezier(int x0, int y0, int x1, int y1, int x2, int y2, int x3, int y3, int count) {
        double a0 = x0;
        double a1 = 3 * (x1 - x0);
        double a2 = 3 * (x0 + x2 - 2 * x1);
        double a3 = x3 - x0 + 3 * x1 - 3 * x2;
        double b0 = y0;
        double b1 = 3 * (y1 - y0);
        double b2 = 3 * (y0 + y2 - 2 * y1);
        double b3 = y3 - y0 + 3 * y1 - 3 * y2;
        int[] polygon = new int[2 * count + 2];
        int i = 0;
        while (i <= count) {
            double t = (double)i / (double)count;
            polygon[2 * i] = (int)(a0 + a1 * t + a2 * t * t + a3 * t * t * t);
            polygon[2 * i + 1] = (int)(b0 + b1 * t + b2 * t * t + b3 * t * t * t);
            ++i;
        }
        return polygon;
    }
}

