/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.commands.Command;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.PTInstanceReference;
import org.eclipse.jem.internal.instantiation.PTName;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.ve.internal.cde.commands.ApplyAttributeSettingCommand;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.EnsureCorrectParentCommand;
import org.eclipse.ve.internal.swt.SWTConstants;

public class CompositeContainerPolicy
extends VisualContainerPolicy {
    protected EReference sfLayoutData;

    public CompositeContainerPolicy(EditDomain domain) {
        super(JavaInstantiation.getSFeature((ResourceSet)JavaEditDomainHelper.getResourceSet((EditDomain)domain), (URI)SWTConstants.SF_COMPOSITE_CONTROLS), domain);
        ResourceSet rset = JavaEditDomainHelper.getResourceSet((EditDomain)domain);
        this.sfLayoutData = JavaInstantiation.getReference((ResourceSet)rset, (URI)SWTConstants.SF_CONTROL_LAYOUTDATA);
    }

    public Command getCreateCommand(Object child, Object positionBeforeChild) {
        Command result = super.getCreateCommand(child, positionBeforeChild);
        if (result.canExecute()) {
            if (child instanceof IJavaObjectInstance && ((IJavaObjectInstance)child).getAllocation() != null) {
                EnsureCorrectParentCommand insertCorrectParentCommand = new EnsureCorrectParentCommand((IJavaObjectInstance)child, (IJavaObjectInstance)this.getContainer());
                return insertCorrectParentCommand.chain(result);
            }
            return this.createInitStringCommand((IJavaObjectInstance)child).chain(result);
        }
        return result;
    }

    private Command createInitStringCommand(IJavaObjectInstance child) {
        PTClassInstanceCreation ic = InstantiationFactory.eINSTANCE.createPTClassInstanceCreation();
        ic.setType(child.getJavaType().getJavaName());
        PTInstanceReference ir = InstantiationFactory.eINSTANCE.createPTInstanceReference();
        ir.setObject((IJavaObjectInstance)this.getContainer());
        PTFieldAccess fa = InstantiationFactory.eINSTANCE.createPTFieldAccess();
        PTName name = InstantiationFactory.eINSTANCE.createPTName("org.eclipse.swt.SWT");
        fa.setField("NONE");
        fa.setReceiver((PTExpression)name);
        ic.getArguments().add((Object)ir);
        ic.getArguments().add((Object)fa);
        ParseTreeAllocation alloc = InstantiationFactory.eINSTANCE.createParseTreeAllocation((PTExpression)ic);
        ApplyAttributeSettingCommand applyCmd = new ApplyAttributeSettingCommand();
        applyCmd.setTarget((EObject)child);
        applyCmd.setAttribute(child.eClass().getEStructuralFeature("allocation"));
        applyCmd.setAttributeSettingValue((Object)alloc);
        return applyCmd;
    }

    protected Command primAddCommand(List children, Object positionBeforeChild, EStructuralFeature containmentSF) {
        Command command = super.primAddCommand(children, positionBeforeChild, containmentSF);
        if (command.canExecute()) {
            CompoundCommand cmd = new CompoundCommand();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                try {
                    cmd.append((Command)new EnsureCorrectParentCommand((IJavaObjectInstance)iter.next(), (IJavaObjectInstance)this.getContainer()));
                }
                catch (ClassCastException classCastException) {}
            }
            cmd.append(command);
            return cmd;
        }
        return command;
    }

    protected Command getOrphanTheChildrenCommand(List children) {
        Command orphanChildrenCommand = super.getOrphanTheChildrenCommand(children);
        RuledCommandBuilder cbld = new RuledCommandBuilder(this.getEditDomain());
        cbld.cancelGroupAttributeSetting(children, (EStructuralFeature)this.sfLayoutData);
        cbld.append(orphanChildrenCommand);
        return cbld.getCommand();
    }

    protected boolean isValidBeanLocation(Object child) {
        return BeanSWTUtilities.isValidBeanLocation(this.getEditDomain(), (EObject)((IJavaObjectInstance)child), (EObject)this.getContainer());
    }

    protected boolean areFieldNamesShared(List children, EStructuralFeature containmentSF) {
        IJavaInstance swtComposite = (IJavaInstance)this.getContainer();
        List compositeControls = (List)swtComposite.eGet(containmentSF);
        HashMap<IJavaInstance, String> controlNames = new HashMap<IJavaInstance, String>(compositeControls.size());
        Iterator allChildren = compositeControls.iterator();
        while (allChildren.hasNext()) {
            IJavaInstance control = (IJavaInstance)allChildren.next();
            String fieldName = BeanUtilities.getBeanName((IJavaInstance)control, (EditDomain)this.getEditDomain());
            controlNames.put(control, fieldName);
        }
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            IJavaInstance control = (IJavaInstance)iter.next();
            String fieldName = BeanUtilities.getBeanName((IJavaInstance)control, (EditDomain)this.getEditDomain());
            Iterator controlNamesIter = controlNames.keySet().iterator();
            while (controlNamesIter.hasNext()) {
                Object controlToCompare = controlNamesIter.next();
                if (controlToCompare == control || !controlNames.get(controlToCompare).equals(fieldName)) continue;
                return true;
            }
        }
        return false;
    }

    public Command getCreateCommand(Object constraintComponent, Object childComponent, Object position) {
        return null;
    }

    public Command getAddCommand(List componentConstraints, List childrenComponents, Object position) {
        return null;
    }
}

