/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IPointBeanProxy;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.IProxyMethod;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.ForExpression;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.jem.internal.proxy.swt.DisplayManager;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ve.internal.cde.core.IImageListener;
import org.eclipse.ve.internal.cde.core.IVisualComponent;
import org.eclipse.ve.internal.cde.core.IVisualComponentListener;
import org.eclipse.ve.internal.cde.core.ImageNotifierSupport;
import org.eclipse.ve.internal.cde.core.ModelChangeController;
import org.eclipse.ve.internal.cde.core.VisualComponentSupport;
import org.eclipse.ve.internal.cde.core.VisualComponentsLayoutPolicy;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.ControlManagerFeedbackControllerNotifier;
import org.eclipse.ve.internal.swt.ImageDataCollector;

public class ControlManager
implements ControlManagerFeedbackControllerNotifier,
IVisualComponent {
    protected VisualComponentSupport vcSupport = new VisualComponentSupport();
    protected IProxy controlManagerProxy;
    protected IProxy controlBeanProxy;
    protected IBeanProxy displayProxy;
    private Point fLastSignalledLocation;
    private Dimension fLastSignalledSize;
    private Point locationOverride;
    private ImageNotifierSupport imSupport;
    private final Object imageAccessorSemaphore = new Object();
    private ImageDataCollector fImageDataCollector;
    private int fImageValid = 4;
    private static final int INVALID = 1;
    private static final int INVALID_COLLECTING = 2;
    private static final int VALID = 3;
    private static final int WAITING_FIRST_INVALIDATION = 4;
    private ListenerList controlImageListeners;
    private List extensions;
    int movedCtr;

    public void addControlExtension(ControlManagerExtension controlExtension, IExpression expression) {
        if (this.extensions == null) {
            this.extensions = new ArrayList(1);
        }
        this.extensions.add(controlExtension);
        if (this.controlManagerProxy != null) {
            this.addExtensionProxy(controlExtension, expression);
        }
    }

    private void addExtensionProxy(ControlManagerExtension extension, IExpression expression) {
        expression.createSimpleMethodInvoke(expression.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(expression, "org.eclipse.ve.internal.swt.targetvm.ControlManager").getMethodProxy(expression, "addExtension", new String[]{"org.eclipse.ve.internal.swt.targetvm.ControlManager$ControlManagerExtension"}), this.controlManagerProxy, new IProxy[]{extension.getExtensionProxy(expression)}, false);
    }

    private void removeExtensionProxy(ControlManagerExtension extension, IExpression expression) {
        expression.createSimpleMethodInvoke(expression.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(expression, "org.eclipse.ve.internal.swt.targetvm.ControlManager").getMethodProxy(expression, "removeExtension", new String[]{"org.eclipse.ve.internal.swt.targetvm.ControlManager$ControlManagerExtension"}), this.controlManagerProxy, new IProxy[]{extension.getExtensionProxy(expression)}, false);
    }

    public void removeControlExtension(ControlManagerExtension controlExtension, IExpression expression) {
        if (this.extensions != null && this.extensions.remove(controlExtension)) {
            if (this.controlManagerProxy != null && this.controlManagerProxy.isBeanProxy() && ((IBeanProxy)this.controlManagerProxy).isValid()) {
                this.removeExtensionProxy(controlExtension, expression);
            }
            controlExtension.disposed(expression);
        }
    }

    public IBeanProxy getDisplay() {
        return this.displayProxy;
    }

    public void addComponentListener(IVisualComponentListener aListener) {
        this.vcSupport.addComponentListener(aListener);
    }

    public void removeComponentListener(IVisualComponentListener aListener) {
        this.vcSupport.removeComponentListener(aListener);
    }

    protected IBeanProxy getControlManagerBeanProxy() {
        return (IBeanProxy)this.controlManagerProxy;
    }

    protected IBeanProxy getControlBeanProxy() {
        return (IBeanProxy)this.controlBeanProxy;
    }

    public boolean isDisposed() {
        return this.controlManagerProxy == null;
    }

    public void setControlBeanProxy(IProxy controlProxy, IExpression expression, ModelChangeController changeController) {
        this.displayProxy = DisplayManager.getCurrentDisplay(expression.getRegistry());
        final FeedbackController feedbackController = BeanSWTUtilities.getFeedbackController(expression, this.displayProxy);
        boolean hadControlBeanProxy = this.controlBeanProxy != null;
        this.controlBeanProxy = null;
        if (controlProxy != null) {
            if (this.controlManagerProxy == null) {
                ExpressionProxy newManager = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
                this.controlManagerProxy = newManager;
                expression.createClassInstanceCreation(ForExpression.ASSIGNMENT_RIGHT, expression.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(expression, "org.eclipse.ve.internal.swt.targetvm.ControlManager"), 0);
                newManager.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(){

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        ControlManager.this.controlManagerProxy = event.getProxy();
                        feedbackController.registerFeedbackNotifier(ControlManager.this, (IBeanProxy)ControlManager.this.controlManagerProxy);
                    }

                    public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                        JavaVEPlugin.log((Object)"Control manager proxy not resolved on remote vm.", (Level)Level.INFO);
                        ControlManager.this.controlManagerProxy = null;
                    }
                });
                if (this.extensions != null) {
                    int i = 0;
                    while (i < this.extensions.size()) {
                        this.addExtensionProxy((ControlManagerExtension)this.extensions.get(i), expression);
                        ++i;
                    }
                }
            }
            expression.createSimpleMethodInvoke(BeanSWTUtilities.getSetControlMethodProxy(expression), this.controlManagerProxy, new IProxy[]{controlProxy, feedbackController.getProxy()}, false);
            if (controlProxy.isExpressionProxy()) {
                ((ExpressionProxy)controlProxy).addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(){

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        ControlManager.this.controlBeanProxy = event.getProxy();
                    }
                });
            } else {
                this.controlBeanProxy = (IBeanProxy)controlProxy;
            }
            if (this.locationOverride != null) {
                expression.createSimpleMethodInvoke(BeanSWTUtilities.getOverrideLocationMethodProxy(expression), this.controlManagerProxy, new IProxy[]{expression.getRegistry().getBeanProxyFactory().createBeanProxyWith(this.locationOverride.x), expression.getRegistry().getBeanProxyFactory().createBeanProxyWith(this.locationOverride.y)}, false);
            }
            feedbackController.queueInitialRefresh(changeController);
            feedbackController.queueInvalidate(this, changeController);
        } else if (hadControlBeanProxy && this.controlManagerProxy != null) {
            IProxy[] iProxyArray = new IProxy[2];
            iProxyArray[1] = feedbackController.getProxy();
            expression.createSimpleMethodInvoke(BeanSWTUtilities.getSetControlMethodProxy(expression), this.controlManagerProxy, iProxyArray, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calledBack(int msgID, Object[] parms) {
        switch (msgID) {
            case 1: {
                this.componentResized(((IIntegerBeanProxy)parms[0]).intValue(), ((IIntegerBeanProxy)parms[1]).intValue());
                break;
            }
            case 2: {
                this.componentMoved(((IIntegerBeanProxy)parms[0]).intValue(), ((IIntegerBeanProxy)parms[1]).intValue());
                break;
            }
            case 3: {
                this.fLastSignalledLocation = new Point(((IIntegerBeanProxy)parms[0]).intValue(), ((IIntegerBeanProxy)parms[1]).intValue());
                this.fLastSignalledSize = new Dimension(((IIntegerBeanProxy)parms[2]).intValue(), ((IIntegerBeanProxy)parms[3]).intValue());
                this.printmoved("refreshed");
                this.fireComponentRefresh();
                break;
            }
            case 5: {
                Object object = this.imageAccessorSemaphore;
                synchronized (object) {
                    this.fImageValid = 1;
                }
                this.componentValidated();
                if (this.imSupport == null || !this.imSupport.hasImageListeners()) break;
                this.getImageCollector();
                this.invalidateImage();
                this.refreshImage();
            }
        }
    }

    private void printmoved(String type) {
        if (VisualComponentsLayoutPolicy.DO_VC_TRACING) {
            ++this.movedCtr;
            if (this.controlBeanProxy.isBeanProxy()) {
                System.out.println("Component " + ((IBeanProxy)this.controlBeanProxy).getTypeProxy().getTypeName() + "(" + this.hashCode() + ") cntr:" + this.movedCtr + ' ' + type + " to:(" + this.fLastSignalledLocation + ' ' + this.fLastSignalledSize + ')');
            } else {
                System.out.println("Component (" + this.hashCode() + ") cntr:" + this.movedCtr + ' ' + type + " to:(" + this.fLastSignalledLocation + ' ' + this.fLastSignalledSize + ')');
            }
        }
    }

    protected void componentResized(int width, int height) {
        this.fLastSignalledSize = new Dimension(width, height);
        this.printmoved("resized");
        this.vcSupport.fireComponentResized(width, height);
    }

    protected void componentMoved(int x, int y) {
        this.fLastSignalledLocation = new Point(x, y);
        this.printmoved("moved");
        this.vcSupport.fireComponentMoved(x, y);
    }

    protected void fireComponentRefresh() {
        this.vcSupport.fireComponentRefreshed();
    }

    protected void componentValidated() {
        this.vcSupport.fireComponentValidated();
    }

    public void dispose(IExpression expression) {
        if (this.fImageDataCollector != null) {
            this.fImageDataCollector.release();
            this.fImageDataCollector = null;
        }
        if (this.controlManagerProxy != null) {
            if (expression != null && this.controlManagerProxy.isBeanProxy() && ((IBeanProxy)this.controlManagerProxy).isValid()) {
                FeedbackController feedback = this.getFeedbackController();
                feedback.deregisterFeedbackNotifier((IBeanProxy)this.controlManagerProxy);
                if (this.getControlManagerBeanProxy().isValid()) {
                    IProxy[] iProxyArray = new IProxy[2];
                    iProxyArray[1] = feedback.getProxy();
                    expression.createSimpleMethodInvoke(BeanSWTUtilities.getSetControlMethodProxy(expression), this.controlManagerProxy, iProxyArray, false);
                    this.getControlManagerBeanProxy().getProxyFactoryRegistry().releaseProxy(this.getControlManagerBeanProxy());
                }
            }
            if (this.extensions != null) {
                int i = 0;
                while (i < this.extensions.size()) {
                    ((ControlManagerExtension)this.extensions.get(i)).disposed(expression);
                    ++i;
                }
            }
            this.locationOverride = null;
            this.controlManagerProxy = null;
            this.controlBeanProxy = null;
            this.fLastSignalledLocation = null;
            this.fLastSignalledSize = null;
            this.displayProxy = null;
        }
    }

    protected boolean isComponentManagerProxyValid() {
        if (this.controlManagerProxy == null) {
            return false;
        }
        if (this.controlManagerProxy.isExpressionProxy()) {
            return true;
        }
        if (((IBeanProxy)this.controlManagerProxy).isValid()) {
            return true;
        }
        this.dispose(null);
        return false;
    }

    public Rectangle getBounds() {
        if (this.fLastSignalledLocation != null && this.fLastSignalledSize != null) {
            if (VisualComponentsLayoutPolicy.DO_VC_TRACING) {
                System.out.println("Requested bounds (" + this.hashCode() + ") cntr:" + this.movedCtr + " bounds: " + this.fLastSignalledLocation + ' ' + this.fLastSignalledSize);
            }
            return new Rectangle(this.fLastSignalledLocation.x, this.fLastSignalledLocation.y, this.fLastSignalledSize.width, this.fLastSignalledSize.height);
        }
        return new Rectangle();
    }

    public Point getLocation() {
        if (this.fLastSignalledLocation != null) {
            return this.fLastSignalledLocation;
        }
        return new Point();
    }

    public Dimension getSize() {
        if (this.fLastSignalledSize != null) {
            return this.fLastSignalledSize;
        }
        return new Dimension();
    }

    public Point getOriginOffset() {
        IBeanProxy controlManager;
        IMethodProxy getOffsetMethod;
        IPointBeanProxy offset;
        if (this.controlManagerProxy != null && this.controlBeanProxy != null && this.controlManagerProxy.isBeanProxy() && (offset = (IPointBeanProxy)(getOffsetMethod = (controlManager = (IBeanProxy)this.controlManagerProxy).getTypeProxy().getMethodProxy("getOriginOffset")).invokeCatchThrowableExceptions(controlManager)) != null) {
            return new Point(offset.getX(), offset.getY());
        }
        return new Point();
    }

    public IProxy applyLayoutData(IProxy layoutData, boolean wantOldValue, IExpression expression) {
        return expression.createSimpleMethodInvoke(BeanSWTUtilities.getApplyLayoutDataMethodProxy(expression), this.controlManagerProxy, new IProxy[]{layoutData}, true);
    }

    public IProxy applyBounds(IProxy bounds, boolean wantOldValue, IExpression expression, ModelChangeController controller) {
        ExpressionProxy oldValue;
        FeedbackController feedback = BeanSWTUtilities.getFeedbackController(expression, this.displayProxy);
        feedback.startChanges(controller, expression);
        if (!wantOldValue) {
            oldValue = null;
        } else {
            oldValue = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            expression.createClassInstanceCreation(ForExpression.ASSIGNMENT_RIGHT, expression.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(expression, "org.eclipse.swt.graphics.Rectangle"), 4);
            expression.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 0);
            expression.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 0);
            expression.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 0);
            expression.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 0);
        }
        expression.createSimpleMethodInvoke(BeanSWTUtilities.getApplyBoundsMethodProxy(expression), this.controlManagerProxy, new IProxy[]{bounds, oldValue}, false);
        return oldValue;
    }

    public IProxy applyLocation(IProxy location, boolean wantOldValue, IExpression expression, ModelChangeController controller) {
        ExpressionProxy oldValue;
        FeedbackController feedback = BeanSWTUtilities.getFeedbackController(expression, this.displayProxy);
        feedback.startChanges(controller, expression);
        if (!wantOldValue) {
            oldValue = null;
        } else {
            oldValue = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            expression.createClassInstanceCreation(ForExpression.ASSIGNMENT_RIGHT, expression.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(expression, "org.eclipse.swt.graphics.Point"), 2);
            expression.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 0);
            expression.createPrimitiveLiteral(ForExpression.CLASSINSTANCECREATION_ARGUMENT, 0);
        }
        expression.createSimpleMethodInvoke(BeanSWTUtilities.getApplyLocationMethodProxy(expression), this.controlManagerProxy, new IProxy[]{location, oldValue}, false);
        return oldValue;
    }

    public void overrideLocation(Point point, IExpression expression) {
        if (this.isComponentManagerProxyValid() && this.controlManagerProxy.isBeanProxy()) {
            ProxyFactoryRegistry registry = this.getControlManagerBeanProxy().getProxyFactoryRegistry();
            expression.createSimpleMethodInvoke(BeanSWTUtilities.getOverrideLocationMethodProxy(expression), (IProxy)this.getControlManagerBeanProxy(), new IProxy[]{registry.getBeanProxyFactory().createBeanProxyWith(point.x), registry.getBeanProxyFactory().createBeanProxyWith(point.y)}, false);
        }
        this.locationOverride = point;
    }

    public IBeanProxy getDefaultLocation() {
        if (this.isComponentManagerProxyValid()) {
            ProxyFactoryRegistry registry = this.getControlManagerBeanProxy().getProxyFactoryRegistry();
            return BeanSWTUtilities.getDefaultLocationMethodProxy(registry).invokeCatchThrowableExceptions(this.getControlManagerBeanProxy());
        }
        return null;
    }

    public IBeanProxy getDefaultBounds() {
        if (this.isComponentManagerProxyValid() && this.controlManagerProxy.isBeanProxy()) {
            ProxyFactoryRegistry registry = this.getControlManagerBeanProxy().getProxyFactoryRegistry();
            return BeanSWTUtilities.getDefaultBoundsMethodProxy(registry).invokeCatchThrowableExceptions(this.getControlManagerBeanProxy());
        }
        return null;
    }

    protected IProxy getComponentManagerProxy() {
        return this.controlManagerProxy;
    }

    public void invalidate(ModelChangeController controller) {
        FeedbackController feedback = this.getFeedbackController();
        feedback.queueInvalidate(this, controller);
    }

    public FeedbackController getFeedbackController() {
        return BeanSWTUtilities.getFeedbackController(this.getRegistry(), this.displayProxy);
    }

    private ProxyFactoryRegistry getRegistry() {
        return this.controlManagerProxy.isBeanProxy() ? ((IBeanProxy)this.controlManagerProxy).getProxyFactoryRegistry() : ((ExpressionProxy)this.controlManagerProxy).getExpression().getRegistry();
    }

    private void invalidate(IExpression expression) {
        if (this.isComponentManagerProxyValid()) {
            expression.createSimpleMethodInvoke(BeanSWTUtilities.getControlInvalidate(expression), this.controlManagerProxy, null, false);
        }
    }

    public void addImageListener(IImageListener listener) {
        if (this.imSupport == null) {
            this.imSupport = new ImageNotifierSupport();
        }
        if (listener instanceof IControlImageListener) {
            if (this.controlImageListeners == null) {
                this.controlImageListeners = new ListenerList(1);
            }
            this.controlImageListeners.add((Object)listener);
        }
        this.imSupport.addImageListener(listener);
        if (this.controlBeanProxy != null && this.controlBeanProxy.isBeanProxy()) {
            this.getImageCollector();
        }
    }

    public void removeImageListener(IImageListener listener) {
        if (this.imSupport != null) {
            this.imSupport.removeImageListener(listener);
        }
        if (listener instanceof IControlImageListener && this.controlImageListeners != null) {
            this.controlImageListeners.remove((Object)listener);
        }
    }

    public boolean hasImageListeners() {
        if (this.imSupport != null) {
            return this.imSupport.hasImageListeners();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateImage() {
        Object object = this.imageAccessorSemaphore;
        synchronized (object) {
            if (this.fImageDataCollector != null && this.fImageValid != 4) {
                if (this.fImageValid == 2 && this.fImageDataCollector.isCollectingData()) {
                    this.fImageDataCollector.abort(false);
                }
                this.fImageValid = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageDataCollector getImageCollector() {
        if (this.fImageDataCollector == null) {
            Object object = this.imageAccessorSemaphore;
            synchronized (object) {
                if (this.fImageDataCollector == null) {
                    this.fImageDataCollector = new ImageDataCollector(this.getRegistry());
                }
            }
        }
        return this.fImageDataCollector;
    }

    private void fireImageStatus(int status) {
        Object[] listeners = this.controlImageListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IControlImageListener)listeners[i]).imageStatus(status);
            ++i;
        }
    }

    private void fireImageException(ThrowableProxy exception) {
        Object[] listeners = this.controlImageListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IControlImageListener)listeners[i]).imageException(exception);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshImage() {
        if (this.imSupport != null && this.imSupport.hasImageListeners() && this.controlBeanProxy.isBeanProxy() && ((IBeanProxy)this.controlBeanProxy).isValid()) {
            boolean doRefresh = false;
            Object object = this.imageAccessorSemaphore;
            synchronized (object) {
                if (this.fImageValid != 4) {
                    boolean bl = doRefresh = this.fImageValid == 1 && this.fImageDataCollector != null;
                    if (doRefresh) {
                        this.fImageValid = 2;
                    }
                }
            }
            if (doRefresh) {
                try {
                    this.getImageCollector().abort(true);
                    object = this.imageAccessorSemaphore;
                    synchronized (object) {
                        this.getImageCollector().startComponent(this.getControlBeanProxy(), new ImageDataCollector.DataCollectedRunnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void imageData(ImageData data, int status) {
                                Object object = ControlManager.this.imageAccessorSemaphore;
                                synchronized (object) {
                                    ControlManager.this.fImageValid = 3;
                                }
                                ControlManager.this.fireImageStatus(status);
                                ControlManager.this.imSupport.fireImageChanged(data);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void imageNotCollected(int status) {
                                Object object = ControlManager.this.imageAccessorSemaphore;
                                synchronized (object) {
                                    ControlManager.this.fImageValid = 1;
                                }
                                ControlManager.this.fireImageStatus(status);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void imageException(ThrowableProxy exception) {
                                Object object = ControlManager.this.imageAccessorSemaphore;
                                synchronized (object) {
                                    ControlManager.this.fImageValid = 1;
                                }
                                ControlManager.this.fireImageException(exception);
                            }
                        });
                    }
                }
                catch (ThrowableProxy e) {
                    Object object2 = this.imageAccessorSemaphore;
                    synchronized (object2) {
                        this.fImageValid = 1;
                    }
                    JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                    this.fireImageException(e);
                }
            }
        }
    }

    public Point getAbsoluteLocation() {
        return this.getLocation();
    }

    static /* synthetic */ void access$0(ControlManager controlManager, IExpression iExpression) {
        controlManager.invalidate(iExpression);
    }

    public static interface IControlImageListener
    extends IImageListener {
        public void imageStatus(int var1);

        public void imageException(ThrowableProxy var1);
    }

    public static abstract class ControlManagerExtension {
        protected IProxy getExtensionProxy(IExpression expression) {
            String extensionClassname;
            IProxy managerExtensionProxy = this.primGetExtensionProxy();
            if ((managerExtensionProxy == null || managerExtensionProxy.isBeanProxy() && !((IBeanProxy)managerExtensionProxy).isValid()) && (extensionClassname = this.getExtensionClassname()) != null) {
                managerExtensionProxy = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
                expression.createClassInstanceCreation(ForExpression.ASSIGNMENT_RIGHT, expression.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(expression, extensionClassname), 0);
                ((ExpressionProxy)managerExtensionProxy).addProxyListener(new ExpressionProxy.ProxyListener(this){
                    final /* synthetic */ ControlManagerExtension this$1;
                    {
                        this.this$1 = controlManagerExtension;
                    }

                    public void proxyVoid(ExpressionProxy.ProxyEvent event) {
                        this.this$1.primSetExtensionProxy(null);
                    }

                    public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                        this.this$1.primSetExtensionProxy(null);
                    }

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        this.this$1.primSetExtensionProxy((IProxy)event.getProxy());
                    }
                });
                this.primSetExtensionProxy(managerExtensionProxy);
            }
            return managerExtensionProxy;
        }

        protected String getExtensionClassname() {
            return null;
        }

        protected IProxy primGetExtensionProxy() {
            return null;
        }

        protected void primSetExtensionProxy(IProxy proxy) {
        }

        protected void disposed(IExpression expression) {
            this.primSetExtensionProxy(null);
        }
    }

    protected static class FeedbackController
    implements ICallback {
        private Map managerProxyToNotifier = new HashMap();
        private IProxy feedbackControllerProxy;
        private IMethodProxy postInitialRefresh;
        private IMethodProxy postInvalidImages;
        private IProxyMethod startingChanges;
        private IMethodProxy postChangesDone;
        private boolean changesHeld;
        private Set pendingInvalidates = new HashSet();
        private Runnable changesDoneRunnable = new Runnable(this){
            final /* synthetic */ FeedbackController this$1;
            {
                this.this$1 = feedbackController;
            }

            public void run() {
                FeedbackController.access$0(this.this$1, false);
                if (FeedbackController.access$1(this.this$1) != null) {
                    if (FeedbackController.access$1(this.this$1).isBeanProxy()) {
                        if (FeedbackController.access$2(this.this$1) != null) {
                            FeedbackController.access$2(this.this$1).invokeCatchThrowableExceptions((IBeanProxy)FeedbackController.access$1(this.this$1));
                        } else {
                            JavaVEPlugin.log((Object)"swt.FeedbackComponentManager didn't resolve postChanges method!", (Level)Level.WARNING);
                        }
                    } else {
                        JavaVEPlugin.log((Object)"swt.FeedbackComponentManager didn't resolve itself!", (Level)Level.WARNING);
                    }
                }
            }
        };
        private Runnable initialRefreshRunnable = new Runnable(this){
            final /* synthetic */ FeedbackController this$1;
            {
                this.this$1 = feedbackController;
            }

            public void run() {
                if (FeedbackController.access$1(this.this$1) != null) {
                    if (FeedbackController.access$1(this.this$1).isBeanProxy()) {
                        if (FeedbackController.access$3(this.this$1) != null) {
                            FeedbackController.access$3(this.this$1).invokeCatchThrowableExceptions((IBeanProxy)FeedbackController.access$1(this.this$1));
                        } else {
                            JavaVEPlugin.log((Object)"swt.FeedbackComponentManager didn't resolve postInitialRefresh method!", (Level)Level.WARNING);
                        }
                    } else {
                        JavaVEPlugin.log((Object)"swt.FeedbackComponentManager didn't resolve itself!", (Level)Level.WARNING);
                    }
                }
            }
        };
        private Runnable invalidateRunnable = new Runnable(this){
            final /* synthetic */ FeedbackController this$1;
            {
                this.this$1 = feedbackController;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                if (FeedbackController.access$1(this.this$1) == null) return;
                IExpression exp = ((IBeanProxy)FeedbackController.access$1(this.this$1)).getProxyFactoryRegistry().getBeanProxyFactory().createExpression();
                try {
                    try {
                        Iterator<E> itr = FeedbackController.access$4(this.this$1).iterator();
                        while (true) {
                            if (!itr.hasNext()) {
                                FeedbackController.access$4(this.this$1).clear();
                                exp.createSimpleMethodInvoke((IProxyMethod)FeedbackController.access$5(this.this$1), FeedbackController.access$1(this.this$1), null, false);
                                exp.invokeExpression();
                            }
                            ControlManager manager = (ControlManager)itr.next();
                            ControlManager.access$0(manager, exp);
                        }
                    }
                    catch (IllegalStateException e) {
                        JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                    }
                    catch (ThrowableProxy e) {
                        JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                    }
                    catch (NoExpressionValueException e) {
                        JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    exp.close();
                    throw throwable;
                }
                {
                    Object var4_9 = null;
                }
                exp.close();
            }
        };

        public FeedbackController(ExpressionProxy feedbackControllerProxy) {
            IProxyMethod postChangesDone;
            this.feedbackControllerProxy = feedbackControllerProxy;
            feedbackControllerProxy.addProxyListener(new ExpressionProxy.ProxyListener(this){
                final /* synthetic */ FeedbackController this$1;
                {
                    this.this$1 = feedbackController;
                }

                public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                    FeedbackController.access$6(this.this$1, (IProxy)event.getProxy());
                }

                public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                    FeedbackController.access$6(this.this$1, null);
                }

                public void proxyVoid(ExpressionProxy.ProxyEvent event) {
                    FeedbackController.access$6(this.this$1, null);
                }
            });
            IProxyMethod postInitial = feedbackControllerProxy.getExpression().getRegistry().getMethodProxyFactory().getMethodProxy((IExpression)feedbackControllerProxy.getExpression(), "org.eclipse.ve.internal.swt.targetvm.ControlManager$ControlManagerFeedbackController", "postInitialRefresh", null);
            if (postInitial.isBeanProxy()) {
                this.postInitialRefresh = (IMethodProxy)postInitial;
            } else {
                ((ExpressionProxy)postInitial).addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(this){
                    final /* synthetic */ FeedbackController this$1;
                    {
                        this.this$1 = feedbackController;
                    }

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        FeedbackController.access$7(this.this$1, (IMethodProxy)event.getProxy());
                    }
                });
            }
            IProxyMethod postImages = feedbackControllerProxy.getExpression().getRegistry().getMethodProxyFactory().getMethodProxy((IExpression)feedbackControllerProxy.getExpression(), "org.eclipse.ve.internal.swt.targetvm.ControlManager$ControlManagerFeedbackController", "postInvalidImages", null);
            if (postImages.isBeanProxy()) {
                this.postInvalidImages = (IMethodProxy)postImages;
            } else {
                ((ExpressionProxy)postImages).addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(this){
                    final /* synthetic */ FeedbackController this$1;
                    {
                        this.this$1 = feedbackController;
                    }

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        FeedbackController.access$8(this.this$1, (IMethodProxy)event.getProxy());
                    }
                });
            }
            this.startingChanges = feedbackControllerProxy.getExpression().getRegistry().getMethodProxyFactory().getMethodProxy((IExpression)feedbackControllerProxy.getExpression(), "org.eclipse.ve.internal.swt.targetvm.ControlManager$ControlManagerFeedbackController", "startingChanges", null);
            if (this.startingChanges.isExpressionProxy()) {
                ((ExpressionProxy)this.startingChanges).addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(this){
                    final /* synthetic */ FeedbackController this$1;
                    {
                        this.this$1 = feedbackController;
                    }

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        FeedbackController.access$9(this.this$1, (IProxyMethod)event.getProxy());
                    }
                });
            }
            if ((postChangesDone = feedbackControllerProxy.getExpression().getRegistry().getMethodProxyFactory().getMethodProxy((IExpression)feedbackControllerProxy.getExpression(), "org.eclipse.ve.internal.swt.targetvm.ControlManager$ControlManagerFeedbackController", "postChanges", null)).isBeanProxy()) {
                this.postChangesDone = (IMethodProxy)postChangesDone;
            } else {
                ((ExpressionProxy)postChangesDone).addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(this){
                    final /* synthetic */ FeedbackController this$1;
                    {
                        this.this$1 = feedbackController;
                    }

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        FeedbackController.access$10(this.this$1, (IMethodProxy)event.getProxy());
                    }
                });
            }
        }

        void startChanges(ModelChangeController controller, IExpression expression) {
            if (!this.changesHeld) {
                this.changesHeld = true;
                expression.createSimpleMethodInvoke(this.startingChanges, this.feedbackControllerProxy, null, false);
                controller.execAtEndOfTransaction(this.changesDoneRunnable, (Object)this.changesDoneRunnable);
            }
        }

        void queueInitialRefresh(ModelChangeController controller) {
            controller.execAtEndOfTransaction(this.initialRefreshRunnable, (Object)this.initialRefreshRunnable);
        }

        public IProxy getProxy() {
            return this.feedbackControllerProxy;
        }

        public void registerFeedbackNotifier(ControlManagerFeedbackControllerNotifier notifier, IBeanProxy notifierProxy) {
            this.managerProxyToNotifier.put(notifierProxy, notifier);
        }

        public void deregisterFeedbackNotifier(IBeanProxy notifierProxy) {
            this.managerProxyToNotifier.remove(notifierProxy);
        }

        void queueInvalidate(ControlManager manager, ModelChangeController controller) {
            this.pendingInvalidates.add(manager);
            controller.execAtEndOfTransaction(this.invalidateRunnable, (Object)this.invalidateRunnable);
        }

        public Object calledBack(int msgID, IBeanProxy parm) {
            throw new RuntimeException("A component listener has been called back incorrectly");
        }

        public Object calledBack(int msgID, Object[] parms) {
            if (msgID == 4) {
                if (VisualComponentsLayoutPolicy.DO_VC_TRACING) {
                    System.out.println("Start feedback transaction. #trans=" + parms.length / 3);
                }
                int i = 0;
                while (i < parms.length) {
                    ControlManagerFeedbackControllerNotifier notifier;
                    if ((notifier = (ControlManagerFeedbackControllerNotifier)this.managerProxyToNotifier.get(parms[i++])) != null) {
                        notifier.calledBack(((IIntegerBeanProxy)parms[i++]).intValue(), (Object[])parms[i++]);
                        continue;
                    }
                    i += 2;
                }
                if (VisualComponentsLayoutPolicy.DO_VC_TRACING) {
                    System.out.println("Stop feedback transaction.");
                }
            }
            return null;
        }

        public Object calledBack(int msgID, Object parm) {
            throw new RuntimeException("A component listener has been called back incorrectly");
        }

        public void calledBackStream(int msgID, InputStream is) {
            throw new RuntimeException("A component listener has been called back incorrectly");
        }

        static /* synthetic */ void access$0(FeedbackController feedbackController, boolean bl) {
            feedbackController.changesHeld = bl;
        }

        static /* synthetic */ IProxy access$1(FeedbackController feedbackController) {
            return feedbackController.feedbackControllerProxy;
        }

        static /* synthetic */ IMethodProxy access$2(FeedbackController feedbackController) {
            return feedbackController.postChangesDone;
        }

        static /* synthetic */ IMethodProxy access$3(FeedbackController feedbackController) {
            return feedbackController.postInitialRefresh;
        }

        static /* synthetic */ Set access$4(FeedbackController feedbackController) {
            return feedbackController.pendingInvalidates;
        }

        static /* synthetic */ IMethodProxy access$5(FeedbackController feedbackController) {
            return feedbackController.postInvalidImages;
        }

        static /* synthetic */ void access$6(FeedbackController feedbackController, IProxy iProxy) {
            feedbackController.feedbackControllerProxy = iProxy;
        }

        static /* synthetic */ void access$7(FeedbackController feedbackController, IMethodProxy iMethodProxy) {
            feedbackController.postInitialRefresh = iMethodProxy;
        }

        static /* synthetic */ void access$8(FeedbackController feedbackController, IMethodProxy iMethodProxy) {
            feedbackController.postInvalidImages = iMethodProxy;
        }

        static /* synthetic */ void access$9(FeedbackController feedbackController, IProxyMethod iProxyMethod) {
            feedbackController.startingChanges = iProxyMethod;
        }

        static /* synthetic */ void access$10(FeedbackController feedbackController, IMethodProxy iMethodProxy) {
            feedbackController.postChangesDone = iMethodProxy;
        }
    }
}

