/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.InstantiationPackage;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTInstanceReference;
import org.eclipse.jem.internal.instantiation.PTMethodInvocation;
import org.eclipse.jem.internal.instantiation.PTName;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.propertysheet.common.commands.CommandWrapper;

public class EnsureCorrectParentCommand
extends CommandWrapper {
    private IJavaObjectInstance javaChild;
    private IJavaObjectInstance correctParent;

    public EnsureCorrectParentCommand(IJavaObjectInstance aChild, IJavaObjectInstance correctParent) {
        this.javaChild = aChild;
        this.correctParent = correctParent;
    }

    public void execute() {
        if (this.javaChild.getAllocation() != null && this.javaChild.getAllocation() instanceof ParseTreeAllocation) {
            CommandBuilder cbldr = new CommandBuilder(false);
            PTExpression expression = ((ParseTreeAllocation)this.javaChild.getAllocation()).getExpression();
            if (expression instanceof PTClassInstanceCreation) {
                this.visitClassInstanceCreation((PTClassInstanceCreation)expression, cbldr);
            } else if (expression instanceof PTMethodInvocation) {
                this.visitMethodInvocation((PTMethodInvocation)expression, cbldr);
            }
            if (!cbldr.isEmpty()) {
                ParseTreeAllocation newAlloc = InstantiationFactory.eINSTANCE.createParseTreeAllocation();
                cbldr.applyAttributeSetting((EObject)newAlloc, (EStructuralFeature)InstantiationPackage.eINSTANCE.getParseTreeAllocation_Expression(), (Object)expression);
                cbldr.applyAttributeSetting((EObject)this.javaChild, (EStructuralFeature)JavaInstantiation.getAllocationFeature((IJavaInstance)this.javaChild), (Object)newAlloc);
                this.command = cbldr.getCommand();
                this.command.execute();
            }
        }
    }

    private void visitClassInstanceCreation(PTClassInstanceCreation expression, CommandBuilder cbldr) {
        this.visitArguments((EObject)expression, (EStructuralFeature)InstantiationPackage.eINSTANCE.getPTClassInstanceCreation_Arguments(), (List)expression.getArguments(), cbldr);
    }

    private void visitMethodInvocation(PTMethodInvocation expression, CommandBuilder cbldr) {
        this.visitArguments((EObject)expression, (EStructuralFeature)InstantiationPackage.eINSTANCE.getPTMethodInvocation_Arguments(), (List)expression.getArguments(), cbldr);
    }

    private void visitArguments(EObject expression, EStructuralFeature feature, List arguments, CommandBuilder cbldr) {
        ArrayList argsCopy = new ArrayList(arguments.size());
        argsCopy.addAll(arguments);
        int i = 0;
        while (i < argsCopy.size()) {
            PTInstanceReference instanceReference;
            Object argument = argsCopy.get(i);
            if (argument instanceof PTName && "{parentComposite}".equals(((PTName)argument).getName())) {
                PTInstanceReference parentRef = InstantiationFactory.eINSTANCE.createPTInstanceReference();
                parentRef.setObject(this.correctParent);
                cbldr.replaceAttributeSetting(expression, feature, (Object)parentRef, i);
            } else if (argument instanceof PTInstanceReference && (instanceReference = (PTInstanceReference)argument).getObject() != this.correctParent) {
                cbldr.applyAttributeSetting((EObject)instanceReference, (EStructuralFeature)InstantiationPackage.eINSTANCE.getPTInstanceReference_Object(), (Object)this.correctParent);
            }
            ++i;
        }
    }

    protected boolean prepare() {
        return true;
    }
}

