/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jem.internal.instantiation.PTClassInstanceCreation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.PTMethodInvocation;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.FontPropertyEditorMessages;

public class FontCustomPropertyEditor
extends Composite {
    protected static final String[] styleNames = new String[]{FontPropertyEditorMessages.normalStyle, FontPropertyEditorMessages.boldStyle, FontPropertyEditorMessages.italicStyle, FontPropertyEditorMessages.boldItalicStyle};
    protected static final int[] styleValues;
    protected static final int[] sizeValues;
    protected static final String[] jfaceFontNames;
    protected static final String[] jfaceNameConstants;
    protected static final String[] jfaceNameInitStrings;
    protected static final String[] jfaceStyleNames;
    protected static final String[] jfaceStyleMethodNames;
    protected static final int JFACE_NORMAL = 0;
    protected static final int JFACE_BOLD = 1;
    protected static final int JFACE_ITALIC = 2;
    protected static Set fontNames;
    protected static Set lowerCaseFontNames;
    private List fPropertyChangeListeners;
    private IJavaObjectInstance fExistingValue;
    private Text nameField;
    private Text styleField;
    private Text sizeField;
    private org.eclipse.swt.widgets.List namesList;
    private org.eclipse.swt.widgets.List stylesList;
    private org.eclipse.swt.widgets.List sizesList;
    private Text previewText;
    private boolean isUpdating = false;
    private boolean isJFace = false;
    private JFaceFontInfo jfaceFontInfo;
    protected Font value;
    private TabFolder tabFolder = null;
    private Composite namedFontsTab = null;
    private Composite jfaceFontsTab = null;
    private Label jfaceNameLabel = null;
    private Label jfaceStyleLabel = null;
    private Text jfaceNameField = null;
    private Text jfaceStyleField = null;
    private org.eclipse.swt.widgets.List jfaceNamesList = null;
    private org.eclipse.swt.widgets.List jfaceStylesList = null;
    private EditDomain fEditDomain = null;
    private Label initStringLabel = null;
    private boolean lookupIsJFaceProject = true;
    private boolean isJFaceProject = false;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        styleValues = nArray;
        sizeValues = new int[]{8, 10, 12, 14, 18, 24, 36, 48, 72};
        jfaceFontNames = new String[]{FontPropertyEditorMessages.jfaceBannerFontName, FontPropertyEditorMessages.jfaceDefaultFontName, FontPropertyEditorMessages.jfaceDialogFontName, FontPropertyEditorMessages.jfaceHeaderFontName, FontPropertyEditorMessages.jfaceTextFontName};
        jfaceNameConstants = new String[]{"org.eclipse.jface.bannerfont", "org.eclipse.jface.defaultfont", "org.eclipse.jface.dialogfont", "org.eclipse.jface.headerfont", "org.eclipse.jface.textfont"};
        jfaceNameInitStrings = new String[]{"org.eclipse.jface.resource.JFaceResources.BANNER_FONT", "org.eclipse.jface.resource.JFaceResources.DEFAULT_FONT", "org.eclipse.jface.resource.JFaceResources.DIALOG_FONT", "org.eclipse.jface.resource.JFaceResources.HEADER_FONT", "org.eclipse.jface.resource.JFaceResources.TEXT_FONT"};
        jfaceStyleNames = new String[]{FontPropertyEditorMessages.normalStyle, FontPropertyEditorMessages.boldStyle, FontPropertyEditorMessages.italicStyle};
        jfaceStyleMethodNames = new String[]{"get", "getBold", "getItalic"};
    }

    public FontCustomPropertyEditor(Composite parent, int style, Font value, IJavaObjectInstance existingValue, EditDomain editDomain) {
        super(parent, style);
        this.value = value;
        this.fEditDomain = editDomain;
        this.fExistingValue = existingValue;
        this.initialize();
    }

    private void initialize() {
        GridData gridData1 = new GridData();
        this.setSize(new Point(322, 245));
        GridLayout grid = new GridLayout();
        grid.horizontalSpacing = 1;
        grid.verticalSpacing = 1;
        this.setLayout((Layout)grid);
        this.createTabFolder();
        this.initializeLists();
        this.previewText = new Text((Composite)this, 2882);
        this.previewText.setText(FontPropertyEditorMessages.previewText);
        GridData gd03 = new GridData();
        this.initStringLabel = new Label((Composite)this, 0);
        gd03.horizontalAlignment = 4;
        gd03.verticalAlignment = 4;
        gd03.grabExcessHorizontalSpace = true;
        gd03.grabExcessVerticalSpace = true;
        gd03.heightHint = 50;
        gd03.widthHint = 500;
        this.previewText.setLayoutData((Object)gd03);
        grid.numColumns = 3;
        this.initStringLabel.setText("");
        this.initStringLabel.setLayoutData((Object)gridData1);
        this.initStringLabel.setForeground(Display.getDefault().getSystemColor(9));
        gridData1.horizontalAlignment = 4;
        gridData1.verticalAlignment = 2;
        gridData1.horizontalSpan = 3;
        this.createFontFromProxy((Control)this);
        this.updateSelections();
        if (this.isJFaceProject()) {
            this.updateJFaceSelections();
        }
        this.nameField.selectAll();
    }

    private void initializeLists() {
        this.namesList.removeAll();
        Iterator iter = this.getFontNames().iterator();
        while (iter.hasNext()) {
            this.namesList.add((String)iter.next());
        }
        this.stylesList.setItems(styleNames);
        this.sizesList.removeAll();
        int i = 0;
        while (i < sizeValues.length) {
            this.sizesList.add(String.valueOf(sizeValues[i]));
            ++i;
        }
    }

    private void initializeJfaceLists() {
        this.jfaceNamesList.setItems(jfaceFontNames);
        this.jfaceStylesList.setItems(jfaceStyleNames);
    }

    private void createFontFromProxy(Control control) {
        if (this.fExistingValue == null) {
            return;
        }
        try {
            IBeanProxy fontProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.fExistingValue);
            if (fontProxy != null) {
                Font newValue;
                IBeanTypeProxy fontType = fontProxy.getTypeProxy();
                IMethodProxy getFontData = fontType.getMethodProxy("getFontData");
                IArrayBeanProxy fontDataArrayProxy = (IArrayBeanProxy)getFontData.invoke(fontProxy);
                int len = fontDataArrayProxy.getLength();
                FontData[] fontData = new FontData[len];
                int i = 0;
                while (i < len) {
                    IBeanProxy fontDataProxy = fontDataArrayProxy.get(i);
                    IBeanTypeProxy fontDataType = fontDataProxy.getTypeProxy();
                    IMethodProxy getHeight = fontDataType.getMethodProxy("getHeight");
                    IMethodProxy getStyle = fontDataType.getMethodProxy("getStyle");
                    IMethodProxy getName = fontDataType.getMethodProxy("getName");
                    int height = ((IIntegerBeanProxy)getHeight.invoke(fontDataProxy)).intValue();
                    int style = ((IIntegerBeanProxy)getStyle.invoke(fontDataProxy)).intValue();
                    String name = ((IStringBeanProxy)getName.invoke(fontDataProxy)).stringValue();
                    fontData[i] = new FontData(name, height, style);
                    ++i;
                }
                this.value = newValue = new Font((Device)control.getDisplay(), fontData);
            }
        }
        catch (ThrowableProxy throwableProxy) {}
    }

    protected Set getFontNames() {
        if (fontNames == null) {
            fontNames = new TreeSet(new StringIgnoreCaseComparator());
            FontData[] fd = this.getDisplay().getFontList(null, true);
            int i = 0;
            while (i < fd.length) {
                fontNames.add(fd[i].getName());
                ++i;
            }
        }
        return fontNames;
    }

    public void setValue(Object v) {
        if (v != null && v instanceof Font) {
            this.value = (Font)v;
        }
        if (this.fPropertyChangeListeners != null) {
            Iterator iter = this.fPropertyChangeListeners.iterator();
            while (iter.hasNext()) {
                ((PropertyChangeListener)iter.next()).propertyChange(new PropertyChangeEvent((Object)this, "value", v, null));
            }
        }
    }

    public String getJavaInitializationString() {
        String SWT_PREFIX = "org.eclipse.swt.SWT";
        if (this.value == null) {
            return "null";
        }
        if (!this.isJFace) {
            String style;
            FontData fd = this.value.getFontData()[0];
            switch (fd.getStyle()) {
                case 0: {
                    style = String.valueOf(SWT_PREFIX) + ".NORMAL";
                    break;
                }
                case 1: {
                    style = String.valueOf(SWT_PREFIX) + ".BOLD";
                    break;
                }
                case 2: {
                    style = String.valueOf(SWT_PREFIX) + ".ITALIC";
                    break;
                }
                case 3: {
                    style = String.valueOf(SWT_PREFIX) + ".BOLD | " + SWT_PREFIX + ".ITALIC";
                    break;
                }
                default: {
                    style = String.valueOf(SWT_PREFIX) + ".NORMAL";
                }
            }
            return "new org.eclipse.swt.graphics.Font(org.eclipse.swt.widgets.Display.getDefault(), \"" + fd.getName() + "\", " + String.valueOf(fd.getHeight()) + ", " + style + ")";
        }
        String results = "";
        switch (this.jfaceFontInfo.style) {
            case 0: {
                results = "org.eclipse.jface.resource.JFaceResources.getFontRegistry().get(" + this.jfaceFontInfo.name + ")";
                break;
            }
            case 1: {
                results = "org.eclipse.jface.resource.JFaceResources.getFontRegistry().getBold(" + this.jfaceFontInfo.name + ")";
                break;
            }
            case 2: {
                results = "org.eclipse.jface.resource.JFaceResources.getFontRegistry().getItalic(" + this.jfaceFontInfo.name + ")";
                break;
            }
            default: {
                results = "org.eclipse.jface.resource.JFaceResources.getFontRegistry().get(" + this.jfaceFontInfo.name + ")";
            }
        }
        return results;
    }

    public Font getValue() {
        return this.value;
    }

    protected Set getLowerCaseFontNames() {
        if (lowerCaseFontNames == null) {
            lowerCaseFontNames = new TreeSet();
            Iterator iter = this.getFontNames().iterator();
            while (iter.hasNext()) {
                lowerCaseFontNames.add(((String)iter.next()).toLowerCase());
            }
        }
        return lowerCaseFontNames;
    }

    private int searchFontNames(String search) {
        int index = 0;
        if (search.length() > 0) {
            search = search.toLowerCase();
            Set lcfn = this.getLowerCaseFontNames();
            Iterator iter = lcfn.iterator();
            while (iter.hasNext()) {
                if (((String)iter.next()).compareTo(search) >= 0) break;
                ++index;
            }
            if (index >= lcfn.size()) {
                index = lcfn.size();
            }
        }
        return index;
    }

    private void updateFont() {
        Font f;
        this.isJFace = false;
        if (this.namesList.getSelectionCount() == 0 || this.stylesList.getSelectionCount() == 0) {
            return;
        }
        int newSize = 1;
        if (this.sizeField.getText().length() > 0) {
            newSize = Integer.parseInt(this.sizeField.getText());
        } else if (this.sizesList.getItemCount() > 0) {
            this.sizesList.setSelection(0);
            String smallestSize = this.sizesList.getItem(0);
            newSize = Integer.parseInt(smallestSize);
            this.sizeField.setText(smallestSize);
        }
        try {
            f = new Font((Device)this.getDisplay(), this.namesList.getSelection()[0], newSize, styleValues[this.stylesList.getSelectionIndex()]);
        }
        catch (SWTError sWTError) {
            return;
        }
        this.previewText.setFont(f);
        if (this.value != null && !this.value.isDisposed()) {
            this.value.dispose();
        }
        this.setValue(f);
        if (!this.isUpdating) {
            this.updateLabelInitializationString();
        }
    }

    private void updateJFaceFont() {
        Font f;
        if (this.jfaceNamesList.getSelectionCount() == 0 || this.jfaceStylesList.getSelectionCount() == 0) {
            return;
        }
        this.isJFace = true;
        this.jfaceFontInfo = new JFaceFontInfo();
        this.jfaceFontInfo.name = jfaceNameInitStrings[this.jfaceNamesList.getSelectionIndex()];
        String jfaceFontName = jfaceNameConstants[this.jfaceNamesList.getSelectionIndex()];
        switch (this.jfaceStylesList.getSelectionIndex()) {
            case 0: {
                this.jfaceFontInfo.style = 0;
                f = JFaceResources.getFontRegistry().get(jfaceFontName);
                break;
            }
            case 1: {
                this.jfaceFontInfo.style = 1;
                f = JFaceResources.getFontRegistry().getBold(jfaceFontName);
                break;
            }
            case 2: {
                this.jfaceFontInfo.style = 2;
                f = JFaceResources.getFontRegistry().getItalic(jfaceFontName);
                break;
            }
            default: {
                this.jfaceFontInfo.style = 0;
                f = JFaceResources.getFontRegistry().get(jfaceFontName);
            }
        }
        f = new Font((Device)this.getDisplay(), f.getFontData());
        this.previewText.setFont(f);
        if (this.value != null && !this.value.isDisposed()) {
            this.value.dispose();
        }
        this.setValue(f);
        this.updateLabelInitializationString();
    }

    private void updateSelections() {
        ParseTreeAllocation ptAlloc;
        PTExpression exp;
        if (this.value == null) {
            return;
        }
        this.isUpdating = true;
        FontData fd = this.value.getFontData()[0];
        this.namesList.setSelection(new String[]{fd.getName()});
        this.nameField.setText(fd.getName());
        int i = 0;
        while (i < styleValues.length) {
            if (fd.getStyle() == styleValues[i]) {
                this.stylesList.setSelection(i);
                this.styleField.setText(styleNames[i]);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < sizeValues.length) {
            if (fd.getHeight() == sizeValues[i]) {
                this.sizesList.setSelection(i);
                break;
            }
            ++i;
        }
        this.sizeField.setText(String.valueOf(fd.getHeight()));
        this.previewText.setFont(this.value);
        if (this.fExistingValue != null && this.fExistingValue.getAllocation() instanceof ParseTreeAllocation && (exp = (ptAlloc = (ParseTreeAllocation)this.fExistingValue.getAllocation()).getExpression()) instanceof PTClassInstanceCreation) {
            this.updateLabelInitializationString();
        }
        this.isUpdating = false;
    }

    private void updateJFaceSelections() {
        ParseTreeAllocation ptAlloc;
        PTExpression exp;
        this.isUpdating = true;
        this.jfaceStylesList.setSelection(0);
        if (this.fExistingValue != null && this.fExistingValue.getAllocation() instanceof ParseTreeAllocation && (exp = (ptAlloc = (ParseTreeAllocation)this.fExistingValue.getAllocation()).getExpression()) instanceof PTMethodInvocation && ((PTMethodInvocation)exp).getReceiver() instanceof PTMethodInvocation && ((PTMethodInvocation)((PTMethodInvocation)exp).getReceiver()).getName().equals("getFontRegistry")) {
            int i;
            this.jfaceFontInfo = new JFaceFontInfo();
            PTExpression arg = (PTExpression)((PTMethodInvocation)exp).getArguments().get(0);
            if (arg instanceof PTFieldAccess) {
                String symbolicName = ((PTFieldAccess)arg).getField();
                i = 0;
                while (i < jfaceNameInitStrings.length) {
                    if (jfaceNameInitStrings[i].endsWith(symbolicName)) {
                        this.jfaceNamesList.setSelection(i);
                        this.jfaceNameField.setText(jfaceFontNames[i]);
                        this.jfaceFontInfo.name = jfaceNameInitStrings[i];
                        break;
                    }
                    ++i;
                }
            }
            String getStyleMethodName = ((PTMethodInvocation)exp).getName();
            i = 0;
            while (i < jfaceStyleMethodNames.length) {
                if (jfaceStyleMethodNames[i].equals(getStyleMethodName)) {
                    this.jfaceStylesList.setSelection(i);
                    this.jfaceStyleField.setText(jfaceStyleNames[i]);
                    this.jfaceFontInfo.style = i;
                    break;
                }
                ++i;
            }
            this.tabFolder.setSelection(1);
            this.isJFace = true;
            this.updateLabelInitializationString();
        }
        this.isUpdating = false;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.fPropertyChangeListeners == null) {
            this.fPropertyChangeListeners = new ArrayList(1);
        }
        this.fPropertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.fPropertyChangeListeners != null) {
            this.fPropertyChangeListeners.remove(listener);
        }
    }

    public void setExistingValue(IJavaObjectInstance existingValue) {
        this.fExistingValue = existingValue;
        this.value = null;
    }

    private void createTabFolder() {
        GridData gridData4 = new GridData();
        this.tabFolder = new TabFolder((Composite)this, 0);
        this.createComposite();
        TabItem tabItem1 = new TabItem(this.tabFolder, 0);
        tabItem1.setControl((Control)this.namedFontsTab);
        tabItem1.setText(FontPropertyEditorMessages.NamedFontsTab);
        if (this.isJFaceProject()) {
            this.createComposite1();
            TabItem tabItem2 = new TabItem(this.tabFolder, 0);
            tabItem2.setControl((Control)this.jfaceFontsTab);
            tabItem2.setText(FontPropertyEditorMessages.JFaceFontsTab);
            this.initializeJfaceLists();
        }
        gridData4.horizontalAlignment = 4;
        gridData4.verticalAlignment = 4;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.grabExcessVerticalSpace = true;
        gridData4.horizontalSpan = 3;
        this.tabFolder.setLayoutData((Object)gridData4);
    }

    private void createComposite() {
        GridLayout gridLayout1 = new GridLayout();
        this.namedFontsTab = new Composite((Composite)this.tabFolder, 0);
        this.namedFontsTab.setLayout((Layout)gridLayout1);
        Label nameLabel = new Label(this.namedFontsTab, 0);
        nameLabel.setText(FontPropertyEditorMessages.nameLabel);
        Label styleLabel = new Label(this.namedFontsTab, 0);
        styleLabel.setText(FontPropertyEditorMessages.styleLabel);
        Label sizeLabel = new Label(this.namedFontsTab, 0);
        sizeLabel.setText(FontPropertyEditorMessages.sizeLabel);
        this.nameField = new Text(this.namedFontsTab, 2052);
        GridData gd01 = new GridData();
        gd01.horizontalAlignment = 4;
        gd01.grabExcessHorizontalSpace = true;
        this.nameField.setLayoutData((Object)gd01);
        this.styleField = new Text(this.namedFontsTab, 2060);
        GridData gd11 = new GridData();
        gd11.horizontalAlignment = 4;
        this.styleField.setLayoutData((Object)gd11);
        this.sizeField = new Text(this.namedFontsTab, 2052);
        GridData gd21 = new GridData();
        gd21.horizontalAlignment = 4;
        this.sizeField.setLayoutData((Object)gd21);
        this.namesList = new org.eclipse.swt.widgets.List(this.namedFontsTab, 2820);
        GridData gd02 = new GridData();
        gd02.horizontalAlignment = 4;
        gd02.verticalAlignment = 4;
        gd02.grabExcessHorizontalSpace = true;
        gd02.grabExcessVerticalSpace = true;
        gd02.heightHint = 100;
        gd02.widthHint = 200;
        this.namesList.setLayoutData((Object)gd02);
        this.stylesList = new org.eclipse.swt.widgets.List(this.namedFontsTab, 2820);
        GridData gd12 = new GridData();
        gd12.horizontalAlignment = 4;
        gd12.verticalAlignment = 4;
        gd12.grabExcessVerticalSpace = true;
        this.stylesList.setLayoutData((Object)gd12);
        this.sizesList = new org.eclipse.swt.widgets.List(this.namedFontsTab, 2820);
        GridData gd22 = new GridData();
        gd22.horizontalAlignment = 4;
        gd22.verticalAlignment = 4;
        gd22.grabExcessVerticalSpace = true;
        gd22.heightHint = 100;
        gd22.widthHint = 40;
        this.sizesList.setLayoutData((Object)gd22);
        gridLayout1.numColumns = 3;
        this.namesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!FontCustomPropertyEditor.this.isUpdating) {
                    String newSelection = FontCustomPropertyEditor.this.namesList.getSelection()[0];
                    FontCustomPropertyEditor.this.isUpdating = true;
                    FontCustomPropertyEditor.this.nameField.setText(newSelection);
                    FontCustomPropertyEditor.this.isUpdating = false;
                }
                FontCustomPropertyEditor.this.updateFont();
            }
        });
        this.nameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!FontCustomPropertyEditor.this.isUpdating) {
                    int newIndex = FontCustomPropertyEditor.this.searchFontNames(FontCustomPropertyEditor.this.nameField.getText());
                    if (FontCustomPropertyEditor.this.namesList.getSelectionIndex() != newIndex) {
                        FontCustomPropertyEditor.this.isUpdating = true;
                        FontCustomPropertyEditor.this.namesList.setSelection(newIndex);
                        FontCustomPropertyEditor.this.isUpdating = false;
                        FontCustomPropertyEditor.this.updateFont();
                    }
                }
            }
        });
        this.nameField.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FontCustomPropertyEditor.this.nameField.selectAll();
            }
        });
        this.stylesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newSelection = FontCustomPropertyEditor.this.stylesList.getSelection()[0];
                FontCustomPropertyEditor.this.styleField.setText(newSelection);
                FontCustomPropertyEditor.this.updateFont();
            }
        });
        this.sizesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newSelection = FontCustomPropertyEditor.this.sizesList.getSelection()[0];
                FontCustomPropertyEditor.this.sizeField.setText(newSelection);
                FontCustomPropertyEditor.this.updateFont();
            }
        });
        this.sizeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newText = FontCustomPropertyEditor.this.sizeField.getText();
                int newSize = 1;
                if (newText.length() > 0) {
                    try {
                        newSize = Integer.parseInt(newText);
                        if (newSize < 1) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        FontCustomPropertyEditor.this.sizeField.setText(String.valueOf(FontCustomPropertyEditor.this.value.getFontData()[0].getHeight()));
                        return;
                    }
                }
                FontCustomPropertyEditor.this.updateFont();
                FontCustomPropertyEditor.this.sizesList.deselectAll();
                int i = 0;
                while (i < sizeValues.length) {
                    if (newSize == sizeValues[i]) {
                        FontCustomPropertyEditor.this.sizesList.setSelection(i);
                        break;
                    }
                    ++i;
                }
            }
        });
        this.sizeField.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                FontCustomPropertyEditor.this.sizeField.selectAll();
            }
        });
    }

    private void createComposite1() {
        GridData gridData7 = new GridData();
        GridData gridData6 = new GridData();
        GridData gridData41 = new GridData();
        GridData gridData3 = new GridData();
        GridLayout gridLayout11 = new GridLayout();
        this.jfaceFontsTab = new Composite((Composite)this.tabFolder, 0);
        this.jfaceNameLabel = new Label(this.jfaceFontsTab, 0);
        this.jfaceStyleLabel = new Label(this.jfaceFontsTab, 0);
        this.jfaceNameField = new Text(this.jfaceFontsTab, 2048);
        this.jfaceStyleField = new Text(this.jfaceFontsTab, 2056);
        this.jfaceNamesList = new org.eclipse.swt.widgets.List(this.jfaceFontsTab, 2816);
        this.jfaceStylesList = new org.eclipse.swt.widgets.List(this.jfaceFontsTab, 2816);
        gridData3.horizontalAlignment = 4;
        gridData3.verticalAlignment = 2;
        gridData3.grabExcessHorizontalSpace = true;
        this.jfaceNameField.setLayoutData((Object)gridData3);
        gridData41.horizontalAlignment = 4;
        gridData41.verticalAlignment = 2;
        this.jfaceStyleField.setLayoutData((Object)gridData41);
        gridData6.horizontalAlignment = 4;
        gridData6.verticalAlignment = 4;
        gridData6.grabExcessHorizontalSpace = true;
        gridData6.grabExcessVerticalSpace = true;
        gridData6.heightHint = 100;
        gridData6.widthHint = 200;
        this.jfaceNamesList.setLayoutData((Object)gridData6);
        gridData7.horizontalAlignment = 4;
        gridData7.verticalAlignment = 4;
        gridData7.grabExcessVerticalSpace = true;
        this.jfaceStylesList.setLayoutData((Object)gridData7);
        this.jfaceFontsTab.setLayout((Layout)gridLayout11);
        gridLayout11.numColumns = 2;
        this.jfaceNameLabel.setText(FontPropertyEditorMessages.FontCustomPropertyEditor_NameLabel_Text);
        this.jfaceStyleLabel.setText(FontPropertyEditorMessages.FontCustomPropertyEditor_StyleLabel_text);
        this.jfaceNamesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!FontCustomPropertyEditor.this.isUpdating) {
                    String newSelection = FontCustomPropertyEditor.this.jfaceNamesList.getSelection()[0];
                    FontCustomPropertyEditor.this.isUpdating = true;
                    FontCustomPropertyEditor.this.jfaceNameField.setText(newSelection);
                    FontCustomPropertyEditor.this.isUpdating = false;
                }
                FontCustomPropertyEditor.this.updateJFaceFont();
            }
        });
        this.jfaceStylesList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newSelection = FontCustomPropertyEditor.this.jfaceStylesList.getSelection()[0];
                FontCustomPropertyEditor.this.jfaceStyleField.setText(newSelection);
                FontCustomPropertyEditor.this.updateJFaceFont();
            }
        });
    }

    protected boolean isJFaceProject() {
        if (this.lookupIsJFaceProject) {
            this.isJFaceProject = BeanSWTUtilities.isJFaceProject(this.fEditDomain);
        }
        return this.isJFaceProject;
    }

    private void updateLabelInitializationString() {
        if (this.value == null) {
            return;
        }
        String SWT_PREFIX = "SWT";
        String result = "";
        if (!this.isJFace) {
            String style;
            FontData fd = this.value.getFontData()[0];
            switch (fd.getStyle()) {
                case 0: {
                    style = String.valueOf(SWT_PREFIX) + ".NORMAL";
                    break;
                }
                case 1: {
                    style = String.valueOf(SWT_PREFIX) + ".BOLD";
                    break;
                }
                case 2: {
                    style = String.valueOf(SWT_PREFIX) + ".ITALIC";
                    break;
                }
                case 3: {
                    style = String.valueOf(SWT_PREFIX) + ".BOLD | " + SWT_PREFIX + ".ITALIC";
                    break;
                }
                default: {
                    style = String.valueOf(SWT_PREFIX) + ".NORMAL";
                }
            }
            result = "new Font(Display.getDefault(), \"" + fd.getName() + "\", " + String.valueOf(fd.getHeight()) + ", " + style + ")";
        } else {
            String fontname = this.jfaceFontInfo.name.replaceAll("org.eclipse.jface.resource.JFaceResources", "JFaceResources");
            switch (this.jfaceFontInfo.style) {
                case 0: {
                    result = "JFaceResources.getFontRegistry().get(" + fontname + ")";
                    break;
                }
                case 1: {
                    result = "JFaceResources.getFontRegistry().getBold(" + fontname + ")";
                    break;
                }
                case 2: {
                    result = "JFaceResources.getFontRegistry().getItalic(" + fontname + ")";
                    break;
                }
                default: {
                    result = "JFaceResources.getFontRegistry().get(" + fontname + ")";
                }
            }
        }
        this.initStringLabel.setText(result);
        this.initStringLabel.setToolTipText(result);
    }

    public class StringIgnoreCaseComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).compareToIgnoreCase((String)o2);
            }
            return -1;
        }

        public boolean equals(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return ((String)o1).equalsIgnoreCase((String)o2);
            }
            return false;
        }
    }

    public class JFaceFontInfo {
        String name = "org.eclipse.jface.defaultfont";
        int style = 0;
    }
}

