/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.ve.internal.swt.GridLayoutPolicyHelper;

public class GridLayoutGridFigure
extends Figure {
    public static final int ROW_COLUMN_SENSITIVITY = 5;
    Rectangle clientArea;
    Point mousePosition;
    int[] columnPositions;
    int[] rowPositions;
    Point[] rowStartPositions;
    Point[] rowEndPositions;
    Point[] columnStartPositions;
    Point[] columnEndPositions;
    int[][] columnSegments;
    int[][] rowSegments;
    int marginWidth;
    int marginHeight;
    int verticalSpacing;
    int horizontalSpacing;

    public GridLayoutGridFigure(Rectangle bounds, int[][] layoutDimensions, EObject[][] cellContents, Rectangle spacing, Rectangle clientArea) {
        this.setBounds(bounds);
        this.clientArea = clientArea;
        if (spacing == null) {
            GridLayout example = new GridLayout();
            this.marginWidth = example.marginWidth;
            this.marginHeight = example.marginHeight;
            this.horizontalSpacing = example.horizontalSpacing;
            this.verticalSpacing = example.verticalSpacing;
        } else {
            this.marginWidth = spacing.x;
            this.marginHeight = spacing.y;
            this.horizontalSpacing = spacing.width;
            this.verticalSpacing = spacing.height;
        }
        if (layoutDimensions != null) {
            int[] columnWidths = layoutDimensions[0];
            int[] rowHeights = layoutDimensions[1];
            this.columnSegments = this.calculateColumnDividers(columnWidths, rowHeights, cellContents);
            this.rowSegments = this.calculateRowDividers(columnWidths, rowHeights, cellContents);
        }
    }

    protected void paintFigure(Graphics g) {
        g.setForegroundColor(ColorConstants.gray);
        g.setLineStyle(3);
        this.drawColumnDividers(g);
        this.drawRowDividers(g);
    }

    protected int[][] calculateColumnDividers(int[] columnWidths, int[] rowHeights, EObject[][] cellContents) {
        if (rowHeights == null || columnWidths == null || this.clientArea == null) {
            return null;
        }
        int spacingLeft = (int)Math.ceil((double)this.horizontalSpacing / 2.0);
        int spacingRight = (int)Math.floor((double)this.horizontalSpacing / 2.0);
        int spacingTop = (int)Math.ceil((double)this.verticalSpacing / 2.0);
        int spacingBottom = (int)Math.floor((double)this.verticalSpacing / 2.0);
        Rectangle r = this.getBounds();
        int containerHeight = 0;
        this.columnPositions = new int[columnWidths.length + 1];
        this.columnStartPositions = new Point[this.columnPositions.length];
        this.columnEndPositions = new Point[this.columnPositions.length];
        int[][] columnSegments = new int[this.columnPositions.length][];
        int i = 0;
        while (i < rowHeights.length) {
            containerHeight += rowHeights[i];
            ++i;
        }
        containerHeight += this.marginHeight * 2;
        int xPos = r.x + this.clientArea.x;
        int yMin = r.y + this.clientArea.y;
        int yMax = r.y + this.clientArea.y + (containerHeight += this.verticalSpacing * (rowHeights.length - 1));
        int xMax = xPos + this.clientArea.width - 1;
        this.columnPositions[0] = xPos;
        this.columnStartPositions[0] = new Point(xPos, yMin);
        this.columnEndPositions[0] = new Point(xPos, yMax);
        columnSegments[0] = new int[]{yMin, yMax};
        xPos += this.marginWidth;
        int[] colSegs = new int[2 + rowHeights.length * 2];
        int i2 = 1;
        while (i2 < this.columnPositions.length) {
            xPos += columnWidths[i2 - 1];
            xPos = i2 < columnWidths.length ? (xPos += spacingLeft) : (xPos += this.marginWidth);
            xPos = Math.min(xPos, xMax);
            Point startPoint = new Point(xPos, yMin);
            Point endPoint = new Point(xPos, yMax);
            this.columnPositions[i2] = xPos;
            this.columnStartPositions[i2] = startPoint;
            this.columnEndPositions[i2] = endPoint;
            if (i2 < columnWidths.length) {
                EObject[] leftColumn = cellContents[i2 - 1];
                EObject[] rightColumn = cellContents[i2];
                int yPos = yMin;
                int lastRow = leftColumn.length - 1;
                int colSegsNdx = 0;
                colSegs[colSegsNdx] = yMin;
                boolean prevSpan = true;
                int j = 0;
                while (j < leftColumn.length) {
                    EObject rightObject;
                    int trueRowHeight = rowHeights[j];
                    trueRowHeight = j == 0 ? (trueRowHeight += this.marginHeight) : (trueRowHeight += spacingTop);
                    trueRowHeight = j != lastRow ? (trueRowHeight += spacingBottom) : (trueRowHeight += this.marginHeight);
                    EObject leftObject = leftColumn[j];
                    if (leftObject != GridLayoutPolicyHelper.EMPTY && (rightObject = rightColumn[j]) != GridLayoutPolicyHelper.EMPTY && leftObject == rightObject) {
                        if (!prevSpan) {
                            colSegs[++colSegsNdx] = yPos;
                            ++colSegsNdx;
                        }
                        colSegs[colSegsNdx] = (yPos += trueRowHeight) + 1;
                        prevSpan = true;
                    } else {
                        prevSpan = false;
                        yPos += trueRowHeight;
                    }
                    ++j;
                }
                if (colSegs[colSegsNdx] < yPos) {
                    colSegs[++colSegsNdx] = yMax;
                } else {
                    --colSegsNdx;
                }
                columnSegments[i2] = new int[++colSegsNdx];
                System.arraycopy(colSegs, 0, columnSegments[i2], 0, colSegsNdx);
            } else {
                columnSegments[i2] = new int[]{yMin, yMax};
            }
            xPos += spacingRight;
            ++i2;
        }
        return columnSegments;
    }

    protected void drawColumnDividers(Graphics g) {
        if (this.columnSegments == null || this.columnStartPositions == null) {
            return;
        }
        int i = 0;
        while (i < this.columnSegments.length) {
            int[] colSegs = this.columnSegments[i];
            int xPos = this.columnStartPositions[i].x;
            int j = -1;
            while (++j < colSegs.length) {
                g.drawLine(xPos, colSegs[j], xPos, colSegs[++j]);
            }
            ++i;
        }
    }

    protected int[][] calculateRowDividers(int[] columnWidths, int[] rowHeights, EObject[][] cellContents) {
        if (columnWidths == null || rowHeights == null || this.clientArea == null) {
            return null;
        }
        int spacingLeft = (int)Math.ceil((double)this.horizontalSpacing / 2.0);
        int spacingRight = (int)Math.floor((double)this.horizontalSpacing / 2.0);
        int spacingTop = (int)Math.ceil((double)this.verticalSpacing / 2.0);
        int spacingBottom = (int)Math.floor((double)this.verticalSpacing / 2.0);
        Rectangle r = this.getBounds();
        int containerWidth = 0;
        this.rowPositions = new int[rowHeights.length + 1];
        this.rowStartPositions = new Point[this.rowPositions.length];
        this.rowEndPositions = new Point[this.rowPositions.length];
        int[][] rowSegments = new int[this.rowPositions.length][];
        int i = 0;
        while (i < columnWidths.length) {
            containerWidth += columnWidths[i];
            ++i;
        }
        containerWidth += this.marginWidth * 2;
        int yPos = r.y + this.clientArea.y;
        int xMin = r.x + this.clientArea.x;
        int xMax = r.x + this.clientArea.x + (containerWidth += this.horizontalSpacing * (columnWidths.length - 1));
        int yMax = yPos + this.clientArea.height - 1;
        this.rowPositions[0] = yPos;
        this.rowStartPositions[0] = new Point(xMin, yPos);
        this.rowEndPositions[0] = new Point(xMax, yPos);
        rowSegments[0] = new int[]{xMin, xMax};
        yPos += this.marginHeight;
        int[] rowSegs = new int[2 + columnWidths.length * 2];
        int i2 = 1;
        while (i2 < this.rowPositions.length) {
            yPos += rowHeights[i2 - 1];
            yPos = i2 < rowHeights.length ? (yPos += spacingTop) : (yPos += this.marginHeight);
            yPos = Math.min(yPos, yMax);
            Point startPoint = new Point(xMin, yPos);
            Point endPoint = new Point(xMax, yPos);
            this.rowPositions[i2] = yPos;
            this.rowStartPositions[i2] = startPoint;
            this.rowEndPositions[i2] = endPoint;
            if (i2 < rowHeights.length) {
                int upperRow = i2 - 1;
                int lowerRow = i2;
                int xPos = xMin;
                int lastCol = cellContents.length - 1;
                int rowSegsNdx = 0;
                rowSegs[rowSegsNdx] = xMin;
                boolean prevSpan = true;
                int j = 0;
                while (j < cellContents.length) {
                    EObject lowerObject;
                    int trueColWidth = columnWidths[j];
                    trueColWidth = j == 0 ? (trueColWidth += this.marginWidth) : (trueColWidth += spacingLeft);
                    trueColWidth = j != lastCol ? (trueColWidth += spacingRight) : (trueColWidth += this.marginWidth);
                    EObject upperObject = cellContents[j][upperRow];
                    if (upperObject != GridLayoutPolicyHelper.EMPTY && (lowerObject = cellContents[j][lowerRow]) != GridLayoutPolicyHelper.EMPTY && upperObject == lowerObject) {
                        if (!prevSpan) {
                            rowSegs[++rowSegsNdx] = xPos;
                            ++rowSegsNdx;
                        }
                        rowSegs[rowSegsNdx] = (xPos += trueColWidth) + 1;
                        prevSpan = true;
                    } else {
                        xPos += trueColWidth;
                        prevSpan = false;
                    }
                    ++j;
                }
                if (rowSegs[rowSegsNdx] < xPos) {
                    rowSegs[++rowSegsNdx] = xMax;
                } else {
                    --rowSegsNdx;
                }
                rowSegments[i2] = new int[++rowSegsNdx];
                System.arraycopy(rowSegs, 0, rowSegments[i2], 0, rowSegsNdx);
            } else {
                rowSegments[i2] = new int[]{xMin, xMax};
            }
            yPos += spacingBottom;
            ++i2;
        }
        return rowSegments;
    }

    protected void drawRowDividers(Graphics g) {
        if (this.rowSegments == null || this.rowStartPositions == null) {
            return;
        }
        int i = 0;
        while (i < this.rowSegments.length) {
            int[] rowSegs = this.rowSegments[i];
            int yPos = this.rowStartPositions[i].y;
            int j = -1;
            while (++j < rowSegs.length) {
                g.drawLine(rowSegs[j], yPos, rowSegs[++j], yPos);
            }
            ++i;
        }
    }

    public Point getCellLocation(Point p) {
        return this.getCellLocation(p.x, p.y);
    }

    public Point getCellLocation(int x, int y) {
        return this.getCellLocation(x, y, false, false);
    }

    public Point getCellLocation(int x, int y, boolean includeEmptyColumns, boolean includeEmptyRows) {
        int j;
        if (this.rowPositions == null || this.columnPositions == null) {
            return new Point(-1, -1);
        }
        int gridx = 0;
        int gridy = 0;
        boolean foundx = false;
        boolean foundy = false;
        int i = 0;
        while (i < this.columnPositions.length - 1) {
            int xpos = this.columnPositions[i];
            if (x >= xpos && x < this.columnPositions[i + 1]) {
                gridx = i;
                if (includeEmptyColumns) {
                    j = i;
                    while (j >= 0 && this.columnPositions[i] == this.columnPositions[j]) {
                        --j;
                    }
                    gridx = j + 1;
                }
                foundx = true;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.rowPositions.length - 1) {
            int ypos = this.rowPositions[i];
            if (y >= ypos && y < this.rowPositions[i + 1]) {
                gridy = i;
                if (includeEmptyRows) {
                    j = i;
                    while (j >= 0 && this.rowPositions[i] == this.rowPositions[j]) {
                        --j;
                    }
                    gridy = j + 1;
                }
                foundy = true;
                break;
            }
            ++i;
        }
        if (!foundx && x >= this.columnPositions[this.columnPositions.length - 1]) {
            gridx = -1;
        }
        if (!foundy && y >= this.rowPositions[this.rowPositions.length - 1]) {
            gridy = -1;
        }
        return new Point(gridx, gridy);
    }

    public Rectangle getCellBounds(int x, int y) {
        if (this.rowPositions == null || this.columnPositions == null) {
            return new Rectangle();
        }
        int cellxpos = 0;
        int cellypos = 0;
        int cellwidth = 0;
        int cellheight = 0;
        int i = 0;
        while (i < this.columnPositions.length - 1) {
            int xpos = this.columnPositions[i];
            if (x >= xpos && x < this.columnPositions[i + 1]) {
                cellxpos = xpos;
                cellwidth = this.columnPositions[i + 1] - xpos;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < this.rowPositions.length - 1) {
            int ypos = this.rowPositions[i];
            if (y >= ypos && y < this.rowPositions[i + 1]) {
                cellypos = ypos;
                cellheight = this.rowPositions[i + 1] - ypos;
                break;
            }
            ++i;
        }
        return new Rectangle(cellxpos, cellypos, cellwidth, cellheight);
    }

    public Rectangle getGridBroundsForCellBounds(Rectangle cellsBounds) {
        Rectangle r = new Rectangle();
        if (this.rowPositions != null && this.columnPositions != null && cellsBounds.y <= this.rowPositions.length - 1 && cellsBounds.x <= this.columnPositions.length - 1) {
            r.x = this.columnPositions[cellsBounds.x];
            r.y = this.rowPositions[cellsBounds.y];
            r.width = cellsBounds.x + cellsBounds.width > this.columnPositions.length - 1 ? this.columnPositions[this.columnPositions.length - 1] : this.columnPositions[cellsBounds.x + cellsBounds.width];
            r.width -= r.x;
            r.height = cellsBounds.y + cellsBounds.height > this.rowPositions.length - 1 ? this.rowPositions[this.rowPositions.length - 1] : this.rowPositions[cellsBounds.y + cellsBounds.height];
            r.height -= r.y;
        }
        return r;
    }

    public Point getColumnStartPosition(int x) {
        if (this.columnStartPositions != null) {
            int i = 0;
            while (i < this.columnPositions.length) {
                int xpos = this.columnPositions[i];
                if (x >= xpos - 5 && x <= xpos + 5) {
                    return this.columnStartPositions[i];
                }
                ++i;
            }
        }
        return new Point(0, 0);
    }

    public Point getColumnEndPosition(int x) {
        if (this.columnEndPositions != null) {
            int i = 0;
            while (i < this.columnPositions.length) {
                int xpos = this.columnPositions[i];
                if (x >= xpos - 5 && x <= xpos + 5) {
                    return this.columnEndPositions[i];
                }
                ++i;
            }
        }
        return new Point(0, 0);
    }

    public Point getRowStartPosition(int y) {
        if (this.rowStartPositions != null) {
            int i = 0;
            while (i < this.rowPositions.length) {
                int ypos = this.rowPositions[i];
                if (y >= ypos - 5 && y <= ypos + 5) {
                    return this.rowStartPositions[i];
                }
                ++i;
            }
        }
        return new Point(0, 0);
    }

    public Point getRowEndPosition(int y) {
        if (this.rowStartPositions != null) {
            int i = 0;
            while (i < this.rowPositions.length) {
                int ypos = this.rowPositions[i];
                if (y >= ypos - 5 && y <= ypos + 5) {
                    return this.rowEndPositions[i];
                }
                ++i;
            }
        }
        return new Point(0, 0);
    }

    public boolean isPointerNearAColumn(int x) {
        if (this.columnPositions == null) {
            return false;
        }
        int i = 0;
        while (i < this.columnPositions.length) {
            int xpos = this.columnPositions[i];
            if (x >= xpos - 5 && x <= xpos + 5) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isPointerNearARow(int y) {
        if (this.rowPositions == null) {
            return false;
        }
        int i = 0;
        while (i < this.rowPositions.length) {
            int ypos = this.rowPositions[i];
            if (y >= ypos - 5 && y <= ypos + 5) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getNearestRow(int y) {
        if (this.rowPositions == null || this.rowPositions.length == 0) {
            return 0;
        }
        int row = 0;
        int value = Math.abs(0 - y);
        int i = 0;
        while (i < this.rowPositions.length) {
            int diff = Math.abs(this.rowPositions[i] - y);
            if (diff < value) {
                row = i;
                value = diff;
            }
            ++i;
        }
        return row;
    }

    public int getNearestColumn(int x) {
        if (this.columnPositions == null || this.columnPositions.length == 0) {
            return 0;
        }
        int column = 0;
        int value = Math.abs(0 - x);
        int i = 0;
        while (i < this.columnPositions.length) {
            int diff = Math.abs(this.columnPositions[i] - x);
            if (diff < value) {
                column = i;
                value = diff;
            }
            ++i;
        }
        return column;
    }
}

