/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ve.internal.swt.GridLayoutLayoutPage;
import org.eclipse.ve.internal.swt.SWTMessages;

public class GridLayoutLayoutComposite
extends Composite {
    private Button equalWidthCheckBox;
    private GridLayoutLayoutPage parentPage;
    private Spinner numColumnsSpinner;
    private Spinner horizontalSpinner;
    private Spinner verticalSpinner;
    private Spinner heightSpinner;
    private Spinner widthSpinner;
    private boolean initialized = false;
    private Composite composite = null;
    protected ModifyListener spinnerModify = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            if (GridLayoutLayoutComposite.this.initialized) {
                Spinner spinner = (Spinner)e.widget;
                if (spinner == GridLayoutLayoutComposite.this.numColumnsSpinner) {
                    GridLayoutLayoutComposite.this.parentPage.propertyChanged(2, String.valueOf(GridLayoutLayoutComposite.this.numColumnsSpinner.getSelection()));
                } else if (spinner == GridLayoutLayoutComposite.this.horizontalSpinner) {
                    GridLayoutLayoutComposite.this.parentPage.propertyChanged(3, String.valueOf(GridLayoutLayoutComposite.this.horizontalSpinner.getSelection()));
                } else if (spinner == GridLayoutLayoutComposite.this.verticalSpinner) {
                    GridLayoutLayoutComposite.this.parentPage.propertyChanged(4, String.valueOf(GridLayoutLayoutComposite.this.verticalSpinner.getSelection()));
                } else if (spinner == GridLayoutLayoutComposite.this.heightSpinner) {
                    GridLayoutLayoutComposite.this.parentPage.propertyChanged(5, String.valueOf(GridLayoutLayoutComposite.this.heightSpinner.getSelection()));
                } else if (spinner == GridLayoutLayoutComposite.this.widthSpinner) {
                    GridLayoutLayoutComposite.this.parentPage.propertyChanged(6, String.valueOf(GridLayoutLayoutComposite.this.widthSpinner.getSelection()));
                }
            }
        }
    };

    public GridLayoutLayoutComposite(GridLayoutLayoutPage parentPage, Composite parent, int style) {
        super(parent, style);
        this.parentPage = parentPage;
        this.initialize();
    }

    private void initialize() {
        this.setLayout((Layout)new RowLayout());
        this.createComposite();
        Group spaceGroup = new Group((Composite)this, 0);
        GridLayout g3 = new GridLayout();
        g3.numColumns = 2;
        spaceGroup.setLayout((Layout)g3);
        spaceGroup.setText(SWTMessages.GridLayoutLayoutPage_spacingTitle);
        Label l2 = new Label((Composite)spaceGroup, 0);
        l2.setText(SWTMessages.GridLayoutLayoutPage_horizontalSpacing);
        this.horizontalSpinner = new Spinner((Composite)spaceGroup, 2048);
        this.horizontalSpinner.addModifyListener(this.spinnerModify);
        GridData gd3 = new GridData();
        gd3.grabExcessHorizontalSpace = true;
        l2.setLayoutData((Object)gd3);
        Label l3 = new Label((Composite)spaceGroup, 0);
        l3.setText(SWTMessages.GridLayoutLayoutPage_verticalSpacing);
        this.verticalSpinner = new Spinner((Composite)spaceGroup, 2048);
        this.verticalSpinner.addModifyListener(this.spinnerModify);
        Label l4 = new Label((Composite)spaceGroup, 0);
        l4.setText(SWTMessages.GridLayoutLayoutPage_marginWidth);
        this.widthSpinner = new Spinner((Composite)spaceGroup, 2048);
        this.widthSpinner.addModifyListener(this.spinnerModify);
        Label l5 = new Label((Composite)spaceGroup, 0);
        l5.setText(SWTMessages.GridLayoutLayoutPage_marginHeight);
        this.heightSpinner = new Spinner((Composite)spaceGroup, 2048);
        this.heightSpinner.addModifyListener(this.spinnerModify);
        this.setSize(new Point(344, 147));
    }

    private void createComposite() {
        this.composite = new Composite((Composite)this, 0);
        this.composite.setLayout((Layout)new GridLayout());
        Group colGroup = new Group(this.composite, 0);
        GridData gd0 = new GridData();
        gd0.verticalAlignment = 1;
        colGroup.setLayoutData((Object)gd0);
        GridLayout g2 = new GridLayout();
        g2.numColumns = 2;
        colGroup.setLayout((Layout)g2);
        colGroup.setText(SWTMessages.GridLayoutLayoutPage_columnsTitle);
        Label l1 = new Label((Composite)colGroup, 0);
        l1.setText(SWTMessages.GridLayoutLayoutPage_numColumns);
        GridData gd4 = new GridData();
        gd4.grabExcessHorizontalSpace = true;
        l1.setLayoutData((Object)gd4);
        this.numColumnsSpinner = new Spinner((Composite)colGroup, 2048);
        this.numColumnsSpinner.setMinimum(1);
        this.numColumnsSpinner.addModifyListener(this.spinnerModify);
        this.equalWidthCheckBox = new Button((Composite)colGroup, 32);
        this.equalWidthCheckBox.setText(SWTMessages.GridLayoutLayoutPage_columnsEqualWidth);
        GridData gd1 = new GridData();
        gd1.horizontalSpan = 2;
        this.equalWidthCheckBox.setLayoutData((Object)gd1);
        this.equalWidthCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GridLayoutLayoutComposite.this.initialized) {
                    GridLayoutLayoutComposite.this.parentPage.propertyChanged(7, new Boolean(GridLayoutLayoutComposite.this.equalWidthCheckBox.getSelection()));
                }
            }
        });
    }

    protected void setInitialValues(Object[] values) {
        if (values == null || values.length != 7) {
            return;
        }
        this.numColumnsSpinner.setSelection(((Integer)values[1]).intValue());
        this.horizontalSpinner.setSelection(((Integer)values[2]).intValue());
        this.verticalSpinner.setSelection(((Integer)values[3]).intValue());
        this.heightSpinner.setSelection(((Integer)values[4]).intValue());
        this.widthSpinner.setSelection(((Integer)values[5]).intValue());
        this.equalWidthCheckBox.setSelection(((Boolean)values[6]).booleanValue());
        this.initialized = true;
    }
}

