/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ve.internal.swt.ImageController;

public class ImageScreenDisplay
extends Canvas {
    private int numOfCols = 1;
    private int numOfRows = 1;
    private int suggestNumOfCols;
    private int suggestNumOfRows;
    private int width;
    private int height;
    private int currentRow = 0;
    private int currentCol = 0;
    private int currentImageIndex = 0;
    private Image[] visibleImages = EMPTY_IMAGES;
    private static Image[] EMPTY_IMAGES = new Image[0];
    private int lastSelectedIndex = -1;
    private int lastToolTipIndex = -1;
    private int offset;
    private int borderOffset;
    private ArrayList paths = new ArrayList();
    private boolean workspacePaths;
    private IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private boolean selectable;
    private SelectionListener selectionListener;
    private boolean enableToolTip;

    public ImageScreenDisplay(Composite parent, int style, int rows, int cols, int width, int height, boolean enableSelectable, boolean enableToolTip, int offset, int borderOffset) {
        super(parent, style);
        this.suggestNumOfCols = cols;
        this.suggestNumOfRows = rows;
        this.height = height;
        this.width = width;
        this.selectable = enableSelectable;
        this.offset = offset;
        this.borderOffset = borderOffset;
        this.enableToolTip = enableToolTip;
        this.initialize();
        this.resetScrollBarProperties();
        this.addListeners();
    }

    public void setIsWorkspacePaths(boolean workspacePaths) {
        this.workspacePaths = workspacePaths;
    }

    public void add(IPath filepath) {
        this.paths.add(filepath);
        this.resetRowsAndCols();
        int index = this.paths.size() - 1;
        if (this.verticalIndexVisible(index) || this.horizontalIndexVisible(index)) {
            this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        ImageScreenDisplay.this.setupImages();
                    }
                    catch (SWTException sWTException) {}
                }
            });
        }
    }

    private void addListeners() {
        ScrollBar vBar;
        final ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.addSelectionListener((org.eclipse.swt.events.SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int newCol = hBar.getSelection();
                    if (newCol != ImageScreenDisplay.this.currentCol) {
                        ImageScreenDisplay.this.scrollTo(ImageScreenDisplay.this.currentRow, newCol, false);
                    }
                }
            });
        }
        if ((vBar = this.getVerticalBar()) != null) {
            vBar.addSelectionListener((org.eclipse.swt.events.SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int newRow = vBar.getSelection();
                    if (newRow != ImageScreenDisplay.this.currentRow) {
                        ImageScreenDisplay.this.scrollTo(newRow, ImageScreenDisplay.this.currentCol, false);
                    }
                }
            });
        }
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ImageScreenDisplay.this.resetRowsAndCols();
                ImageScreenDisplay.this.setupImages();
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                ImageScreenDisplay.this.drawImagesAndLabels(event);
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                ImageScreenDisplay.this.redraw();
            }

            public void focusLost(FocusEvent e) {
                ImageScreenDisplay.this.redraw();
            }
        });
        if (this.selectable) {
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    int imageIndex = ImageScreenDisplay.this.findImageIndexFromPosition(e.x, e.y);
                    if (imageIndex >= 0) {
                        ImageScreenDisplay.this.setSelected(imageIndex);
                    }
                }

                public void mouseDoubleClick(MouseEvent e) {
                    if (ImageScreenDisplay.this.selectionListener != null) {
                        ImageScreenDisplay.this.selectionListener.imageDefaultSelected();
                    }
                }
            });
        }
        if (this.enableToolTip) {
            this.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    int imageIndex = ImageScreenDisplay.this.findImageIndexFromPosition(e.x, e.y);
                    if (ImageScreenDisplay.this.lastToolTipIndex != imageIndex) {
                        if (imageIndex == -1) {
                            ImageScreenDisplay.this.setToolTipText("");
                        } else {
                            ImageScreenDisplay.this.setToolTipText(((IPath)ImageScreenDisplay.this.paths.get(imageIndex)).toString());
                        }
                        ImageScreenDisplay.this.lastToolTipIndex = imageIndex;
                    }
                }
            });
        }
        this.addKeyListener(new KeyboardNavigationListener());
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4 || e.detail == 16 || e.detail == 8) {
                    e.doit = true;
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ImageScreenDisplay.this.visibleImages != null) {
                    ImageScreenDisplay.this.disposeImages(0, ImageScreenDisplay.this.visibleImages.length);
                    ImageScreenDisplay.this.visibleImages = EMPTY_IMAGES;
                }
            }
        });
    }

    private void setupImages() {
        int move;
        int firstVisIndex = this.getFirstVisibleIndex();
        int visCols = this.getNumOfVisibleCols();
        int visRows = this.getNumOfVisibleRows();
        int newVisSize = visCols * visRows;
        Image[] newImages = null;
        int index = 0;
        int imageIndex = firstVisIndex;
        Rectangle redrawRect = null;
        Display display = this.getDisplay();
        int firstVisibleNull = 0;
        while (firstVisibleNull < this.visibleImages.length) {
            if (this.visibleImages[firstVisibleNull] == null) break;
            ++firstVisibleNull;
        }
        if (firstVisIndex != this.currentImageIndex) {
            newImages = new Image[newVisSize];
            if (firstVisIndex < this.currentImageIndex) {
                while (imageIndex < this.currentImageIndex && index < newImages.length) {
                    newImages[index] = this.getImage(display, imageIndex);
                    ++imageIndex;
                    ++index;
                }
                if (imageIndex == this.currentImageIndex) {
                    move = Math.min(newImages.length - index, firstVisibleNull);
                    System.arraycopy(this.visibleImages, 0, newImages, index, move);
                    index += move;
                    imageIndex += move;
                    this.disposeImages(move, firstVisibleNull);
                } else {
                    this.disposeImages(0, firstVisibleNull);
                }
                this.visibleImages = newImages;
                this.currentImageIndex = firstVisIndex;
                redrawRect = this.getClientArea();
            } else {
                int startOld = firstVisIndex - this.currentImageIndex;
                if (startOld < firstVisibleNull) {
                    int move2 = Math.min(firstVisibleNull - startOld, newImages.length);
                    System.arraycopy(this.visibleImages, startOld, newImages, index, move2);
                    this.disposeImages(0, startOld);
                    this.disposeImages(startOld + move2, firstVisibleNull);
                    index += move2;
                    imageIndex += move2;
                } else {
                    this.disposeImages(0, firstVisibleNull);
                }
                this.visibleImages = newImages;
                this.currentImageIndex = firstVisIndex;
                redrawRect = this.getClientArea();
            }
        } else if (this.visibleImages.length != newVisSize) {
            newImages = new Image[newVisSize];
            move = Math.min(firstVisibleNull, newVisSize);
            System.arraycopy(this.visibleImages, index, newImages, index, move);
            imageIndex += move;
            if ((index += move) < firstVisibleNull) {
                this.disposeImages(index, firstVisibleNull);
            }
            this.visibleImages = newImages;
            this.currentImageIndex = firstVisIndex;
            redrawRect = this.getClientArea();
        } else {
            index += firstVisibleNull;
            imageIndex += firstVisibleNull;
        }
        int pathsLength = this.itemsSize();
        while (index < this.visibleImages.length && imageIndex < pathsLength) {
            this.visibleImages[index] = this.getImage(display, imageIndex);
            Rectangle imageBounds = this.getImageBounds(imageIndex);
            if (redrawRect == null) {
                redrawRect = imageBounds;
            } else {
                redrawRect.add(imageBounds);
            }
            ++index;
            ++imageIndex;
        }
        if (redrawRect != null) {
            this.redraw(redrawRect.x, redrawRect.y, redrawRect.width, redrawRect.height, false);
        }
    }

    private Image getImage(Display display, int imageIndex) {
        String filename = this.getFileName((IPath)this.paths.get(imageIndex));
        if (filename != null) {
            try {
                int newHeight;
                Image img = new Image((Device)display, filename);
                Rectangle bounds = img.getBounds();
                int newWidth = bounds.width < this.width ? bounds.width : this.width;
                int n = newHeight = bounds.height < this.height ? bounds.height : this.height;
                if (newWidth != bounds.width || newHeight != bounds.height) {
                    Image tnImage = new Image((Device)display, newWidth, newHeight);
                    GC tnGC = new GC((Drawable)tnImage);
                    tnGC.drawImage(img, 0, 0, bounds.width, bounds.height, 0, 0, newWidth, newHeight);
                    img.dispose();
                    img = tnImage;
                    tnGC.dispose();
                }
                return img;
            }
            catch (SWTException sWTException) {
                return ImageController.warnIcon;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                return ImageController.noMemoryIcon;
            }
        }
        return null;
    }

    private String getFileName(IPath path) {
        if (this.workspacePaths) {
            IResource res = this.workspaceRoot.findMember(path);
            if (res != null) {
                return res.getLocation().toOSString();
            }
        } else {
            return path.toOSString();
        }
        return null;
    }

    private void scrollTo(int row, int col, boolean holdSetup) {
        if (this.currentRow != row || this.currentCol != col) {
            this.currentRow = row;
            this.currentCol = col;
            this.resetScrollBarProperties();
            if (!holdSetup) {
                this.setupImages();
            }
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.selectionListener = listener;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.selectionListener = null;
    }

    public static int calculateGridIndex(int row, int col, int numberOfCols) {
        return row * numberOfCols + col;
    }

    private void drawImage(int gridIndex, GC gc) {
        int imageIndex = gridIndex - this.currentImageIndex;
        if (this.currentImageIndex != -1 && imageIndex < this.visibleImages.length) {
            Rectangle imageDrawingBounds = this.getImageBounds(gridIndex);
            if (imageDrawingBounds == null || !gc.getClipping().intersects(imageDrawingBounds)) {
                return;
            }
            Image img = this.visibleImages[imageIndex];
            if (img != null) {
                gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, imageDrawingBounds.x, imageDrawingBounds.y, imageDrawingBounds.width, imageDrawingBounds.height);
            }
        }
    }

    private void drawImagesAndLabels(PaintEvent event) {
        GC gc = event.gc;
        int lastRow = this.getLastVisibleRow();
        int lastCol = this.getLastVisibleCol();
        int row = this.getFirstVisibleRow();
        while (row <= lastRow) {
            int col = this.getFirstVisibleCol();
            while (col <= lastCol) {
                int index = row * this.getNumOfCols() + col;
                if (index >= this.itemsSize()) break;
                this.drawImage(index, gc);
                ++col;
            }
            ++row;
        }
        this.drawCursor(this.lastSelectedIndex, gc);
    }

    public int findImageIndexFromPosition(int posX, int posY) {
        int row = this.currentRow + (posY - this.borderOffset) / this.height;
        int col = this.currentCol + (posX - this.borderOffset) / this.width;
        int index = ImageScreenDisplay.calculateGridIndex(row, col, this.numOfCols);
        if (index < this.itemsSize() && this.getDisplayBounds(index).contains(new Point(posX, posY))) {
            return index;
        }
        return -1;
    }

    private Rectangle getDisplayBounds(int index) {
        Point pos = this.getGridPosition(index);
        return new Rectangle(pos.x + this.offset, pos.y + this.offset, this.width - 2 * this.offset, this.height - 2 * this.offset);
    }

    public int getFirstVisibleCol() {
        return this.currentCol;
    }

    public int getFirstVisibleRow() {
        return this.currentRow;
    }

    private Point getGridPosition(int gridIndex) {
        if (gridIndex >= this.getNumOfGrids()) {
            gridIndex = 0;
        }
        int rowNumber = gridIndex / this.numOfCols;
        int colNumber = gridIndex % this.numOfCols;
        int xPosition = this.width * (colNumber - this.currentCol) + this.borderOffset;
        int yPosition = this.height * (rowNumber - this.currentRow) + this.borderOffset;
        return new Point(xPosition, yPosition);
    }

    public Point getGridSize() {
        return new Point(this.width, this.height);
    }

    private Rectangle getImageBounds(int index) {
        Image img;
        int visibleIndex = index - this.currentImageIndex;
        if (visibleIndex >= 0 && visibleIndex < this.visibleImages.length && (img = this.visibleImages[visibleIndex]) != null) {
            double vRatio;
            double hRatio;
            Rectangle bounds = img.getBounds();
            Point imageSize = new Point(bounds.width, bounds.height);
            Rectangle displayBounds = this.getDisplayBounds(index);
            double ratio = imageSize.x <= displayBounds.width && imageSize.y <= displayBounds.height ? 1.0 : ((hRatio = (double)imageSize.x / (double)displayBounds.width) > (vRatio = (double)imageSize.y / (double)displayBounds.height) ? hRatio : vRatio);
            int newWidth = Math.max((int)Math.floor((double)imageSize.x / ratio), 5);
            int newHeight = Math.max((int)Math.floor((double)imageSize.y / ratio), 5);
            int newXPosition = displayBounds.x + (displayBounds.width - newWidth) / 2;
            int newYPosition = displayBounds.y + (displayBounds.height - newHeight) / 2;
            return new Rectangle(newXPosition, newYPosition, newWidth, newHeight);
        }
        return null;
    }

    public Point getImageSize() {
        return new Point(this.width - 2 * this.offset, this.height - 2 * this.offset);
    }

    private int getLastVisibleCol() {
        return this.getFirstVisibleCol() + this.getNumOfVisibleCols() - 1;
    }

    private int getLastVisibleRow() {
        return this.getFirstVisibleRow() + this.getNumOfVisibleRows() - 1;
    }

    public int getNumOfCols() {
        return this.numOfCols;
    }

    public int getNumOfGrids() {
        return this.numOfCols * this.numOfRows;
    }

    public int getNumOfRows() {
        return this.numOfRows;
    }

    public int getNumOfVisibleCols() {
        double cols = (double)(this.getClientArea().width - this.borderOffset) / (double)this.width;
        return this.getHorizontalBar() != null ? (int)Math.ceil(cols) : (int)cols;
    }

    public int getNumOfVisibleRows() {
        double rows = (double)(this.getClientArea().height - this.borderOffset) / (double)this.height;
        return this.getVerticalBar() != null ? (int)Math.ceil(rows) : (int)rows;
    }

    public IPath getSelectedImagePath() {
        if (this.lastSelectedIndex < 0) {
            return null;
        }
        return (IPath)this.paths.get(this.lastSelectedIndex);
    }

    private int getTotalGridHeight() {
        return this.numOfRows * this.height;
    }

    private int getTotalGridWidth() {
        return this.numOfCols * this.width;
    }

    private void initialize() {
        this.setBackground(ColorConstants.white);
    }

    public void removeAll() {
        this.paths.clear();
        this.lastSelectedIndex = -1;
        ScrollBar vBar = this.getVerticalBar();
        if (vBar != null) {
            vBar.setSelection(0);
        }
        this.currentRow = 0;
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar != null) {
            hBar.setSelection(0);
        }
        this.currentCol = 0;
        this.currentImageIndex = 0;
        this.disposeImages(0, this.visibleImages.length);
        this.visibleImages = EMPTY_IMAGES;
        this.resetRowsAndCols();
        this.setupImages();
    }

    private void disposeImages(int startIndex, int endIndex) {
        int i = startIndex;
        while (i < endIndex && i < this.visibleImages.length) {
            Image img = this.visibleImages[i];
            if (img != null) {
                if (img != ImageController.noMemoryIcon && img != ImageController.warnIcon && img != ImageController.errorIcon) {
                    this.visibleImages[i].dispose();
                }
                this.visibleImages[i] = null;
            }
            ++i;
        }
    }

    private void resetHScrollBarProperties() {
        ScrollBar hBar = this.getHorizontalBar();
        if (hBar == null) {
            return;
        }
        int displayWidth = this.getClientArea().width;
        if (displayWidth - this.borderOffset >= this.getTotalGridWidth()) {
            hBar.setEnabled(false);
            return;
        }
        hBar.setEnabled(true);
        int numVisibleCols = this.getNumOfVisibleCols();
        hBar.setValues(this.currentCol, 0, this.numOfCols + 1, numVisibleCols, 1, numVisibleCols - 1);
    }

    private void resetRowsAndCols() {
        int rows;
        boolean hBar = this.getHorizontalBar() != null;
        boolean vBar = this.getVerticalBar() != null;
        int cols = !hBar ? Math.max(this.getNumOfVisibleCols(), 1) : this.suggestNumOfCols;
        if (!vBar) {
            rows = Math.max(this.getNumOfRows() / this.height, 1);
            if (hBar) {
                cols = (int)Math.ceil((double)this.paths.size() / (double)this.numOfRows);
            }
        } else {
            rows = Math.max((int)Math.ceil((double)this.paths.size() / (double)this.numOfCols), 1);
        }
        if (cols != this.numOfCols) {
            this.numOfCols = cols;
            this.resetHScrollBarProperties();
        }
        if (rows != this.numOfRows) {
            this.numOfRows = rows;
            this.resetVScrollBarProperties();
        }
    }

    private void resetScrollBarProperties() {
        this.resetHScrollBarProperties();
        this.resetVScrollBarProperties();
    }

    private void resetVScrollBarProperties() {
        ScrollBar vBar = this.getVerticalBar();
        if (vBar == null) {
            return;
        }
        int displayHeight = this.getClientArea().height;
        if (displayHeight - this.borderOffset >= this.getTotalGridHeight()) {
            vBar.setEnabled(false);
            return;
        }
        vBar.setEnabled(true);
        int numVisRows = this.getNumOfVisibleRows();
        vBar.setValues(this.currentRow, 0, this.numOfRows + 1, numVisRows, 1, numVisRows - 1);
    }

    private void drawCursor(int index, GC gc) {
        if (index < 0) {
            Rectangle bounds = this.getDisplayBounds(0);
            Rectangle focusBounds = new Rectangle(bounds.x - this.borderOffset, bounds.y - this.borderOffset, bounds.width + this.borderOffset * 2, bounds.height + this.borderOffset * 2);
            if (focusBounds.intersects(this.getClientArea()) && focusBounds.intersects(gc.getClipping())) {
                this.drawFocus(focusBounds, gc);
            }
            return;
        }
        Rectangle bounds = this.getDisplayBounds(index);
        Rectangle focusBounds = new Rectangle(bounds.x - this.borderOffset, bounds.y - this.borderOffset, bounds.width + this.borderOffset * 2, bounds.height + this.borderOffset * 2);
        if (focusBounds.intersects(this.getClientArea()) && focusBounds.intersects(gc.getClipping())) {
            this.drawFocus(focusBounds, gc);
            Color oldBackground = gc.getBackground();
            gc.setBackground(ColorConstants.menuBackgroundSelected);
            focusBounds.x += 2;
            focusBounds.y += 2;
            focusBounds.height -= 3;
            focusBounds.width -= 3;
            gc.fillRectangle(focusBounds);
            this.drawImage(index, gc);
            gc.setBackground(oldBackground);
        }
    }

    private void drawFocus(Rectangle focusBounds, GC gc) {
        if (this.isFocusControl()) {
            Color oldForeground = gc.getForeground();
            gc.setForeground(ColorConstants.gray);
            int oldLS = gc.getLineStyle();
            gc.setLineStyle(3);
            gc.drawRectangle(focusBounds);
            gc.setForeground(oldForeground);
            gc.setLineStyle(oldLS);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean change) {
        int tempWidth = this.width * this.suggestNumOfCols + this.borderOffset;
        int tempHeight = this.height * this.suggestNumOfRows + this.borderOffset;
        if (wHint != -1) {
            tempWidth = wHint;
        }
        if (hHint != -1) {
            tempHeight = hHint;
        }
        Rectangle rect = this.computeTrim(0, 0, tempWidth, tempHeight);
        return new Point(rect.width, rect.height);
    }

    public int getNumOfImages() {
        return this.itemsSize();
    }

    public int getNumOfVisibleImages() {
        return this.getNumOfVisibleCols() * this.getNumOfVisibleRows();
    }

    public int getSelectedColNum() {
        int result = this.isValidIndex(this.lastSelectedIndex) ? this.lastSelectedIndex % this.numOfCols : this.lastSelectedIndex;
        return result;
    }

    public int getSelectedRowNum() {
        int result = this.isValidIndex(this.lastSelectedIndex) ? this.lastSelectedIndex / this.numOfCols : this.lastSelectedIndex;
        return result;
    }

    public void deselect() {
        if (this.lastSelectedIndex >= 0 && this.lastSelectedIndex < this.itemsSize()) {
            this.lastSelectedIndex = -1;
            this.fireSelection(-1);
            this.redraw();
        }
    }

    private void fireSelection(int index) {
        if (this.selectionListener != null) {
            this.selectionListener.imageSelected(index);
        }
    }

    public boolean setSelected(int index) {
        boolean success = false;
        if (this.selectable && this.isValidIndex(index) && index != this.lastSelectedIndex) {
            this.lastSelectedIndex = index;
            success = true;
            this.redraw();
            this.fireSelection(index);
        }
        return success;
    }

    public boolean setSelected(IPath path) {
        int index = this.paths.indexOf(path);
        return index != -1 ? this.setSelected(index) : false;
    }

    public void showSelection() {
        boolean needToSetupImages = false;
        if (!this.verticalIndexVisible(this.lastSelectedIndex)) {
            this.showVerticalSelection();
            needToSetupImages = true;
        }
        if (!this.horizontalIndexVisible(this.lastSelectedIndex)) {
            this.showHorizontalSelection();
            needToSetupImages = true;
        }
        if (needToSetupImages) {
            this.setupImages();
        }
    }

    private void showVerticalSelection() {
        if (this.isValidIndex(this.lastSelectedIndex)) {
            int newRow = this.lastSelectedIndex / this.numOfCols;
            this.scrollTo(newRow, this.currentCol, true);
        }
    }

    public boolean isValidIndex(int index) {
        return index >= 0 && index < this.itemsSize();
    }

    public int itemsSize() {
        return this.paths.size();
    }

    private void showHorizontalSelection() {
        if (this.isValidIndex(this.lastSelectedIndex)) {
            int newCol = this.lastSelectedIndex % this.numOfCols;
            this.scrollTo(this.currentRow, newCol, true);
        }
    }

    private boolean horizontalIndexVisible(int index) {
        if (this.getHorizontalBar() == null) {
            return true;
        }
        int col = index % this.numOfCols;
        return this.getFirstVisibleCol() <= col && col <= this.getLastVisibleCol();
    }

    private boolean verticalIndexVisible(int index) {
        if (this.getVerticalBar() == null) {
            return true;
        }
        int row = index / this.numOfCols;
        return this.getFirstVisibleRow() <= row && row <= this.getLastVisibleRow();
    }

    public int getFirstVisibleIndex() {
        return this.getFirstVisibleRow() * this.numOfCols + this.getFirstVisibleCol();
    }

    public int getSelectedIndex() {
        return this.selectable ? this.lastSelectedIndex : -1;
    }

    public static interface SelectionListener {
        public void imageSelected(int var1);

        public void imageDefaultSelected();
    }

    private class KeyboardNavigationListener
    implements KeyListener {
        KeyboardNavigationListener() {
        }

        public void keyPressed(KeyEvent kee) {
            if (ImageScreenDisplay.this.selectable && !ImageScreenDisplay.this.isValidIndex(ImageScreenDisplay.this.getSelectedIndex())) {
                this.select(ImageScreenDisplay.this.getFirstVisibleIndex());
                return;
            }
            switch (kee.keyCode) {
                case 0x1000001: {
                    this.select(ImageScreenDisplay.this.lastSelectedIndex - ImageScreenDisplay.this.numOfCols);
                    break;
                }
                case 0x1000002: {
                    this.select(ImageScreenDisplay.this.lastSelectedIndex + ImageScreenDisplay.this.numOfCols);
                    break;
                }
                case 0x1000004: {
                    this.select(ImageScreenDisplay.this.lastSelectedIndex + 1);
                    break;
                }
                case 0x1000003: {
                    this.select(ImageScreenDisplay.this.lastSelectedIndex - 1);
                    break;
                }
                case 0x1000005: {
                    if (this.select(ImageScreenDisplay.this.lastSelectedIndex - ImageScreenDisplay.this.numOfCols * (ImageScreenDisplay.this.getNumOfVisibleRows() - 1))) break;
                    this.select(0);
                    break;
                }
                case 0x1000006: {
                    if (this.select(ImageScreenDisplay.this.lastSelectedIndex + ImageScreenDisplay.this.numOfCols * (ImageScreenDisplay.this.getNumOfVisibleRows() - 1))) break;
                    this.select(ImageScreenDisplay.this.itemsSize() - 1);
                    break;
                }
                case 0x1000007: {
                    if (kee.stateMask == 262144) {
                        this.select(0);
                        break;
                    }
                    this.select(ImageScreenDisplay.this.lastSelectedIndex - ImageScreenDisplay.this.getSelectedColNum());
                    break;
                }
                case 0x1000008: {
                    if (kee.stateMask == 262144) {
                        this.select(ImageScreenDisplay.this.itemsSize() - 1);
                        break;
                    }
                    if (this.select(ImageScreenDisplay.this.lastSelectedIndex - 1 - ImageScreenDisplay.this.getSelectedColNum() + ImageScreenDisplay.this.numOfCols)) break;
                    this.select(ImageScreenDisplay.this.itemsSize() - 1);
                }
            }
        }

        public void keyReleased(KeyEvent kee) {
        }

        private boolean select(int index) {
            boolean success = false;
            if (ImageScreenDisplay.this.isValidIndex(index)) {
                ImageScreenDisplay.this.setSelected(index);
                ImageScreenDisplay.this.showSelection();
                success = true;
            }
            return success;
        }
    }
}

