/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jem.internal.instantiation.InstantiationFactory;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.PTExpression;
import org.eclipse.jem.internal.instantiation.PTFieldAccess;
import org.eclipse.jem.internal.instantiation.PTName;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.workbench.utility.NoASTResolver;
import org.eclipse.jem.workbench.utility.ParseTreeCreationFromAST;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.IJavaCellEditor;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.swt.PropertyDialogEditor;
import org.eclipse.ve.internal.swt.PropertyEditor;

public class JVEDialogCellEditor
extends DialogCellEditor
implements IJavaCellEditor,
INeedData,
IExecutableExtension {
    protected EditDomain fEditDomain;
    private String initString = "";
    private Class chooserClass;
    PropertyEditor chooser = null;
    private Label label;

    public JVEDialogCellEditor(Composite parent) {
        super(parent);
    }

    private Object createValue(Object value) {
        String qualifiedClassName = value.getClass().getName();
        return BeanUtilities.createJavaObject((String)qualifiedClassName, (ResourceSet)JavaEditDomainHelper.getResourceSet((EditDomain)this.fEditDomain), (JavaAllocation)this.getJavaAllocation());
    }

    private JavaAllocation getJavaAllocation() {
        ASTParser parser = ASTParser.newParser((int)2);
        String initString = this.getJavaInitializationString();
        parser.setSource(initString.toCharArray());
        parser.setSourceRange(0, initString.length());
        parser.setKind(1);
        ASTNode ast = parser.createAST(null);
        if (ast == null) {
            return null;
        }
        NoASTResolver res = new NoASTResolver(){

            public PTExpression resolveName(Name name) {
                PTFieldAccess exp = null;
                if (name instanceof QualifiedName && (name.getFullyQualifiedName().startsWith("org.eclipse.swt.SWT.") || name.getFullyQualifiedName().startsWith("org.eclipse.jface.resource.JFaceResources.") || name.getFullyQualifiedName().startsWith("org.eclipse.jface.preference.JFacePreferences."))) {
                    PTName receiver = InstantiationFactory.eINSTANCE.createPTName(((QualifiedName)name).getQualifier().getFullyQualifiedName());
                    exp = InstantiationFactory.eINSTANCE.createPTFieldAccess((PTExpression)receiver, ((QualifiedName)name).getName().getIdentifier());
                    return exp;
                }
                return super.resolveName(name);
            }
        };
        ParseTreeAllocation alloc = InstantiationFactory.eINSTANCE.createParseTreeAllocation();
        alloc.setExpression(new ParseTreeCreationFromAST((ParseTreeCreationFromAST.Resolver)res).createExpression((Expression)ast));
        return alloc;
    }

    public Object openDialogBox(Control cellEditorWindow) {
        IJavaObjectInstance aValue = (IJavaObjectInstance)this.getValue();
        this.chooser.setValue(aValue);
        PropertyDialogEditor chooseDialog = new PropertyDialogEditor(cellEditorWindow.getShell(), this.chooser, ((IFileEditorInput)this.fEditDomain.getEditorPart().getEditorInput()).getFile().getProject());
        int returnCode = chooseDialog.open();
        if (returnCode == 0) {
            this.initString = chooseDialog.getJavaInitializationString();
            return this.createValue(chooseDialog.getValue());
        }
        return null;
    }

    public void setData(Object data) {
        this.fEditDomain = (EditDomain)data;
        if (this.chooser != null && this.chooser instanceof INeedData) {
            ((INeedData)this.chooser).setData(data);
        }
    }

    public String getJavaInitializationString() {
        return this.initString;
    }

    public void setInitializationData(IConfigurationElement ce, String pName, Object initData) {
        if (initData instanceof String) {
            try {
                this.chooserClass = CDEPlugin.getClassFromString((String)((String)initData));
                try {
                    this.chooser = (PropertyEditor)this.chooserClass.newInstance();
                    if (this.chooser instanceof INeedData) {
                        ((INeedData)this.chooser).setData((Object)this.fEditDomain);
                    }
                }
                catch (Exception exc) {
                    JavaVEPlugin.log((Throwable)exc, (Level)Level.WARNING);
                }
            }
            catch (ClassNotFoundException exc) {
                JavaVEPlugin.log((Throwable)exc, (Level)Level.WARNING);
            }
        }
    }

    protected Label getDefaultLabel() {
        return this.label;
    }

    protected Control createContents(Composite cell) {
        this.label = new Label(cell, 16384);
        this.label.setFont(cell.getFont());
        this.label.setBackground(cell.getBackground());
        return this.label;
    }

    protected void updateContents(Object value) {
        if (this.label == null) {
            return;
        }
        if (value instanceof IJavaObjectInstance) {
            this.chooser.setJavaObjectInstanceValue((IJavaObjectInstance)value);
            this.label.setText(this.chooser.getText());
        } else {
            this.label.setText("");
        }
    }
}

