/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.text.MessageFormat;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ve.internal.java.core.StringJavaClassCellEditor;
import org.eclipse.ve.internal.swt.SWTMessages;

public class LinkJavaClassCellEditor
extends StringJavaClassCellEditor {
    private boolean infoMessageDisplayed = false;
    private Link workingLink;

    public LinkJavaClassCellEditor(Composite aComposite) {
        super(aComposite);
    }

    public void dispose() {
        super.dispose();
        if (this.workingLink != null) {
            Composite parent = this.workingLink.getParent();
            this.workingLink = null;
            parent.dispose();
        }
    }

    protected String isCorrectString(String value) {
        this.infoMessageDisplayed = false;
        if (this.workingLink == null) {
            this.workingLink = new Link((Composite)new Shell(Display.getCurrent()), 0);
        }
        try {
            this.workingLink.setText(value);
        }
        catch (Exception exception) {
            this.infoMessageDisplayed = true;
            return SWTMessages.LinkJavaClassCellEditor_NoLink_ERROR_;
        }
        return null;
    }

    protected void fireApplyEditorValue() {
        super.fireApplyEditorValue();
        final String value = this.doGetEditorString();
        if (value != null) {
            String lowCaseValue = value.toLowerCase();
            int openA = lowCaseValue.indexOf("<a>");
            int closeA = lowCaseValue.indexOf("</a>");
            if ((openA == -1 || closeA == -1 || openA > closeA) && !this.infoMessageDisplayed && this.isDirty()) {
                this.infoMessageDisplayed = true;
                final Display display = Display.getCurrent();
                display.asyncExec(new Runnable(){

                    public void run() {
                        Shell shell = display.getActiveShell();
                        if (shell != null) {
                            String message = MessageFormat.format(SWTMessages.LinkJavaClassCellEditor_NoLink_INFO_, value);
                            MessageDialog.openInformation((Shell)shell, (String)SWTMessages.LinkJavaClassCellEditor_NoLinkInfoTitle, (String)message);
                        }
                    }
                });
            }
        }
    }
}

