/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ve.internal.swt.PropertyEditor;
import org.eclipse.ve.internal.swt.SWTMessages;

public class PropertyDialogEditor
extends Dialog {
    protected IProject myProject = null;
    protected PropertyEditor chooser;
    protected String initString;
    protected PropertyChangeListener changeListener;

    public PropertyDialogEditor(Shell parentShell, PropertyEditor aChooser, IProject project) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x80 | 0x400 | 0x10);
        this.myProject = project;
        this.chooser = aChooser;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(SWTMessages.PropertyDialogEditor_dialog_title);
    }

    public Object getValue() {
        return this.chooser.getValue();
    }

    public boolean close() {
        this.initString = this.chooser.getJavaInitializationString();
        return super.close();
    }

    public String getJavaInitializationString() {
        return this.initString;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        final Button okButton = this.getButton(0);
        okButton.setEnabled(false);
        this.changeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                okButton.setEnabled(PropertyDialogEditor.this.chooser.getValue() != null);
            }
        };
        this.chooser.addPropertyChangeListener(this.changeListener);
        okButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (PropertyDialogEditor.this.chooser != null) {
                    PropertyDialogEditor.this.chooser.removePropertyChangeListener(PropertyDialogEditor.this.changeListener);
                }
            }
        });
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout grid = new GridLayout();
        grid.numColumns = 1;
        grid.verticalSpacing = 5;
        composite.setLayout((Layout)grid);
        Control c = this.chooser.createControl(composite, 0);
        GridData gd1 = new GridData();
        gd1.grabExcessHorizontalSpace = true;
        gd1.grabExcessVerticalSpace = true;
        gd1.horizontalAlignment = 4;
        gd1.verticalAlignment = 4;
        c.setLayoutData((Object)gd1);
        PropertyDialogEditor.applyDialogFont((Control)composite);
        return composite;
    }
}

