/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jem.internal.proxy.core.ConfigurationContributorAdapter;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionInfo;
import org.eclipse.jem.internal.proxy.core.IStringBeanProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.osgi.framework.adaptor.core.AbstractFrameworkAdaptor;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.swt.SWTContainer;
import org.eclipse.ve.internal.swt.SWTMessages;
import org.eclipse.ve.internal.swt.SwtPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class SWTConfigurationContributor
extends ConfigurationContributorAdapter {
    public static final String SWT_BUILD_PATH_MARKER = "org.eclipse.ve.swt.buildpath";
    protected IJavaProject javaProject;
    protected IConfigurationContributionInfo fConfigContributionInfo;
    private static Set libraryCaches = new HashSet();
    private static final String argSeperator = "|";
    private static HashMap platformSrcPath = new HashMap(10);

    public void initialize(IConfigurationContributionInfo info) {
        super.initialize(info);
        this.javaProject = info.getJavaProject();
        this.fConfigContributionInfo = info;
    }

    protected static boolean isInterestingLibFile(String name) {
        return name.endsWith(".dll") || name.endsWith(".jnilib") || name.endsWith(".sl") || name.endsWith(".a") || name.indexOf(".so") != -1;
    }

    public static URL generateLibCacheIfNeeded(IFragmentModel frag, String relativePath) {
        return SWTConfigurationContributor.generateLibCacheIfNeeded(frag.getInstallLocation(), relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL generateLibCacheIfNeeded(String srcJarFile, String relativePath) {
        if (srcJarFile == null) {
            return null;
        }
        libraryCaches.add((String.valueOf(srcJarFile) + argSeperator + relativePath).intern());
        File f = new File(srcJarFile);
        if (f.isDirectory()) {
            try {
                return f.toURL();
            }
            catch (MalformedURLException e2) {
                JavaVEPlugin.log((Throwable)e2);
            }
        }
        IPath root = JavaVEPlugin.VE_GENERATED_LIBRARIES_CACHE.append(Integer.toString(f.getAbsolutePath().hashCode()));
        URL url = null;
        String string = root.toString().intern();
        synchronized (string) {
            File target = root.append(relativePath).toFile();
            if (target.exists()) {
                try {
                    return target.toURL();
                }
                catch (MalformedURLException e1) {
                    JavaVEPlugin.log((Throwable)e1);
                    return null;
                }
            }
            target.mkdirs();
            File src = new File(srcJarFile);
            if (!src.isFile()) return url;
            if (!src.getName().endsWith(".jar")) return url;
            try {
                ZipFile zip = new ZipFile(src);
                try {
                    try {
                        Enumeration<? extends ZipEntry> entries = zip.entries();
                        while (true) {
                            Object var13_20;
                            if (!entries.hasMoreElements()) {
                                url = target.toURL();
                            }
                            ZipEntry entry = entries.nextElement();
                            if (!entry.getName().startsWith(relativePath) || !SWTConfigurationContributor.isInterestingLibFile(entry.getName())) continue;
                            InputStream in = zip.getInputStream(entry);
                            try {
                                try {
                                    if (in != null) {
                                        File dest = new File(root.toFile(), entry.getName());
                                        AbstractFrameworkAdaptor.readFile((InputStream)in, (File)dest);
                                        if (!Platform.getOS().equals("win32")) {
                                            Runtime.getRuntime().exec(new String[]{"chmod", "755", dest.getAbsolutePath()}).waitFor();
                                        }
                                    }
                                }
                                catch (IOException e) {
                                    JavaVEPlugin.log((Throwable)e);
                                }
                                catch (InterruptedException e) {
                                    JavaVEPlugin.log((Throwable)e);
                                }
                            }
                            catch (Throwable throwable) {
                                var13_20 = null;
                                try {
                                    in.close();
                                    throw throwable;
                                }
                                catch (Exception exception) {}
                                throw throwable;
                            }
                            {
                                var13_20 = null;
                            }
                            try {}
                            catch (Exception exception) {}
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        JavaVEPlugin.log((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    Object var15_23 = null;
                    try {
                        zip.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var15_24 = null;
                    try {}
                    catch (IOException iOException) {}
                    zip.close();
                }
            }
            catch (ZipException e) {
                JavaVEPlugin.log((Throwable)e);
            }
            catch (IOException e) {
                JavaVEPlugin.log((Throwable)e);
            }
            return url;
        }
    }

    protected void contributePluginLibrary(final IConfigurationContributionController controller) throws CoreException {
        final IPluginModelBase swtModel = PDECore.getDefault().getModelManager().findModel(SWTContainer.swtLibraries[0].getPluginID());
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                String msg = SWTMessages.SWTConfigurationContributor_CouldntResolveDLLInPDE_ERROR_;
                if (swtModel != null && swtModel.isEnabled()) {
                    URL librarylocation = SWTConfigurationContributor.generateLibCacheIfNeeded(swtModel.getBundleDescription().getLocation(), "");
                    if (librarylocation != null) {
                        controller.contributeClasspath(librarylocation, 4);
                        SWTConfigurationContributor.this.removeMarker(msg);
                    } else {
                        SWTConfigurationContributor.this.createMarker(msg);
                    }
                } else {
                    SWTConfigurationContributor.this.createMarker(msg);
                }
            }
        }, null, 1, (IProgressMonitor)new NullProgressMonitor());
    }

    protected static URL getSWTLegacyOSPath() {
        PluginModelManager pm = PDECore.getDefault().getModelManager();
        IFragmentModel[] frags = pm.getFragments();
        URL os = null;
        int i = 0;
        while (i < frags.length) {
            if (frags[i].getBundleDescription().getSymbolicName().startsWith("org.eclipse.swt") && frags[i].getBundleDescription().getHost().getName().equals("org.eclipse.swt") && !frags[i].getBundleDescription().getSymbolicName().startsWith("org.eclipse.swt.nl") && (os = SWTConfigurationContributor.getResourceURL((IPluginModelBase)frags[i], SWTContainer.SWT_CONTAINER_OS.toPortableString())) != null) {
                return os;
            }
            ++i;
        }
        return null;
    }

    static String[] getSrcConfig(IPluginModelBase plugin) {
        ArrayList<String> configs = new ArrayList<String>();
        IPluginExtension[] extensions = plugin.getExtensions().getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IPluginExtension extension = extensions[i];
            if ((String.valueOf(PDECore.getPluginId()) + ".source").equals(extension.getPoint())) {
                IPluginObject[] children = extension.getChildren();
                int j = 0;
                while (j < children.length) {
                    if (children[j].getName().equals("location")) {
                        IPluginElement element = (IPluginElement)children[j];
                        String pathValue = element.getAttribute("path").getValue();
                        configs.add(pathValue);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return configs.toArray(new String[configs.size()]);
    }

    protected static IPath getPDESrceLocationFor(IPluginModelBase plugin, String pkgName, String srcPath, String srcPluginID) {
        IPath result = (IPath)platformSrcPath.get(plugin);
        if (result != null) {
            return result;
        }
        String[] rel = SWTConfigurationContributor.getSrcConfig(plugin);
        if (rel.length == 0) {
            result = SWTConfigurationContributor.getFilePath(SWTConfigurationContributor.getResourceURL(plugin, srcPath));
        } else {
            int i = 0;
            while (i < rel.length) {
                result = SWTConfigurationContributor.getFilePath(SWTConfigurationContributor.getResourceURL(plugin, String.valueOf(rel[i]) + "/" + srcPath));
                if (result != null) break;
                ++i;
            }
        }
        if (result != null) {
            platformSrcPath.put(plugin, result);
            return result;
        }
        if (pkgName.endsWith(".jar")) {
            pkgName = pkgName.substring(0, pkgName.lastIndexOf(".jar"));
        }
        if (srcPluginID != null) {
            IPluginModelBase srcPlugin = PDECore.getDefault().getModelManager().findModel(srcPluginID);
            if (srcPlugin == null) {
                return null;
            }
            BundleDescription[] fragDesc = srcPlugin.getBundleDescription().getFragments();
            ArrayList<IPluginModelBase> plugins = new ArrayList<IPluginModelBase>();
            plugins.add(srcPlugin);
            int i = 0;
            while (i < fragDesc.length) {
                plugins.add(PDECore.getDefault().getModelManager().findModel(fragDesc[i].getSymbolicName()));
                ++i;
            }
            i = 0;
            while (i < plugins.size()) {
                IPluginModelBase p = (IPluginModelBase)plugins.get(i);
                rel = SWTConfigurationContributor.getSrcConfig(p);
                if (rel.length == 0) {
                    result = SWTConfigurationContributor.getFilePath(SWTConfigurationContributor.getResourceURL(p, String.valueOf(pkgName) + "/" + srcPath));
                } else {
                    int j = 0;
                    while (j < rel.length) {
                        Path pre = new Path(rel[j]);
                        result = SWTConfigurationContributor.getFilePath(SWTConfigurationContributor.getResourceURL(p, pre.append(pkgName).append(srcPath).toPortableString()));
                        if (result != null) break;
                        ++j;
                    }
                }
                if (result != null) {
                    platformSrcPath.put(plugin, result);
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static IClasspathEntry getLegacyPDEPath(String pluginID, String jarPath, String libPath, String srcPluginID) {
        IPluginModelBase base = PDECore.getDefault().getModelManager().findModel(pluginID);
        Path baseLocation = new Path(base.getInstallLocation());
        IPath location = baseLocation.append(jarPath);
        IPath libLocation = libPath != null ? new Path(base.getInstallLocation()).append(libPath) : null;
        String srcPath = String.valueOf(jarPath.substring(0, jarPath.lastIndexOf(46))) + "src.zip";
        IPath srcLocation = SWTConfigurationContributor.getPDESrceLocationFor(base, baseLocation.lastSegment(), srcPath, srcPluginID);
        IClasspathAttribute[] attr = new IClasspathAttribute[]{};
        if (libLocation != null) {
            attr = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)JavaRuntime.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY, (String)libLocation.toPortableString())};
        }
        return JavaCore.newLibraryEntry((IPath)location, (IPath)srcLocation, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])attr, (boolean)false);
    }

    public static IClasspathEntry getPDEPath(String pluginID, String srcPluginID, boolean lib) {
        IPath pLocation;
        IPluginModelBase base = PDECore.getDefault().getModelManager().findModel(pluginID);
        IResource r = ResourcesPlugin.getWorkspace().getRoot().findMember(base.getBundleDescription().getName());
        Path baseLocation = new Path(base.getInstallLocation());
        IClasspathAttribute[] attr = new IClasspathAttribute[]{};
        if (r != null && r instanceof IProject && (pLocation = r.getLocation()).equals((Object)baseLocation)) {
            if (lib) {
                attr = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)JavaRuntime.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY, (String)baseLocation.toPortableString())};
            }
            return JavaCore.newProjectEntry((IPath)r.getFullPath(), (IAccessRule[])new IAccessRule[0], (boolean)false, (IClasspathAttribute[])attr, (boolean)false);
        }
        Path location = baseLocation;
        IPath libLocation = lib ? SWTConfigurationContributor.getFilePath(SWTConfigurationContributor.generateLibCacheIfNeeded(base.getBundleDescription().getLocation(), "")) : null;
        String srcPath = "src.zip";
        IPath srcLocation = SWTConfigurationContributor.getPDESrceLocationFor(base, baseLocation.lastSegment(), srcPath, srcPluginID);
        if (libLocation != null) {
            attr = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)JavaRuntime.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY, (String)libLocation.toPortableString())};
        }
        return JavaCore.newLibraryEntry((IPath)location, (IPath)srcLocation, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])attr, (boolean)false);
    }

    protected void contributeLegacyPluginLibrary(final IConfigurationContributionController controller) throws CoreException {
        URL os = SWTConfigurationContributor.getSWTLegacyOSPath();
        if (os != null && os.toString().startsWith("jar")) {
            os = SWTConfigurationContributor.generateLibCacheIfNeeded(SWTConfigurationContributor.getFilePath(os).toPortableString(), SWTContainer.SWT_CONTAINER_OS.toPortableString());
        }
        final String msg = SWTMessages.SWTConfigurationContributor_CouldntResolveDLLInPDE_ERROR_;
        final URL osURL = os;
        ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                if (osURL != null) {
                    controller.contributeClasspath(osURL, 4);
                    SWTConfigurationContributor.this.removeMarker(msg);
                } else {
                    SWTConfigurationContributor.this.createMarker(msg);
                }
            }
        }, null, 1, (IProgressMonitor)new NullProgressMonitor());
        if ("gtk".equals(Platform.getWS())) {
            controller.contributeClasspath(Platform.getBundle((String)"org.eclipse.ve.swt"), "$os$", 4, false);
        }
    }

    public void contributeClasspaths(IConfigurationContributionController controller) throws CoreException {
        controller.contributeClasspath(SwtPlugin.getDefault().getBundle(), "vm/jbcfswtvm.jar", 0, false);
        if (SWTContainer.isGTK) {
            controller.contributeClasspath(Platform.getBundle((String)"org.eclipse.ve.swt"), "$os$", 4, false);
        }
        if (!ProxyPlugin.isPDEProject((IJavaProject)this.javaProject)) {
            Iterator itr = libraryCaches.iterator();
            while (itr.hasNext()) {
                StringTokenizer st = new StringTokenizer((String)itr.next(), argSeperator);
                if (st.countTokens() > 1) {
                    SWTConfigurationContributor.generateLibCacheIfNeeded(st.nextToken(), st.nextToken());
                    continue;
                }
                SWTConfigurationContributor.generateLibCacheIfNeeded(st.nextToken(), "");
            }
        } else {
            PluginModelManager pm = PDECore.getDefault().getModelManager();
            IPluginModelBase swtEntry = pm.findModel("org.eclipse.swt");
            Version version = swtEntry.getBundleDescription().getVersion();
            if (version.getMajor() < 3 || version.getMinor() < 1) {
                this.contributeLegacyPluginLibrary(controller);
            } else {
                this.contributePluginLibrary(controller);
            }
        }
    }

    public void contributeToConfiguration(ILaunchConfigurationWorkingCopy config) throws CoreException {
    }

    protected IMarker[] getMarker(String msg) {
        ArrayList<IMarker> result = new ArrayList<IMarker>();
        try {
            IMarker[] markers = this.javaProject.getProject().findMarkers(SWT_BUILD_PATH_MARKER, false, 0);
            int i = 0;
            while (i < markers.length) {
                if (markers[i].getAttribute("message").equals(msg)) {
                    result.add(markers[i]);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            SwtPlugin.getDefault().getLogger().log((Throwable)e, Level.WARNING);
        }
        return result.toArray(new IMarker[result.size()]);
    }

    protected void removeMarker(String msg) {
        try {
            IMarker[] marks = this.getMarker(msg);
            int i = 0;
            while (i < marks.length) {
                marks[i].delete();
                ++i;
            }
        }
        catch (CoreException e) {
            SwtPlugin.getDefault().getLogger().log((Throwable)e, Level.WARNING);
        }
    }

    protected void createMarker(String msg) {
        try {
            if (this.getMarker(msg).length == 0) {
                IMarker marker = this.javaProject.getProject().createMarker(SWT_BUILD_PATH_MARKER);
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)msg);
            }
        }
        catch (CoreException e) {
            SwtPlugin.getDefault().getLogger().log((Throwable)e, Level.WARNING);
        }
    }

    public void contributeToRegistry(ProxyFactoryRegistry registry) {
        if (this.javaProject != null) {
            StringTokenizer versTokens;
            boolean versOk = true;
            IBeanProxy version = registry.getMethodProxyFactory().getInvokable("java.lang.System", "getProperty", new String[]{"java.lang.String"}).invokeCatchThrowableExceptions(null, (IBeanProxy)registry.getBeanProxyFactory().createBeanProxyWith("java.version"));
            if (version instanceof IStringBeanProxy && (versTokens = new StringTokenizer(((IStringBeanProxy)version).stringValue(), "._")).hasMoreTokens()) {
                try {
                    Integer v = Integer.valueOf(versTokens.nextToken());
                    if (v == 1 && versTokens.hasMoreTokens()) {
                        Integer r = Integer.valueOf(versTokens.nextToken());
                        if (r < 4) {
                            versOk = false;
                        } else if (r == 4) {
                            if (versTokens.hasMoreTokens()) {
                                Integer m = Integer.valueOf(versTokens.nextToken());
                                if (m < 2) {
                                    versOk = false;
                                }
                            } else {
                                versOk = false;
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
            final boolean fversok = versOk;
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        if (fversok) {
                            SWTConfigurationContributor.this.removeMarker(SWTMessages.Marker_BuildPathNot142);
                        } else {
                            SWTConfigurationContributor.this.createMarker(SWTMessages.Marker_BuildPathNot142);
                        }
                    }
                }, null, 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                SwtPlugin.getDefault().getLogger().log((Throwable)e, Level.WARNING);
            }
        }
    }

    private static URL getResourceURL(IPluginModelBase frag, String relativePath) {
        String location = frag.getInstallLocation();
        if (location == null) {
            return null;
        }
        File file = new File(location);
        URL url = null;
        try {
            if (file.isFile() && file.getName().endsWith(".jar")) {
                ZipFile zip = new ZipFile(file);
                if (zip.getEntry(relativePath) != null) {
                    url = new URL("jar:file:" + file.getAbsolutePath() + "!/" + relativePath);
                }
            } else if (new File(file, relativePath).exists()) {
                url = new URL("file:" + file.getAbsolutePath() + '/' + relativePath);
            }
        }
        catch (IOException iOException) {}
        return url;
    }

    public static IPath getFilePath(URL l) {
        if (l != null) {
            if (l.getProtocol().equals("file")) {
                return new Path(l.getFile());
            }
            if (l.getProtocol().equals("jar")) {
                String f = l.getFile();
                int idx = f.lastIndexOf(33);
                if (idx >= 0) {
                    f = f.substring(0, idx);
                }
                try {
                    return SWTConfigurationContributor.getFilePath(new URL(f));
                }
                catch (MalformedURLException malformedURLException) {}
            }
        }
        return null;
    }

    protected static String[] getSrcConfig(Bundle b) {
        Bundle[] frags = Platform.getFragments((Bundle)b);
        if (frags == null) {
            frags = new Bundle[]{};
        }
        String[] names = new String[frags.length + 1];
        names[0] = b.getSymbolicName();
        int i = 1;
        while (i < names.length) {
            names[i] = frags[i - 1].getSymbolicName();
            ++i;
        }
        List<String> fragNames = Arrays.asList(names);
        ArrayList<String> result = new ArrayList<String>();
        IConfigurationElement[] ces = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.pde.core.source");
        int i2 = 0;
        while (i2 < ces.length) {
            String p;
            if (fragNames.contains(ces[i2].getDeclaringExtension().getNamespace()) && !result.contains(p = ces[i2].getAttributeAsIs("path"))) {
                result.add(p);
            }
            ++i2;
        }
        return result.toArray(new String[result.size()]);
    }

    public static IPath getPlatformSrcLocationFor(Bundle bundle, String pkgName, String srcPluginID) {
        IPath result = (IPath)platformSrcPath.get(bundle);
        if (result != null) {
            return result;
        }
        String srcFile = "src.zip";
        try {
            String[] rel = SWTConfigurationContributor.getSrcConfig(bundle);
            URL u = null;
            if (rel.length == 0) {
                u = bundle.getEntry(srcFile);
            } else {
                int i = 0;
                while (i < rel.length) {
                    u = bundle.getEntry(String.valueOf(rel[i]) + "/" + srcFile);
                    if (u != null) break;
                    ++i;
                }
            }
            if (u != null) {
                result = SWTConfigurationContributor.getFilePath(Platform.resolve((URL)u));
                platformSrcPath.put(bundle, result);
                return result;
            }
        }
        catch (IOException iOException) {}
        if (pkgName.endsWith(".jar")) {
            pkgName = pkgName.substring(0, pkgName.lastIndexOf(".jar"));
        }
        if (srcPluginID != null) {
            Bundle srcBundle = Platform.getBundle((String)srcPluginID);
            String[] rel = SWTConfigurationContributor.getSrcConfig(srcBundle);
            URL u = null;
            if (rel.length == 0) {
                u = Platform.find((Bundle)srcBundle, (IPath)new Path(pkgName).append(srcFile));
            } else {
                int i = 0;
                while (i < rel.length) {
                    u = Platform.find((Bundle)srcBundle, (IPath)new Path(rel[i]).append(pkgName).append(srcFile));
                    if (u != null) break;
                    ++i;
                }
            }
            if (u != null) {
                try {
                    result = SWTConfigurationContributor.getFilePath(Platform.resolve((URL)u));
                    platformSrcPath.put(bundle, result);
                    return result;
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static IClasspathEntry getPlatformPath(String pluginID, boolean libPath, String srcPluginID) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        if (bundle.getState() != 32 && bundle.getState() != 4) {
            return null;
        }
        IPath location = null;
        try {
            URL l = Platform.resolve((URL)bundle.getEntry("/"));
            boolean project = l.getProtocol().equals("file");
            location = SWTConfigurationContributor.getFilePath(l).removeTrailingSeparator();
            if (location != null && location.lastSegment().endsWith(".jar")) {
                IPath src = SWTConfigurationContributor.getPlatformSrcLocationFor(bundle, location.lastSegment(), srcPluginID);
                IClasspathAttribute[] attr = new IClasspathAttribute[]{};
                if (libPath) {
                    URL libURL = project ? location.toFile().toURL() : SWTConfigurationContributor.generateLibCacheIfNeeded(location.toPortableString(), "");
                    attr = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)JavaRuntime.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY, (String)SWTConfigurationContributor.getFilePath(libURL).toPortableString())};
                }
                return JavaCore.newLibraryEntry((IPath)location, (IPath)src, null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])attr, (boolean)false);
            }
        }
        catch (IOException e) {
            JavaVEPlugin.log((Throwable)e, (Level)Level.INFO);
        }
        return null;
    }
}

