/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionController;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributionInfo;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.swt.SWTConfigurationContributor;
import org.eclipse.ve.internal.swt.SWTMessages;
import org.osgi.framework.Bundle;

public class SWTContainer
implements IClasspathContainer,
IConfigurationContributor {
    public static final int SWT_CONTAINER_PATH_CUSTOM = 1;
    public static final int SWT_CONTAINER_PATH_PDE = 2;
    public static final int SWT_CONTAINER_PATH_PLATFORM = 4;
    static final int SWT_CONTAINER_PATH = 7;
    public static final int SWT_CONTAINER_JFACE = 16;
    public static final String SWT_CONTAINER_SIGNITURE = "SWT_CONTAINER";
    public static final String SWT_CONTAINER_SIGNITURE_JFACE = "JFACE";
    public static final String SWT_CONTAINER_SIGNITURE_PATH_PLATFORM = "PLATFORM";
    public static final String SWT_CONTAINER_SIGNITURE_PATH_PDE = "PDE";
    public static final String SWT_CONTAINER_SIGNITURE_PATH_CUSTOM = "CUSTOM";
    public static final IPath SWT_CONTAINER_WS = new Path("ws").append(Platform.getWS());
    public static final IPath SWT_CONTAINER_OS = new Path("os").append(Platform.getOS()).append(Platform.getOSArch());
    public static final String SWT_CONTAINER_OS_PLUGIN_EXT = "." + Platform.getOS() + "." + Platform.getWS() + "." + Platform.getOSArch();
    public static final String SWT_CONTAINER_WS_PLUGIN_EXT = "." + Platform.getWS() + "." + Platform.getOS() + "." + Platform.getOSArch();
    public static final String SWT_CONTAINER_SRC_PLUGIN = "org.eclipse.rcp.source";
    private IClasspathEntry[] fClasspathEntries = new IClasspathEntry[0];
    private IPath containerPath;
    private IJavaProject project;
    boolean initialized = false;
    private ContainerType containerType = null;
    private IPluginModelListener pdeModelListener = new IPluginModelListener(){

        public void modelsChanged(PluginModelDelta delta) {
            try {
                SWTContainer.this.removelisteners();
                ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)SWTContainer.this.getPath().segment(0));
                initializer.initialize(SWTContainer.this.getPath(), SWTContainer.this.project);
            }
            catch (JavaModelException e) {
                JavaVEPlugin.log((Throwable)e);
            }
            catch (CoreException e) {
                JavaVEPlugin.log((Throwable)e);
            }
        }
    };
    private IElementChangedListener javaModelListener = new IElementChangedListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void elementChanged(ElementChangedEvent event) {
            if (SWTContainer.this.isClassPathChanged(new IJavaElementDelta[]{event.getDelta()})) {
                2 var2_2 = this;
                synchronized (var2_2) {
                    try {
                        IClasspathContainer c = JavaCore.getClasspathContainer((IPath)SWTContainer.this.containerType.getContainerPath(), (IJavaProject)SWTContainer.this.project);
                        if (c == null || c != SWTContainer.this) {
                            SWTContainer.this.removelisteners();
                        }
                        SWTContainer.this.clear();
                    }
                    catch (JavaModelException e) {
                        JavaVEPlugin.log((Throwable)e);
                    }
                }
            }
        }
    };
    public static boolean isGTK = "gtk".equals(Platform.getWS());
    public static final JarInfo[] swtLibraries = new JarInfo[]{new JarInfo("org.eclipse.swt" + SWT_CONTAINER_WS_PLUGIN_EXT, true, "org.eclipse.swt." + Platform.getWS(), SWT_CONTAINER_WS.append("swt.jar").toPortableString(), SWT_CONTAINER_OS.toPortableString(), "org.eclipse.rcp.source", "org.eclipse.rcp.source" + SWT_CONTAINER_OS_PLUGIN_EXT)};
    private static final JarInfo[] swtGTKLibraries = new JarInfo[]{new JarInfo("org.eclipse.swt.gtk", SWT_CONTAINER_WS.append("swt-pi.jar").toPortableString(), null), new JarInfo("org.eclipse.swt.gtk", SWT_CONTAINER_WS.append("swt-mozilla.jar").toPortableString(), null)};
    private static final JarInfo[] jfaceLibraries = new JarInfo[]{new JarInfo("org.eclipse.jface", "jface.jar", "org.eclipse.rcp.source"), new JarInfo("org.eclipse.jface.text", "jfacetext.jar", "org.eclipse.rcp.source"), new JarInfo("org.eclipse.core.runtime", "runtime.jar", "org.eclipse.rcp.source"), new JarInfo("org.eclipse.core.runtime.compatibility", "compatibility.jar", "org.eclipse.rcp.source"), new JarInfo("org.eclipse.osgi", "core.jar", "org.eclipse.rcp.source"), new JarInfo("org.eclipse.core.commands", ".", "org.eclipse.rcp.source")};
    private String currentPDEPath = null;
    private String currentCustomPath = null;
    private SWTConfigurationContributor configContribute = new SWTConfigurationContributor();

    private boolean isClassPathChanged(IJavaElementDelta[] deltas) {
        if (deltas == null) {
            return false;
        }
        int i = 0;
        while (i < deltas.length) {
            IResourceDelta[] rdeltas = deltas[i].getResourceDeltas();
            if (rdeltas != null && rdeltas.length > 0) {
                int j = 0;
                while (j < rdeltas.length) {
                    if (rdeltas[j].getFullPath().lastSegment().equals(".classpath")) {
                        return true;
                    }
                    ++j;
                }
            }
            if (this.isClassPathChanged(deltas[i].getChangedChildren())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected static boolean isLegacy(String version) {
        StringTokenizer tk = new StringTokenizer(version, ".");
        try {
            int Major = Integer.parseInt(tk.nextToken());
            int Minor = Integer.parseInt(tk.nextToken());
            if (Major > 3 || Major == 3 && Minor >= 1) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return true;
    }

    protected void initPlatformPath(IPath containerPath) throws IOException {
        IClasspathEntry e;
        this.removeProblems();
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < swtLibraries.length) {
            e = null;
            Bundle b = Platform.getBundle((String)swtLibraries[i].getPluginID());
            if (b != null) {
                e = SWTConfigurationContributor.getPlatformPath(swtLibraries[i].getPluginID(), swtLibraries[i].isIncludesLibraries(), swtLibraries[i].getSrcPluginID());
                if (e != null) {
                    entries.add(e);
                } else {
                    this.addProblem(MessageFormat.format(SWTMessages.SWTContainer_44, swtLibraries[i].getPluginID()));
                }
            } else {
                JavaVEPlugin.log((Object)(String.valueOf(SWTMessages.SWTContainer_45) + swtLibraries[i].getPluginID()));
            }
            ++i;
        }
        if (this.containerType.includeJFace()) {
            i = 0;
            while (i < jfaceLibraries.length) {
                e = SWTConfigurationContributor.getPlatformPath(jfaceLibraries[i].getPluginID(), jfaceLibraries[i].isIncludesLibraries(), jfaceLibraries[i].getSrcPluginID());
                if (e != null) {
                    entries.add(e);
                } else {
                    this.addProblem(MessageFormat.format(SWTMessages.SWTContainer_46, jfaceLibraries[i].getPluginID()));
                }
                ++i;
            }
        }
        this.fClasspathEntries = entries.toArray(new IClasspathEntry[entries.size()]);
    }

    protected void removeProblems() {
        block3: {
            try {
                IMarker[] markers = this.project.getProject().findMarkers("org.eclipse.ve.swt.buildpath", false, 0);
                int i = 0;
                while (i < markers.length) {
                    markers[i].delete();
                    ++i;
                }
            }
            catch (CoreException e) {
                if (!JavaVEPlugin.isLoggingLevel((Level)Level.INFO)) break block3;
                JavaVEPlugin.log((Throwable)e, (Level)Level.INFO);
            }
        }
    }

    protected void addProblem(String msg) {
        block2: {
            try {
                IMarker marker = this.project.getProject().createMarker("org.eclipse.ve.swt.buildpath");
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)msg);
            }
            catch (CoreException e) {
                if (!JavaVEPlugin.isLoggingLevel((Level)Level.INFO)) break block2;
                JavaVEPlugin.log((Throwable)e, (Level)Level.INFO);
            }
        }
    }

    protected void initLegacyPDE(IPath containerPath) throws IOException {
        IClasspathEntry e;
        IPluginModelBase pluginBase;
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < swtLibraries.length) {
            IClasspathEntry e2 = null;
            IPluginModelBase pluginBase2 = PDECore.getDefault().getModelManager().findModel(swtLibraries[i].getLegacyID());
            if (pluginBase2 != null) {
                e2 = SWTConfigurationContributor.getLegacyPDEPath(swtLibraries[i].getLegacyID(), swtLibraries[i].getLegacyJarPath(), swtLibraries[i].getLegacyLibPath(), swtLibraries[i].getLegacySrcPluginID());
                if (e2 != null) {
                    entries.add(e2);
                } else {
                    this.addProblem(MessageFormat.format(SWTMessages.SWTContainer_47, swtLibraries[i].getLegacyID()));
                }
            } else {
                JavaVEPlugin.log((Object)("SWTContainer: Could not find a plugin for:" + swtLibraries[i].getLegacyID()));
            }
            ++i;
        }
        if (this.containerType.includeJFace()) {
            i = 0;
            while (i < jfaceLibraries.length) {
                pluginBase = PDECore.getDefault().getModelManager().findModel(jfaceLibraries[i].getLegacyID());
                if (pluginBase != null) {
                    e = SWTConfigurationContributor.getLegacyPDEPath(jfaceLibraries[i].getLegacyID(), jfaceLibraries[i].getLegacyJarPath(), jfaceLibraries[i].getLegacyLibPath(), jfaceLibraries[i].getLegacySrcPluginID());
                    if (e != null) {
                        entries.add(e);
                    } else {
                        this.addProblem(MessageFormat.format(SWTMessages.SWTContainer_49, jfaceLibraries[i].getLegacyID()));
                    }
                } else {
                    JavaVEPlugin.log((Object)("SWTContainer: Could not find a plugin for: " + jfaceLibraries[i].getLegacyID()));
                }
                ++i;
            }
        }
        if (isGTK) {
            i = 0;
            while (i < swtGTKLibraries.length) {
                pluginBase = PDECore.getDefault().getModelManager().findModel(swtGTKLibraries[i].getLegacyID());
                if (pluginBase != null) {
                    e = SWTConfigurationContributor.getLegacyPDEPath(swtGTKLibraries[i].getLegacyID(), swtGTKLibraries[i].getLegacyJarPath(), swtGTKLibraries[i].getLegacyLibPath(), swtGTKLibraries[i].getLegacySrcPluginID());
                    if (e != null) {
                        entries.add(e);
                    } else {
                        this.addProblem(MessageFormat.format(SWTMessages.SWTContainer_51, swtGTKLibraries[i].getLegacyID()));
                    }
                } else {
                    JavaVEPlugin.log((Object)("SWTContainer: Could not find a plugin for: " + swtGTKLibraries[i].getLegacyID()));
                }
                ++i;
            }
        }
        this.fClasspathEntries = entries.toArray(new IClasspathEntry[entries.size()]);
    }

    protected void initPDE(IPath containerPath) throws IOException {
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < swtLibraries.length) {
            IClasspathEntry e = null;
            IPluginModelBase pluginBase = PDECore.getDefault().getModelManager().findModel(swtLibraries[i].getPluginID());
            if (pluginBase != null) {
                e = SWTConfigurationContributor.getPDEPath(swtLibraries[i].getPluginID(), swtLibraries[i].getSrcPluginID(), swtLibraries[i].isIncludesLibraries());
                if (e != null) {
                    entries.add(e);
                } else {
                    this.addProblem(MessageFormat.format(SWTMessages.SWTContainer_53, swtLibraries[i].getLegacyID()));
                }
            } else {
                JavaVEPlugin.log((Object)("SWTContainer: Could not find a plugin for:" + swtLibraries[i].getLegacyID()));
            }
            ++i;
        }
        if (this.containerType.includeJFace()) {
            i = 0;
            while (i < jfaceLibraries.length) {
                IPluginModelBase pluginBase = PDECore.getDefault().getModelManager().findModel(jfaceLibraries[i].getLegacyID());
                if (pluginBase != null) {
                    IClasspathEntry e = SWTConfigurationContributor.getPDEPath(jfaceLibraries[i].getPluginID(), jfaceLibraries[i].getSrcPluginID(), jfaceLibraries[i].isIncludesLibraries());
                    if (e != null) {
                        entries.add(e);
                    } else {
                        this.addProblem(MessageFormat.format(SWTMessages.SWTContainer_55, jfaceLibraries[i].getLegacyID()));
                    }
                } else if (JavaVEPlugin.isLoggingLevel((Level)Level.INFO)) {
                    JavaVEPlugin.log((Object)("SWTContainer: plugin " + jfaceLibraries[i].getLegacyID() + " is not available on the PDE target"), (Level)Level.INFO);
                }
                ++i;
            }
        }
        this.fClasspathEntries = entries.toArray(new IClasspathEntry[entries.size()]);
    }

    protected void initPDEPath(IPath containerPath) throws IOException {
        ContainerType ct = new ContainerType(containerPath);
        if (this.currentPDEPath != null && this.currentPDEPath.equals(ct.getPdePath())) {
            return;
        }
        this.currentPDEPath = ct.getPdePath();
        this.containerType = ct;
        this.removeProblems();
        if (SWTContainer.isLegacy(PDECore.getDefault().getModelManager().getTargetVersion())) {
            this.initLegacyPDE(containerPath);
        } else {
            this.initPDE(containerPath);
        }
    }

    protected void addListeners() {
        if (this.containerType.isPDEPath()) {
            PDECore.getDefault().getModelManager().addPluginModelListener(this.pdeModelListener);
        }
        JavaCore.addElementChangedListener((IElementChangedListener)this.javaModelListener, (int)1);
    }

    protected void removelisteners() {
        if (this.containerType.isPDEPath()) {
            PDECore.getDefault().getModelManager().removePluginModelListener(this.pdeModelListener);
        }
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaModelListener);
    }

    protected void initCustom(IPath containerPath) throws IOException {
        IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)new Path(this.containerType.getCustomPath()));
        if (resolvedPath == null) {
            this.removeProblems();
            this.addProblem(MessageFormat.format(SWTMessages.SWTContainer_57, this.containerType.getCustomPath()));
            this.fClasspathEntries = new IClasspathEntry[0];
            return;
        }
        if (this.currentCustomPath != null && this.currentCustomPath.equals(resolvedPath.toPortableString())) {
            return;
        }
        this.currentCustomPath = resolvedPath.toPortableString();
        this.removeProblems();
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < swtLibraries.length) {
            Bundle b = Platform.getBundle((String)swtLibraries[i].getPluginID());
            if (b != null) {
                IClasspathEntry entry;
                IPath jarPath;
                Bundle[] hosts = Platform.getHosts((Bundle)b);
                if (hosts != null && hosts.length > 0) {
                    b = hosts[0];
                }
                String jarName = b.getSymbolicName();
                int index = jarName.lastIndexOf(46);
                jarName = String.valueOf(jarName.substring(index + 1, jarName.length())) + ".jar";
                String jarSrc = "src.zip";
                IClasspathAttribute[] attr = null;
                if (swtLibraries[i].isIncludesLibraries()) {
                    attr = new IClasspathAttribute[]{JavaCore.newClasspathAttribute((String)JavaRuntime.CLASSPATH_ATTR_LIBRARY_PATH_ENTRY, (String)resolvedPath.toPortableString())};
                    if (!resolvedPath.toFile().exists()) {
                        this.addProblem(MessageFormat.format(SWTMessages.SWTContainer_60, resolvedPath.toPortableString()));
                    }
                }
                if (!(jarPath = resolvedPath.append(jarName)).toFile().exists()) {
                    this.addProblem(MessageFormat.format(SWTMessages.SWTContainer_61, jarPath.toPortableString()));
                }
                if ((entry = JavaCore.newLibraryEntry((IPath)resolvedPath.append(jarName), (IPath)resolvedPath.append(jarSrc), null, (IAccessRule[])new IAccessRule[0], (IClasspathAttribute[])attr, (boolean)false)) != null) {
                    entries.add(entry);
                }
            } else {
                JavaVEPlugin.log((Object)("Could not location class path for: " + swtLibraries[i].getPluginID()));
            }
            ++i;
        }
        this.containerType.includeJFace();
        this.fClasspathEntries = entries.toArray(new IClasspathEntry[entries.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void computeEntries() {
        try {
            SWTContainer sWTContainer = this;
            synchronized (sWTContainer) {
                if (this.initialized) {
                    return;
                }
                if (this.containerType.isPlatformPath()) {
                    this.initPlatformPath(this.containerPath);
                } else if (this.containerType.isPDEPath()) {
                    this.initPDEPath(this.containerPath);
                } else if (this.containerType.isCustomPath()) {
                    this.initCustom(this.containerPath);
                }
                this.addListeners();
                this.initialized = true;
                try {
                    JavaCore.setClasspathContainer((IPath)this.containerType.getContainerPath(), (IJavaProject[])new IJavaProject[]{this.project}, (IClasspathContainer[])new IClasspathContainer[]{this}, null);
                }
                catch (JavaModelException e) {
                    JavaVEPlugin.log((Throwable)e, (Level)Level.INFO);
                }
            }
        }
        catch (IOException e1) {
            JavaVEPlugin.log((Throwable)e1, (Level)Level.INFO);
        }
    }

    protected void init() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        if (ws.isTreeLocked()) {
            this.computeEntries();
        } else {
            try {
                ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        SWTContainer.this.computeEntries();
                    }
                }, null, 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                JavaVEPlugin.log((Throwable)e, (Level)Level.INFO);
            }
        }
    }

    public SWTContainer(IPath containerPath, IJavaProject project) {
        this.containerPath = containerPath;
        this.project = project;
        this.containerType = new ContainerType(containerPath);
    }

    private void clear() {
        this.initialized = false;
        this.fClasspathEntries = new IClasspathEntry[0];
        this.currentCustomPath = null;
        this.currentPDEPath = null;
    }

    protected boolean hasChanged() {
        if (this.containerType.isPDEPath()) {
            ContainerType ct = new ContainerType(this.containerPath);
            if (this.currentPDEPath == null || !this.currentPDEPath.equals(ct.getPdePath())) {
                return true;
            }
        } else if (this.containerType.isCustomPath()) {
            IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)new Path(this.containerType.getCustomPath()));
            if (this.currentCustomPath == null || !this.currentCustomPath.equals(resolvedPath.toPortableString())) {
                return true;
            }
        }
        return false;
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (!this.initialized) {
            this.init();
        } else if (this.hasChanged()) {
            this.clear();
            this.init();
        }
        return this.fClasspathEntries;
    }

    public String getDescription() {
        return SWTMessages.SWTContainer_Description;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.containerPath;
    }

    public void initialize(IConfigurationContributionInfo info) {
        this.configContribute.initialize(info);
    }

    public void contributeClasspaths(IConfigurationContributionController controller) throws CoreException {
        this.configContribute.contributeClasspaths(controller);
    }

    public void contributeToConfiguration(ILaunchConfigurationWorkingCopy config) throws CoreException {
        this.configContribute.contributeToConfiguration(config);
    }

    public void contributeToRegistry(ProxyFactoryRegistry registry) {
        this.configContribute.contributeToRegistry(registry);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.project.getElementName());
        sb.append("\ninitialized=");
        sb.append(String.valueOf(this.initialized) + "\n");
        int i = 0;
        while (i < this.fClasspathEntries.length) {
            sb.append(this.fClasspathEntries[i].getPath().toPortableString());
            ++i;
        }
        return sb.toString();
    }

    public static class ContainerType {
        private int pathType = 4;
        private String customPath = null;
        static String platformPath = null;
        static String platformVersion = null;
        String pdePath = null;
        String pdeVersion = null;

        public ContainerType(IPath containerPath) {
            this();
            this.parsePath(containerPath);
        }

        public ContainerType() {
        }

        protected void parsePath(IPath containerPath) {
            if (containerPath != null && !containerPath.segment(0).equals(SWTContainer.SWT_CONTAINER_SIGNITURE)) {
                throw new IllegalStateException(String.valueOf(SWTMessages.SWTContainer_11) + containerPath);
            }
            this.pathType = 4;
            if (containerPath != null) {
                int i = 1;
                while (i < containerPath.segmentCount()) {
                    if (containerPath.segment(i).equals(SWTContainer.SWT_CONTAINER_SIGNITURE_JFACE)) {
                        this.setPathType(16, true);
                    } else if (containerPath.segment(i).equals(SWTContainer.SWT_CONTAINER_SIGNITURE_PATH_PLATFORM)) {
                        this.setPathType(4, true);
                    } else if (containerPath.segment(i).equals(SWTContainer.SWT_CONTAINER_SIGNITURE_PATH_PDE)) {
                        this.setPathType(2, true);
                    } else if (containerPath.segment(i).equals(SWTContainer.SWT_CONTAINER_SIGNITURE_PATH_CUSTOM)) {
                        this.setPathType(1, true);
                        if (containerPath.segmentCount() < i + 2) break;
                        this.customPath = containerPath.removeFirstSegments(i + 1).toString();
                        break;
                    }
                    ++i;
                }
            }
        }

        public IPath getContainerPath() {
            Path result = new Path(SWTContainer.SWT_CONTAINER_SIGNITURE);
            if ((this.pathType & 0x10) > 0) {
                result = result.append(SWTContainer.SWT_CONTAINER_SIGNITURE_JFACE);
            }
            int path = this.pathType & 7;
            switch (path) {
                case 4: {
                    result = result.append(SWTContainer.SWT_CONTAINER_SIGNITURE_PATH_PLATFORM);
                    break;
                }
                case 2: {
                    result = result.append(SWTContainer.SWT_CONTAINER_SIGNITURE_PATH_PDE);
                    break;
                }
                case 1: {
                    result = result.append(SWTContainer.SWT_CONTAINER_SIGNITURE_PATH_CUSTOM).append(this.customPath);
                }
            }
            return result;
        }

        public void setPathType(int type, boolean flag) {
            if ((type & 7) > 0 && flag) {
                this.pathType &= 0xFFFFFFF8;
            }
            this.pathType = flag ? (this.pathType |= type) : (this.pathType &= ~type);
            if ((this.pathType & 7) == 0) {
                this.pathType &= 4;
            }
        }

        public boolean isPlatformPath() {
            return (this.pathType & 4) > 0;
        }

        public boolean isPDEPath() {
            return (this.pathType & 2) > 0;
        }

        public boolean isCustomPath() {
            return (this.pathType & 1) > 0;
        }

        public boolean includeJFace() {
            return (this.pathType & 0x10) > 0;
        }

        public String getCustomPath() {
            if (this.customPath != null) {
                return this.customPath;
            }
            return "";
        }

        public void setCustomPath(String path) {
            Path p = new Path(path);
            this.customPath = p.toPortableString();
        }

        public String getPdePath() {
            if (this.pdePath == null) {
                this.pdePath = SWTContainer.isLegacy(PDECore.getDefault().getModelManager().getTargetVersion()) ? PDECore.getDefault().getModelManager().findModel(swtLibraries[0].getLegacyID()).getInstallLocation() : PDECore.getDefault().getModelManager().findModel(swtLibraries[0].getPluginID()).getInstallLocation();
            }
            return this.pdePath;
        }

        public String getPlatformPath() {
            if (platformPath == null) {
                try {
                    platformPath = SWTConfigurationContributor.getFilePath(Platform.resolve((URL)Platform.getBundle((String)swtLibraries[0].getPluginID()).getEntry("/"))).toOSString();
                }
                catch (IOException iOException) {}
            }
            return platformPath;
        }

        public String toString() {
            return this.getContainerPath().toPortableString();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof ContainerType)) {
                return false;
            }
            ContainerType ct = (ContainerType)o;
            return ct.getContainerPath().equals((Object)this.getContainerPath());
        }

        public String getPlatformVersion() {
            if (platformVersion == null) {
                platformVersion = (String)Platform.getBundle((String)swtLibraries[0].getPluginID()).getHeaders().get("Bundle-Version");
            }
            return platformVersion;
        }

        public String getPdeVersion() {
            if (this.pdeVersion == null) {
                this.pdeVersion = PDECore.getDefault().getModelManager().findModel("org.eclipse.swt").getBundleDescription().getVersion().toString();
            }
            return this.pdeVersion;
        }
    }

    public static class JarInfo {
        String pluginID;
        boolean includesLibraries = false;
        String legacyID;
        String legacyJarPath;
        String legacyLibPath;
        String srcPluginID;
        String legacySrcPluginID;

        public JarInfo(String pluginID, String jarPath, String srcPluginID) {
            this.pluginID = pluginID;
            this.legacyID = pluginID;
            this.legacyJarPath = jarPath;
            this.srcPluginID = srcPluginID;
            this.legacySrcPluginID = srcPluginID;
            this.legacyLibPath = null;
        }

        public JarInfo(String pluginID, boolean includeLibraries, String legacyID, String jarPath, String libPath, String srcPluginID, String legacySrcPluginID) {
            this.pluginID = pluginID;
            this.legacyID = legacyID;
            this.legacyJarPath = jarPath;
            this.srcPluginID = srcPluginID;
            this.legacyLibPath = libPath;
            this.includesLibraries = includeLibraries;
            this.legacySrcPluginID = legacySrcPluginID;
        }

        public String getLegacyJarPath() {
            return this.legacyJarPath;
        }

        public String getLegacyLibPath() {
            return this.legacyLibPath;
        }

        public String getPluginID() {
            return this.pluginID;
        }

        public String getSrcPluginID() {
            return this.srcPluginID;
        }

        public String getLegacyID() {
            return this.legacyID;
        }

        public boolean isIncludesLibraries() {
            return this.includesLibraries;
        }

        public String getLegacySrcPluginID() {
            return this.legacySrcPluginID;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("pluginID=");
            sb.append(this.pluginID);
            if (this.includesLibraries) {
                sb.append(" [With Libraries]");
            } else {
                sb.append(" [No Libraries]");
            }
            sb.append(", legacyID=");
            sb.append(this.legacyID);
            sb.append(", legacyJarPath=");
            sb.append(this.legacyJarPath);
            sb.append(", legacyLibPath=");
            sb.append(this.legacyLibPath);
            sb.append(", srcPluginID=");
            sb.append(this.srcPluginID);
            return sb.toString();
        }
    }
}

