/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IRectangleBeanProxy;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.LayoutPolicyHelper;
import org.eclipse.ve.internal.swt.SWTConstants;
import org.eclipse.ve.internal.swt.SWTMessages;

public class ViewFormLayoutPolicyHelper
extends LayoutPolicyHelper {
    protected VisualContainerPolicy policy;
    public static final List REAL_INTERNAL_TAGS = new ArrayList(4);
    public static final List DISPLAY_TAGS;
    public static final int LEFT_INDEX = 0;
    public static final int RIGHT_INDEX = 1;
    public static final int CENTER_INDEX = 2;
    public static final int CONTENT_INDEX = 3;

    static {
        REAL_INTERNAL_TAGS.add("Top Left");
        REAL_INTERNAL_TAGS.add("Top Right");
        REAL_INTERNAL_TAGS.add("Top Center");
        REAL_INTERNAL_TAGS.add("Content");
        DISPLAY_TAGS = new ArrayList(4);
        DISPLAY_TAGS.add(SWTMessages.ViewFormLayout_TopLeft);
        DISPLAY_TAGS.add(SWTMessages.ViewFormLayout_TopRight);
        DISPLAY_TAGS.add(SWTMessages.ViewFormLayout_TopCenter);
        DISPLAY_TAGS.add(SWTMessages.ViewFormLayout_Content);
    }

    protected static HashMap getDisplayTagMap() {
        HashMap displayTagMap = new HashMap(DISPLAY_TAGS.size());
        List displayTags = DISPLAY_TAGS;
        displayTagMap.put(displayTags.get(0), displayTags.get(0));
        displayTagMap.put(displayTags.get(1), displayTags.get(1));
        displayTagMap.put(displayTags.get(2), displayTags.get(2));
        displayTagMap.put(displayTags.get(3), displayTags.get(3));
        return displayTagMap;
    }

    public static HashMap getInternalTagMap() {
        HashMap internalTagMap = new HashMap(REAL_INTERNAL_TAGS.size());
        List realInternalTags = REAL_INTERNAL_TAGS;
        internalTagMap.put(realInternalTags.get(0), realInternalTags.get(0));
        internalTagMap.put(realInternalTags.get(1), realInternalTags.get(1));
        internalTagMap.put(realInternalTags.get(2), realInternalTags.get(2));
        internalTagMap.put(realInternalTags.get(3), realInternalTags.get(3));
        return internalTagMap;
    }

    public ViewFormLayoutPolicyHelper(VisualContainerPolicy ep) {
        super(ep);
    }

    public ViewFormLayoutPolicyHelper() {
    }

    private Rectangle boundingRectangle() {
        if (this.getContainer() != null) {
            IBeanProxy containerProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.getContainer());
            IRectangleBeanProxy rectangleProxy = BeanSWTUtilities.invoke_getBounds(containerProxy);
            Rectangle r = new Rectangle(rectangleProxy.getX(), rectangleProxy.getY(), rectangleProxy.getWidth(), rectangleProxy.getHeight());
            return r;
        }
        return null;
    }

    public Point convertLocation(Point p) {
        if (p == null) {
            return null;
        }
        Rectangle r = this.boundingRectangle();
        return new Point(p.x + r.x, p.y + r.y);
    }

    public List getAllRegions() {
        return REAL_INTERNAL_TAGS;
    }

    public String[] getAvailableRegions() {
        EStructuralFeature sfLeftControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_TOPLEFT);
        EStructuralFeature sfRightControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_TOPRIGHT);
        EStructuralFeature sfCenterControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_TOPCENTER);
        EStructuralFeature sfContentControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_CONTENT);
        ArrayList result = new ArrayList(this.getAllRegions().size());
        result.addAll(this.getAllRegions());
        IJavaObjectInstance viewFormBean = this.getContainer();
        if (viewFormBean != null) {
            IJavaInstance left = (IJavaInstance)viewFormBean.eGet(sfLeftControl);
            IJavaInstance right = (IJavaInstance)viewFormBean.eGet(sfRightControl);
            IJavaInstance center = (IJavaInstance)viewFormBean.eGet(sfCenterControl);
            IJavaInstance content = (IJavaInstance)viewFormBean.eGet(sfContentControl);
            if (content != null) {
                result.remove(3);
            }
            if (center != null) {
                result.remove(2);
            }
            if (right != null) {
                result.remove(1);
            }
            if (left != null) {
                result.remove(0);
            }
        }
        if (result.size() <= 0) {
            return null;
        }
        String[] tags = new String[result.size()];
        int i = 0;
        while (i < result.size()) {
            tags[i] = (String)result.get(i);
            ++i;
        }
        return tags;
    }

    public Command getAddChildrenCommand(List children, List constraints, Object position) {
        Object constraint = null;
        Iterator itr = constraints.iterator();
        while (itr.hasNext()) {
            Object next = itr.next();
            if (next == null) {
                return UnexecutableCommand.INSTANCE;
            }
            if (!REAL_INTERNAL_TAGS.contains(next)) continue;
            constraint = next;
        }
        Object child = children.get(0);
        EStructuralFeature sfLeftControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_TOPLEFT);
        EStructuralFeature sfRightControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_TOPRIGHT);
        EStructuralFeature sfCenterControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_TOPCENTER);
        EStructuralFeature sfContentControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_CONTENT);
        IJavaObjectInstance viewFormBean = this.getContainer();
        IJavaInstance left = (IJavaInstance)viewFormBean.eGet(sfLeftControl);
        IJavaInstance right = (IJavaInstance)viewFormBean.eGet(sfRightControl);
        IJavaInstance center = (IJavaInstance)viewFormBean.eGet(sfCenterControl);
        IJavaInstance content = (IJavaInstance)viewFormBean.eGet(sfContentControl);
        IJavaObjectInstance parent = this.getContainer();
        CommandBuilder cBld = new CommandBuilder("");
        if (left == null && ((String)REAL_INTERNAL_TAGS.get(0)).equals(constraint)) {
            cBld.applyAttributeSetting((EObject)parent, sfLeftControl, child, position);
        } else if (right == null && ((String)REAL_INTERNAL_TAGS.get(1)).equals(constraint)) {
            cBld.applyAttributeSetting((EObject)parent, sfRightControl, child, position);
        } else if (center == null && ((String)REAL_INTERNAL_TAGS.get(2)).equals(constraint)) {
            cBld.applyAttributeSetting((EObject)parent, sfCenterControl, child, position);
        } else if (content == null && ((String)REAL_INTERNAL_TAGS.get(3)).equals(constraint)) {
            cBld.applyAttributeSetting((EObject)parent, sfContentControl, child, position);
        }
        Command setAsContent = cBld.getCommand();
        return super.getCreateChildCommand(child, constraint, position).chain(setAsContent);
    }

    public Command getCreateChildCommand(Object child, Object constraint, Object position) {
        if (constraint == null) {
            return UnexecutableCommand.INSTANCE;
        }
        EStructuralFeature sfLeftControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_TOPLEFT);
        EStructuralFeature sfRightControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_TOPRIGHT);
        EStructuralFeature sfCenterControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_TOPCENTER);
        EStructuralFeature sfContentControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_CONTENT);
        IJavaObjectInstance viewFormBean = this.getContainer();
        IJavaInstance left = (IJavaInstance)viewFormBean.eGet(sfLeftControl);
        IJavaInstance right = (IJavaInstance)viewFormBean.eGet(sfRightControl);
        IJavaInstance center = (IJavaInstance)viewFormBean.eGet(sfCenterControl);
        IJavaInstance content = (IJavaInstance)viewFormBean.eGet(sfContentControl);
        IJavaObjectInstance parent = this.getContainer();
        CommandBuilder cBld = new CommandBuilder("");
        if (left == null && ((String)REAL_INTERNAL_TAGS.get(0)).equals(constraint)) {
            cBld.applyAttributeSetting((EObject)parent, sfLeftControl, child, position);
        } else if (right == null && ((String)REAL_INTERNAL_TAGS.get(1)).equals(constraint)) {
            cBld.applyAttributeSetting((EObject)parent, sfRightControl, child, position);
        } else if (center == null && ((String)REAL_INTERNAL_TAGS.get(2)).equals(constraint)) {
            cBld.applyAttributeSetting((EObject)parent, sfCenterControl, child, position);
        } else if (content == null && ((String)REAL_INTERNAL_TAGS.get(3)).equals(constraint)) {
            cBld.applyAttributeSetting((EObject)parent, sfContentControl, child, position);
        }
        Command setAsContent = cBld.getCommand();
        return super.getCreateChildCommand(child, constraint, position).chain(setAsContent);
    }

    public String getCurrentConstraint(Point p) {
        if (p == null) {
            return null;
        }
        Rectangle r = this.boundingRectangle();
        Rectangle leftRect = new Rectangle(r.x, r.y, r.width / 3, r.height / 3);
        Rectangle centerRect = new Rectangle(r.x + r.width / 3, r.y, r.width / 3, r.height / 3);
        Rectangle rightRect = new Rectangle(r.x + 2 * r.width / 3, r.y, r.width / 3, r.height / 3);
        Rectangle contentRect = new Rectangle(r.x, r.y + r.height / 3, r.width, 2 * r.height / 3);
        if (leftRect.contains(p)) {
            return (String)REAL_INTERNAL_TAGS.get(0);
        }
        if (rightRect.contains(p)) {
            return (String)REAL_INTERNAL_TAGS.get(1);
        }
        if (centerRect.contains(p)) {
            return (String)REAL_INTERNAL_TAGS.get(2);
        }
        if (contentRect.contains(p)) {
            return (String)REAL_INTERNAL_TAGS.get(3);
        }
        return null;
    }

    public Rectangle getCurrentRectangle(Point p) {
        if (p == null) {
            return null;
        }
        Rectangle r = this.boundingRectangle();
        Rectangle leftRect = new Rectangle(r.x, r.y, r.width / 3, r.height / 3);
        Rectangle centerRect = new Rectangle(r.x + r.width / 3, r.y, r.width / 3, r.height / 3);
        Rectangle rightRect = new Rectangle(r.x + 2 * r.width / 3, r.y, r.width / 3, r.height / 3);
        Rectangle contentRect = new Rectangle(r.x, r.y + r.height / 3, r.width, 2 * r.height / 3);
        if (leftRect.contains(p)) {
            return leftRect;
        }
        if (rightRect.contains(p)) {
            return rightRect;
        }
        if (centerRect.contains(p)) {
            return centerRect;
        }
        if (contentRect.contains(p)) {
            return contentRect;
        }
        return null;
    }

    public List getDefaultConstraint(List children) {
        ArrayList<String> constraints = new ArrayList<String>(children.size());
        String[] regions = this.getAvailableRegions();
        if (regions == null || regions.length < children.size()) {
            return Collections.nCopies(children.size(), null);
        }
        int i = 0;
        while (i < children.size()) {
            constraints.add(regions[i]);
            ++i;
        }
        return constraints;
    }

    public String[] getFilledRegions() {
        EStructuralFeature sfLeftControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_TOPLEFT);
        EStructuralFeature sfRightControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_TOPRIGHT);
        EStructuralFeature sfCenterControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_TOPCENTER);
        EStructuralFeature sfContentControl = JavaInstantiation.getSFeature((IJavaObjectInstance)this.getContainer(), (URI)SWTConstants.SF_VIEWFORM_CONTENT);
        ArrayList result = new ArrayList();
        IJavaObjectInstance viewFormBean = this.getContainer();
        if (viewFormBean != null) {
            IJavaInstance left = (IJavaInstance)viewFormBean.eGet(sfLeftControl);
            IJavaInstance right = (IJavaInstance)viewFormBean.eGet(sfRightControl);
            IJavaInstance center = (IJavaInstance)viewFormBean.eGet(sfCenterControl);
            IJavaInstance content = (IJavaInstance)viewFormBean.eGet(sfContentControl);
            if (left != null) {
                result.add(REAL_INTERNAL_TAGS.get(0));
            }
            if (right != null) {
                result.add(REAL_INTERNAL_TAGS.get(1));
            }
            if (center != null) {
                result.add(REAL_INTERNAL_TAGS.get(2));
            }
            if (content != null) {
                result.add(REAL_INTERNAL_TAGS.get(3));
            }
        }
        if (result.size() <= 0) {
            return null;
        }
        String[] tags = new String[result.size()];
        int i = 0;
        while (i < result.size()) {
            tags[i] = (String)result.get(i);
            ++i;
        }
        return tags;
    }

    public boolean isRegionAvailable(String constraint) {
        String[] tags = this.getAvailableRegions();
        if (tags != null) {
            int i = 0;
            while (i < tags.length) {
                if (tags[i].equals(constraint)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void cancelConstraints(CommandBuilder commandBuilder, List children) {
    }
}

