/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.internal.instantiation.base.FeatureValueProvider;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.swt.DisplayManager;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.IInternalBeanProxyHost;
import org.eclipse.ve.internal.swt.BeanSWTUtilities;
import org.eclipse.ve.internal.swt.UIThreadOnlyProxyAdapter;

public class WidgetProxyAdapter
extends UIThreadOnlyProxyAdapter
implements IExecutableExtension {
    private static final int NO_STYLE = -1;
    private int style = -1;
    private EStructuralFeature sf_items;
    private String itemsName;
    private boolean inApplyItem;
    private boolean inReapplyItems;
    public static final String DEFAULT_ITEMS_NAME = "items";
    public static final String ITEMS_NAME_KEY = "items";

    public WidgetProxyAdapter(IBeanProxyDomain domain) {
        super(domain);
    }

    public void setTarget(Notifier newTarget) {
        super.setTarget(newTarget);
        if (newTarget instanceof IJavaObjectInstance) {
            this.sf_items = this.getSingleItemsFeature((IJavaObjectInstance)newTarget);
        }
    }

    protected void setSingleItemsFeatureName(String itemsName) {
        if (this.itemsName == null && this.getTarget() == null) {
            this.itemsName = itemsName;
        }
    }

    protected boolean isItemFeature(EStructuralFeature feature) {
        return feature == this.sf_items;
    }

    protected void applySetting(EStructuralFeature feature, Object value, int index, IExpression expression) {
        if (this.isItemFeature(feature)) {
            this.applyItemSetting(feature, value, index, expression);
        } else {
            super.applySetting(feature, value, index, expression);
        }
    }

    protected void primPrimReleaseBeanProxy(final IExpression expression) {
        boolean wasInstantiated = this.isBeanProxyInstantiated();
        this.style = -1;
        if (this.isOwnsProxy() && this.isBeanProxyInstantiated()) {
            BeanSWTUtilities.invoke_WidgetDispose(this.getProxy(), expression);
        }
        if (wasInstantiated) {
            this.getJavaObject().visitSetFeatures(new FeatureValueProvider.Visitor(){

                public Object isSet(EStructuralFeature feature, Object value) {
                    if (WidgetProxyAdapter.this.isItemFeature(feature)) {
                        WidgetProxyAdapter.this.removeAllItems(feature, expression);
                    }
                    return null;
                }
            });
        }
    }

    protected EStructuralFeature getSingleItemsFeature(IJavaObjectInstance target) {
        return target.eClass().getEStructuralFeature(this.itemsName);
    }

    public int getStyle() {
        if (this.style == -1 && this.isBeanProxyInstantiated()) {
            this.invokeSyncExecCatchThrowable(new DisplayManager.DisplayRunnable(){

                public Object run(IBeanProxy displayProxy) throws ThrowableProxy {
                    IBeanProxy widgetBeanProxy = WidgetProxyAdapter.this.getBeanProxy();
                    IMethodProxy getStyleMethodProxy = widgetBeanProxy.getTypeProxy().getMethodProxy("getStyle");
                    IIntegerBeanProxy styleBeanProxy = (IIntegerBeanProxy)getStyleMethodProxy.invoke(widgetBeanProxy);
                    WidgetProxyAdapter.this.style = styleBeanProxy.intValue();
                    return null;
                }
            });
        }
        return this.style;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void applyItemSetting(EStructuralFeature feature, Object value, int index, IExpression expression) {
        if (this.inApplyItem) return;
        this.inApplyItem = true;
        try {
            if (this.inInstantiation() || this.getProxyAt(index, feature) == null) {
                this.createItem(feature, value, expression);
            } else {
                IInternalBeanProxyHost settingHost = this.getSettingBeanProxyHost((IJavaInstance)value);
                if (!settingHost.isBeanProxyInstantiated()) {
                    this.reapplyItems(feature, expression, false);
                }
            }
            Object var6_8 = null;
            this.inApplyItem = false;
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.inApplyItem = false;
            throw throwable;
        }
    }

    protected void primAppliedList(EStructuralFeature feature, List values, int index, boolean isTouch, IExpression expression, boolean testValidity) {
        if (this.isItemFeature(feature) && this.primAppliedListItems(feature, values, index, isTouch, expression, testValidity)) {
            return;
        }
        super.primAppliedList(feature, values, index, isTouch, expression, testValidity);
    }

    protected boolean primAppliedListItems(EStructuralFeature feature, List values, int index, boolean isTouch, IExpression expression, boolean testValidity) {
        if (!this.inInstantiation() && this.getProxyAt(index, feature) != null) {
            this.reapplyItems(feature, expression, testValidity);
            this.revalidateBeanProxy();
            return true;
        }
        return false;
    }

    private void createItem(EStructuralFeature feature, Object value, IExpression expression) {
        IInternalBeanProxyHost settingHost = this.getSettingBeanProxyHost((IJavaInstance)value);
        this.instantiateSettingBean(settingHost, expression, feature, value, null);
    }

    protected void cancelSetting(EStructuralFeature sf, Object oldValue, int position, IExpression expression) {
        if (this.isItemFeature(sf)) {
            this.removeItem((IJavaObjectInstance)oldValue, expression);
        } else {
            super.cancelSetting(sf, oldValue, position, expression);
        }
    }

    protected IProxy getProxyAt(int position, EStructuralFeature feature) {
        List settings = (List)this.getEObject().eGet(feature);
        int i = position;
        while (i < settings.size()) {
            IJavaInstance setting = (IJavaInstance)settings.get(i);
            IInternalBeanProxyHost settingProxyHost = this.getSettingBeanProxyHost(setting);
            if (settingProxyHost.isBeanProxyInstantiated() || settingProxyHost.inInstantiation()) {
                return settingProxyHost.getProxy();
            }
            ++i;
        }
        return null;
    }

    public final void reinstantiateItem(final EStructuralFeature feature, final IJavaObjectInstance item, final IBeanProxyHost itemProxy, IExpression expression) {
        if (this.onUIThread()) {
            this.primReinstantiateItem(feature, item, itemProxy, expression);
        } else {
            this.invokeSyncExecCatchThrowable(new DisplayManager.ExpressionDisplayRunnable(expression){

                protected Object doRun(IBeanProxy displayProxy) {
                    WidgetProxyAdapter.this.primReinstantiateItem(feature, item, itemProxy, (IExpression)this.expression);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reapplyItems(EStructuralFeature feature, IExpression expression, boolean testValidity) {
        if (this.inReapplyItems) return;
        this.inReapplyItems = true;
        try {
            this.removeAllItems(feature, expression);
            List columns = (List)((EObject)this.getTarget()).eGet(feature);
            Iterator iter = columns.iterator();
            while (iter.hasNext()) {
                Object value = iter.next();
                if (!this.testApplyValidity(expression, testValidity, feature, value, true)) continue;
                expression.createTry();
                this.createItem(feature, value, expression);
                expression.createTryCatchClause(this.getBeanInstantiationExceptionTypeProxy(expression), false);
                expression.createTryEnd();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.inReapplyItems = false;
            throw throwable;
        }
        {
            Object var7_9 = null;
            this.inReapplyItems = false;
            return;
        }
    }

    protected void removeItem(IJavaObjectInstance item, IExpression expression) {
        this.getSettingBeanProxyHost((IJavaInstance)item).releaseBeanProxy(expression);
    }

    protected void removeAllItems(EStructuralFeature feature, IExpression expression) {
        if (!this.isBeanProxyInstantiated()) {
            return;
        }
        List items = (List)((EObject)this.getTarget()).eGet(feature);
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            this.removeItem((IJavaObjectInstance)iter.next(), expression);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.itemsName = CDEPlugin.parseInitializationData((Object)data, (String)"items");
    }

    protected void primReinstantiateItem(EStructuralFeature feature, IJavaObjectInstance item, IBeanProxyHost itemProxy, IExpression expression) {
        itemProxy.releaseBeanProxy(expression);
        this.applyItemSetting(feature, item, ((List)this.getJavaObject().eGet(feature)).indexOf(item), expression);
    }
}

