/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt.targetvm;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.GenericEventQueue;
import org.eclipse.jem.internal.proxy.common.ICallback;
import org.eclipse.jem.internal.proxy.common.ICallbackHandler;
import org.eclipse.jem.internal.proxy.common.ICallbackRunnable;
import org.eclipse.jem.internal.proxy.common.IVMCallbackServer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ve.internal.swt.targetvm.Environment;
import org.eclipse.ve.internal.swt.targetvm.TargetVMMessages;

public class ControlManager {
    private static final String LAYOUT_DATA_KEY = "org.swt.layoutdata";
    private static final Object LAYOUT_DATA_NULL = new Object();
    protected static final Object LAYOUT_DATA_NOTSTORED = new Object();
    protected Control fControl;
    protected ControlManagerFeedbackController feedbackController;
    protected ControlManagerExtension[] extensions;
    private static final Object[] SHELL_LOCATION = new Object[]{new Integer(0), new Integer(0)};
    protected Point overPoint;
    protected boolean locOverridden;

    public static void disposeWidget(Widget widget) {
        if (!widget.isDisposed()) {
            widget.dispose();
        }
    }

    public void addExtension(ControlManagerExtension extension) {
        if (this.extensions == null) {
            this.extensions = new ControlManagerExtension[]{extension};
            extension.setControlManager(this);
        } else {
            int i = 0;
            while (i < this.extensions.length) {
                if (this.extensions[i] == extension) {
                    return;
                }
                ++i;
            }
            ControlManagerExtension[] newExtensions = new ControlManagerExtension[this.extensions.length + 1];
            System.arraycopy(this.extensions, 0, newExtensions, 0, this.extensions.length);
            newExtensions[newExtensions.length - 1] = extension;
            this.extensions = newExtensions;
            extension.setControlManager(this);
        }
    }

    public void removeExtension(ControlManagerExtension extension) {
        if (this.extensions != null) {
            int i = 0;
            while (i < this.extensions.length) {
                if (this.extensions[i] == extension) {
                    if (this.extensions.length > 1) {
                        ControlManagerExtension[] newExtensions = new ControlManagerExtension[this.extensions.length - 1];
                        System.arraycopy(this.extensions, 0, newExtensions, 0, i);
                        int left = newExtensions.length - i;
                        if (left > 0) {
                            System.arraycopy(this.extensions, i + 1, newExtensions, i, left);
                        }
                        this.extensions = newExtensions;
                    } else {
                        this.extensions = null;
                    }
                    extension.setControlManager(null);
                    return;
                }
                ++i;
            }
        }
    }

    public void setControl(Control aControl, ControlManagerFeedbackController feedbackController) {
        this.feedbackController = feedbackController;
        if (this.fControl != null) {
            feedbackController.deregisterComponentManager(this.fControl);
            this.locOverridden = false;
            if (!this.fControl.isDisposed()) {
                this.fControl.setData(LAYOUT_DATA_KEY, null);
            }
        }
        Control oldControl = this.fControl;
        this.fControl = aControl;
        if (this.isValidControl(this.fControl)) {
            feedbackController.registerComponentManager(this.fControl, this);
            feedbackController.queueInitialRefresh(this);
            Object layoutData = this.fControl.getLayoutData();
            ControlManager.storeLayoutData(this.fControl, layoutData);
        }
        if (this.extensions != null) {
            ControlManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].controlSet(oldControl, this.fControl);
                ++i;
            }
        }
    }

    protected static void storeLayoutData(Control control, Object layoutData) {
        control.setData(LAYOUT_DATA_KEY, layoutData != null ? layoutData : LAYOUT_DATA_NULL);
    }

    protected static Object getStoredLayoutData(Control control) {
        Object data = control.getData(LAYOUT_DATA_KEY);
        if (data == null) {
            return LAYOUT_DATA_NOTSTORED;
        }
        if (data != LAYOUT_DATA_NULL) {
            return data;
        }
        return null;
    }

    protected Control getControl() {
        return this.fControl;
    }

    public ControlManagerFeedbackController getFeedbackController() {
        return this.feedbackController;
    }

    public void invalidate() {
        this.feedbackController.invalidateControl(this.fControl);
    }

    protected void aboutToValidate() {
        if (this.extensions != null) {
            ControlManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].aboutToValidate();
                ++i;
            }
        }
    }

    protected void startComponentListening() {
        this.feedbackController.startComponentListening(this.fControl);
        if (this.extensions != null) {
            ControlManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].startComponentListening();
                ++i;
            }
        }
    }

    public Object[] getLocation() {
        if (this.isValidControl(this.fControl)) {
            if (!(this.fControl instanceof Shell)) {
                final Object[] result = new Object[2];
                this.feedbackController.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        Point s = ControlManager.this.fControl.getShell().getLocation();
                        Point c = ControlManager.this.fControl.getParent().toDisplay(ControlManager.this.fControl.getLocation());
                        result[0] = new Integer(c.x - s.x);
                        result[1] = new Integer(c.y - s.y);
                    }
                });
                return result;
            }
            return SHELL_LOCATION;
        }
        return null;
    }

    public Object[] getBounds() {
        final Object[] result = new Object[4];
        if (this.isValidControl(this.fControl)) {
            this.feedbackController.getDisplay().syncExec(new Runnable(){

                public void run() {
                    Object[] location = ControlManager.this.getLocation();
                    Point size = ControlManager.this.fControl.getSize();
                    result[0] = location[0];
                    result[1] = location[1];
                    result[2] = new Integer(size.x);
                    result[3] = new Integer(size.y);
                }
            });
        }
        return result;
    }

    void controlResized() {
        Point s = this.fControl.getSize();
        this.feedbackController.addTransaction(this, 1, new Object[]{new Integer(s.x), new Integer(s.y)}, true);
        if (this.extensions != null) {
            ControlManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].controlResized();
                ++i;
            }
        }
    }

    void controlMoved() {
        this.fireMoved();
    }

    protected void fireMoved() {
        this.feedbackController.addTransaction(this, 2, this.getLocation(), true);
        if (this.extensions != null) {
            ControlManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].controlMoved();
                ++i;
            }
        }
    }

    private Object[] getRefreshParms() {
        return this.getBounds();
    }

    public void queueRefresh() {
        this.feedbackController.addTransaction(this, 3, this.getRefreshParms(), true);
        this.feedbackController.getDisplay().asyncExec(new Runnable(){

            public void run() {
                ControlManager.this.feedbackController.addTransaction(ControlManager.this, 3, ControlManager.this.getRefreshParms(), true);
            }
        });
        if (this.extensions != null) {
            ControlManagerExtension[] lcl = this.extensions;
            int i = 0;
            while (i < lcl.length) {
                lcl[i].refreshQueued();
                ++i;
            }
        }
    }

    public boolean isValidControl(Control control) {
        return control != null && !control.isDisposed();
    }

    public Object applyLayoutData(Object newData) {
        Control control = this.getControl();
        control.setData(LAYOUT_DATA_KEY, newData != null ? newData : LAYOUT_DATA_NULL);
        Object old = control.getLayoutData();
        control.setLayoutData(newData);
        return old;
    }

    public void applyBounds(Rectangle rect, Rectangle oldRect) {
        if (this.isValidControl(this.fControl)) {
            if (!this.locOverridden) {
                if (oldRect != null) {
                    Rectangle o = this.fControl.getBounds();
                    oldRect.x = o.x;
                    oldRect.y = o.y;
                    oldRect.width = o.width;
                    oldRect.height = o.height;
                }
                this.fControl.setBounds(rect);
            } else {
                if (oldRect != null) {
                    oldRect.x = this.overPoint.x;
                    oldRect.y = this.overPoint.y;
                    Point s = this.fControl.getSize();
                    oldRect.width = s.x;
                    oldRect.height = s.y;
                }
                this.fControl.setSize(rect.width, rect.height);
                this.overPoint.x = rect.x;
                this.overPoint.y = rect.y;
            }
        }
    }

    public void applyLocation(Point point, Point oldPoint) {
        if (this.isValidControl(this.fControl)) {
            if (!this.locOverridden) {
                if (oldPoint != null) {
                    Point l = this.fControl.getLocation();
                    oldPoint.x = l.x;
                    oldPoint.y = l.y;
                }
                this.fControl.setLocation(point);
            } else {
                if (oldPoint != null) {
                    oldPoint.x = this.overPoint.x;
                    oldPoint.y = this.overPoint.y;
                }
                this.overPoint.x = point.x;
                this.overPoint.y = point.y;
            }
        }
    }

    public void overrideLoc(final int x, final int y) {
        if (this.isValidControl(this.fControl)) {
            this.feedbackController.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (!ControlManager.this.locOverridden) {
                        ControlManager.this.overPoint = ControlManager.this.fControl.getLocation();
                        ControlManager.this.locOverridden = true;
                    }
                    ControlManager.this.fControl.setLocation(x, y);
                }
            });
        }
    }

    public void removeOverrideLoc() {
        if (this.isValidControl(this.fControl)) {
            this.feedbackController.getDisplay().syncExec(new Runnable(){

                public void run() {
                    if (ControlManager.this.locOverridden) {
                        ControlManager.this.locOverridden = false;
                        if (ControlManager.this.overPoint != null) {
                            ControlManager.this.fControl.setLocation(ControlManager.this.overPoint);
                        }
                    }
                }
            });
        }
    }

    public Point getDefaultLocation() {
        if (this.locOverridden) {
            return this.overPoint;
        }
        final Point[] l = new Point[1];
        if (this.isValidControl(this.fControl)) {
            this.feedbackController.getDisplay().syncExec(new Runnable(){

                public void run() {
                    l[0] = ControlManager.this.fControl.getLocation();
                }
            });
        }
        return l[0];
    }

    public Rectangle getDefaultBounds() {
        final Rectangle result = new Rectangle(0, 0, 0, 0);
        if (this.isValidControl(this.fControl)) {
            this.feedbackController.getDisplay().syncExec(new Runnable(){

                public void run() {
                    Point s = ControlManager.this.fControl.getSize();
                    if (!ControlManager.this.locOverridden) {
                        Point l = ControlManager.this.fControl.getLocation();
                        result.x = l.x;
                        result.y = l.y;
                    } else {
                        result.x = ControlManager.this.overPoint.x;
                        result.y = ControlManager.this.overPoint.y;
                    }
                    result.width = s.x;
                    result.height = s.y;
                }
            });
        }
        return result;
    }

    public Point getOriginOffset() {
        final Point[] originOffset = new Point[1];
        if (this.isValidControl(this.fControl)) {
            this.feedbackController.getDisplay().syncExec(new Runnable(){

                public void run() {
                    Point controlOrigin = ControlManager.this.fControl.toDisplay(0, 0);
                    Composite parent = ControlManager.this.fControl.getParent();
                    Point controlCorner = parent != null ? parent.toDisplay(ControlManager.this.fControl.getLocation()) : ControlManager.this.fControl.getLocation();
                    controlOrigin.x -= controlCorner.x;
                    controlOrigin.y -= controlCorner.y;
                    originOffset[0] = controlOrigin;
                }
            });
        }
        return originOffset[0];
    }

    public static abstract class ControlManagerExtension {
        private ControlManager controlManager;

        void setControlManager(ControlManager componentManager) {
            ControlManager old = this.controlManager;
            this.controlManager = componentManager;
            this.controlManagerSet(old);
        }

        protected void controlManagerSet(ControlManager oldManager) {
        }

        public final ControlManager getControlManager() {
            return this.controlManager;
        }

        public final Control getControl() {
            return this.controlManager != null ? this.controlManager.getControl() : null;
        }

        protected void controlMoved() {
        }

        protected void controlResized() {
        }

        protected void refreshQueued() {
        }

        protected void aboutToValidate() {
        }

        protected void startComponentListening() {
        }

        protected void controlSet(Control oldControl, Control newControl) {
        }
    }

    public static abstract class ControlManagerFeedbackController
    implements ICallback,
    Runnable {
        protected IVMCallbackServer fServer;
        protected int fCallbackID;
        protected Environment environment;
        private boolean changesHeld;
        private GenericEventQueue callbackEventQueue = new GenericEventQueue(TargetVMMessages.getString("ControlManager.CallbackQueueThreadTitle"));
        private List transactions = new ArrayList();
        private Map uniquesMap = new HashMap();
        private List queuedRefreshRequests;
        protected Set queuedInvalidControls;
        private Map controlToControlManagers = new HashMap();
        private Runnable validateImages = new Runnable(this){
            final /* synthetic */ ControlManagerFeedbackController this$1;
            {
                this.this$1 = controlManagerFeedbackController;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (this.this$1.queuedInvalidControls != null && !this.this$1.queuedInvalidControls.isEmpty()) {
                    HashMap<Shell, HashSet<Control>> invalidShells = new HashMap<Shell, HashSet<Control>>();
                    Iterator<E> invItr = this.this$1.queuedInvalidControls.iterator();
                    while (invItr.hasNext()) {
                        Control control = (Control)invItr.next();
                        if (control.isDisposed()) continue;
                        Shell shell = control.getShell();
                        HashSet<Control> invalids = (HashSet<Control>)invalidShells.get(shell);
                        if (invalids == null) {
                            invalids = new HashSet<Control>(2);
                            invalidShells.put(shell, invalids);
                        }
                        invalids.add(control);
                    }
                    Collection invalidControls = this.this$1.validateControls(invalidShells);
                    List list = ControlManagerFeedbackController.access$0(this.this$1);
                    synchronized (list) {
                        Iterator<E> itr = invalidControls.iterator();
                        while (itr.hasNext()) {
                            Control component = (Control)itr.next();
                            ControlManager cmanager = this.this$1.getControlManager(component);
                            if (cmanager == null) continue;
                            ControlManagerFeedbackController.access$1(this.this$1, cmanager, 5, null, true);
                        }
                    }
                    this.this$1.queuedInvalidControls.clear();
                    ControlManagerFeedbackController.access$2(this.this$1);
                }
            }
        };
        private Set controlListening = new HashSet();
        private ControlListener controlListener = new ControlListener(this){
            final /* synthetic */ ControlManagerFeedbackController this$1;
            {
                this.this$1 = controlManagerFeedbackController;
            }

            public void controlResized(ControlEvent e) {
                ControlManager cm = this.this$1.getControlManager((Control)e.getSource());
                if (cm != null) {
                    cm.controlResized();
                }
            }

            public void controlMoved(ControlEvent e) {
                this.notifyMoved((Control)e.getSource());
            }

            private void notifyMoved(Control control) {
                ControlManager cm = this.this$1.getControlManager(control);
                if (cm != null) {
                    cm.controlMoved();
                }
                if (control instanceof Composite) {
                    Control[] children = ((Composite)control).getChildren();
                    int i = 0;
                    while (i < children.length) {
                        this.notifyMoved(children[i]);
                        ++i;
                    }
                }
            }
        };
        private DisposeListener disposeListener = new DisposeListener(this){
            final /* synthetic */ ControlManagerFeedbackController this$1;
            {
                this.this$1 = controlManagerFeedbackController;
            }

            public void widgetDisposed(DisposeEvent e) {
                ControlManagerFeedbackController.access$3(this.this$1).remove(e.getSource());
            }
        };
        static /* synthetic */ Class class$0;

        public static ControlManagerFeedbackController createFeedbackController(Display display) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
            Class<?> feedbackControllerClass = SWT.getVersion() >= 3100 ? Class.forName("org.eclipse.ve.internal.swt.targetvm.ControlManagerFeedbackController_GreaterThan_30") : Class.forName("org.eclipse.ve.internal.swt.targetvm.ControlManagerFeedbackController_30");
            Environment environment = Environment.getEnvironment(display);
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ve.internal.swt.targetvm.Environment");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Constructor<?> ctor = feedbackControllerClass.getConstructor(classArray);
            return (ControlManagerFeedbackController)ctor.newInstance(environment);
        }

        public ControlManagerFeedbackController(Environment environment) {
            this.environment = environment;
        }

        public Display getDisplay() {
            return this.environment.getDisplay();
        }

        public Environment getEnvironment() {
            return this.environment;
        }

        public void initializeCallback(IVMCallbackServer server, int callbackID) {
            this.fServer = server;
            this.fCallbackID = callbackID;
            server.getIVMServer().addShutdownListener(new Runnable(this){
                final /* synthetic */ ControlManagerFeedbackController this$1;
                {
                    this.this$1 = controlManagerFeedbackController;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    List list = ControlManagerFeedbackController.access$0(this.this$1);
                    synchronized (list) {
                        if (this.this$1.fServer != null) {
                            this.this$1.fServer = null;
                            ControlManagerFeedbackController.access$4(this.this$1).close();
                        }
                    }
                }
            });
        }

        public void registerComponentManager(Control component, ControlManager manager) {
            this.controlToControlManagers.put(component, manager);
        }

        public void deregisterComponentManager(Control component) {
            this.controlToControlManagers.remove(component);
        }

        private void postCallback() {
            this.callbackEventQueue.postEvent((Runnable)this);
        }

        public void invalidateControl(Control control) {
            if (this.queuedInvalidControls == null) {
                this.queuedInvalidControls = new HashSet();
            }
            this.queuedInvalidControls.add(control);
        }

        protected abstract Collection validateControls(Map var1);

        protected void sendAboutToValidateToManager(Control control) {
            ControlManager cmanager = this.getControlManager(control);
            if (cmanager != null) {
                cmanager.aboutToValidate();
            }
        }

        protected ControlManager getControlManager(Control control) {
            return (ControlManager)this.controlToControlManagers.get(control);
        }

        public void postInvalidImages() {
            if (this.queuedInvalidControls != null && !this.queuedInvalidControls.isEmpty()) {
                this.getDisplay().asyncExec(this.validateImages);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTransaction(Object notifier, int callbackID, Object[] parms, boolean unique) {
            boolean queueNow;
            this.appendTransaction(notifier, callbackID, parms, unique);
            ControlManagerFeedbackController controlManagerFeedbackController = this;
            synchronized (controlManagerFeedbackController) {
                queueNow = !this.changesHeld;
            }
            if (queueNow) {
                this.postCallback();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void appendTransaction(Object notifier, int callbackID, Object[] parms, boolean unique) {
            List list = this.transactions;
            synchronized (list) {
                if (unique) {
                    UniqueEntry newUE = new UniqueEntry(notifier, callbackID);
                    UniqueEntry ue = (UniqueEntry)this.uniquesMap.get(newUE);
                    if (ue != null) {
                        int index = ue.getIndex();
                        this.transactions.set(index++, null);
                        this.transactions.set(index++, null);
                        this.transactions.set(index++, null);
                    } else {
                        ue = newUE;
                        this.uniquesMap.put(ue, ue);
                    }
                    ue.setIndex(this.transactions.size());
                }
                this.transactions.add(notifier);
                this.transactions.add(new Integer(callbackID));
                this.transactions.add(parms != null ? new ICallbackHandler.TransmitableArray((Object[])parms) : parms);
            }
        }

        void queueInitialRefresh(ControlManager manager) {
            if (this.queuedRefreshRequests == null) {
                this.queuedRefreshRequests = new ArrayList();
            }
            this.queuedRefreshRequests.add(manager);
        }

        public void postInitialRefresh() {
            if (this.queuedRefreshRequests != null && !this.queuedRefreshRequests.isEmpty()) {
                List queued = this.queuedRefreshRequests;
                this.getDisplay().asyncExec(new Runnable(this, queued){
                    final /* synthetic */ ControlManagerFeedbackController this$1;
                    private final /* synthetic */ List val$queued;
                    {
                        this.this$1 = controlManagerFeedbackController;
                        this.val$queued = list;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        List list = ControlManagerFeedbackController.access$0(this.this$1);
                        synchronized (list) {
                            int i = 0;
                            while (i < this.val$queued.size()) {
                                ControlManager manager = (ControlManager)this.val$queued.get(i);
                                if (manager.fControl != null && !manager.fControl.isDisposed()) {
                                    ControlManagerFeedbackController.access$1(this.this$1, manager, 3, ControlManager.access$0(manager), true);
                                    manager.startComponentListening();
                                }
                                ++i;
                            }
                        }
                        ControlManagerFeedbackController.access$2(this.this$1);
                    }
                });
            }
            this.queuedRefreshRequests = null;
        }

        public synchronized void startingChanges() {
            this.changesHeld = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void postChanges() {
            ControlManagerFeedbackController controlManagerFeedbackController = this;
            synchronized (controlManagerFeedbackController) {
                this.changesHeld = false;
            }
            this.postCallback();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object[] trans;
            IVMCallbackServer server = null;
            List list = this.transactions;
            synchronized (list) {
                if (this.fServer == null) {
                    return;
                }
                if (this.transactions.isEmpty()) {
                    return;
                }
                trans = this.transactions.toArray();
                this.transactions.clear();
                this.uniquesMap.clear();
                server = this.fServer;
            }
            try {
                server.doCallback(new ICallbackRunnable(this, trans){
                    final /* synthetic */ ControlManagerFeedbackController this$1;
                    private final /* synthetic */ Object[] val$trans;
                    {
                        this.this$1 = controlManagerFeedbackController;
                        this.val$trans = objectArray;
                    }

                    public Object run(ICallbackHandler handler) throws CommandException {
                        return handler.callbackWithParms(this.this$1.fCallbackID, 4, this.val$trans);
                    }
                });
            }
            catch (CommandException exp) {
                exp.printStackTrace();
            }
        }

        public void startComponentListening(Control control) {
            Shell ffHost = this.getEnvironment().getFreeFormHost();
            while (control != null && control != ffHost) {
                if (this.controlListening.contains(control)) break;
                control.addControlListener(this.controlListener);
                control.addDisposeListener(this.disposeListener);
                this.controlListening.add(control);
                control = control.getParent();
            }
        }

        static /* synthetic */ List access$0(ControlManagerFeedbackController controlManagerFeedbackController) {
            return controlManagerFeedbackController.transactions;
        }

        static /* synthetic */ void access$1(ControlManagerFeedbackController controlManagerFeedbackController, Object object, int n, Object[] objectArray, boolean bl) {
            controlManagerFeedbackController.appendTransaction(object, n, objectArray, bl);
        }

        static /* synthetic */ void access$2(ControlManagerFeedbackController controlManagerFeedbackController) {
            controlManagerFeedbackController.postCallback();
        }

        static /* synthetic */ Set access$3(ControlManagerFeedbackController controlManagerFeedbackController) {
            return controlManagerFeedbackController.controlListening;
        }

        static /* synthetic */ GenericEventQueue access$4(ControlManagerFeedbackController controlManagerFeedbackController) {
            return controlManagerFeedbackController.callbackEventQueue;
        }

        private static class UniqueEntry {
            protected final Object notifier;
            protected final int ID;
            private int index;

            public UniqueEntry(Object notifier, int ID) {
                this.notifier = notifier;
                this.ID = ID;
            }

            public int hashCode() {
                return 31 * (31 + this.notifier.hashCode()) + this.ID;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                try {
                    UniqueEntry ue = (UniqueEntry)obj;
                    return this.notifier == ue.notifier && this.ID == ue.ID;
                }
                catch (ClassCastException classCastException) {
                    return false;
                }
            }

            public void setIndex(int index) {
                this.index = index;
            }

            public int getIndex() {
                return this.index;
            }
        }
    }
}

