/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt.targetvm;

import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.jem.internal.proxy.common.CommandException;
import org.eclipse.jem.internal.proxy.common.ICallback;
import org.eclipse.jem.internal.proxy.common.ICallbackHandler;
import org.eclipse.jem.internal.proxy.common.ICallbackRunnable;
import org.eclipse.jem.internal.proxy.common.IVMCallbackServer;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;

public abstract class ImageCapture
implements ICallback {
    protected IVMCallbackServer vmServer;
    protected int callbackID;
    protected DataOutputStream os;
    private int status = -1;

    public void initializeCallback(IVMCallbackServer vmServer, int callbackID) {
        this.vmServer = vmServer;
        this.callbackID = callbackID;
    }

    protected abstract Image getImage(Control var1, int var2, int var3, boolean var4);

    protected synchronized int getStatus() {
        return this.status;
    }

    protected synchronized void setStatus(int status) {
        this.status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean captureImage(final Control control, final int maxWidth, final int maxHeight, boolean abortAndWait) {
        if (control.isDisposed()) {
            return false;
        }
        ImageCapture imageCapture = this;
        synchronized (imageCapture) {
            if (abortAndWait) {
                if (!this.abortImage(true)) {
                    return false;
                }
            } else if (this.status != -1) {
                return false;
            }
            try {
                this.os = new DataOutputStream(this.vmServer.requestStream(this.callbackID, 1));
            }
            catch (CommandException e1) {
                e1.printStackTrace();
                return false;
            }
            this.status = 6;
            try {
                control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        block9: {
                            if (ImageCapture.this.testForAbort()) {
                                return;
                            }
                            try {
                                Image image;
                                Point size = control.getSize();
                                if (size.x == 0 || size.y == 0) {
                                    ImageCapture.this.imageComplete(3);
                                    return;
                                }
                                boolean clipped = false;
                                if (size.x > maxWidth) {
                                    clipped = true;
                                    size.x = maxWidth;
                                }
                                if (size.y > maxHeight) {
                                    clipped = true;
                                    size.y = maxHeight;
                                }
                                if (clipped) {
                                    ImageCapture.this.setStatus(2);
                                }
                                if ((image = ImageCapture.this.getImage(control, size.x, size.y, true)) != null) {
                                    ImageData imageData = image.getImageData();
                                    image.dispose();
                                    ImageCapture.this.startProcessingThread(imageData);
                                } else {
                                    ImageCapture.this.imageComplete(3);
                                }
                            }
                            catch (Throwable e) {
                                ImageCapture.this.processTerminatingException(e);
                                if (!(e instanceof Error)) break block9;
                                throw (Error)e;
                            }
                        }
                    }
                });
            }
            catch (SWTException e) {
                this.processTerminatingException(e);
                return false;
            }
            return true;
        }
    }

    private void processTerminatingException(final Throwable e) {
        e.printStackTrace();
        try {
            this.vmServer.doCallback(new ICallbackRunnable(){

                public Object run(ICallbackHandler handler) throws CommandException {
                    return handler.callbackWithParms(ImageCapture.this.callbackID, 2, new Object[]{e});
                }
            });
        }
        catch (CommandException e1) {
            e1.printStackTrace();
        }
        this.imageComplete(4);
    }

    private void sendPalette(ImageData imageData) {
        if (imageData.palette.isDirect) {
            try {
                this.os.writeByte(2);
                this.os.writeByte((byte)imageData.depth);
                this.os.writeInt(imageData.palette.redMask);
                this.os.writeInt(imageData.palette.greenMask);
                this.os.writeInt(imageData.palette.blueMask);
            }
            catch (IOException e) {
                this.processTerminatingException(e);
                return;
            }
        }
        try {
            this.os.writeByte(3);
            this.os.writeByte((byte)imageData.depth);
            this.os.writeInt(imageData.transparentPixel);
            RGB[] rgbs = imageData.palette.getRGBs();
            this.os.writeInt(rgbs.length);
            int i = 0;
            while (i < rgbs.length) {
                RGB rgb = rgbs[i];
                this.os.writeByte(rgb.red);
                this.os.writeByte(rgb.green);
                this.os.writeByte(rgb.blue);
                ++i;
            }
        }
        catch (IOException e) {
            this.processTerminatingException(e);
            return;
        }
    }

    private void startProcessingThread(final ImageData imageData) {
        if (this.testForAbort()) {
            return;
        }
        Thread t = new Thread(){

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [5 : 242->246)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        t.start();
    }

    private void sendByteData(ImageData imageData) {
        byte[] pixels = new byte[imageData.width];
        try {
            int row = 0;
            while (row < imageData.height) {
                int dupCnt;
                int col;
                if (this.testForAbort()) {
                    return;
                }
                imageData.getPixels(0, row, pixels.length, pixels, 0);
                this.os.writeByte(4);
                this.os.writeInt(row);
                int startNonDup = col = 0;
                int startDup = col;
                byte startDupPixel = pixels[col];
                int stop = pixels.length;
                while (col < stop) {
                    byte pixel = pixels[col];
                    if (pixel != startDupPixel) {
                        dupCnt = col - startDup;
                        if (dupCnt < 3) {
                            startDup = col;
                            startDupPixel = pixel;
                        } else {
                            if (startNonDup < startDup) {
                                this.os.writeByte(7);
                                this.os.writeInt(startDup - startNonDup);
                                while (startNonDup < startDup) {
                                    this.os.writeByte(pixels[startNonDup++]);
                                }
                            }
                            this.os.writeByte(6);
                            this.os.writeInt(dupCnt);
                            this.os.writeByte(startDupPixel);
                            startDup = startNonDup = col;
                            startDupPixel = pixel;
                        }
                    }
                    ++col;
                }
                dupCnt = col - startDup;
                if (dupCnt < 3) {
                    startDup = col;
                    dupCnt = 0;
                }
                if (startNonDup < startDup) {
                    this.os.writeByte(7);
                    this.os.writeInt(startDup - startNonDup);
                    while (startNonDup < startDup) {
                        this.os.writeByte(pixels[startNonDup++]);
                    }
                }
                if (dupCnt > 0) {
                    this.os.writeByte(6);
                    this.os.writeInt(dupCnt);
                    this.os.writeByte(startDupPixel);
                }
                ++row;
            }
        }
        catch (IOException e) {
            this.processTerminatingException(e);
            return;
        }
    }

    private void sendIntData(ImageData imageData) {
        int[] pixels = new int[imageData.width];
        try {
            int row = 0;
            while (row < imageData.height) {
                int dupCnt;
                int col;
                if (this.testForAbort()) {
                    return;
                }
                imageData.getPixels(0, row, pixels.length, pixels, 0);
                this.os.writeByte(5);
                this.os.writeInt(row);
                int startNonDup = col = 0;
                int startDup = col;
                int startDupPixel = pixels[col];
                int stop = pixels.length;
                while (col < stop) {
                    int pixel = pixels[col];
                    if (pixel != startDupPixel) {
                        dupCnt = col - startDup;
                        if (dupCnt < 3) {
                            startDup = col;
                            startDupPixel = pixel;
                        } else {
                            if (startNonDup < startDup) {
                                this.os.writeByte(7);
                                this.os.writeInt(startDup - startNonDup);
                                while (startNonDup < startDup) {
                                    this.os.writeInt(pixels[startNonDup++]);
                                }
                            }
                            this.os.writeByte(6);
                            this.os.writeInt(dupCnt);
                            this.os.writeInt(startDupPixel);
                            startDup = startNonDup = col;
                            startDupPixel = pixel;
                        }
                    }
                    ++col;
                }
                dupCnt = col - startDup;
                if (dupCnt < 3) {
                    startDup = col;
                    dupCnt = 0;
                }
                if (startNonDup < startDup) {
                    this.os.writeByte(7);
                    this.os.writeInt(startDup - startNonDup);
                    while (startNonDup < startDup) {
                        this.os.writeInt(pixels[startNonDup++]);
                    }
                }
                if (dupCnt > 0) {
                    this.os.writeByte(6);
                    this.os.writeInt(dupCnt);
                    this.os.writeInt(startDupPixel);
                }
                ++row;
            }
        }
        catch (IOException e) {
            this.processTerminatingException(e);
            return;
        }
    }

    public synchronized boolean abortImage(boolean wait) {
        if (this.status != -1) {
            this.status = 5;
            if (wait) {
                while (true) {
                    try {
                        this.wait(15000L);
                        return this.status == -1;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void imageComplete(int status) {
        block12: {
            if (this.os != null) {
                try {
                    try {
                        this.os.writeByte(8);
                        this.os.writeInt(status);
                        this.os.close();
                        this.os = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    if (this.os == null) throw throwable;
                    try {
                        this.os.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                    if (this.os == null) break block12;
                }
                try {}
                catch (IOException iOException) {}
                this.os.close();
            }
        }
        ImageCapture imageCapture = this;
        synchronized (imageCapture) {
            this.status = -1;
            this.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean testForAbort() {
        int s;
        ImageCapture imageCapture = this;
        synchronized (imageCapture) {
            s = this.status;
        }
        if (s == -1) {
            return true;
        }
        if (s == 5) {
            if (this.os != null) {
                this.imageComplete(s);
            }
            return true;
        }
        return false;
    }

    static /* synthetic */ int access$2(ImageCapture imageCapture) {
        return imageCapture.status;
    }

    static /* synthetic */ void access$3(ImageCapture imageCapture, ImageData imageData) {
        imageCapture.sendPalette(imageData);
    }

    static /* synthetic */ void access$4(ImageCapture imageCapture, ImageData imageData) {
        imageCapture.sendByteData(imageData);
    }

    static /* synthetic */ void access$5(ImageCapture imageCapture, ImageData imageData) {
        imageCapture.sendIntData(imageData);
    }
}

