/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt.targetvm.unix.bits64;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImageCapture
extends org.eclipse.ve.internal.swt.targetvm.ImageCapture {
    static final int OBSCURED = 64;
    static final String FIELD_STATE_NAME = "state";
    protected Map fieldAccessors = new HashMap();
    private static final Object NO_FIELD;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        try {
            System.loadLibrary("swt-gtk-print");
        }
        catch (UnsatisfiedLinkError error) {
            error.printStackTrace();
        }
        NO_FIELD = new Object();
    }

    private native int[] getPixels(long var1, int var3, int var4, int var5, int var6);

    protected Point getTopLeftOfClientarea(Decorations decorations) {
        Point trim = decorations.toControl(decorations.getLocation());
        trim.x = -trim.x;
        trim.y = -trim.y;
        if (decorations.getMenuBar() != null) {
            Menu menu = decorations.getMenuBar();
            try {
                Class<?> osClass = Class.forName("org.eclipse.swt.internal.gtk.OS");
                Method method = osClass.getMethod("GTK_WIDGET_HEIGHT", Integer.TYPE);
                Object ret = method.invoke((Object)menu, new Integer(menu.handle));
                if (ret != null) {
                    int menuBarHeight = (Integer)ret;
                    trim.y -= menuBarHeight;
                }
            }
            catch (Throwable throwable) {}
        }
        return new Point(trim.x, trim.y);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Image getImageOfControl(Control control, int includeChildren) {
        Shell shell;
        long handle;
        Image image = null;
        if (control instanceof Shell && (handle = this.readLongFieldValue((shell = (Shell)control).getClass(), shell, "shellHandle")) > 0L) {
            image = this.getImageOfHandle(handle, shell.getDisplay(), includeChildren);
        }
        if (image == null) {
            image = this.getImageOfHandle(control.handle, control.getDisplay(), includeChildren);
        }
        if (!(control instanceof Decorations)) return image;
        Decorations decorations = (Decorations)control;
        Rectangle shellBounds = decorations.getBounds();
        Point topLeft = this.getTopLeftOfClientarea(decorations);
        Image realShellImage = new Image((Device)decorations.getDisplay(), shellBounds.width, shellBounds.height);
        Image origImage = image;
        try {
            this.simulateDecoration(decorations, realShellImage, decorations.getBounds(), decorations.getClientArea(), topLeft);
            GC gc = new GC((Drawable)realShellImage);
            gc.drawImage(image, topLeft.x, topLeft.y);
            gc.dispose();
            image = realShellImage;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            origImage.dispose();
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        origImage.dispose();
        return image;
    }

    protected Image getImageOfHandle(long handle, Display display, int includeChildren) {
        int[] tcData = this.getPixels(handle, includeChildren, 0, 0, 0);
        int depth = display.getDepth();
        if (depth == 15) {
            depth = 16;
        }
        if (depth > 24) {
            depth = 24;
        }
        if (tcData != null) {
            int tcWidth = tcData[0];
            int tcHeight = tcData[1];
            int type = tcData[2];
            if (type == 1) {
                int red_mask = tcData[3] == -1 ? 255 : tcData[3];
                int green_mask = tcData[4] == -1 ? 65280 : tcData[4];
                int blue_mask = tcData[5] == -1 ? 0xFF0000 : tcData[5];
                int[] tcPixels = new int[tcData.length - 6];
                System.arraycopy(tcData, 6, tcPixels, 0, tcPixels.length);
                ImageData tcImageData = new ImageData(tcWidth, tcHeight, depth, new PaletteData(red_mask, green_mask, blue_mask));
                tcImageData.setPixels(0, 0, tcPixels.length, tcPixels, 0);
                Image tcImage = new Image((Device)display, tcImageData);
                return tcImage;
            }
            if (type == 2) {
                int numColors = tcData[3];
                RGB[] rgb = new RGB[numColors];
                int colCount = 0;
                while (colCount < numColors) {
                    int r = tcData[4 + colCount * 3 + 0];
                    int g = tcData[4 + colCount * 3 + 1];
                    int b = tcData[4 + colCount * 3 + 2];
                    rgb[colCount] = new RGB(r, g, b);
                    ++colCount;
                }
                PaletteData pd = new PaletteData(rgb);
                ImageData id = new ImageData(tcWidth, tcHeight, depth, pd);
                int offset = 4 + rgb.length * 3;
                int[] pixels = new int[tcData.length - offset];
                System.arraycopy(tcData, offset, pixels, 0, pixels.length);
                id.setPixels(0, 0, pixels.length, pixels, 0);
                Image tcImage = new Image((Device)display, id);
                return tcImage;
            }
            System.err.println("JNI Returned unknown image type");
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void simulateDecoration(Decorations decoration, Image realShellImage, Rectangle bounds, Rectangle clientArea, Point topLeft) {
        GC gc = new GC((Drawable)realShellImage);
        try {
            gc.setBackground(decoration.getDisplay().getSystemColor(22));
            gc.fillRectangle(0, 0, bounds.width, bounds.height);
            gc.setBackground(decoration.getDisplay().getSystemColor(17));
            gc.drawRectangle(topLeft.x - 1, topLeft.y - 1, clientArea.width + 2, clientArea.height + 2);
            gc.setBackground(decoration.getDisplay().getSystemColor(31));
            gc.fillRectangle(0, bounds.height - topLeft.y, topLeft.y, bounds.height);
            gc.fillRectangle(bounds.width - topLeft.y, bounds.height - topLeft.y, bounds.width, bounds.height);
            if ((decoration.getStyle() & 0x4E0) != 0 && topLeft.y > 2) {
                int barHeight = topLeft.y - 2;
                gc.setForeground(decoration.getDisplay().getSystemColor(31));
                gc.setBackground(decoration.getDisplay().getSystemColor(30));
                gc.fillGradientRectangle(0, 0, bounds.width, barHeight, false);
                gc.setForeground(decoration.getDisplay().getSystemColor(30));
                gc.drawText(decoration.getText(), topLeft.y, 2, true);
                if (decoration.getImage() != null && !decoration.getImage().isDisposed()) {
                    Rectangle imageBounds = decoration.getImage().getBounds();
                    if (imageBounds.height <= barHeight) {
                        gc.drawImage(decoration.getImage(), 0, 0);
                    } else {
                        ImageData imageData = decoration.getImage().getImageData();
                        double factor = (double)barHeight / (double)imageBounds.height;
                        int newWidth = (int)((double)imageBounds.width * factor);
                        imageData = imageData.scaledTo(newWidth, barHeight);
                        Image newImage = new Image((Device)decoration.getDisplay(), imageData);
                        gc.drawImage(newImage, 0, 0);
                        newImage.dispose();
                    }
                }
                int rightx = bounds.width - topLeft.y;
                if ((decoration.getStyle() & 0x40) != 0) {
                    gc.setBackground(decoration.getDisplay().getSystemColor(22));
                    gc.fillRectangle(rightx, 0, topLeft.y, topLeft.y);
                    gc.setLineWidth(1);
                    gc.setForeground(decoration.getDisplay().getSystemColor(17));
                    gc.drawRectangle(rightx, 0, topLeft.y, topLeft.y);
                    int lineWidth = topLeft.y / 6;
                    if (lineWidth < 1) {
                        lineWidth = 1;
                    }
                    gc.setLineWidth(lineWidth);
                    gc.setForeground(decoration.getDisplay().getSystemColor(23));
                    gc.drawLine(rightx + (lineWidth *= 2), lineWidth, rightx + topLeft.y - lineWidth, topLeft.y - lineWidth);
                    gc.drawLine(rightx + lineWidth, topLeft.y - lineWidth, rightx + topLeft.y - lineWidth, lineWidth);
                    rightx -= topLeft.y;
                }
                if ((decoration.getStyle() & 0x400) != 0) {
                    gc.setBackground(decoration.getDisplay().getSystemColor(22));
                    gc.fillRectangle(rightx, 0, topLeft.y, topLeft.y);
                    gc.setLineWidth(1);
                    gc.setForeground(decoration.getDisplay().getSystemColor(17));
                    gc.drawRectangle(rightx, 0, topLeft.y, topLeft.y);
                    int lineWidth = topLeft.y / 6;
                    if (lineWidth < 1) {
                        lineWidth = 1;
                    }
                    gc.setLineWidth(lineWidth);
                    gc.setForeground(decoration.getDisplay().getSystemColor(23));
                    gc.drawRectangle(rightx + (lineWidth *= 2), lineWidth, topLeft.y - 2 * lineWidth, topLeft.y - 2 * lineWidth);
                    rightx -= topLeft.y;
                }
                if ((decoration.getStyle() & 0x80) != 0) {
                    gc.setLineWidth(1);
                    gc.setBackground(decoration.getDisplay().getSystemColor(22));
                    gc.fillRectangle(rightx, 0, topLeft.y - 1, topLeft.y - 1);
                    gc.setForeground(decoration.getDisplay().getSystemColor(17));
                    gc.drawRectangle(rightx, 0, topLeft.y - 1, topLeft.y - 1);
                    int lineWidth = topLeft.y / 6;
                    if (lineWidth < 1) {
                        lineWidth = 1;
                    }
                    gc.setLineWidth(lineWidth);
                    gc.setForeground(decoration.getDisplay().getSystemColor(23));
                    gc.drawLine(rightx + (lineWidth *= 2), topLeft.y - lineWidth, rightx + topLeft.y - lineWidth, topLeft.y - lineWidth);
                    rightx -= topLeft.y;
                }
                gc.setLineWidth(1);
                gc.setForeground(decoration.getDisplay().getSystemColor(17));
                gc.drawLine(0, topLeft.y - 1, bounds.width, topLeft.y - 1);
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            gc.dispose();
            throw throwable;
        }
        {
            Object var14_19 = null;
        }
        gc.dispose();
    }

    private int readIntFieldValue(Class klass, Object object, String fieldName) {
        try {
            Field field = this.getField(klass, fieldName);
            return field != null ? field.getInt(object) : 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return -1;
    }

    private long readLongFieldValue(Class klass, Object object, String fieldName) {
        try {
            Field field = this.getField(klass, fieldName);
            return field != null ? field.getLong(object) : 0L;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return -1L;
    }

    private Field getField(Class klass, String fieldName) {
        Object field;
        HashMap nameToField = (HashMap)this.fieldAccessors.get(klass);
        if (nameToField == null) {
            nameToField = new HashMap();
            this.fieldAccessors.put(klass, nameToField);
        }
        if ((field = nameToField.get(fieldName)) == null) {
            try {
                field = klass.getDeclaredField(fieldName);
                ((Field)field).setAccessible(true);
            }
            catch (SecurityException e) {
                field = NO_FIELD;
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                field = NO_FIELD;
                e.printStackTrace();
            }
            nameToField.put(klass, field);
        }
        return (Field)(field != NO_FIELD ? field : null);
    }

    private void writeIntFieldValue(Class klass, Object object, String fieldName, int newInt) {
        try {
            Field field = this.getField(klass, fieldName);
            field.setInt(object, newInt);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Image getImage(Control control, int maxWidth, int maxHeight, boolean includeChildren) {
        int ic = includeChildren ? 1 : 0;
        HashMap map = new HashMap();
        this.changeObscured(control, map, false);
        Image image = null;
        try {
            image = this.getImageOfControl(control, ic);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.changeObscured(control, map, true);
            throw throwable;
        }
        {
            Object var8_10 = null;
            this.changeObscured(control, map, true);
            return image;
        }
    }

    private void changeObscured(Control control, Map map, boolean on) {
        if (on) {
            if (map.containsKey(control)) {
                Integer originalValue = (Integer)map.get(control);
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.swt.widgets.Widget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.writeIntFieldValue(clazz, control, FIELD_STATE_NAME, originalValue);
            }
        } else {
            int stateValue;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.swt.widgets.Widget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (((stateValue = this.readIntFieldValue(clazz, control, FIELD_STATE_NAME)) & 0x40) != 0) {
                map.put(control, new Integer(stateValue));
                stateValue &= 0xFFFFFFBF;
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$1 = Class.forName("org.eclipse.swt.widgets.Widget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this.writeIntFieldValue(clazz2, control, FIELD_STATE_NAME, stateValue);
            }
        }
        if (control instanceof CCombo) {
            Object val;
            CCombo ccombo = (CCombo)control;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.swt.custom.CCombo");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((val = this.readObjectFieldValue(clazz, ccombo, "text")) instanceof Text) {
                Text text = (Text)val;
                this.changeObscured((Control)text, map, on);
            }
        } else if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            int cc = 0;
            while (children != null && cc < children.length) {
                this.changeObscured(children[cc], map, on);
                ++cc;
            }
        }
    }

    private Object readObjectFieldValue(Class klass, Object object, String fieldName) {
        try {
            Field field = klass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return null;
    }
}

