/* @(#) TimeZoneEditor.java        Ver 1.0    01,April,1998
 *
 * Copyright (c) 1998 International Business Machines.
 * All Rights Reserved.
 *
 * Author : Sunanda Bera & P.Sushma
 * Last Modified : 01,April,1998
 *
 * Purpose : Defines class TimeZoneEditor.
 *
 *
 * Revision History 
 * ======== ======= 
 *
 * Date        By            Description
 * ----        --            -----------
 *
 *
 */
package com.ibm.clock.editors;

import java.beans.PropertyEditorSupport;

import java.util.TimeZone;

public class TimeZoneEditor
extends PropertyEditorSupport
{
    public String getAsText()
    {
        TimeZone timeZone = ( TimeZone )getValue();
        return timeZone.getID();
    }//end of getAsText
    
    public String [] getTags()
    {
        String [] ids = TimeZone.getAvailableIDs();
      
        return TimeZone.getAvailableIDs();
    }//end of getTags
    
    public boolean supportsCustomEditor()
    {
        return false;
    }//end supportsCustomEditor
    
    public void setAsText( String id )
    {
        setValue( TimeZone.getTimeZone( id ) );
    }//end of setAsText
    
    public String getJavaInitializationString()
    {
        TimeZone timeZone = ( TimeZone )getValue();
        return " java.util.TimeZone.getTimeZone( \"" +timeZone.getID() + "\" )" ;
    }//end of getJavaInitializationString
}//end of TimeZoneEditor class definition
