/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.property;

import java.util.Iterator;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.examples.cdm.dept.Company;
import org.eclipse.ve.examples.cdm.dept.Department;
import org.eclipse.ve.examples.cdm.dept.Employee;
import org.eclipse.ve.examples.cdm.dept.property.CompanyPropertySource;
import org.eclipse.ve.examples.cdm.dept.property.DepartmentPropertySource;
import org.eclipse.ve.examples.cdm.dept.property.EmployeePropertySource;

public class PropertySupport {
    public static IPropertySource getPropertySource(Object model) {
        if (model instanceof Company) {
            return new CompanyPropertySource((Company)model);
        }
        if (model instanceof Department) {
            return new DepartmentPropertySource((Department)model);
        }
        if (model instanceof Employee) {
            return new EmployeePropertySource((Employee)model);
        }
        return null;
    }

    public static String getUniqueDepartmentName(Company company, String deptName) {
        String baseDeptName = null;
        baseDeptName = deptName != null ? deptName : "Dept XYZ";
        String componentName = baseDeptName;
        int incr = 0;
        block0: while (true) {
            Iterator departments = company.getDepartments().iterator();
            while (departments.hasNext()) {
                Department aDept = (Department)departments.next();
                if (!componentName.equals(aDept.getDepartmentName())) continue;
                componentName = String.valueOf(baseDeptName) + ++incr;
                continue block0;
            }
            break;
        }
        return componentName;
    }

    public static String getUniqueEmployeeName(Company company, String empName) {
        String baseEmpName = null;
        baseEmpName = empName != null ? empName : "Employee XYZ";
        String componentName = baseEmpName;
        int incr = 0;
        block0: while (true) {
            Iterator employees = company.getEmployeesIterator();
            while (employees.hasNext()) {
                Employee anEmp = (Employee)employees.next();
                if (!componentName.equals(anEmp.getName())) continue;
                componentName = String.valueOf(baseEmpName) + ++incr;
                continue block0;
            }
            break;
        }
        return componentName;
    }
}

