/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.property;

import java.util.Iterator;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.examples.cdm.dept.Company;
import org.eclipse.ve.examples.cdm.dept.Department;
import org.eclipse.ve.examples.cdm.dept.Employee;
import org.eclipse.ve.examples.cdm.dept.property.DepartmentPropertySource;
import org.eclipse.ve.examples.cdm.dept.property.PropertySupport;
import org.eclipse.ve.examples.cdm.dept.property.UniqueEmployeeName;
import org.eclipse.ve.internal.propertysheet.command.SetPropertyValueCommand;
import org.eclipse.ve.internal.propertysheet.common.commands.CommandWrapper;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class UniqueDepartmentName
extends CommandWrapper {
    protected Company company;
    protected Department department;

    public UniqueDepartmentName(Company company, Department department) {
        this.company = company;
        this.department = department;
    }

    protected boolean prepare() {
        return true;
    }

    public void execute() {
        CompoundCommand c = new CompoundCommand();
        String newName = PropertySupport.getUniqueDepartmentName(this.company, this.department.getDepartmentName());
        if (!newName.equals(this.department.getDepartmentName())) {
            SetPropertyValueCommand pcmd = new SetPropertyValueCommand();
            pcmd.setTarget((IPropertySource)new DepartmentPropertySource(this.department));
            pcmd.setPropertyId((Object)"deptname");
            pcmd.setPropertyValue((Object)newName);
            c.append((Command)pcmd);
        }
        Iterator itr = this.department.getEmployees().iterator();
        while (itr.hasNext()) {
            c.append((Command)new UniqueEmployeeName(this.company, (Employee)itr.next()));
        }
        if (!c.isEmpty()) {
            this.command = c.unwrap();
            this.command.execute();
        }
    }

    public void undo() {
        if (this.command != null) {
            super.undo();
        }
    }
}

