/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.ui;

import java.util.Iterator;
import java.util.List;
import org.eclipse.ve.examples.cdm.dept.Company;
import org.eclipse.ve.examples.cdm.dept.Department;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;

public class RemoveDepartmentsCommand
extends AbstractCommand {
    protected Company company;
    protected List departments;
    protected int[] oldPos;

    public RemoveDepartmentsCommand(Company company, List departments) {
        this.company = company;
        this.departments = departments;
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        Iterator itr = this.departments.iterator();
        this.oldPos = new int[this.departments.size()];
        int i = -1;
        while (itr.hasNext()) {
            Department department = (Department)itr.next();
            int pos = this.company.getDepartments().indexOf(department);
            this.oldPos[++i] = pos;
            if (pos == -1) continue;
            this.company.removeDepartment(department);
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        Iterator itr = this.departments.iterator();
        int i = -1;
        while (itr.hasNext()) {
            int pos;
            Department department = (Department)itr.next();
            if ((pos = this.oldPos[++i]) == -1) continue;
            this.company.addDepartment(department, pos);
        }
        this.oldPos = null;
    }
}

