/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.examples.cdm.dept.ui;

import java.util.Iterator;
import java.util.List;
import org.eclipse.ve.examples.cdm.dept.Department;
import org.eclipse.ve.examples.cdm.dept.Employee;
import org.eclipse.ve.internal.propertysheet.common.commands.AbstractCommand;

public class RemoveEmployeesCommand
extends AbstractCommand {
    protected Department department;
    protected List employees;
    protected int[] oldPos;

    public RemoveEmployeesCommand(Department department, List employees) {
        this.department = department;
        this.employees = employees;
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        Iterator itr = this.employees.iterator();
        this.oldPos = new int[this.employees.size()];
        int i = 0;
        while (itr.hasNext()) {
            Employee employee = (Employee)itr.next();
            int pos = this.department.getEmployees().indexOf(employee);
            this.oldPos[i++] = pos;
            if (pos == -1) continue;
            this.department.removeEmployee(employee);
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        Iterator itr = this.employees.iterator();
        int i = 0;
        while (itr.hasNext()) {
            int pos;
            Employee employee = (Employee)itr.next();
            if ((pos = this.oldPos[i++]) == -1) continue;
            this.department.addEmployee(employee, pos);
        }
        this.oldPos = null;
    }
}

