package com.abc.wizzowidgets.beaninfo;

import java.beans.*;

import com.abc.wizzowidgets.Shape;
/**
 * BeanInfo for the Shape class
 */
public class ShapeBeanInfo extends SimpleBeanInfo {
	/**
 * Get the bean descriptor with the customizer
 */
public BeanDescriptor getBeanDescriptor(){
	return new BeanDescriptor(Shape.class);
}
/**
 * Return the property descriptors for this bean.
 */
public PropertyDescriptor[] getPropertyDescriptors() {
	try {
		PropertyDescriptor shapeDescriptor = new PropertyDescriptor("shape",Shape.class);
		shapeDescriptor.setPropertyEditorClass(ShapePropertyEditor.class);
		return new PropertyDescriptor[] { shapeDescriptor };
	} catch ( IntrospectionException exc ) {
		return null;
	}
}
public static class ShapePropertyEditor extends PropertyEditorSupport{
	
	public String[] TAGS = new String[] { "NONE" , "OVAL" , "DIAMOND" };
	public int[] SHAPES = new int[] { Shape.NONE , Shape.OVAL , Shape.DIAMOND };
	private int shape;
	
	public void setValue(Object aShape){
		if ( aShape instanceof Integer ) {
			shape = ((Integer)aShape).intValue();	
		}
	}
	public Object getValue(){
		return new Integer(shape);
	}
	public String getAsText(){
		return TAGS[shape];
	}
	public String[] getTags(){
		return TAGS;
	}
	public String getJavaInitializationString(){
		// The shape values are public fields on the Shape class with the same name as the tag
		return "com.abc.wizzowidgets.Shape." + TAGS[shape];		
	}
	public void setAsText(String aText){
		for (int i = 0; i < TAGS.length; i++) {
			if ( TAGS[i].equals(aText) ) {
				shape = SHAPES[i];
				break;
			}		
		}
	}
}
}
