/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.remotevm;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ve.internal.java.remotevm.IBeanPropertyEditorDialog;
import org.eclipse.ve.internal.java.remotevm.IPropertyEditorDialogListener;
import org.eclipse.ve.internal.java.remotevm.PropertyCustomComponentLayout;
import org.eclipse.ve.internal.java.remotevm.RemoteVMMessages;

public final class BeanPropertyEditorFrame
extends Frame
implements IBeanPropertyEditorDialog {
    private static final long serialVersionUID = -751707180162909504L;
    private transient List fListeners = new ArrayList(1);
    private Component propertyEditorComponent;
    private Panel propertyEditorContainer;
    private Button okButton;
    private Button cancelButton;
    private Panel buttonRow;

    public BeanPropertyEditorFrame() {
        super(RemoteVMMessages.getString("PropertyEditor.Dialog.Title"));
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("customiz.gif")));
        this.setLayout(new BorderLayout());
        this.setBackground(SystemColor.control);
        this.propertyEditorContainer = new Panel();
        this.propertyEditorContainer.setLayout(new PropertyCustomComponentLayout());
        this.add((Component)this.propertyEditorContainer, "Center");
        this.addWindowListenersToFrame(this);
    }

    public void addListener(IPropertyEditorDialogListener aListener) {
        this.fListeners.add(aListener);
    }

    protected void addWindowListenersToFrame(Window aFrame) {
        aFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                BeanPropertyEditorFrame.this.doCancel();
            }
        });
    }

    protected void closeDialog() {
        if (this.propertyEditorComponent != null && this.propertyEditorComponent instanceof IPropertyEditorDialogListener) {
            this.removeListener((IPropertyEditorDialogListener)((Object)this.propertyEditorComponent));
        }
        this.dispose();
    }

    public void doCancel() {
        this.notifyRevertPropertyValue();
        this.closeDialog();
    }

    public void doOK() {
        this.notifySavePropertyValue();
        this.closeDialog();
    }

    protected Button getCancelButton() {
        if (this.cancelButton != null) {
            return this.cancelButton;
        }
        this.cancelButton = new Button(RemoteVMMessages.getString("PropertyEditor.Dialog.Button.Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BeanPropertyEditorFrame.this.doCancel();
            }
        });
        return this.cancelButton;
    }

    protected Button getOKButton() {
        if (this.okButton != null) {
            return this.okButton;
        }
        this.okButton = new Button(RemoteVMMessages.getString("PropertyEditor.Dialog.Button.OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BeanPropertyEditorFrame.this.doOK();
            }
        });
        return this.okButton;
    }

    protected void notifyRevertPropertyValue() {
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            IPropertyEditorDialogListener aListener = (IPropertyEditorDialogListener)iter.next();
            aListener.revertPropertyValue();
        }
    }

    protected void notifySavePropertyValue() {
        Iterator iter = this.fListeners.iterator();
        while (iter.hasNext()) {
            IPropertyEditorDialogListener aListener = (IPropertyEditorDialogListener)iter.next();
            aListener.savePropertyValue();
        }
    }

    public void removeListener(IPropertyEditorDialogListener aListener) {
        this.fListeners.remove(aListener);
    }

    public void setPropertyEditor(Component aComponent) {
        if (this.propertyEditorComponent != null) {
            this.propertyEditorContainer.remove(this.propertyEditorComponent);
        }
        if (this.propertyEditorComponent instanceof IPropertyEditorDialogListener) {
            this.removeListener((IPropertyEditorDialogListener)((Object)this.propertyEditorComponent));
        }
        if (this.buttonRow != null) {
            this.buttonRow.setBackground(null);
        }
        this.propertyEditorComponent = aComponent;
        if (this.propertyEditorComponent != null) {
            this.propertyEditorContainer.add(this.propertyEditorComponent);
            if (aComponent instanceof IPropertyEditorDialogListener) {
                this.addListener((IPropertyEditorDialogListener)((Object)aComponent));
            }
            if (this.propertyEditorComponent.getBackground() != this.propertyEditorContainer.getBackground() && this.buttonRow != null) {
                this.buttonRow.setBackground(this.propertyEditorComponent.getBackground());
            }
        }
    }

    public void decorateWithButtons(boolean abool) {
        if (abool) {
            this.buttonRow = new Panel();
            this.buttonRow.setLayout(new FlowLayout(2));
            Panel buttonGrid = new Panel();
            this.buttonRow.add(buttonGrid);
            buttonGrid.setLayout(new GridLayout(1, 0, 5, 0));
            buttonGrid.add(this.getOKButton());
            buttonGrid.add(this.getCancelButton());
            this.add((Component)this.buttonRow, "South");
        }
    }
}

