/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.logging.Level;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.proxy.core.IArrayBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IDimensionBeanProxy;
import org.eclipse.jem.internal.proxy.core.IRectangleBeanProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.BeanUtilities;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.visual.DimensionJavaClassCellEditor;
import org.eclipse.ve.internal.java.visual.NullLayoutConstraintCommand;
import org.eclipse.ve.internal.java.visual.PointJavaClassCellEditor;
import org.eclipse.ve.internal.java.visual.RectangleJavaClassCellEditor;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.JFCConstants;

public class ApplyNullLayoutConstraintCommand
extends NullLayoutConstraintCommand {
    public ApplyNullLayoutConstraintCommand(String label) {
        super(label);
    }

    public ApplyNullLayoutConstraintCommand() {
    }

    protected IJavaInstance createLocationInstance(int x, int y) {
        return BeanUtilities.createJavaObject((String)JFCConstants.POINT_CLASS_NAME, (ResourceSet)this.rset, (String)PointJavaClassCellEditor.getJavaInitializationString((int)x, (int)y, (String)JFCConstants.POINT_CLASS_NAME));
    }

    protected IJavaInstance createSizeInstance(int width, int height) {
        return BeanUtilities.createJavaObject((String)JFCConstants.DIMENSION_CLASS_NAME, (ResourceSet)this.rset, (String)DimensionJavaClassCellEditor.getJavaInitializationString((int)width, (int)height, (String)JFCConstants.DIMENSION_CLASS_NAME));
    }

    protected IJavaInstance createBoundsInstance(int x, int y, int width, int height) {
        return BeanUtilities.createJavaObject((String)JFCConstants.RECTANGLE_CLASS_NAME, (ResourceSet)this.rset, (String)RectangleJavaClassCellEditor.getJavaInitializationString((int)x, (int)y, (int)width, (int)height, (String)JFCConstants.RECTANGLE_CLASS_NAME));
    }

    protected URI getSFBounds() {
        return JFCConstants.SF_COMPONENT_BOUNDS;
    }

    protected URI getSFSize() {
        return JFCConstants.SF_COMPONENT_SIZE;
    }

    protected URI getSFLocation() {
        return JFCConstants.SF_COMPONENT_LOCATION;
    }

    protected Point getPreferredLoc() {
        IBeanProxy childProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.target, (boolean)true);
        if (childProxy == null) {
            return new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        IDimensionBeanProxy size = BeanAwtUtilities.invoke_getSize(childProxy);
        if (size == null) {
            return new Point(Integer.MIN_VALUE, Integer.MIN_VALUE);
        }
        Rectangle bounds = new Rectangle(Integer.MIN_VALUE, Integer.MIN_VALUE, size.getWidth(), size.getHeight());
        return ApplyNullLayoutConstraintCommand.findNextAvailablePosition(bounds, BeanAwtUtilities.invoke_getParent(childProxy), 5, 5);
    }

    protected static Point findNextAvailablePosition(Rectangle bounds, IBeanProxy containerBeanProxy, int marginWidth, int marginHeight) {
        int requestedWidth = bounds.width + 2 * marginWidth;
        int requestedHeight = bounds.height + 2 * marginHeight;
        IRectangleBeanProxy boundingRect = BeanAwtUtilities.invoke_getBounds(containerBeanProxy);
        IArrayBeanProxy children = BeanAwtUtilities.invoke_getComponents(containerBeanProxy);
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>(children.getLength());
        int i = 0;
        while (i < children.getLength()) {
            try {
                IRectangleBeanProxy cBounds = BeanAwtUtilities.invoke_getBounds(children.get(i));
                if (cBounds.getWidth() != -1 && cBounds.getHeight() != -1) {
                    Rectangle lBounds = new Rectangle(cBounds.getX(), cBounds.getY(), cBounds.getWidth(), cBounds.getHeight());
                    rects.add(lBounds);
                }
            }
            catch (ThrowableProxy exc) {
                JavaVEPlugin.log((Throwable)exc, (Level)Level.WARNING);
            }
            ++i;
        }
        if (requestedWidth < boundingRect.getWidth()) {
            Rectangle tryRect;
            int highestBottom = 0;
            block3: while (true) {
                boolean intersects;
                int x = 0;
                int y = highestBottom;
                highestBottom = Integer.MAX_VALUE;
                do {
                    if (x + requestedWidth >= boundingRect.getWidth()) continue block3;
                    intersects = false;
                    tryRect = new Rectangle(x, y, requestedWidth, requestedHeight);
                    int i2 = 0;
                    while (i2 < rects.size()) {
                        Rectangle rect = (Rectangle)rects.get(i2);
                        if (rect.intersects(tryRect)) {
                            intersects = true;
                            x = Math.max(x, rect.x + rect.width);
                            highestBottom = Math.min(highestBottom, rect.y + rect.height);
                        }
                        ++i2;
                    }
                } while (intersects);
                break;
            }
            Point position = new Point(tryRect.x + marginWidth, tryRect.y + marginHeight);
            return position;
        }
        int y = 0;
        block6: while (true) {
            boolean intersects = false;
            Rectangle tryRect = new Rectangle(0, y, requestedWidth, requestedHeight);
            int i3 = 0;
            while (true) {
                if (i3 >= rects.size()) continue block6;
                Rectangle rect = (Rectangle)rects.get(i3);
                if (rect.intersects(tryRect)) {
                    intersects = true;
                    y = Math.max(y, rect.y + rect.height);
                }
                if (!intersects) {
                    Point position = new Point(tryRect.x + marginWidth, tryRect.y + marginHeight);
                    return position;
                }
                ++i3;
            }
            break;
        }
    }

    protected Dimension getPreferredSize(int width, int height) {
        IBeanProxy childProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.target, (boolean)true);
        if (childProxy != null) {
            IDimensionBeanProxy preferredSize = BeanAwtUtilities.invoke_getPreferredSize(childProxy);
            if (width == -1) {
                width = Math.max(preferredSize.getWidth(), 10);
            }
            if (height == -1) {
                height = Math.max(preferredSize.getHeight(), 10);
            }
        }
        return new Dimension(width, height);
    }

    protected Rectangle getPreferredBounds(Rectangle constraint) {
        Rectangle newConstraint = new Rectangle(constraint);
        IBeanProxy childProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)this.target, (boolean)true);
        if (childProxy != null) {
            if (newConstraint.width == -1 || newConstraint.height == -1) {
                IDimensionBeanProxy preferredSize = BeanAwtUtilities.invoke_getPreferredSize(childProxy);
                if (newConstraint.width == -1) {
                    newConstraint.width = Math.max(preferredSize.getWidth(), 10);
                }
                if (newConstraint.height == -1) {
                    newConstraint.height = Math.max(preferredSize.getHeight(), 10);
                }
            }
            if (newConstraint.x == Integer.MIN_VALUE && newConstraint.y == Integer.MIN_VALUE) {
                IBeanProxy containerBeanProxy = BeanAwtUtilities.invoke_getParent(childProxy);
                Point position = ApplyNullLayoutConstraintCommand.findNextAvailablePosition(newConstraint, containerBeanProxy, 5, 5);
                newConstraint.x = position.x;
                newConstraint.y = position.y;
            }
        }
        return newConstraint;
    }
}

