/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.ICallback;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.core.IMethodProxy;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.IProxyMethod;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.ForExpression;
import org.eclipse.jem.internal.proxy.initParser.tree.NoExpressionValueException;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ve.internal.cde.core.IImageListener;
import org.eclipse.ve.internal.cde.core.IVisualComponent;
import org.eclipse.ve.internal.cde.core.IVisualComponentListener;
import org.eclipse.ve.internal.cde.core.ImageNotifierSupport;
import org.eclipse.ve.internal.cde.core.ModelChangeController;
import org.eclipse.ve.internal.cde.core.VisualComponentSupport;
import org.eclipse.ve.internal.cde.core.VisualComponentsLayoutPolicy;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jfc.core.BeanAwtUtilities;
import org.eclipse.ve.internal.jfc.core.ComponentManagerFeedbackControllerNotifier;
import org.eclipse.ve.internal.jfc.core.ImageDataCollector;

public class ComponentManager
implements ComponentManagerFeedbackControllerNotifier,
IVisualComponent {
    protected VisualComponentSupport vcSupport = new VisualComponentSupport();
    protected IProxy fComponentManagerProxy;
    protected IProxy fComponentBeanProxy;
    private Point fLastSignalledLocation;
    private Dimension fLastSignalledSize;
    private Point locationOverride;
    private ImageNotifierSupport imSupport;
    private final Object imageAccessorSemaphore = new Object();
    private ImageDataCollector fImageDataCollector;
    private int fImageValid = 1;
    private static final int INVALID = 1;
    private static final int INVALID_COLLECTING = 2;
    private static final int VALID = 3;
    private ListenerList componentImageListeners;
    private List extensions;
    int movedCtr;

    public void addComponentExtension(ComponentManagerExtension componentExtension, IExpression expression) {
        if (this.extensions == null) {
            this.extensions = new ArrayList(1);
        }
        this.extensions.add(componentExtension);
        if (this.fComponentManagerProxy != null) {
            this.addExtensionProxy(componentExtension, expression);
        }
    }

    private void addExtensionProxy(ComponentManagerExtension extension, IExpression expression) {
        expression.createSimpleMethodInvoke(expression.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(expression, "org.eclipse.ve.internal.jfc.vm.ComponentManager").getMethodProxy(expression, "addExtension", new String[]{"org.eclipse.ve.internal.jfc.vm.ComponentManager$ComponentManagerExtension"}), this.fComponentManagerProxy, new IProxy[]{extension.getExtensionProxy(expression)}, false);
    }

    private void removeExtensionProxy(ComponentManagerExtension extension, IExpression expression) {
        expression.createSimpleMethodInvoke(expression.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(expression, "org.eclipse.ve.internal.jfc.vm.ComponentManager").getMethodProxy(expression, "removeExtension", new String[]{"org.eclipse.ve.internal.jfc.vm.ComponentManager$ComponentManagerExtension"}), this.fComponentManagerProxy, new IProxy[]{extension.getExtensionProxy(expression)}, false);
    }

    public void removeComponentExtension(ComponentManagerExtension componentExtension, IExpression expression) {
        if (this.extensions != null && this.extensions.remove(componentExtension)) {
            if (this.fComponentManagerProxy != null && this.fComponentManagerProxy.isBeanProxy() && ((IBeanProxy)this.fComponentManagerProxy).isValid()) {
                this.removeExtensionProxy(componentExtension, expression);
            }
            componentExtension.disposed(expression);
        }
    }

    public void addComponentListener(IVisualComponentListener aListener) {
        this.vcSupport.addComponentListener(aListener);
    }

    public void removeComponentListener(IVisualComponentListener aListener) {
        this.vcSupport.removeComponentListener(aListener);
    }

    protected IBeanProxy getComponentManagerBeanProxy() {
        return (IBeanProxy)this.fComponentManagerProxy;
    }

    protected IBeanProxy getComponentBeanProxy() {
        return (IBeanProxy)this.fComponentBeanProxy;
    }

    public boolean isDisposed() {
        return this.fComponentManagerProxy == null;
    }

    public FeedbackController getFeedbackController() {
        return BeanAwtUtilities.getFeedbackController(this.getRegistry());
    }

    public void setComponentBeanProxy(IProxy componentProxy, IExpression expression, ModelChangeController changeController) {
        final FeedbackController feedbackController = BeanAwtUtilities.getFeedbackController(expression);
        boolean hadComponentBeanProxy = this.fComponentBeanProxy != null;
        this.fComponentBeanProxy = null;
        if (componentProxy != null) {
            if (this.fComponentManagerProxy == null) {
                ExpressionProxy newManager = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
                this.fComponentManagerProxy = newManager;
                expression.createClassInstanceCreation(ForExpression.ASSIGNMENT_RIGHT, expression.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(expression, "org.eclipse.ve.internal.jfc.vm.ComponentManager"), 0);
                newManager.addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(){

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        ComponentManager.this.fComponentManagerProxy = event.getProxy();
                        feedbackController.registerFeedbackNotifier(ComponentManager.this, (IBeanProxy)ComponentManager.this.fComponentManagerProxy);
                    }

                    public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                        JavaVEPlugin.log((Object)"Component manager proxy not resolved on remote vm.", (Level)Level.INFO);
                        ComponentManager.this.fComponentManagerProxy = null;
                    }
                });
                if (this.extensions != null) {
                    int i = 0;
                    while (i < this.extensions.size()) {
                        this.addExtensionProxy((ComponentManagerExtension)this.extensions.get(i), expression);
                        ++i;
                    }
                }
            }
            expression.createSimpleMethodInvoke(BeanAwtUtilities.getSetComponentMethodProxy(expression), this.fComponentManagerProxy, new IProxy[]{componentProxy, feedbackController.getProxy()}, false);
            if (componentProxy.isExpressionProxy()) {
                ((ExpressionProxy)componentProxy).addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(){

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        ComponentManager.this.fComponentBeanProxy = event.getProxy();
                    }
                });
            } else {
                this.fComponentBeanProxy = (IBeanProxy)componentProxy;
            }
            if (this.locationOverride != null) {
                expression.createSimpleMethodInvoke(BeanAwtUtilities.getOverrideLocationMethodProxy(expression), this.fComponentManagerProxy, new IProxy[]{expression.getRegistry().getBeanProxyFactory().createBeanProxyWith(this.locationOverride.x), expression.getRegistry().getBeanProxyFactory().createBeanProxyWith(this.locationOverride.y)}, false);
            }
            feedbackController.queueInitialRefresh(changeController);
            feedbackController.queueInvalidate(this, changeController);
        } else if (hadComponentBeanProxy && this.fComponentManagerProxy != null) {
            IProxy[] iProxyArray = new IProxy[2];
            iProxyArray[1] = feedbackController.getProxy();
            expression.createSimpleMethodInvoke(BeanAwtUtilities.getSetComponentMethodProxy(expression), this.fComponentManagerProxy, iProxyArray, false);
        }
    }

    public void calledBack(int msgID, Object[] parms) {
        switch (msgID) {
            case 0: {
                this.componentHidden();
                break;
            }
            case 1: {
                this.componentShown();
                break;
            }
            case 2: {
                this.componentResized(((IIntegerBeanProxy)parms[0]).intValue(), ((IIntegerBeanProxy)parms[1]).intValue());
                break;
            }
            case 3: {
                this.componentMoved(((IIntegerBeanProxy)parms[0]).intValue(), ((IIntegerBeanProxy)parms[1]).intValue());
                break;
            }
            case 4: {
                this.fLastSignalledLocation = new Point(((IIntegerBeanProxy)parms[0]).intValue(), ((IIntegerBeanProxy)parms[1]).intValue());
                this.fLastSignalledSize = new Dimension(((IIntegerBeanProxy)parms[2]).intValue(), ((IIntegerBeanProxy)parms[3]).intValue());
                this.printmoved("refreshed");
                this.fireComponentRefresh();
                break;
            }
            case 6: {
                this.componentValidated();
                if (this.imSupport == null || !this.imSupport.hasImageListeners()) break;
                this.getImageCollector();
                this.invalidateImage();
                this.refreshImage();
            }
        }
    }

    private void printmoved(String type) {
        if (VisualComponentsLayoutPolicy.DO_VC_TRACING) {
            ++this.movedCtr;
            if (this.fComponentBeanProxy.isBeanProxy()) {
                System.out.println("Component " + ((IBeanProxy)this.fComponentBeanProxy).getTypeProxy().getTypeName() + "(" + this.hashCode() + ") cntr:" + this.movedCtr + ' ' + type + " to:(" + this.fLastSignalledLocation + ' ' + this.fLastSignalledSize + ')');
            } else {
                System.out.println("Component (" + this.hashCode() + ") cntr:" + this.movedCtr + ' ' + type + " to:(" + this.fLastSignalledLocation + ' ' + this.fLastSignalledSize + ')');
            }
        }
    }

    protected void componentResized(int width, int height) {
        this.fLastSignalledSize = new Dimension(width, height);
        this.printmoved("resized");
        this.vcSupport.fireComponentResized(width, height);
    }

    protected void componentMoved(int x, int y) {
        this.fLastSignalledLocation = new Point(x, y);
        this.printmoved("moved");
        this.vcSupport.fireComponentMoved(x, y);
    }

    protected void componentValidated() {
        this.vcSupport.fireComponentValidated();
    }

    protected void componentHidden() {
        this.vcSupport.fireComponentHidden();
    }

    protected void componentShown() {
        this.vcSupport.fireComponentShown();
    }

    protected void fireComponentRefresh() {
        this.vcSupport.fireComponentRefreshed();
    }

    public void dispose(IExpression expression) {
        if (this.fImageDataCollector != null) {
            this.fImageDataCollector.release();
            this.fImageDataCollector = null;
        }
        if (this.fComponentManagerProxy != null) {
            if (expression != null && this.fComponentManagerProxy.isBeanProxy() && ((IBeanProxy)this.fComponentManagerProxy).isValid()) {
                FeedbackController feedback = BeanAwtUtilities.getFeedbackController(expression);
                feedback.deregisterFeedbackNotifier((IBeanProxy)this.fComponentManagerProxy);
                if (this.getComponentManagerBeanProxy().isValid()) {
                    IProxy[] iProxyArray = new IProxy[2];
                    iProxyArray[1] = feedback.getProxy();
                    expression.createSimpleMethodInvoke(BeanAwtUtilities.getSetComponentMethodProxy(expression), this.fComponentManagerProxy, iProxyArray, false);
                    this.getComponentManagerBeanProxy().getProxyFactoryRegistry().releaseProxy(this.getComponentManagerBeanProxy());
                }
            }
            if (this.extensions != null) {
                int i = 0;
                while (i < this.extensions.size()) {
                    ((ComponentManagerExtension)this.extensions.get(i)).disposed(expression);
                    ++i;
                }
            }
            this.locationOverride = null;
            this.fComponentManagerProxy = null;
            this.fComponentBeanProxy = null;
            this.fLastSignalledLocation = null;
            this.fLastSignalledSize = null;
        }
    }

    protected boolean isComponentManagerProxyValid() {
        if (this.fComponentManagerProxy == null) {
            return false;
        }
        if (this.fComponentManagerProxy.isExpressionProxy()) {
            return true;
        }
        if (((IBeanProxy)this.fComponentManagerProxy).isValid()) {
            return true;
        }
        this.dispose(null);
        return false;
    }

    public Rectangle getBounds() {
        if (this.fLastSignalledLocation != null && this.fLastSignalledSize != null) {
            if (VisualComponentsLayoutPolicy.DO_VC_TRACING) {
                System.out.println("Requested bounds (" + this.hashCode() + ") cntr:" + this.movedCtr + " bounds: " + this.fLastSignalledLocation + ' ' + this.fLastSignalledSize);
            }
            return new Rectangle(this.fLastSignalledLocation.x, this.fLastSignalledLocation.y, this.fLastSignalledSize.width, this.fLastSignalledSize.height);
        }
        return new Rectangle();
    }

    public Point getLocation() {
        if (this.fLastSignalledLocation != null) {
            return this.fLastSignalledLocation;
        }
        return new Point();
    }

    public Dimension getSize() {
        if (this.fLastSignalledSize != null) {
            return this.fLastSignalledSize;
        }
        return new Dimension();
    }

    public IProxy applyBounds(IProxy bounds, boolean wantOldValue, IExpression expression, ModelChangeController controller) {
        ExpressionProxy oldValue;
        FeedbackController feedback = BeanAwtUtilities.getFeedbackController(expression);
        feedback.startChanges(controller, expression);
        if (!wantOldValue) {
            oldValue = null;
        } else {
            oldValue = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            expression.createClassInstanceCreation(ForExpression.ASSIGNMENT_RIGHT, expression.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(expression, "java.awt.Rectangle"), 0);
        }
        expression.createSimpleMethodInvoke(BeanAwtUtilities.getApplyBoundsMethodProxy(expression), this.fComponentManagerProxy, new IProxy[]{bounds, oldValue}, false);
        return oldValue;
    }

    public IProxy applyLocation(IProxy location, boolean wantOldValue, IExpression expression, ModelChangeController controller) {
        ExpressionProxy oldValue;
        FeedbackController feedback = BeanAwtUtilities.getFeedbackController(expression);
        feedback.startChanges(controller, expression);
        if (!wantOldValue) {
            oldValue = null;
        } else {
            oldValue = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            expression.createClassInstanceCreation(ForExpression.ASSIGNMENT_RIGHT, expression.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(expression, "java.awt.Point"), 0);
        }
        expression.createSimpleMethodInvoke(BeanAwtUtilities.getApplyLocationMethodProxy(expression), this.fComponentManagerProxy, new IProxy[]{location, oldValue}, false);
        return oldValue;
    }

    public void overrideLocation(Point point, IExpression expression) {
        if (this.isComponentManagerProxyValid() && this.fComponentManagerProxy.isBeanProxy()) {
            ProxyFactoryRegistry registry = this.getComponentManagerBeanProxy().getProxyFactoryRegistry();
            expression.createSimpleMethodInvoke(BeanAwtUtilities.getOverrideLocationMethodProxy(expression), (IProxy)this.getComponentManagerBeanProxy(), new IProxy[]{registry.getBeanProxyFactory().createBeanProxyWith(point.x), registry.getBeanProxyFactory().createBeanProxyWith(point.y)}, false);
        }
        this.locationOverride = point;
    }

    public IBeanProxy getDefaultLocation() {
        if (this.isComponentManagerProxyValid()) {
            ProxyFactoryRegistry registry = this.getComponentManagerBeanProxy().getProxyFactoryRegistry();
            return BeanAwtUtilities.getDefaultLocationMethodProxy(registry).invokeCatchThrowableExceptions(this.getComponentManagerBeanProxy());
        }
        return null;
    }

    public IBeanProxy getDefaultBounds() {
        if (this.isComponentManagerProxyValid() && this.fComponentManagerProxy.isBeanProxy()) {
            ProxyFactoryRegistry registry = this.getComponentManagerBeanProxy().getProxyFactoryRegistry();
            return BeanAwtUtilities.getDefaultBoundsMethodProxy(registry).invokeCatchThrowableExceptions(this.getComponentManagerBeanProxy());
        }
        return null;
    }

    protected IProxy getComponentManagerProxy() {
        return this.fComponentManagerProxy;
    }

    public void invalidate(ModelChangeController controller) {
        if (!this.isDisposed()) {
            this.getFeedbackController().queueInvalidate(this, controller);
        }
    }

    private ProxyFactoryRegistry getRegistry() {
        return this.fComponentManagerProxy.isBeanProxy() ? ((IBeanProxy)this.fComponentManagerProxy).getProxyFactoryRegistry() : ((ExpressionProxy)this.fComponentManagerProxy).getExpression().getRegistry();
    }

    private void invalidate(IExpression expression) {
        if (this.isComponentManagerProxyValid()) {
            expression.createSimpleMethodInvoke(BeanAwtUtilities.getComponentInvalidate(expression), this.fComponentManagerProxy, null, false);
        }
    }

    public void addImageListener(IImageListener listener) {
        if (this.imSupport == null) {
            this.imSupport = new ImageNotifierSupport();
        }
        if (listener instanceof IComponentImageListener) {
            if (this.componentImageListeners == null) {
                this.componentImageListeners = new ListenerList(1);
            }
            this.componentImageListeners.add((Object)listener);
        }
        this.imSupport.addImageListener(listener);
        if (this.fComponentBeanProxy != null && this.fComponentBeanProxy.isBeanProxy()) {
            this.getImageCollector();
        }
    }

    public void removeImageListener(IImageListener listener) {
        if (this.imSupport != null) {
            this.imSupport.removeImageListener(listener);
        }
        if (listener instanceof IComponentImageListener && this.componentImageListeners != null) {
            this.componentImageListeners.remove((Object)listener);
        }
    }

    public boolean hasImageListeners() {
        if (this.imSupport != null) {
            return this.imSupport.hasImageListeners();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateImage() {
        Object object = this.imageAccessorSemaphore;
        synchronized (object) {
            if (this.fImageDataCollector != null) {
                if (this.fImageValid == 2 && this.fImageDataCollector.isCollectingData()) {
                    this.fImageDataCollector.abort();
                }
                this.fImageValid = 1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageDataCollector getImageCollector() {
        if (this.fImageDataCollector == null) {
            Object object = this.imageAccessorSemaphore;
            synchronized (object) {
                if (this.fImageDataCollector == null) {
                    this.fImageDataCollector = new ImageDataCollector(this.getRegistry());
                }
            }
        }
        return this.fImageDataCollector;
    }

    private void fireImageStatus(int status) {
        Object[] listeners = this.componentImageListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IComponentImageListener)listeners[i]).imageStatus(status);
            ++i;
        }
    }

    private void fireImageException(ThrowableProxy exception) {
        Object[] listeners = this.componentImageListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IComponentImageListener)listeners[i]).imageException(exception);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshImage() {
        if (this.imSupport != null && this.imSupport.hasImageListeners() && this.fComponentBeanProxy != null && this.fComponentBeanProxy.isBeanProxy() && ((IBeanProxy)this.fComponentBeanProxy).isValid()) {
            boolean doRefresh = false;
            Object object = this.imageAccessorSemaphore;
            synchronized (object) {
                boolean bl = doRefresh = this.fImageValid == 1 && this.fImageDataCollector != null;
                if (doRefresh) {
                    this.fImageValid = 2;
                }
            }
            if (doRefresh) {
                try {
                    this.getImageCollector().waitForCompletion();
                    object = this.imageAccessorSemaphore;
                    synchronized (object) {
                        this.getImageCollector().startComponent(this.getComponentBeanProxy(), new ImageDataCollector.DataCollectedRunnable(){
                            private int startedStatus = -1;

                            public void imageStarted(int startStatus) {
                                this.startedStatus = startStatus;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void imageData(ImageData data) {
                                Object object = ComponentManager.this.imageAccessorSemaphore;
                                synchronized (object) {
                                    ComponentManager.this.fImageValid = 3;
                                }
                                if (this.startedStatus == -4) {
                                    ComponentManager.this.fireImageStatus(this.startedStatus);
                                } else if (data == null) {
                                    ComponentManager.this.fireImageStatus(-2);
                                } else {
                                    ComponentManager.this.fireImageStatus(-3);
                                }
                                ComponentManager.this.imSupport.fireImageChanged(data);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void imageNotCollected(int status) {
                                Object object = ComponentManager.this.imageAccessorSemaphore;
                                synchronized (object) {
                                    ComponentManager.this.fImageValid = 1;
                                }
                                ComponentManager.this.fireImageStatus(status);
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void imageException(ThrowableProxy exception) {
                                Object object = ComponentManager.this.imageAccessorSemaphore;
                                synchronized (object) {
                                    ComponentManager.this.fImageValid = 1;
                                }
                                ComponentManager.this.fireImageException(exception);
                            }
                        });
                    }
                }
                catch (ThrowableProxy e) {
                    Object object2 = this.imageAccessorSemaphore;
                    synchronized (object2) {
                        this.fImageValid = 1;
                    }
                    JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                    this.fireImageException(e);
                }
            }
        }
    }

    public Point getAbsoluteLocation() {
        return this.getLocation();
    }

    static /* synthetic */ void access$0(ComponentManager componentManager, IExpression iExpression) {
        componentManager.invalidate(iExpression);
    }

    public static interface IComponentImageListener
    extends IImageListener {
        public void imageStatus(int var1);

        public void imageException(ThrowableProxy var1);
    }

    public static abstract class ComponentManagerExtension {
        protected IProxy getExtensionProxy(IExpression expression) {
            String extensionClassname;
            IProxy managerExtensionProxy = this.primGetExtensionProxy();
            if ((managerExtensionProxy == null || managerExtensionProxy.isBeanProxy() && !((IBeanProxy)managerExtensionProxy).isValid()) && (extensionClassname = this.getExtensionClassname()) != null) {
                managerExtensionProxy = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
                this.primSetExtensionProxy(managerExtensionProxy);
                expression.createClassInstanceCreation(ForExpression.ASSIGNMENT_RIGHT, expression.getRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(expression, extensionClassname), 0);
                ((ExpressionProxy)managerExtensionProxy).addProxyListener(new ExpressionProxy.ProxyListener(this){
                    final /* synthetic */ ComponentManagerExtension this$1;
                    {
                        this.this$1 = componentManagerExtension;
                    }

                    public void proxyVoid(ExpressionProxy.ProxyEvent event) {
                        this.this$1.primSetExtensionProxy(null);
                    }

                    public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                        this.this$1.primSetExtensionProxy(null);
                    }

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        this.this$1.primSetExtensionProxy((IProxy)event.getProxy());
                    }
                });
            }
            return managerExtensionProxy;
        }

        protected String getExtensionClassname() {
            return null;
        }

        protected IProxy primGetExtensionProxy() {
            return null;
        }

        protected void primSetExtensionProxy(IProxy proxy) {
        }

        protected void disposed(IExpression expression) {
            this.primSetExtensionProxy(null);
        }
    }

    protected static class FeedbackController
    implements ICallback {
        private Map managerProxyToNotifier = new HashMap();
        private IProxy feedbackControllerProxy;
        private IMethodProxy postInitialRefresh;
        private IMethodProxy postInvalidImages;
        private IProxyMethod startingChanges;
        private IMethodProxy postChangesDone;
        private boolean changesHeld;
        private Set pendingInvalidates = new HashSet();
        private Runnable changesDoneRunnable = new Runnable(this){
            final /* synthetic */ FeedbackController this$1;
            {
                this.this$1 = feedbackController;
            }

            public void run() {
                FeedbackController.access$0(this.this$1, false);
                if (FeedbackController.access$1(this.this$1) != null) {
                    if (FeedbackController.access$1(this.this$1).isBeanProxy()) {
                        if (FeedbackController.access$2(this.this$1) != null) {
                            FeedbackController.access$2(this.this$1).invokeCatchThrowableExceptions((IBeanProxy)FeedbackController.access$1(this.this$1));
                        } else {
                            JavaVEPlugin.log((Object)"jfc.FeedbackComponentManager didn't resolve postChanges method!", (Level)Level.WARNING);
                        }
                    } else {
                        JavaVEPlugin.log((Object)"jfc.FeedbackComponentManager didn't resolve itself!", (Level)Level.WARNING);
                    }
                }
            }
        };
        private Runnable initialRefreshRunnable = new Runnable(this){
            final /* synthetic */ FeedbackController this$1;
            {
                this.this$1 = feedbackController;
            }

            public void run() {
                if (FeedbackController.access$1(this.this$1) != null) {
                    if (FeedbackController.access$1(this.this$1).isBeanProxy()) {
                        if (FeedbackController.access$3(this.this$1) != null) {
                            FeedbackController.access$3(this.this$1).invokeCatchThrowableExceptions((IBeanProxy)FeedbackController.access$1(this.this$1));
                        } else {
                            JavaVEPlugin.log((Object)"jfc.FeedbackComponentManager didn't resolve postInitialRefresh method!", (Level)Level.WARNING);
                        }
                    } else {
                        JavaVEPlugin.log((Object)"jfc.FeedbackComponentManager didn't resolve itself!", (Level)Level.WARNING);
                    }
                }
            }
        };
        private Runnable invalidateRunnable = new Runnable(this){
            final /* synthetic */ FeedbackController this$1;
            {
                this.this$1 = feedbackController;
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                if (FeedbackController.access$1(this.this$1) != null && ((IBeanProxy)FeedbackController.access$1(this.this$1)).isValid()) {
                    IExpression exp = ((IBeanProxy)FeedbackController.access$1(this.this$1)).getProxyFactoryRegistry().getBeanProxyFactory().createExpression();
                    try {
                        try {
                            Iterator<E> itr = FeedbackController.access$4(this.this$1).iterator();
                            while (true) {
                                if (!itr.hasNext()) {
                                    FeedbackController.access$4(this.this$1).clear();
                                    exp.createSimpleMethodInvoke((IProxyMethod)FeedbackController.access$5(this.this$1), FeedbackController.access$1(this.this$1), null, false);
                                    exp.invokeExpression();
                                }
                                ComponentManager manager = (ComponentManager)itr.next();
                                ComponentManager.access$0(manager, exp);
                            }
                        }
                        catch (IllegalStateException e) {
                            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                        }
                        catch (ThrowableProxy e) {
                            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                        }
                        catch (NoExpressionValueException e) {
                            JavaVEPlugin.log((Throwable)e, (Level)Level.WARNING);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        exp.close();
                        throw throwable;
                    }
                    {
                        Object var4_9 = null;
                        exp.close();
                        return;
                    }
                }
                FeedbackController.access$4(this.this$1).clear();
            }
        };

        public FeedbackController(ExpressionProxy feedbackControllerProxy) {
            IProxyMethod postChangesDone;
            this.feedbackControllerProxy = feedbackControllerProxy;
            feedbackControllerProxy.addProxyListener(new ExpressionProxy.ProxyListener(this){
                final /* synthetic */ FeedbackController this$1;
                {
                    this.this$1 = feedbackController;
                }

                public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                    FeedbackController.access$6(this.this$1, (IProxy)event.getProxy());
                }

                public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                    FeedbackController.access$6(this.this$1, null);
                }

                public void proxyVoid(ExpressionProxy.ProxyEvent event) {
                    FeedbackController.access$6(this.this$1, null);
                }
            });
            IProxyMethod postInitial = feedbackControllerProxy.getExpression().getRegistry().getMethodProxyFactory().getMethodProxy((IExpression)feedbackControllerProxy.getExpression(), "org.eclipse.ve.internal.jfc.vm.ComponentManager$ComponentManagerFeedbackController", "postInitialRefresh", null);
            if (postInitial.isBeanProxy()) {
                this.postInitialRefresh = (IMethodProxy)postInitial;
            } else {
                ((ExpressionProxy)postInitial).addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(this){
                    final /* synthetic */ FeedbackController this$1;
                    {
                        this.this$1 = feedbackController;
                    }

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        FeedbackController.access$7(this.this$1, (IMethodProxy)event.getProxy());
                    }
                });
            }
            IProxyMethod postImages = feedbackControllerProxy.getExpression().getRegistry().getMethodProxyFactory().getMethodProxy((IExpression)feedbackControllerProxy.getExpression(), "org.eclipse.ve.internal.jfc.vm.ComponentManager$ComponentManagerFeedbackController", "postInvalidImages", null);
            if (postImages.isBeanProxy()) {
                this.postInvalidImages = (IMethodProxy)postImages;
            } else {
                ((ExpressionProxy)postImages).addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(this){
                    final /* synthetic */ FeedbackController this$1;
                    {
                        this.this$1 = feedbackController;
                    }

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        FeedbackController.access$8(this.this$1, (IMethodProxy)event.getProxy());
                    }
                });
            }
            this.startingChanges = feedbackControllerProxy.getExpression().getRegistry().getMethodProxyFactory().getMethodProxy((IExpression)feedbackControllerProxy.getExpression(), "org.eclipse.ve.internal.jfc.vm.ComponentManager$ComponentManagerFeedbackController", "startingChanges", null);
            if (this.startingChanges.isExpressionProxy()) {
                ((ExpressionProxy)this.startingChanges).addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(this){
                    final /* synthetic */ FeedbackController this$1;
                    {
                        this.this$1 = feedbackController;
                    }

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        FeedbackController.access$9(this.this$1, (IProxyMethod)event.getProxy());
                    }
                });
            }
            if ((postChangesDone = feedbackControllerProxy.getExpression().getRegistry().getMethodProxyFactory().getMethodProxy((IExpression)feedbackControllerProxy.getExpression(), "org.eclipse.ve.internal.jfc.vm.ComponentManager$ComponentManagerFeedbackController", "postChanges", null)).isBeanProxy()) {
                this.postChangesDone = (IMethodProxy)postChangesDone;
            } else {
                ((ExpressionProxy)postChangesDone).addProxyListener((ExpressionProxy.ProxyListener)new ExpressionProxy.ProxyAdapter(this){
                    final /* synthetic */ FeedbackController this$1;
                    {
                        this.this$1 = feedbackController;
                    }

                    public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                        FeedbackController.access$10(this.this$1, (IMethodProxy)event.getProxy());
                    }
                });
            }
        }

        void startChanges(ModelChangeController controller, IExpression expression) {
            if (!this.changesHeld) {
                this.changesHeld = true;
                expression.createSimpleMethodInvoke(this.startingChanges, this.feedbackControllerProxy, null, false);
                controller.execAtEndOfTransaction(this.changesDoneRunnable, (Object)this.changesDoneRunnable);
            }
        }

        void queueInitialRefresh(ModelChangeController controller) {
            controller.execAtEndOfTransaction(this.initialRefreshRunnable, (Object)this.initialRefreshRunnable);
        }

        public IProxy getProxy() {
            return this.feedbackControllerProxy;
        }

        public void registerFeedbackNotifier(ComponentManagerFeedbackControllerNotifier notifier, IBeanProxy notifierProxy) {
            this.managerProxyToNotifier.put(notifierProxy, notifier);
        }

        public void deregisterFeedbackNotifier(IBeanProxy notifierProxy) {
            this.managerProxyToNotifier.remove(notifierProxy);
        }

        void queueInvalidate(ComponentManager manager, ModelChangeController controller) {
            this.pendingInvalidates.add(manager);
            controller.execAtEndOfTransaction(this.invalidateRunnable, (Object)this.invalidateRunnable);
        }

        public Object calledBack(int msgID, IBeanProxy parm) {
            throw new RuntimeException("A component listener has been called back incorrectly");
        }

        public Object calledBack(int msgID, Object[] parms) {
            if (msgID == 5) {
                if (VisualComponentsLayoutPolicy.DO_VC_TRACING) {
                    System.out.println("Start feedback transaction. #trans=" + parms.length / 3);
                }
                int i = 0;
                while (i < parms.length) {
                    ComponentManagerFeedbackControllerNotifier notifier;
                    if ((notifier = (ComponentManagerFeedbackControllerNotifier)this.managerProxyToNotifier.get(parms[i++])) != null) {
                        notifier.calledBack(((IIntegerBeanProxy)parms[i++]).intValue(), (Object[])parms[i++]);
                        continue;
                    }
                    i += 2;
                }
                if (VisualComponentsLayoutPolicy.DO_VC_TRACING) {
                    System.out.println("Stop feedback transaction.");
                }
            }
            return null;
        }

        public Object calledBack(int msgID, Object parm) {
            throw new RuntimeException("A component listener has been called back incorrectly");
        }

        public void calledBackStream(int msgID, InputStream is) {
            throw new RuntimeException("A component listener has been called back incorrectly");
        }

        static /* synthetic */ void access$0(FeedbackController feedbackController, boolean bl) {
            feedbackController.changesHeld = bl;
        }

        static /* synthetic */ IProxy access$1(FeedbackController feedbackController) {
            return feedbackController.feedbackControllerProxy;
        }

        static /* synthetic */ IMethodProxy access$2(FeedbackController feedbackController) {
            return feedbackController.postChangesDone;
        }

        static /* synthetic */ IMethodProxy access$3(FeedbackController feedbackController) {
            return feedbackController.postInitialRefresh;
        }

        static /* synthetic */ Set access$4(FeedbackController feedbackController) {
            return feedbackController.pendingInvalidates;
        }

        static /* synthetic */ IMethodProxy access$5(FeedbackController feedbackController) {
            return feedbackController.postInvalidImages;
        }

        static /* synthetic */ void access$6(FeedbackController feedbackController, IProxy iProxy) {
            feedbackController.feedbackControllerProxy = iProxy;
        }

        static /* synthetic */ void access$7(FeedbackController feedbackController, IMethodProxy iMethodProxy) {
            feedbackController.postInitialRefresh = iMethodProxy;
        }

        static /* synthetic */ void access$8(FeedbackController feedbackController, IMethodProxy iMethodProxy) {
            feedbackController.postInvalidImages = iMethodProxy;
        }

        static /* synthetic */ void access$9(FeedbackController feedbackController, IProxyMethod iProxyMethod) {
            feedbackController.startingChanges = iProxyMethod;
        }

        static /* synthetic */ void access$10(FeedbackController feedbackController, IMethodProxy iMethodProxy) {
            feedbackController.postChangesDone = iMethodProxy;
        }
    }
}

