/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class GridBagLayoutFeedBack
extends Figure {
    public static final String copyright = "(c) Copyright IBM Corporation 2002.";
    Point layoutOrigin = new Point(0, 0);
    int[] columnWidths = null;
    int[] rowHeights = null;

    protected void paintFigure(Graphics g) {
        g.setBackgroundColor(ColorConstants.red);
        g.setLineStyle(3);
        this.drawColumnDividers(g);
        this.drawRowDividers(g);
    }

    protected void drawColumnDividers(Graphics g) {
        if (this.rowHeights == null || this.columnWidths == null || this.layoutOrigin == null) {
            return;
        }
        Rectangle r = this.getBounds();
        int containerHeight = 0;
        int i = 0;
        while (i < this.rowHeights.length) {
            containerHeight += this.rowHeights[i];
            ++i;
        }
        int xPos = r.x + this.layoutOrigin.x;
        int yMin = r.y + this.layoutOrigin.y;
        int yMax = r.y + this.layoutOrigin.y + containerHeight;
        g.drawLine(new Point(xPos, yMin), new Point(xPos, yMax));
        int i2 = 0;
        while (i2 < this.columnWidths.length) {
            if ((xPos += this.columnWidths[i2]) >= r.x + r.width) {
                xPos = r.x + r.width - 1;
            }
            Point startPoint = new Point(xPos, yMin);
            Point endPoint = new Point(xPos, yMax);
            g.drawLine(startPoint, endPoint);
            ++i2;
        }
    }

    protected void drawRowDividers(Graphics g) {
        if (this.rowHeights == null || this.columnWidths == null || this.layoutOrigin == null) {
            return;
        }
        Rectangle r = this.getBounds();
        int containerWidth = 0;
        int i = 0;
        while (i < this.columnWidths.length) {
            containerWidth += this.columnWidths[i];
            ++i;
        }
        int yPos = r.y + this.layoutOrigin.y;
        int xMin = r.x + this.layoutOrigin.x;
        int xMax = r.x + this.layoutOrigin.x + containerWidth;
        g.drawLine(new Point(xMin, yPos), new Point(xMax, yPos));
        int i2 = 0;
        while (i2 < this.rowHeights.length) {
            if ((yPos += this.rowHeights[i2]) >= r.y + r.height) {
                yPos = r.y + r.height - 1;
            }
            Point startPoint = new Point(xMin, yPos);
            Point endPoint = new Point(xMax, yPos);
            g.drawLine(startPoint, endPoint);
            ++i2;
        }
    }

    public void setLayoutDimensions(int[][] dim) {
        if (dim == null) {
            return;
        }
        this.columnWidths = dim[0];
        this.rowHeights = dim[1];
    }

    public void setLayoutOrigin(Point p) {
        this.layoutOrigin = p;
    }
}

