/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.jfc.core.JTabbedPaneContainerPolicy;

public class JTabbedPaneLayoutEditPolicy
extends LayoutEditPolicy {
    protected JTabbedPaneContainerPolicy containerPolicy;
    protected Figure tabbedLayoutFeedback;

    public JTabbedPaneLayoutEditPolicy(EditDomain anEditDomain) {
        this.containerPolicy = new JTabbedPaneContainerPolicy(anEditDomain);
    }

    public void activate() {
        super.activate();
        this.containerPolicy.setContainer(this.getHost().getModel());
    }

    public void deactivate() {
        super.deactivate();
        this.containerPolicy.setContainer(null);
    }

    public EditPolicy createChildEditPolicy(EditPart aChild) {
        return new NonResizableEditPolicy();
    }

    protected Command getAddCommand(Request request) {
        Command addContributionCmd = this.containerPolicy.getCommand(request);
        if (addContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return addContributionCmd;
    }

    protected Command getCreateCommand(CreateRequest request) {
        Command createContributionCmd = this.containerPolicy.getCommand((Request)request);
        if (createContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return createContributionCmd;
    }

    protected Command getDeleteDependantCommand(Request request) {
        Command deleteContributionCmd = this.containerPolicy.getCommand(request);
        if (deleteContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return deleteContributionCmd;
    }

    protected Command getMoveChildrenCommand(Request request) {
        return null;
    }

    protected Command getOrphanChildrenCommand(Request request) {
        Command orphanContributionCmd = this.containerPolicy.getCommand(request);
        if (orphanContributionCmd == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return orphanContributionCmd;
    }

    protected void showLayoutTargetFeedback(Request request) {
        if (this.tabbedLayoutFeedback == null) {
            this.tabbedLayoutFeedback = new JTabbedPaneLayoutFeedback();
            IFigure f = ((GraphicalEditPart)this.getHost()).getFigure();
            this.tabbedLayoutFeedback.setBounds(f.getBounds());
            this.addFeedback((IFigure)this.tabbedLayoutFeedback);
        }
    }

    protected void eraseLayoutTargetFeedback(Request request) {
        if (this.tabbedLayoutFeedback != null) {
            this.removeFeedback((IFigure)this.tabbedLayoutFeedback);
            this.tabbedLayoutFeedback = null;
        }
    }

    protected static class JTabbedPaneLayoutFeedback
    extends RectangleFigure {
        public JTabbedPaneLayoutFeedback() {
            this.setOutline(false);
        }

        protected void fillShape(Graphics graphics) {
            Rectangle b = this.getBounds().getExpanded(-3, -3);
            int tabHeight = Math.min((int)Math.round((double)b.height * 0.3), 20);
            int tabWidth = Math.min((int)Math.round((double)b.width * 0.2) - 3, 20);
            int x_NewTab = b.x + 2 * tabWidth + 7;
            int x_EndNewTab = b.x + 3 * tabWidth + 7;
            int[] newTabShape = new int[]{b.x, b.y + b.height, b.x, b.y + tabHeight, x_NewTab, b.y + tabHeight, x_NewTab, b.y + tabHeight / 3, x_NewTab + tabWidth / 3, b.y, x_EndNewTab, b.y, x_EndNewTab, b.y + tabHeight, b.x + b.width, b.y + tabHeight, b.x + b.width, b.y + b.height};
            graphics.setXORMode(true);
            graphics.fillRectangle(b);
            graphics.setXORMode(false);
            graphics.setForegroundColor(ColorConstants.black);
            Color incomingBackground = graphics.getBackgroundColor();
            graphics.setBackgroundColor(ColorConstants.lightGray);
            graphics.fillPolygon(newTabShape);
            graphics.drawPolygon(newTabShape);
            graphics.setBackgroundColor(incomingBackground);
            Rectangle panelRect = new Rectangle(b.x, b.y + tabHeight, b.width, b.height - tabHeight).shrink(2, 2);
            graphics.fillRectangle(panelRect);
            graphics.drawRectangle(panelRect);
        }
    }
}

