/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.jfc.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ve.internal.cde.commands.CommandBuilder;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.XYLayoutUtility;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.java.visual.ILayoutPolicyHelper;
import org.eclipse.ve.internal.java.visual.VisualContainerPolicy;
import org.eclipse.ve.internal.jfc.core.ApplyNullLayoutConstraintCommand;
import org.eclipse.ve.internal.jfc.core.JFCConstants;
import org.eclipse.ve.internal.propertysheet.common.commands.CompoundCommand;

public class NullLayoutPolicyHelper
implements ILayoutPolicyHelper,
IActionFilter {
    protected VisualContainerPolicy policy;
    static /* synthetic */ Class class$0;

    public NullLayoutPolicyHelper(VisualContainerPolicy ep) {
        this.setContainerPolicy(ep);
    }

    public NullLayoutPolicyHelper() {
    }

    public void setContainerPolicy(VisualContainerPolicy policy) {
        this.policy = policy;
    }

    public Command getCreateChildCommand(Object childComponent, Object constraint, Object position) {
        EClass constraintComponentClass = (EClass)((EObject)this.policy.getContainer()).eResource().getResourceSet().getEObject(JFCConstants.CLASS_CONTAINER_CONSTRAINTCOMPONENT, true);
        EFactory visualFact = JFCConstants.getFactory(constraintComponentClass);
        EObject constraintComponent = visualFact.create(constraintComponentClass);
        constraintComponent.eSet(JavaInstantiation.getSFeature((IJavaObjectInstance)((IJavaObjectInstance)this.policy.getContainer()), (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT), null);
        Command createContributionCmd = this.policy.getCreateCommand((Object)constraintComponent, childComponent, position);
        if (createContributionCmd == null || !createContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand command = new CompoundCommand("");
        command.append(this.createChangeConstraintCommand((IJavaObjectInstance)childComponent, (NullConstraint)constraint));
        command.append(createContributionCmd);
        return command.unwrap();
    }

    public Command getAddChildrenCommand(List childrenComponents, List constraints, Object position) {
        EClass constraintComponentClass = (EClass)((EObject)this.policy.getContainer()).eResource().getResourceSet().getEObject(JFCConstants.CLASS_CONTAINER_CONSTRAINTCOMPONENT, true);
        EFactory visualFact = JFCConstants.getFactory(constraintComponentClass);
        ArrayList<EObject> componentConstraints = new ArrayList<EObject>(childrenComponents.size());
        int i = 0;
        while (i < childrenComponents.size()) {
            EObject constraintComponent = visualFact.create(constraintComponentClass);
            constraintComponent.eSet(JavaInstantiation.getSFeature((IJavaObjectInstance)((IJavaObjectInstance)this.policy.getContainer()), (URI)JFCConstants.SF_CONSTRAINT_CONSTRAINT), null);
            componentConstraints.add(constraintComponent);
            ++i;
        }
        Command addContributionCmd = this.policy.getAddCommand(componentConstraints, childrenComponents, position);
        if (addContributionCmd == null || !addContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand command = new CompoundCommand("");
        command.append(this.getChangeConstraintCommand(childrenComponents, constraints));
        command.append(addContributionCmd);
        return command.unwrap();
    }

    public Command getOrphanChildrenCommand(List children) {
        Command orphanContributionCmd = this.policy.getOrphanChildrenCommand(children);
        if (orphanContributionCmd == null || !orphanContributionCmd.canExecute()) {
            return UnexecutableCommand.INSTANCE;
        }
        RuledCommandBuilder cb = new RuledCommandBuilder(this.policy.getEditDomain());
        cb.append(orphanContributionCmd);
        this.cancelConstraints((CommandBuilder)cb, children);
        return cb.getCommand();
    }

    protected void cancelConstraints(CommandBuilder cb, List children) {
        IJavaObjectInstance parent = (IJavaObjectInstance)this.policy.getContainer();
        EStructuralFeature sfComponentLocation = JavaInstantiation.getSFeature((IJavaObjectInstance)parent, (URI)JFCConstants.SF_COMPONENT_LOCATION);
        EStructuralFeature sfComponentSize = JavaInstantiation.getSFeature((IJavaObjectInstance)parent, (URI)JFCConstants.SF_COMPONENT_SIZE);
        EStructuralFeature sfComponentBounds = JavaInstantiation.getSFeature((IJavaObjectInstance)parent, (URI)JFCConstants.SF_COMPONENT_BOUNDS);
        Iterator childrenItr = children.iterator();
        while (childrenItr.hasNext()) {
            EObject child = (EObject)childrenItr.next();
            if (child.eIsSet(sfComponentBounds)) {
                cb.cancelAttributeSetting(child, sfComponentBounds);
            }
            if (child.eIsSet(sfComponentSize)) {
                cb.cancelAttributeSetting(child, sfComponentSize);
            }
            if (!child.eIsSet(sfComponentLocation)) continue;
            cb.cancelAttributeSetting(child, sfComponentLocation);
        }
    }

    public List getDefaultConstraint(List children) {
        return Collections.nCopies(children.size(), new NullConstraint(XYLayoutUtility.modifyPreferredRectangle((Rectangle)new Rectangle(), (boolean)true, (boolean)true, (boolean)true), true, true));
    }

    public Command getChangeConstraintCommand(List children, List constraints) {
        Iterator childItr = children.iterator();
        Iterator conItr = constraints.iterator();
        CompoundCommand cmd = new CompoundCommand();
        while (childItr.hasNext()) {
            cmd.append(this.createChangeConstraintCommand((IJavaObjectInstance)childItr.next(), (NullConstraint)conItr.next()));
        }
        return !cmd.isEmpty() ? cmd.unwrap() : null;
    }

    protected Command createChangeConstraintCommand(IJavaObjectInstance child, NullConstraint constraint) {
        ApplyNullLayoutConstraintCommand cmd = new ApplyNullLayoutConstraintCommand();
        cmd.setTarget(child);
        cmd.setDomain(this.policy.getEditDomain());
        if (!constraint.moved && !constraint.resized) {
            return null;
        }
        cmd.setConstraint(constraint.rect, constraint.moved, constraint.resized);
        return cmd;
    }

    public Command getOrphanConstraintsCommand(List children) {
        RuledCommandBuilder cb = new RuledCommandBuilder(this.policy.getEditDomain());
        this.cancelConstraints((CommandBuilder)cb, children);
        return cb.getCommand();
    }

    public boolean testAttribute(Object target, String name, String value) {
        if (target instanceof EditPart) {
            EditPart ep;
            EditPartViewer viewer;
            EditDomain ed = EditDomain.getEditDomain((EditPart)((EditPart)target));
            IEditorPart iEditorPart = ed.getEditorPart();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gef.EditPartViewer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (EditPartViewer)iEditorPart.getAdapter((Class)clazz)) != null && (ep = (EditPart)viewer.getEditPartRegistry().get(((EditPart)target).getModel())) != null && ep.getEditPolicy((Object)"LayoutEditPolicy") instanceof IActionFilter) {
                return ((IActionFilter)ep.getEditPolicy((Object)"LayoutEditPolicy")).testAttribute(target, name, value);
            }
        }
        return false;
    }

    public static class NullConstraint {
        public Rectangle rect;
        public boolean moved;
        public boolean resized;

        public NullConstraint(Rectangle rect, boolean moved, boolean resized) {
            this.rect = rect;
            this.moved = moved;
            this.resized = resized;
        }
    }
}

