/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.choosebean;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoFilter;
import org.eclipse.jdt.internal.ui.dialogs.TypeInfoViewer;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ve.internal.java.choosebean.ChooseBeanDialogUtilities;
import org.eclipse.ve.internal.java.choosebean.IChooseBeanContributor;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class BeanViewer
extends TypeInfoViewer {
    private IPackageFragment pkg = null;
    private BeanTypeInfoFilter typeInfoFilter = null;
    private HashMap contributorFilterMap = null;
    private String currentText;
    private IChooseBeanContributor selectedContributor = null;
    private boolean showOnlyBeans = false;
    private ResourceSet resourceSet = null;
    private IJavaSearchScope scope = null;

    public BeanViewer(Composite parent, Label progressLabel, IJavaSearchScope scope, IPackageFragment pkg, ResourceSet resourceSet) {
        super(parent, 0, progressLabel, scope, 5, null);
        this.resourceSet = resourceSet;
        this.scope = scope;
        this.pkg = pkg;
    }

    private boolean isValidBean(TypeInfo type) {
        IStatus status = ChooseBeanDialogUtilities.getClassStatus(type, this.pkg.getElementName(), this.resourceSet, this.scope);
        return status.isOK();
    }

    protected TypeInfoViewer.TypeInfoLabelProvider createLabelProvider() {
        return new BeanLabelProvider();
    }

    protected TypeInfoFilter createTypeInfoFilter(String text) {
        this.typeInfoFilter = new BeanTypeInfoFilter(text, this.fSearchScope, this.fElementKind);
        this.typeInfoFilter.setCustomFilter(this.getCustomFilter(this.selectedContributor));
        return this.typeInfoFilter;
    }

    public void updateContributor(IChooseBeanContributor contributor) {
        this.selectedContributor = contributor;
        if (this.currentText != null) {
            this.setSearchPattern(this.currentText);
        }
    }

    private HashMap getContributorFilterMap() {
        if (this.contributorFilterMap == null) {
            this.contributorFilterMap = new HashMap();
        }
        return this.contributorFilterMap;
    }

    private IFilter getCustomFilter(final IChooseBeanContributor contributor) {
        IFilter customFilter = null;
        if (this.getContributorFilterMap().containsKey(contributor)) {
            customFilter = (IFilter)this.getContributorFilterMap().get(contributor);
        } else {
            final ArrayList filterList = new ArrayList();
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    filterList.add(contributor.getFilter(BeanViewer.this.pkg, monitor));
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().run(false, false, runnable);
                if (filterList.size() > 0) {
                    customFilter = (IFilter)filterList.get(0);
                }
            }
            catch (InvocationTargetException e) {
                JavaVEPlugin.log(e, Level.FINE);
                customFilter = null;
            }
            catch (InterruptedException interruptedException) {
                customFilter = null;
            }
            this.getContributorFilterMap().put(contributor, customFilter);
        }
        return customFilter;
    }

    public void setSearchPattern(String text) {
        this.currentText = text;
        super.setSearchPattern(text);
    }

    public void showOnlyBeans(boolean showOnlyBeans) {
        this.showOnlyBeans = showOnlyBeans;
    }

    public class BeanLabelProvider
    extends TypeInfoViewer.TypeInfoLabelProvider {
        private HashMap imageToDescriptorMap = new HashMap();

        public ImageDescriptor getImageDescriptor(Object element) {
            Image image = ChooseBeanDialogUtilities.getContributorImage(BeanViewer.this.selectedContributor);
            if (BeanViewer.this.showOnlyBeans && image == null) {
                image = JavaVEPlugin.getJavaBeanImage();
            }
            ImageDescriptor imageDescriptor = null;
            if (image == null) {
                imageDescriptor = super.getImageDescriptor(element);
            } else if (this.imageToDescriptorMap.containsKey(image)) {
                imageDescriptor = (ImageDescriptor)this.imageToDescriptorMap.get(image);
            } else {
                imageDescriptor = ImageDescriptor.createFromImage((Image)image);
                this.imageToDescriptorMap.put(image, imageDescriptor);
            }
            return imageDescriptor;
        }
    }

    public class BeanTypeInfoFilter
    extends TypeInfoFilter {
        private IFilter customFilter = null;

        public BeanTypeInfoFilter(String text, IJavaSearchScope scope, int elementKind) {
            super(text, scope, elementKind);
        }

        public void setCustomFilter(IFilter filter) {
            this.customFilter = filter;
        }

        public boolean matchesCachedResult(TypeInfo type) {
            return super.matchesCachedResult(type) && this.filter(type);
        }

        public boolean matchesHistoryElement(TypeInfo type) {
            return super.matchesHistoryElement(type) && this.filter(type);
        }

        public boolean matchesNameExact(TypeInfo type) {
            return super.matchesNameExact(type) && this.filter(type);
        }

        public boolean matchesSearchResult(TypeInfo type) {
            return super.matchesSearchResult(type) && this.filter(type);
        }

        protected boolean filter(TypeInfo type) {
            boolean valid = true;
            if (this.customFilter != null) {
                boolean bl = valid = valid && this.customFilter.select((Object)type);
            }
            if (valid && BeanViewer.this.showOnlyBeans) {
                valid = valid && BeanViewer.this.isValidBean(type);
            }
            return valid;
        }

        public boolean isSubFilter(String text) {
            return false;
        }
    }
}

