/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.choosebean;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameRequestor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.TypeInfo;
import org.eclipse.jdt.internal.corext.util.TypeInfoHistory;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaUIMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TypeInfoLabelProvider;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.cde.core.CDEUtilities;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.decorators.ClassDescriptorDecorator;
import org.eclipse.ve.internal.cde.emf.ClassDecoratorFeatureAccess;
import org.eclipse.ve.internal.java.choosebean.BeanViewer;
import org.eclipse.ve.internal.java.choosebean.ChooseBeanDialogUtilities;
import org.eclipse.ve.internal.java.choosebean.ChooseBeanMessages;
import org.eclipse.ve.internal.java.choosebean.IChooseBeanContributor;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.core.PrototypeFactory;
import org.eclipse.ve.internal.java.vce.VCEPreferences;

public class ChooseBeanDialog
extends SelectionStatusDialog
implements SelectionListener {
    private ResourceSet resourceSet;
    private IJavaProject project;
    private IPackageFragment pkg;
    private List unmodifieableContributors = null;
    private int selectedContributor = -1;
    private boolean disableOthers = false;
    private EditDomain editDomain = null;
    private IJavaSearchScope javaSearchScope = null;
    Button[] contributorStyleButtons = null;
    String beanName = null;
    Text beanNameText = null;
    BeanViewer bv = null;
    private static boolean fgFirstTime = true;
    protected String filterString = null;
    private CLabel pkgName;
    private TypeInfoLabelProvider pkgLabelProvider = new TypeInfoLabelProvider(40);
    static /* synthetic */ Class class$0;

    protected ChooseBeanDialog(Shell parent, boolean multi, IJavaSearchScope scope) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setTitle(ChooseBeanMessages.MainDialog_title);
        this.setMessage(ChooseBeanMessages.MainDialog_message);
        this.setStatusLineAboveButtons(true);
        this.javaSearchScope = scope;
    }

    public ChooseBeanDialog(Shell shell, EditDomain ed, IChooseBeanContributor[] contributors, int choice, boolean disableOthers) {
        this(shell, ((FileEditorInput)ed.getEditorPart().getEditorInput()).getFile(), JavaEditDomainHelper.getResourceSet((EditDomain)ed), contributors, choice, disableOthers);
        this.editDomain = ed;
    }

    protected ChooseBeanDialog(Shell shell, IFile file, ResourceSet resourceSet, IChooseBeanContributor[] contributors, int choice, boolean disableOthers) {
        this(shell, (IPackageFragment)JavaCore.create((IFile)file).getParent(), contributors, choice, disableOthers);
        this.resourceSet = resourceSet;
    }

    protected ChooseBeanDialog(Shell shell, IPackageFragment packageFragment, IChooseBeanContributor[] contributors, int choice, boolean disableOthers) {
        this(shell, false, SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{packageFragment.getJavaProject()}));
        this.selectedContributor = choice;
        this.pkg = packageFragment;
        this.project = packageFragment.getJavaProject();
        this.disableOthers = disableOthers;
        List<IChooseBeanContributor> list = this.unmodifieableContributors = contributors != null ? Arrays.asList(contributors) : Arrays.asList(ChooseBeanDialogUtilities.determineContributors(this.project));
        if (this.unmodifieableContributors == null || this.unmodifieableContributors.size() < 1) {
            this.selectedContributor = -1;
        } else if (!this.isValidContributor()) {
            this.selectedContributor = 0;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite top = (Composite)super.createDialogArea(parent);
        Composite area = new Composite(top, 0);
        area.setLayoutData((Object)new GridData(1808));
        area.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(area, 0);
        label.setText(JavaUIMessages.OpenTypeAction_dialogMessage);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Text filterText = new Text(area, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        filterText.setLayoutData((Object)gd);
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChooseBeanDialog.this.bv.setSearchPattern(((Text)e.getSource()).getText());
            }
        });
        filterText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    ChooseBeanDialog.this.bv.setFocus();
                }
            }
        });
        label = new Label(area, 0);
        label.setText(JavaUIMessages.TypeSelectionComponent_label);
        label.setLayoutData((Object)new GridData(768));
        Label progressLabel = new Label(area, 0);
        progressLabel.setLayoutData((Object)new GridData(768));
        progressLabel.setAlignment(131072);
        this.bv = new BeanViewer(area, progressLabel, this.javaSearchScope, this.pkg, this.resourceSet);
        gd = new GridData(1808);
        PixelConverter converter = new PixelConverter((Control)this.bv.getTable());
        gd.widthHint = converter.convertWidthInCharsToPixels(70);
        gd.heightHint = SWTUtil.getTableHeightHint((Table)this.bv.getTable(), (int)10);
        gd.horizontalSpan = 2;
        this.bv.getTable().setLayoutData((Object)gd);
        this.bv.getTable().addSelectionListener((SelectionListener)this);
        ViewForm pkgViewForm = new ViewForm(area, 0x800800);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        pkgViewForm.setLayoutData((Object)gd);
        this.pkgName = new CLabel((Composite)pkgViewForm, 0);
        pkgViewForm.setContent((Control)this.pkgName);
        if (this.unmodifieableContributors.size() > 0) {
            int numColumns = this.unmodifieableContributors.size() * 2 + 1;
            Composite stylesComposite = new Composite(area, 0);
            GridLayout stylesCompositeLayout = new GridLayout(numColumns, false);
            stylesComposite.setLayout((Layout)stylesCompositeLayout);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            stylesComposite.setLayoutData((Object)gd);
            Label sectionLabel = new Label(stylesComposite, 0);
            GridData sectionLabelData = new GridData(768);
            sectionLabelData.horizontalSpan = numColumns;
            sectionLabel.setLayoutData((Object)sectionLabelData);
            sectionLabel.setText(ChooseBeanMessages.ChooseBeanDialog_Section_Styles);
            Label spacer = new Label(stylesComposite, 0);
            spacer.setText("");
            this.contributorStyleButtons = new Button[this.unmodifieableContributors.size()];
            int i = 0;
            while (i < this.unmodifieableContributors.size()) {
                IChooseBeanContributor contrib = (IChooseBeanContributor)this.unmodifieableContributors.get(i);
                Label contribImage = new Label(stylesComposite, 0);
                Image image = ChooseBeanDialogUtilities.getContributorImage(contrib);
                if (image != null) {
                    contribImage.setImage(image);
                }
                this.contributorStyleButtons[i] = new Button(stylesComposite, 16);
                this.contributorStyleButtons[i].setText(contrib.getName());
                this.contributorStyleButtons[i].setLayoutData((Object)new GridData(768));
                this.contributorStyleButtons[i].setData("contributor", (Object)contrib);
                this.contributorStyleButtons[i].addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        Button b = (Button)e.getSource();
                        if (b.getSelection()) {
                            IChooseBeanContributor contrib = (IChooseBeanContributor)b.getData("contributor");
                            ChooseBeanDialog.this.selectContributor(contrib);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
                if (this.disableOthers && i != this.selectedContributor) {
                    this.contributorStyleButtons[i].setEnabled(false);
                }
                ++i;
            }
            if (this.contributorStyleButtons.length > 0) {
                if (this.selectedContributor > this.contributorStyleButtons.length - 1 || this.selectedContributor < 0) {
                    this.selectedContributor = 0;
                }
                this.contributorStyleButtons[this.selectedContributor].setSelection(true);
                this.selectContributor((IChooseBeanContributor)this.unmodifieableContributors.get(this.selectedContributor));
            }
            spacer = new Label(stylesComposite, 0);
            spacer.setLayoutData((Object)new GridData());
            spacer.setText("");
            Button showBeansButton = new Button(stylesComposite, 32);
            showBeansButton.setText(ChooseBeanMessages.ChooseBeanDialog_Checkbox_ShowValidClasses);
            gd = new GridData(768);
            gd.horizontalSpan = numColumns - 1;
            showBeansButton.setLayoutData((Object)gd);
            showBeansButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button b = (Button)e.getSource();
                    ChooseBeanDialog.this.bv.showOnlyBeans(b.getSelection());
                    if (ChooseBeanDialog.this.selectedContributor > -1) {
                        ChooseBeanDialog.this.bv.updateContributor((IChooseBeanContributor)ChooseBeanDialog.this.unmodifieableContributors.get(ChooseBeanDialog.this.selectedContributor));
                    }
                }
            });
        }
        if (!VCEPreferences.askForRename()) {
            Composite beanNameComposite = new Composite(area, 0);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            beanNameComposite.setLayoutData((Object)gd);
            beanNameComposite.setLayout((Layout)new GridLayout(2, false));
            Label image = new Label(beanNameComposite, 0);
            image.setImage(JavaPlugin.getDefault().getImageRegistry().get("org.eclipse.jdt.ui.field_public_obj.gif"));
            Label beanNameLabel = new Label(beanNameComposite, 0);
            beanNameLabel.setLayoutData((Object)new GridData(768));
            beanNameLabel.setText(ChooseBeanMessages.ChooseBeanDialog_Label_BeanName);
            Label spacer = new Label(beanNameComposite, 0);
            spacer.setText("");
            this.beanNameText = new Text(beanNameComposite, 2048);
            this.beanNameText.setLayoutData((Object)new GridData(768));
        }
        if (this.filterString != null) {
            filterText.setText(this.filterString);
        }
        ChooseBeanDialog.applyDialogFont((Control)top);
        return top;
    }

    protected void selectContributor(IChooseBeanContributor contrib) {
        this.selectedContributor = this.unmodifieableContributors.indexOf(contrib);
        if (this.unmodifieableContributors.contains(contrib)) {
            this.bv.updateContributor(contrib);
        }
    }

    public Object[] getResult() {
        Object[] results = super.getResult();
        if (this.resourceSet != null) {
            Object[] newResults = new Object[results.length * 2];
            int i = 0;
            while (i < results.length) {
                if (results[i] instanceof IType) {
                    IType type = (IType)results[i];
                    String realFQN = type.getFullyQualifiedName('$');
                    PrototypeFactory prototypeFactory = null;
                    JavaClass javaClass = Utilities.getJavaClass((String)realFQN, (ResourceSet)this.resourceSet);
                    try {
                        ClassDescriptorDecorator decorator;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.ve.internal.cde.decorators.ClassDescriptorDecorator");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((decorator = (ClassDescriptorDecorator)ClassDecoratorFeatureAccess.getDecoratorWithKeyedFeature((EClassifier)javaClass, (Class)clazz, (String)"org.eclipse.ve.internal.prototypefactory")) != null) {
                            String prototypeFactoryName = (String)decorator.getKeyedValues().get((Object)"org.eclipse.ve.internal.prototypefactory");
                            prototypeFactory = (PrototypeFactory)CDEPlugin.createInstance(null, (String)prototypeFactoryName);
                        }
                    }
                    catch (Exception e) {
                        JavaVEPlugin.getPlugin().getLogger().log(Level.WARNING, e);
                    }
                    EObject eObject = null;
                    eObject = prototypeFactory == null ? javaClass.getEPackage().getEFactoryInstance().create((EClass)javaClass) : prototypeFactory.createPrototype((EClass)javaClass);
                    if (this.beanName == null || this.beanName.trim().length() < 1) {
                        this.beanName = ((IJavaObjectInstance)eObject).getJavaType().getJavaName();
                        if (this.beanName.indexOf(46) > 0) {
                            this.beanName = this.beanName.substring(this.beanName.lastIndexOf(46) + 1);
                        }
                        this.beanName = CDEUtilities.lowCaseFirstCharacter((String)this.beanName);
                    }
                    ChooseBeanDialogUtilities.setBeanName(eObject, this.beanName, this.editDomain);
                    newResults[i * 2] = eObject;
                    newResults[i * 2 + 1] = javaClass;
                }
                ++i;
            }
            return newResults;
        }
        return results;
    }

    protected boolean isValidContributor() {
        return this.selectedContributor > -1 && this.selectedContributor < this.unmodifieableContributors.size();
    }

    protected void computeResult() {
        TypeInfo[] selected = this.bv.getSelection();
        if (selected == null || selected.length == 0) {
            this.setResult(null);
            return;
        }
        TypeInfoHistory history = TypeInfoHistory.getInstance();
        ArrayList<IType> result = new ArrayList<IType>(selected.length);
        if (result != null) {
            int i = 0;
            while (i < selected.length) {
                try {
                    TypeInfo typeInfo = selected[i];
                    history.accessed(typeInfo);
                    IType type = typeInfo.resolveType(this.javaSearchScope);
                    if (type == null) {
                        String title = JavaUIMessages.TypeSelectionDialog_errorTitle;
                        String message = Messages.format((String)JavaUIMessages.TypeSelectionDialog_dialogMessage, (Object)typeInfo.getPath());
                        MessageDialog.openError((Shell)this.getShell(), (String)title, (String)message);
                        this.setResult(null);
                    } else {
                        result.add(type);
                    }
                }
                catch (JavaModelException e) {
                    String title = JavaUIMessages.MultiTypeSelectionDialog_errorTitle;
                    String message = JavaUIMessages.MultiTypeSelectionDialog_errorMessage;
                    ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)message, (IStatus)e.getStatus());
                }
                ++i;
            }
        }
        this.setResult(result);
    }

    public int open() {
        try {
            this.ensureConsistency();
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle((InvocationTargetException)e, (String)JavaUIMessages.TypeSelectionDialog_error3Title, (String)JavaUIMessages.TypeSelectionDialog_error3Message);
            return 1;
        }
        catch (InterruptedException interruptedException) {
            return 1;
        }
        return super.open();
    }

    public boolean close() {
        TypeInfoHistory.getInstance().save();
        return super.close();
    }

    private void ensureConsistency() throws InvocationTargetException, InterruptedException {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                TypeInfoHistory history = TypeInfoHistory.getInstance();
                if (fgFirstTime || history.isEmpty()) {
                    monitor.beginTask(JavaUIMessages.TypeSelectionDialog_progress_consistency, 100);
                    this.refreshSearchIndices((IProgressMonitor)new SubProgressMonitor(monitor, 90));
                    history.checkConsistency((IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    monitor.done();
                    fgFirstTime = false;
                } else {
                    history.checkConsistency(monitor);
                }
            }

            private void refreshSearchIndices(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    new SearchEngine().searchAllTypeNames(null, "_______________".toCharArray(), 8, 7, SearchEngine.createWorkspaceScope(), new TypeNameRequestor(this){
                        final /* synthetic */ 5 this$1;
                        {
                            this.this$1 = var1_1;
                        }
                    }, 3, monitor);
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        IProgressService context = PlatformUI.getWorkbench().getProgressService();
        context.run(true, true, runnable);
    }

    public void setFilter(String string) {
        this.filterString = string;
    }

    private void updateStatus() {
        TypeInfo selected;
        TypeInfo[] typeSelection = this.bv.getSelection();
        TypeInfo typeInfo = selected = typeSelection == null || typeSelection.length < 1 ? null : typeSelection[0];
        if (selected == null) {
            this.pkgName.setImage(null);
            this.pkgName.setText("");
        } else {
            this.pkgName.setImage(this.pkgLabelProvider.getImage((Object)selected));
            this.pkgName.setText(this.pkgLabelProvider.getText((Object)selected));
        }
        this.updateStatus(ChooseBeanDialogUtilities.getClassStatus(selected, this.pkg.getElementName(), this.resourceSet, this.javaSearchScope));
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateStatus();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }
}

