/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IConstructorProxy;
import org.eclipse.jem.internal.proxy.core.ProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.ClassDescriptorDecoratorPolicy;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.JavaEditDomainHelper;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.core.PropertyEditorBeanProxyWrapper;
import org.eclipse.ve.internal.propertysheet.INeedData;
import org.eclipse.ve.internal.propertysheet.ISourced;

public class BeanCellRenderer
extends LabelProvider
implements IExecutableExtension,
INeedData,
ISourced {
    protected static Image BEAN_IMAGE;
    protected String fJavaBeansPropertyEditorClassName;
    protected EditDomain editDomain;
    protected boolean rebuildWrapper = true;
    private Object[] sources;
    private IPropertySource[] pos;
    private IPropertyDescriptor[] des;
    private boolean sourceIsValid;

    public BeanCellRenderer() {
    }

    public BeanCellRenderer(String aPropertyEditorClassName) {
        this.fJavaBeansPropertyEditorClassName = aPropertyEditorClassName;
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (!(element instanceof IJavaInstance)) {
            return element.toString();
        }
        IBeanProxy elementProxy = BeanProxyUtilities.getBeanProxy((IJavaInstance)element, JavaEditDomainHelper.getResourceSet((EditDomain)this.editDomain));
        if (elementProxy == null) {
            return "";
        }
        PropertyEditorBeanProxyWrapper proxyWrapper = this.calculateJavaBeanPropertyEditor(elementProxy.getProxyFactoryRegistry());
        if (proxyWrapper == null) {
            if (element instanceof IJavaObjectInstance && this.editDomain != null) {
                IJavaObjectInstance javaComponent = (IJavaObjectInstance)element;
                ILabelProvider labelProvider = ClassDescriptorDecoratorPolicy.getPolicy((EditDomain)this.editDomain).getLabelProvider((EClassifier)javaComponent.getJavaType());
                if (labelProvider != null) {
                    if (labelProvider instanceof ISourced) {
                        ((ISourced)labelProvider).setSources(this.sources, this.pos, this.des);
                    }
                    return labelProvider.getText((Object)javaComponent);
                }
            }
            return elementProxy.toBeanString();
        }
        proxyWrapper.setValue(elementProxy);
        return proxyWrapper.getAsText();
    }

    protected PropertyEditorBeanProxyWrapper calculateJavaBeanPropertyEditor(ProxyFactoryRegistry registry) {
        if (this.fJavaBeansPropertyEditorClassName == null) {
            return null;
        }
        PropertyEditorBeanProxyWrapper wrapper = (PropertyEditorBeanProxyWrapper)registry.getConstants((Object)this);
        if (!this.rebuildWrapper) {
            return wrapper;
        }
        this.rebuildWrapper = false;
        registry.deregisterConstants((Object)this);
        if (wrapper != null) {
            wrapper.dispose();
        }
        if (this.fJavaBeansPropertyEditorClassName != null) {
            IConstructorProxy ctor = null;
            IBeanTypeProxy fPropertyEditorTypeProxy = registry.getBeanTypeProxyFactory().getBeanTypeProxy(this.fJavaBeansPropertyEditorClassName);
            try {
                wrapper = this.sourceIsValid && this.sources[0] != null ? ((ctor = fPropertyEditorTypeProxy.getConstructorProxy(new String[]{"java.lang.Object"})) != null ? new PropertyEditorBeanProxyWrapper(ctor.newInstance(new IBeanProxy[]{BeanProxyUtilities.getBeanProxy((IJavaInstance)this.sources[0], JavaEditDomainHelper.getResourceSet((EditDomain)this.editDomain))})) : new PropertyEditorBeanProxyWrapper(fPropertyEditorTypeProxy.newInstance())) : new PropertyEditorBeanProxyWrapper(fPropertyEditorTypeProxy.newInstance());
            }
            catch (ThrowableProxy exc) {
                if (ctor != null) {
                    try {
                        wrapper = new PropertyEditorBeanProxyWrapper(fPropertyEditorTypeProxy.newInstance());
                    }
                    catch (ThrowableProxy e) {
                        JavaVEPlugin.log(e);
                    }
                }
                JavaVEPlugin.log(exc);
            }
        }
        registry.registerConstants((Object)this, (Object)wrapper);
        return wrapper;
    }

    public void setInitializationData(IConfigurationElement ce, String pName, Object initData) {
        if (initData instanceof String) {
            this.fJavaBeansPropertyEditorClassName = ((String)initData).trim();
        }
    }

    public void setData(Object data) {
        this.editDomain = (EditDomain)data;
    }

    public void setSources(Object[] sources, IPropertySource[] pos, IPropertyDescriptor[] des) {
        this.pos = pos;
        this.des = des;
        if (sources[0] instanceof IJavaObjectInstance) {
            this.sourceIsValid = true;
            this.rebuildWrapper = this.sources == null || !this.sources[0].equals(sources[0]);
        } else {
            this.sourceIsValid = false;
            this.rebuildWrapper = true;
        }
        this.sources = sources;
    }
}

