/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.List;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jem.internal.beaninfo.BeanDecorator;
import org.eclipse.jem.internal.beaninfo.common.FeatureAttributeValue;
import org.eclipse.jem.internal.beaninfo.core.Utilities;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ve.internal.java.core.BeanProxyAdapter;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.core.IBeanProxyHost;
import org.eclipse.ve.internal.java.core.JavaMessages;

public class CustomizeAction
extends SelectionAction {
    public static final String ACTION_ID = "jcm.CUSTOMIZE";
    protected boolean explicitPropertyChange;

    public CustomizeAction(IWorkbenchPart anEditorPart) {
        super(anEditorPart);
        this.setId(ACTION_ID);
        this.setText(JavaMessages.Action_Customize_Text);
    }

    protected boolean calculateEnabled() {
        List editParts = this.getSelectedObjects();
        JavaClass customizerClass = this.getCustomizerClass(editParts);
        return customizerClass != null;
    }

    protected JavaClass getCustomizerClass(List editParts) {
        if (editParts.size() != 1) {
            return null;
        }
        if (!(editParts.get(0) instanceof EditPart)) {
            return null;
        }
        Object model = ((EditPart)editParts.get(0)).getModel();
        if (model instanceof IJavaObjectInstance) {
            IBeanProxyHost ba = BeanProxyUtilities.getBeanProxyHost((IJavaInstance)model);
            if (ba instanceof BeanProxyAdapter && ((BeanProxyAdapter)ba).isThisPart()) {
                return null;
            }
            JavaClass beanClass = (JavaClass)((EObject)model).eClass();
            BeanDecorator beanDecor = Utilities.getBeanDecorator((EModelElement)beanClass);
            if (beanDecor != null) {
                FeatureAttributeValue beanInfoChangeFlag = (FeatureAttributeValue)beanDecor.getAttributes().get((Object)"EXPLICIT_PROPERTY_CHANGE");
                this.explicitPropertyChange = beanInfoChangeFlag != null ? (Boolean)beanInfoChangeFlag.getValue() : false;
                return beanDecor.getCustomizerClass();
            }
        }
        return null;
    }

    protected String getCustomizerClassName() {
        JavaClass customizerClass = this.getCustomizerClass(this.getSelectedObjects());
        if (customizerClass != null) {
            return customizerClass.getQualifiedNameForReflection();
        }
        return null;
    }

    public void run() {
    }
}

