/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.Iterator;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jem.internal.adapters.jdom.JavaModelListener;
import org.eclipse.jem.internal.proxy.core.IStandardBeanTypeProxyFactory;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;

public class JavaModelSynchronizer
extends JavaModelListener {
    protected IBeanProxyDomain proxyDomain;
    protected IJavaProject fProject;
    private boolean recycleVM = false;
    private TerminateRunnable terminateRun;
    private String ignoreTypeName;

    public JavaModelSynchronizer(IBeanProxyDomain proxyDomain, IJavaProject aProject, TerminateRunnable terminateRun) {
        super(1);
        this.proxyDomain = proxyDomain;
        this.terminateRun = terminateRun;
        this.fProject = aProject;
    }

    protected IJavaProject getJavaProject() {
        return this.fProject;
    }

    public void setProject(IJavaProject project) {
        this.fProject = project;
    }

    public void stopSynchronizer() {
        JavaCore.removeElementChangedListener((IElementChangedListener)this);
    }

    protected void processJavaElementChanged(IJavaProject element, IJavaElementDelta delta) {
        if (this.isInClasspath(element)) {
            if (delta.getKind() == 2 || delta.getKind() == 1) {
                this.recycleVM = true;
                return;
            }
            if (this.isClasspathResourceChange(delta)) {
                this.recycleVM = true;
                return;
            }
            this.processChildren((IJavaElement)element, delta);
        }
    }

    protected void processJavaElementChanged(ICompilationUnit element, IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 4: {
                if ((delta.getFlags() & 0x40000) == 0) break;
                this.testForRecycle(this.getFullNameFromElement((IJavaElement)element));
                break;
            }
            case 1: 
            case 2: {
                this.testForRecycle(this.getFullNameFromElement((IJavaElement)element));
            }
        }
    }

    protected void testForRecycle(String sourceName) {
        if (sourceName.equals(this.ignoreTypeName)) {
            return;
        }
        String sourceNameForInner = String.valueOf(sourceName) + '$';
        IStandardBeanTypeProxyFactory btypeFactory = this.proxyDomain.getProxyFactoryRegistry().getBeanTypeProxyFactory();
        Iterator itr = btypeFactory.registeredTypes().iterator();
        while (itr.hasNext()) {
            String entryName = (String)itr.next();
            if (!entryName.equals(sourceName) && !entryName.startsWith(sourceNameForInner)) continue;
            this.recycleVM = true;
            return;
        }
    }

    protected void processJavaElementChanged(IClassFile element, IJavaElementDelta delta) {
        if (delta.getKind() == 2) {
            this.testForRecycle(this.getFullNameFromElement((IJavaElement)element));
            return;
        }
        this.processChildren((IJavaElement)element, delta);
    }

    protected void processJavaElementChanged(IPackageFragment element, IJavaElementDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                break;
            }
            case 2: {
                if (delta.getAffectedChildren().length != 0) break;
                this.recycleVM = true;
                break;
            }
            default: {
                super.processJavaElementChanged(element, delta);
            }
        }
    }

    protected String getFullNameFromElement(IJavaElement element) {
        String name = element.getElementName();
        if (!(element instanceof ICompilationUnit) && !(element instanceof IClassFile)) {
            return name;
        }
        int periodNdx = name.lastIndexOf(46);
        if (periodNdx == -1) {
            return name;
        }
        String typeName = null;
        String parentName = element.getParent().getElementName();
        typeName = parentName == null || parentName.length() == 0 ? name.substring(0, periodNdx) : String.valueOf(parentName) + "." + name.substring(0, periodNdx);
        return typeName;
    }

    protected void processJavaElementChanged(IPackageFragmentRoot element, IJavaElementDelta delta) {
        if (this.isClassPathChange(delta)) {
            this.recycleVM = true;
        } else {
            super.processJavaElementChanged(element, delta);
        }
    }

    protected void processJavaElementChanged(IType element, IJavaElementDelta delta) {
        String typeName;
        IStandardBeanTypeProxyFactory btypeFactory;
        if (!this.recycleVM && ((btypeFactory = this.proxyDomain.getProxyFactoryRegistry().getBeanTypeProxyFactory()).isBeanTypeRegistered(typeName = element.getFullyQualifiedName()) || btypeFactory.isBeanTypeNotFound(typeName))) {
            this.recycleVM = true;
        }
    }

    public String toString() {
        return String.valueOf(super.toString()) + " " + this.fProject.getElementName();
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.proxyDomain.getProxyFactoryRegistry() == null || !this.proxyDomain.getProxyFactoryRegistry().isValid()) {
            return;
        }
        this.recycleVM = false;
        super.elementChanged(event);
        if (this.recycleVM) {
            this.recycleVM = false;
            this.terminateRun.run(false);
        }
    }

    public void setIgnoreTypeName(String thisTypeName) {
        this.ignoreTypeName = thisTypeName;
    }

    public String getIgnoreTypeName() {
        return this.ignoreTypeName;
    }

    public static interface TerminateRunnable {
        public void run(boolean var1);
    }
}

