/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.base.IJavaDataTypeInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.proxy.core.ExpressionProxy;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IExpression;
import org.eclipse.jem.internal.proxy.core.IProxy;
import org.eclipse.jem.internal.proxy.core.ThrowableProxy;
import org.eclipse.jem.internal.proxy.initParser.tree.ForExpression;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ve.internal.cde.core.IErrorHolder;
import org.eclipse.ve.internal.cde.core.IErrorNotifier;
import org.eclipse.ve.internal.java.core.BeanExceptionError;
import org.eclipse.ve.internal.java.core.CompositionProxyAdapter;
import org.eclipse.ve.internal.java.core.IAllocationProcesser;
import org.eclipse.ve.internal.java.core.IBeanProxyDomain;
import org.eclipse.ve.internal.java.core.IInternalBeanProxyHost;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

public class PrimitiveProxyAdapter
extends AdapterImpl
implements IInternalBeanProxyHost {
    private IProxy beanProxy;
    private boolean ownsProxy;
    protected IBeanProxyDomain domain;
    protected IErrorHolder.ErrorType instantiationError;
    protected ListenerList errorListeners;

    public PrimitiveProxyAdapter(IBeanProxyDomain domain) {
        this.domain = domain;
    }

    public void releaseBeanProxy() {
        if (this.ownsProxy && this.getBeanProxy() != null && this.getBeanProxy().isValid()) {
            this.getBeanProxy().getProxyFactoryRegistry().releaseProxy(this.getBeanProxy());
        }
        this.beanProxy = null;
    }

    public void releaseBeanProxy(IExpression expression) {
        this.releaseBeanProxy();
    }

    public IJavaInstance getBeanPropertyValue(EStructuralFeature aBeanPropertyFeature) {
        return null;
    }

    public IBeanProxy getBeanProxy() {
        return (IBeanProxy)(this.beanProxy != null && this.beanProxy.isBeanProxy() ? this.beanProxy : null);
    }

    public IProxy getProxy() {
        return this.beanProxy;
    }

    public Map getOriginalSettingsTable() {
        return Collections.EMPTY_MAP;
    }

    public IBeanProxy instantiateBeanProxy() {
        if (this.beanProxy == null) {
            block7: {
                this.instantiationError = null;
                this.fireSeverityError(0);
                IJavaDataTypeInstance jTarget = (IJavaDataTypeInstance)this.target;
                if (jTarget.isSetAllocation()) {
                    JavaAllocation allocation = jTarget.getAllocation();
                    this.ownsProxy = true;
                    try {
                        this.beanProxy = this.getBeanProxyDomain().getAllocationProcesser().allocate(allocation);
                    }
                    catch (IAllocationProcesser.AllocationException e) {
                        this.processInstantiationError((IErrorHolder.ErrorType)new IErrorHolder.ExceptionError(e.getCause(), 1));
                    }
                    return (IBeanProxy)this.beanProxy;
                }
                String qualifiedClassName = jTarget.getJavaType().getQualifiedNameForReflection();
                IBeanTypeProxy targetClass = this.domain.getProxyFactoryRegistry().getBeanTypeProxyFactory().getBeanTypeProxy(qualifiedClassName);
                try {
                    this.beanProxy = targetClass.newInstance();
                    this.ownsProxy = true;
                }
                catch (ThrowableProxy exc) {
                    this.processInstantiationError((IErrorHolder.ErrorType)new BeanExceptionError(exc, 3));
                    if (!JavaVEPlugin.isLoggingLevel(Level.WARNING)) break block7;
                    JavaVEPlugin.log("Could not instantiate " + qualifiedClassName, Level.WARNING);
                    JavaVEPlugin.log(exc, Level.WARNING);
                }
            }
            return (IBeanProxy)this.beanProxy;
        }
        if (this.beanProxy.isExpressionProxy()) {
            return null;
        }
        return (IBeanProxy)this.beanProxy;
    }

    protected void processInstantiationError(IErrorHolder.ErrorType error) {
        this.instantiationError = error;
        this.fireSeverityError(error.getSeverity());
    }

    public boolean hasInstantiationErrors() {
        return this.instantiationError != null;
    }

    protected void fireSeverityError(int severity) {
        if (this.errorListeners != null) {
            Object[] listeners = this.errorListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IErrorNotifier.ErrorListener)listeners[i]).errorStatusChanged();
                ++i;
            }
        }
    }

    public IBeanProxy instantiateBeanProxy(IBeanProxy proxy) {
        this.ownsProxy = false;
        this.beanProxy = proxy;
        this.instantiationError = null;
        this.fireSeverityError(0);
        return (IBeanProxy)this.beanProxy;
    }

    public boolean isBeanProxyInstantiated() {
        return this.beanProxy != null && this.beanProxy.isBeanProxy();
    }

    public void revalidateBeanProxy() {
    }

    public void setBeanProxy(IBeanProxy beanProxy) {
        this.beanProxy = beanProxy;
        this.ownsProxy = false;
    }

    public void setOwnsProxy(boolean ownsProxy) {
        this.ownsProxy = ownsProxy;
    }

    public IBeanProxyDomain getBeanProxyDomain() {
        return this.domain;
    }

    public boolean isAdapterForType(Object type) {
        return BEAN_PROXY_TYPE == type || ERROR_NOTIFIER_TYPE == type || ERROR_HOLDER_TYPE == type;
    }

    public int getErrorStatus() {
        if (this.instantiationError != null) {
            return this.instantiationError.getSeverity();
        }
        return 0;
    }

    public List getErrors() {
        if (this.instantiationError != null) {
            return Collections.singletonList(this.instantiationError);
        }
        return Collections.EMPTY_LIST;
    }

    public List getInstantiationError() {
        return this.getErrors();
    }

    public void addErrorListener(IErrorNotifier.ErrorListener aListener) {
        if (this.errorListeners == null) {
            this.errorListeners = new ListenerList(2);
        }
        this.errorListeners.add((Object)aListener);
    }

    public void removeErrorListener(IErrorNotifier.ErrorListener aListener) {
        if (this.errorListeners != null) {
            this.errorListeners.remove((Object)aListener);
        }
    }

    public void invalidateBeanProxy() {
    }

    public void validateBeanProxy() {
    }

    public IBeanProxy getBeanPropertyProxyValue(EStructuralFeature aBeanPropertyFeature) {
        return null;
    }

    public void applyBeanPropertyProxyValue(EStructuralFeature aBeanPropertyFeature, IBeanProxy aproxy) {
    }

    public IProxy instantiateBeanProxy(IExpression expression) {
        IJavaDataTypeInstance jTarget = (IJavaDataTypeInstance)this.target;
        this.instantiationError = null;
        this.ownsProxy = true;
        this.fireSeverityError(0);
        if (jTarget.isSetAllocation()) {
            JavaAllocation allocation = jTarget.getAllocation();
            try {
                this.beanProxy = this.getBeanProxyDomain().getAllocationProcesser().allocate(allocation, expression);
            }
            catch (IAllocationProcesser.AllocationException e) {
                this.processInstantiationError((IErrorHolder.ErrorType)new IErrorHolder.ExceptionError(e.getCause(), 1));
                JavaVEPlugin.log(e, Level.WARNING);
                return null;
            }
        } else {
            this.beanProxy = expression.createProxyAssignmentExpression(ForExpression.ROOTEXPRESSION);
            switch (jTarget.getJavaType().getPrimitiveID()) {
                case 1: {
                    expression.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, false);
                    break;
                }
                case 3: {
                    expression.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, (byte)0);
                    break;
                }
                case 2: {
                    expression.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, '\u0000');
                    break;
                }
                case 8: {
                    expression.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, (short)0);
                    break;
                }
                case 6: {
                    expression.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, 0);
                    break;
                }
                case 7: {
                    expression.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, 0L);
                    break;
                }
                case 5: {
                    expression.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, 0.0f);
                    break;
                }
                case 4: {
                    expression.createPrimitiveLiteral(ForExpression.ASSIGNMENT_RIGHT, 0.0);
                }
            }
        }
        if (this.beanProxy.isExpressionProxy()) {
            ((ExpressionProxy)this.beanProxy).addProxyListener(new ExpressionProxy.ProxyListener(){

                public void proxyResolved(ExpressionProxy.ProxyEvent event) {
                    PrimitiveProxyAdapter.this.beanProxy = (IProxy)event.getProxy();
                }

                public void proxyNotResolved(ExpressionProxy.ProxyEvent event) {
                    PrimitiveProxyAdapter.this.beanProxy = null;
                }

                public void proxyVoid(ExpressionProxy.ProxyEvent event) {
                    PrimitiveProxyAdapter.this.beanProxy = null;
                }
            });
        }
        return this.beanProxy;
    }

    public IProxy getBeanPropertyProxyValue(EStructuralFeature aBeanPropertyFeature, IExpression expression, ForExpression forExpression) {
        return null;
    }

    public void addToFreeForm(CompositionProxyAdapter compositionAdapter) {
    }

    public void removeFromFreeForm() {
    }

    public boolean isSettingInOriginalSettingsTable(EStructuralFeature feature) {
        return false;
    }

    public boolean inInstantiation() {
        return this.beanProxy != null && this.beanProxy.isExpressionProxy();
    }
}

