/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.core;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class XMLTextViewer
extends TextViewer {
    protected Color fQuotedTextColor = ColorConstants.red;
    protected Color fNormalTextColor = ColorConstants.black;
    protected Color fClassIDTextColor = ColorConstants.blue;
    protected Cursor fWaitCursor;
    protected Cursor fNormalCursor;
    protected Font fTextFont;

    public XMLTextViewer(Composite aParent, int style) {
        super(aParent, style);
        this.setDocument((IDocument)new Document());
    }

    protected void createControl(Composite parent, int style) {
        super.createControl(parent, style);
        Display d = parent.getDisplay();
        this.fTextFont = new Font((Device)d, "Arial", 8, 8);
        this.getTextWidget().setFont(this.fTextFont);
    }

    protected Color getClassIDTextColor() {
        return this.fClassIDTextColor;
    }

    protected Color getNormalTextColor() {
        return this.fNormalTextColor;
    }

    protected Color getQuotedTextColor() {
        return this.fQuotedTextColor;
    }

    protected void handleDispose() {
        if (this.fNormalCursor != null) {
            this.fNormalCursor.dispose();
            this.fNormalCursor = null;
        }
        if (this.fWaitCursor != null) {
            this.fWaitCursor.dispose();
            this.fWaitCursor = null;
        }
        if (this.fTextFont != null) {
            this.fTextFont.dispose();
        }
        super.handleDispose();
    }

    public void highlightText() {
        String text = this.getDocument().get();
        int positionOfQuote = -1;
        int positionOfClassIDStart = -1;
        boolean classIDStartOn = false;
        boolean quoteOn = false;
        int[] ranges = new int[300];
        int iRange = 0;
        boolean quotedIsClass = false;
        int i = 0;
        while (i < text.length()) {
            int[] temp;
            char nextChar = text.charAt(i);
            if (nextChar == '\"') {
                if (!quoteOn) {
                    quoteOn = true;
                    classIDStartOn = false;
                    positionOfQuote = i;
                    if (i > 6 && text.charAt(i - 1) == '=' && text.charAt(i - 2) == 'e' && text.charAt(i - 3) == 'p' && text.charAt(i - 4) == 'y' && text.charAt(i - 5) == 't') {
                        quotedIsClass = true;
                    }
                } else {
                    quoteOn = false;
                    classIDStartOn = false;
                    if (iRange >= ranges.length) {
                        temp = ranges;
                        ranges = new int[ranges.length + 300];
                        System.arraycopy(temp, 0, ranges, 0, temp.length);
                    }
                    if (quotedIsClass) {
                        ranges[iRange++] = 1;
                        quotedIsClass = false;
                    } else {
                        ranges[iRange++] = 0;
                    }
                    ranges[iRange++] = positionOfQuote;
                    ranges[iRange++] = i + 1;
                    positionOfQuote = i;
                }
            } else if (nextChar == ':' && !quoteOn) {
                if (!classIDStartOn) {
                    classIDStartOn = true;
                    positionOfClassIDStart = i;
                }
            } else if ((nextChar == ' ' || nextChar == '>') && classIDStartOn) {
                classIDStartOn = false;
                if (iRange >= ranges.length) {
                    temp = ranges;
                    ranges = new int[ranges.length + 300];
                    System.arraycopy(temp, 0, ranges, 0, temp.length);
                }
                ranges[iRange++] = 1;
                ranges[iRange++] = positionOfClassIDStart;
                ranges[iRange++] = i;
            }
            ++i;
        }
        if (iRange > 0) {
            int[] temp = ranges;
            ranges = new int[iRange];
            System.arraycopy(temp, 0, ranges, 0, iRange);
            Color[] colors = new Color[]{this.getQuotedTextColor(), this.getClassIDTextColor()};
            StyleRange[] styles = new StyleRange[ranges.length / 3];
            int i2 = 0;
            int j = 0;
            while (i2 < ranges.length) {
                StyleRange style = new StyleRange();
                style.start = ranges[i2 + 1];
                style.length = ranges[i2 + 2] - style.start;
                style.foreground = colors[ranges[i2]];
                styles[j] = style;
                i2 += 3;
                ++j;
            }
            this.getTextWidget().setStyleRanges(styles);
        }
    }

    public void setText(String text) {
        if (this.getDocument() == null) {
            return;
        }
        int oldTopIndex = this.getTopIndex();
        this.getDocument().set(text);
        this.highlightText();
        this.setTopIndex(oldTopIndex);
    }
}

