/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.launcher;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.launcher.JavaBeanLaunchConfigurationDelegate;
import org.eclipse.ve.internal.java.vce.launcher.VCELauncherMessages;

public class AppletParametersTab
extends AbstractLaunchConfigurationTab {
    protected Table fParmsTable;
    protected TableEditor fTableEditor;
    protected Button fAddButton;
    protected Button fRemoveButton;
    protected Button fEditButton;
    protected TableColumn nameColumn;
    protected TableColumn valueColumn;
    protected int fEditedItemIndex = -1;
    protected int fX;
    protected int fY;
    protected int fNumberOfParms;
    protected boolean isValid = true;
    static String ARGUMENT_DELIMITER = new Character('\u00fe').toString();
    static String NAME_VALUE_DELIMITER = new Character('\u00ff').toString();

    public void createControl(Composite aParent) {
        Composite comp = new Composite(aParent, 0);
        this.setControl((Control)comp);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        comp.setLayout((Layout)gridLayout);
        this.fParmsTable = new Table(comp, 67588);
        TableLayout fTableLayout = new TableLayout();
        this.fParmsTable.setLayout((Layout)fTableLayout);
        GridData gd = new GridData(1808);
        this.fParmsTable.setLayoutData((Object)gd);
        this.nameColumn = new TableColumn(this.fParmsTable, 0);
        this.nameColumn.setText(VCELauncherMessages.AppletParms_name);
        this.valueColumn = new TableColumn(this.fParmsTable, 0);
        this.valueColumn.setText(VCELauncherMessages.AppletParms_value);
        fTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        fTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.fParmsTable.setHeaderVisible(true);
        this.fParmsTable.setLinesVisible(true);
        this.createButtons(comp);
        this.fTableEditor = new TableEditor(this.fParmsTable);
        this.fParmsTable.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent event) {
                AppletParametersTab.this.fX = event.x;
                AppletParametersTab.this.fY = event.y;
            }
        });
        this.fParmsTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int index;
                AppletParametersTab.this.enableRemoveButton();
                Control oldEditor = AppletParametersTab.this.fTableEditor.getEditor();
                if (oldEditor != null) {
                    AppletParametersTab.this.fEditedItemIndex = -1;
                    oldEditor.dispose();
                }
                if ((index = AppletParametersTab.this.fParmsTable.getSelectionIndex()) == -1) {
                    return;
                }
                TableItem item = AppletParametersTab.this.fParmsTable.getItem(index);
                AppletParametersTab.this.fEditedItemIndex = index;
                Text text = new Text((Composite)AppletParametersTab.this.fParmsTable, 0);
                AppletParametersTab.this.fTableEditor.horizontalAlignment = 16384;
                AppletParametersTab.this.fTableEditor.grabHorizontal = true;
                AppletParametersTab.this.fTableEditor.minimumWidth = 50;
                int nameWidth = AppletParametersTab.this.nameColumn.getWidth();
                int columnToEdit = -1;
                columnToEdit = nameWidth >= AppletParametersTab.this.fX ? 0 : 1;
                AppletParametersTab.this.fTableEditor.setEditor((Control)text, item, columnToEdit);
                text.setText(item.getText(columnToEdit));
                text.setSelection(0, text.getText().length());
                int finalColumnToEdit = columnToEdit;
                text.addModifyListener(new ModifyListener(this, text, item, finalColumnToEdit){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ Text val$text;
                    private final /* synthetic */ TableItem val$item;
                    private final /* synthetic */ int val$finalColumnToEdit;
                    {
                        this.this$1 = var1_1;
                        this.val$text = text;
                        this.val$item = tableItem;
                        this.val$finalColumnToEdit = n;
                    }

                    public void modifyText(ModifyEvent event) {
                        if (this.val$text.getText() == null || this.val$text.getText().trim().length() == 0) {
                            AppletParametersTab.access$0(2.access$0(this.this$1), VCELauncherMessages.AppletParms_novalue_WARN_);
                            2.access$0(this.this$1).isValid = false;
                            this.val$text.setBackground(ColorConstants.red);
                        } else {
                            2.access$0(this.this$1).isValid = true;
                            AppletParametersTab.access$0(2.access$0(this.this$1), null);
                            this.val$text.setBackground(ColorConstants.white);
                            this.val$item.setText(this.val$finalColumnToEdit, this.val$text.getText());
                            AppletParametersTab.access$1(2.access$0(this.this$1));
                        }
                    }
                });
                text.setFocus();
            }

            static /* synthetic */ AppletParametersTab access$0(2 var0) {
                return var0.AppletParametersTab.this;
            }
        });
    }

    protected void createButtons(Composite comp) {
        Composite buttonsComp = new Composite(comp, 0);
        GridLayout buttonsLayout = new GridLayout();
        buttonsLayout.marginHeight = 0;
        buttonsLayout.marginWidth = 0;
        buttonsLayout.makeColumnsEqualWidth = true;
        buttonsComp.setLayout((Layout)buttonsLayout);
        GridData data = new GridData(258);
        buttonsComp.setLayoutData((Object)data);
        this.fAddButton = new Button(buttonsComp, 8);
        this.fAddButton.setText(VCELauncherMessages.AppletParms_new);
        this.fAddButton.setLayoutData((Object)new GridData());
        this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                TableItem newItem = new TableItem(AppletParametersTab.this.fParmsTable, 0);
                int newItemIndex = AppletParametersTab.this.fParmsTable.indexOf(newItem);
                String nameString = MessageFormat.format(VCELauncherMessages.AppletParms_nameindex, new Integer(newItemIndex));
                newItem.setText(0, nameString);
                String valueString = MessageFormat.format(VCELauncherMessages.AppletParms_valueindex, new Integer(newItemIndex));
                newItem.setText(1, valueString);
                AppletParametersTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fRemoveButton = new Button(buttonsComp, 8);
        this.fRemoveButton.setText(VCELauncherMessages.AppletParms_remove);
        this.fRemoveButton.setLayoutData((Object)new GridData());
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                int selectedIndex = AppletParametersTab.this.fParmsTable.getSelectionIndex();
                if (selectedIndex != -1) {
                    Control editor;
                    AppletParametersTab.this.fParmsTable.remove(selectedIndex);
                    if (AppletParametersTab.this.fEditedItemIndex == selectedIndex && (editor = AppletParametersTab.this.fTableEditor.getEditor()) != null) {
                        AppletParametersTab.this.fEditedItemIndex = -1;
                        editor.dispose();
                    }
                    AppletParametersTab.this.fParmsTable.redraw();
                    AppletParametersTab.this.fRemoveButton.setEnabled(false);
                    AppletParametersTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
    }

    protected void enableRemoveButton() {
        TableItem[] selectedItems = this.fParmsTable.getSelection();
        if (selectedItems != null && selectedItems.length == 1) {
            this.fRemoveButton.setEnabled(true);
        } else {
            this.fRemoveButton.setEnabled(false);
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.fParmsTable.removeAll();
        try {
            int numberOfParms;
            String numberOfParmsString = config.getAttribute(JavaBeanLaunchConfigurationDelegate.APPLET_PARMS_NUMBER, "");
            if (numberOfParmsString.equals("")) {
                return;
            }
            this.fNumberOfParms = numberOfParms = Integer.parseInt(numberOfParmsString);
            int i = 1;
            while (i <= numberOfParms) {
                String parmName = config.getAttribute(String.valueOf(JavaBeanLaunchConfigurationDelegate.APPLET_PARM_NAME) + i, "");
                String parmValue = config.getAttribute(String.valueOf(JavaBeanLaunchConfigurationDelegate.APPLET_PARM_VALUE) + i, "");
                TableItem item = new TableItem(this.fParmsTable, 0);
                item.setText(0, parmName);
                item.setText(1, parmValue);
                ++i;
            }
        }
        catch (CoreException coreException) {}
    }

    public boolean isValid(ILaunchConfiguration config) {
        return this.isValid;
    }

    public void performApply(ILaunchConfigurationWorkingCopy aConfiguration) {
        TableItem[] tableItems = this.fParmsTable.getItems();
        if (tableItems == null) {
            aConfiguration.setAttribute(JavaBeanLaunchConfigurationDelegate.APPLET_PARMS_NUMBER, "0");
            return;
        }
        aConfiguration.setAttribute(JavaBeanLaunchConfigurationDelegate.APPLET_PARMS_NUMBER, String.valueOf(tableItems.length));
        int i = 0;
        while (i < tableItems.length) {
            String parmName = tableItems[i].getText(0);
            String parmValue = tableItems[i].getText(1);
            aConfiguration.setAttribute(String.valueOf(JavaBeanLaunchConfigurationDelegate.APPLET_PARM_NAME) + (i + 1), parmName);
            aConfiguration.setAttribute(String.valueOf(JavaBeanLaunchConfigurationDelegate.APPLET_PARM_VALUE) + (i + 1), parmValue);
            ++i;
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy aConfiguration) {
    }

    public String getName() {
        return VCELauncherMessages.AppletParms_title;
    }

    public Image getImage() {
        return JavaVEPlugin.getAppletImage();
    }

    static /* synthetic */ void access$0(AppletParametersTab appletParametersTab, String string) {
        appletParametersTab.setErrorMessage(string);
    }
}

