/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.rules;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.ve.internal.cde.rules.IRule;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.rules.DefaultRuleProvider;
import org.eclipse.ve.internal.java.vce.rules.IEditorStyle;
import org.eclipse.ve.internal.java.vce.rules.IEditorStylePrefUI;
import org.eclipse.ve.internal.java.vce.rules.IRuleProvider;

public class EditorStyle
implements IEditorStyle {
    private Map fRules = null;
    private Map fTemplates = null;
    private String fID;
    private String fDescription;
    private IEditorStylePrefUI fPrefUI = null;
    private IConfigurationElement fConfig;
    public static final String EXT_DESC = "description";
    public static final String EXT_CLASS = "class";
    private boolean noStyle;

    public EditorStyle(String styleId, IConfigurationElement ce) {
        this.fConfig = ce;
        this.fID = styleId;
        this.fDescription = ce.getAttribute(EXT_DESC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getRules() {
        if (this.fRules != null) {
            return this.fRules;
        }
        EditorStyle editorStyle = this;
        synchronized (editorStyle) {
            if (this.fRules == null) {
                HashMap<String, DefaultRuleProvider> rules = new HashMap<String, DefaultRuleProvider>();
                IConfigurationElement[] elements = this.fConfig.getChildren();
                int i = 0;
                while (i < elements.length) {
                    IConfigurationElement ce = elements[i];
                    if (ce.getName().equals("rule")) {
                        DefaultRuleProvider rp = new DefaultRuleProvider(ce, this.fID, this);
                        rules.put(rp.getRuleID(), rp);
                    }
                    ++i;
                }
                this.fRules = rules;
            }
        }
        return this.fRules;
    }

    protected Map getTemplates() {
        return this.fTemplates;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getStyleID() {
        return this.fID;
    }

    public Preferences getPrefStore() {
        return null;
    }

    public IEditorStylePrefUI getPrefUI() {
        if (this.noStyle) {
            return null;
        }
        if (this.fPrefUI != null) {
            return this.fPrefUI;
        }
        IConfigurationElement[] elements = this.fConfig.getChildren();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement ce = elements[i];
            if (ce.getName().equals("prefui")) {
                try {
                    this.fPrefUI = (IEditorStylePrefUI)ce.createExecutableExtension(EXT_CLASS);
                }
                catch (CoreException e) {
                    this.noStyle = true;
                    JavaVEPlugin.log(e);
                }
                catch (ClassCastException e) {
                    this.noStyle = true;
                    JavaVEPlugin.log(e);
                }
                break;
            }
            ++i;
        }
        return this.fPrefUI;
    }

    public String toString() {
        return "EditorStyle(" + this.fID + ")";
    }

    public String getPluginID() {
        return this.fConfig.getDeclaringExtension().getNamespace();
    }

    public IRule getRule(String id) {
        IRuleProvider p = (IRuleProvider)this.getRules().get(id);
        if (p != null) {
            return p.getRule();
        }
        return null;
    }

    public Object getTemplate(String id) {
        return null;
    }
}

