/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.vce.templates;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.java.vce.templates.TemplatesException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class TemplateUtil {
    private static final HashMap fClassPathMap = new HashMap();
    private static final HashMap fClassPathPreReqMap = new HashMap();
    private static List fPlatformJRE = null;
    private static boolean DEV_MODE = Platform.inDevelopmentMode();
    private static HashMap fFilePath = new HashMap();
    private static HashMap fClassLoaders = new HashMap();

    public static String getPathForBundleFile(String bundleName, String relativePath) {
        String key = String.valueOf(bundleName) + ":" + relativePath;
        String result = (String)fFilePath.get(key);
        if (result == null) {
            result = TemplateUtil.getPathForBundleFile(Platform.getBundle((String)bundleName), relativePath);
            fFilePath.put(key, result);
        }
        return result;
    }

    public static String getPathForBundleFile(Bundle bundle, String relativePath) {
        return TemplateUtil.getCorrectPath(ProxyPlugin.getPlugin().localizeFromBundleOnly(bundle, relativePath));
    }

    public static List getPluginJarPath(String plugin) {
        List l = (List)fClassPathMap.get(plugin);
        if (l != null) {
            return l;
        }
        Bundle bundle = Platform.getBundle((String)plugin);
        ArrayList list = null;
        if (bundle != null) {
            list = new ArrayList();
            TemplateUtil.getBundleLibraries(bundle, list);
            Bundle[] frags = Platform.getFragments((Bundle)bundle);
            if (frags != null) {
                int i = 0;
                while (i < frags.length) {
                    TemplateUtil.getBundleLibraries(frags[i], list);
                    ++i;
                }
            }
        } else {
            list = Collections.EMPTY_LIST;
        }
        fClassPathMap.put(plugin, list);
        return list;
    }

    private static void getBundleLibraries(Bundle bundle, List list) {
        block10: {
            try {
                URL bin;
                URL url = Platform.resolve((URL)bundle.getEntry("/"));
                if (url.getProtocol().equals("jar")) {
                    String path = new URL(url.getFile().substring(0, url.getFile().indexOf("!/"))).getFile();
                    list.add(TemplateUtil.getCorrectPath(path));
                    break block10;
                }
                String requires = (String)bundle.getHeaders().get("Bundle-ClassPath");
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)requires);
                if (elements != null) {
                    int i = 0;
                    while (i < elements.length) {
                        String name = ProxyPlugin.getPlugin().localizeFromBundleAndFragments(bundle, elements[i].getValue());
                        if (!name.equals(".")) {
                            list.add(TemplateUtil.getCorrectPath(name));
                        }
                        ++i;
                    }
                }
                if (!DEV_MODE || (bin = bundle.getEntry("bin/")) == null) break block10;
                try {
                    String path;
                    bin = Platform.resolve((URL)bin);
                    if (bin.getProtocol() == "file" && !list.contains(path = TemplateUtil.getCorrectPath(bin.getFile()))) {
                        list.add(bin.getFile());
                    }
                }
                catch (IOException iOException) {}
            }
            catch (BundleException e) {
                JavaVEPlugin.getPlugin().getLogger().log((Throwable)e, Level.WARNING);
            }
            catch (IOException e) {
                JavaVEPlugin.log(e);
            }
        }
    }

    public static List getPluginAndPreReqJarPath(String plugin) {
        List lst = (List)fClassPathPreReqMap.get(plugin);
        if (lst != null) {
            return lst;
        }
        Bundle bundle = Platform.getBundle((String)plugin);
        List l = null;
        if (bundle != null) {
            l = TemplateUtil.getPluginJarPath(bundle.getSymbolicName());
            List allReqs = ProxyPlugin.getAllPrereqs((Bundle)bundle);
            int i = 0;
            while (i < allReqs.size()) {
                l.addAll(TemplateUtil.getPluginJarPath(((Bundle)allReqs.get(i)).getSymbolicName()));
                ++i;
            }
        }
        fClassPathPreReqMap.put(plugin, l);
        return l;
    }

    /*
     * Unable to fully structure code
     */
    private static String getCorrectPath(String path) {
        block4: {
            if (path.length() == 0) {
                return path;
            }
            v0 = skipLeading = path.charAt(0) == '/' && Platform.getOS().equals("win32") != false;
            if (!skipLeading && path.indexOf(37) == -1) break block4;
            buf = new StringBuffer(path.length());
            i = skipLeading != false ? 1 : 0;
            while (i < path.length()) {
                c = path.charAt(i);
                if (c != '%' || i + 2 >= path.length()) ** GOTO lbl-1000
                c1 = path.charAt(i + 1);
                c2 = path.charAt(i + 2);
                if (c1 == '2' && c2 == '0') {
                    i += 2;
                    buf.append(' ');
                } else lbl-1000:
                // 2 sources

                {
                    buf.append(c);
                }
                ++i;
            }
            return buf.toString();
        }
        return path;
    }

    public static List getPlatformJREPath() throws TemplatesException {
        if (fPlatformJRE != null) {
            return fPlatformJRE;
        }
        VMStandin detectedVMStandin = null;
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            String vmID;
            File detectedLocation = vmTypes[i].detectInstallLocation();
            if (detectedLocation != null && (detectedVMStandin = new VMStandin(vmTypes[i], vmID = String.valueOf("1"))) != null) {
                detectedVMStandin.setInstallLocation(detectedLocation);
                detectedVMStandin.setName(detectedVMStandin.getInstallLocation().getName());
                LibraryLocation[] locations = JavaRuntime.getLibraryLocations((IVMInstall)detectedVMStandin);
                fPlatformJRE = new ArrayList(locations.length);
                int j = 0;
                while (j < locations.length) {
                    IPath path = locations[j].getSystemLibraryPath();
                    if (!Path.EMPTY.equals((Object)path)) {
                        fPlatformJRE.add(path.toString());
                    }
                    ++j;
                }
                return fPlatformJRE;
            }
            ++i;
        }
        fPlatformJRE = Collections.EMPTY_LIST;
        return fPlatformJRE;
    }

    public static String getClassPath(Object o) {
        if (o == null) {
            return null;
        }
        return TemplateUtil.getClassPath(o.getClass());
    }

    public static String getClassPath(Class clazz) {
        int excMarkIndex;
        if (clazz == null) {
            return null;
        }
        String name = "/" + clazz.getName().replace('.', '/') + ".class";
        URL url = clazz.getResource(name);
        if (url == null) {
            return null;
        }
        try {
            url = Platform.resolve((URL)url);
        }
        catch (IOException iOException) {}
        String path = url.getFile();
        if (path.startsWith("/") && path.charAt(2) == ':') {
            path = path.substring(1);
        } else if (path.toLowerCase().startsWith("file:")) {
            int excMarkIndex2 = (path = path.substring(5)).indexOf("!");
            if (excMarkIndex2 != -1) {
                path = path.substring(0, excMarkIndex2);
            }
        } else if (path.charAt(1) != ':' && (excMarkIndex = path.indexOf("!")) != -1) {
            path = path.substring(0, excMarkIndex);
        }
        return TemplateUtil.getCorrectPath(path);
    }

    public static long getTimeStamp(Object o) {
        return TemplateUtil.getTimeStamp(o.getClass());
    }

    public static long getTimeStamp(Class clazz) {
        String path = TemplateUtil.getClassPath(clazz);
        if (path == null) {
            return -1L;
        }
        File f = new File(path);
        if (!f.canRead()) {
            return -1L;
        }
        return f.lastModified();
    }

    public static ClassLoader getClassLoader(String plugin) {
        Bundle b;
        ClassLoader cl = (ClassLoader)fClassLoaders.get(plugin);
        if (cl == null && (b = Platform.getBundle((String)plugin)) != null) {
            cl = new SpecialClassLoader(b);
            fClassLoaders.put(plugin, cl);
        }
        return cl;
    }

    private static class SpecialClassLoader
    extends ClassLoader {
        Bundle bundle;

        public SpecialClassLoader(Bundle bundle) {
            this.bundle = bundle;
        }

        protected Class findClass(String name) throws ClassNotFoundException {
            return this.bundle.loadClass(name);
        }
    }
}

