/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.visual;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.commands.Command;
import org.eclipse.jem.internal.instantiation.base.IJavaInstance;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.base.JavaInstantiation;
import org.eclipse.jem.internal.proxy.core.IRectangleBeanProxy;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.core.ModelChangeController;
import org.eclipse.ve.internal.cde.core.XYLayoutUtility;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.java.core.BeanProxyUtilities;
import org.eclipse.ve.internal.java.rules.RuledCommandBuilder;
import org.eclipse.ve.internal.propertysheet.common.commands.CommandWrapper;

public abstract class NullLayoutConstraintCommand
extends CommandWrapper {
    protected IJavaObjectInstance target;
    protected ResourceSet rset;
    protected Rectangle constraint;
    protected byte changed = 0;
    protected EditDomain domain;
    protected static final byte NO_CHANGE = 0;
    protected static final byte MOVED = 1;
    protected static final byte RESIZED = 2;
    private static final int NO_TYPE = -1;
    private static final int TYPE_BOUNDS = 0;
    private static final int TYPE_LOC = 1;
    private static final int TYPE_SIZE = 2;
    private static final int TYPE_LOC_AND_SIZE = 3;

    public NullLayoutConstraintCommand(String label) {
        super(label);
    }

    public NullLayoutConstraintCommand() {
    }

    public void setTarget(IJavaObjectInstance target) {
        this.target = target;
    }

    public void setDomain(EditDomain domain) {
        this.domain = domain;
        this.rset = EMFEditDomainHelper.getResourceSet((EditDomain)domain);
    }

    public void setConstraint(Rectangle constraint, boolean moved, boolean resized) {
        if (moved) {
            this.changed = (byte)(this.changed | 1);
        }
        if (resized) {
            this.changed = (byte)(this.changed | 2);
        }
        this.constraint = constraint;
    }

    protected boolean prepare() {
        return this.target != null && this.rset != null && this.constraint != null;
    }

    public void execute() {
        int tranEndType = -1;
        RuledCommandBuilder cb = new RuledCommandBuilder(this.domain);
        EReference sfComponentBounds = JavaInstantiation.getReference((IJavaObjectInstance)this.target, (URI)this.getSFBounds());
        if (this.target.eIsSet((EStructuralFeature)sfComponentBounds)) {
            int height;
            int width;
            int y;
            int x;
            IRectangleBeanProxy oldBounds = (IRectangleBeanProxy)BeanProxyUtilities.getBeanProxy((IJavaInstance)((IJavaObjectInstance)this.target.eGet((EStructuralFeature)sfComponentBounds)), this.rset);
            if ((this.changed & 1) != 0) {
                if (this.constraint.x == Integer.MIN_VALUE && this.constraint.y == Integer.MIN_VALUE) {
                    tranEndType = 0;
                    x = 0;
                    boolean bl = false;
                }
                x = this.constraint.x;
                y = this.constraint.y;
            } else {
                x = oldBounds.getX();
                y = oldBounds.getY();
            }
            if ((this.changed & 2) != 0) {
                if (this.constraint.width == -1) {
                    tranEndType = 0;
                    width = 0;
                } else {
                    width = this.constraint.width;
                }
                if (this.constraint.height == -1) {
                    tranEndType = 0;
                    height = 0;
                } else {
                    height = this.constraint.height;
                }
            } else {
                width = oldBounds.getWidth();
                height = oldBounds.getHeight();
            }
            IJavaInstance bounds = this.createBoundsInstance(x, y, width, height);
            cb.applyAttributeSetting((EObject)this.target, (EStructuralFeature)sfComponentBounds, (Object)bounds);
        } else {
            EReference sfComponentSize = JavaInstantiation.getReference((IJavaObjectInstance)this.target, (URI)this.getSFSize());
            if ((this.changed & 2) != 0 && (this.changed & 1) == 0) {
                int height;
                int width;
                if (this.constraint.width == -1) {
                    tranEndType = 2;
                    width = 0;
                } else {
                    width = this.constraint.width;
                }
                if (this.constraint.height == -1) {
                    tranEndType = 2;
                    height = 0;
                } else {
                    height = this.constraint.height;
                }
                IJavaInstance size = this.createSizeInstance(width, height);
                cb.applyAttributeSetting((EObject)this.target, (EStructuralFeature)sfComponentSize, (Object)size);
            } else {
                EReference sfComponentLocation = JavaInstantiation.getReference((IJavaObjectInstance)this.target, (URI)this.getSFLocation());
                if (this.target.eIsSet((EStructuralFeature)sfComponentSize) || this.target.eIsSet((EStructuralFeature)sfComponentLocation)) {
                    int height;
                    if ((this.changed & 2) != 0) {
                        int width;
                        if (this.constraint.width == -1) {
                            tranEndType = 2;
                            width = 0;
                        } else {
                            width = this.constraint.width;
                        }
                        if (this.constraint.height == -1) {
                            tranEndType = 2;
                            height = 0;
                        } else {
                            height = this.constraint.height;
                        }
                        IJavaInstance size = this.createSizeInstance(width, height);
                        cb.applyAttributeSetting((EObject)this.target, (EStructuralFeature)sfComponentSize, (Object)size);
                    }
                    if ((this.changed & 1) != 0) {
                        int x;
                        if (this.constraint.x == Integer.MIN_VALUE && this.constraint.y == Integer.MIN_VALUE) {
                            tranEndType = tranEndType != 2 ? 1 : 3;
                            x = 0;
                            height = 0;
                        }
                        x = this.constraint.x;
                        int y = this.constraint.y;
                        IJavaInstance loc = this.createLocationInstance(x, y);
                        cb.applyAttributeSetting((EObject)this.target, (EStructuralFeature)sfComponentLocation, (Object)loc);
                    }
                } else {
                    int height;
                    int width;
                    int y;
                    int x;
                    if (this.constraint.x == Integer.MIN_VALUE && this.constraint.y == Integer.MIN_VALUE) {
                        tranEndType = 0;
                        x = 0;
                        y = 0;
                    } else {
                        x = this.constraint.x;
                        y = this.constraint.y;
                    }
                    if (this.constraint.width == -1) {
                        tranEndType = 0;
                        width = 0;
                    } else {
                        width = this.constraint.width;
                    }
                    if (this.constraint.height == -1) {
                        tranEndType = 0;
                        height = 0;
                    } else {
                        height = this.constraint.height;
                    }
                    IJavaInstance bounds = this.createBoundsInstance(x, y, width, height);
                    cb.applyAttributeSetting((EObject)this.target, (EStructuralFeature)sfComponentBounds, (Object)bounds);
                }
            }
        }
        if (tranEndType != -1) {
            cb.appendPost(new TransactionEndCommand(tranEndType));
        }
        this.command = cb.getCommand();
        this.command.execute();
    }

    protected abstract IJavaInstance createLocationInstance(int var1, int var2);

    protected abstract IJavaInstance createBoundsInstance(int var1, int var2, int var3, int var4);

    protected abstract IJavaInstance createSizeInstance(int var1, int var2);

    protected abstract Point getPreferredLoc();

    protected abstract Dimension getPreferredSize(int var1, int var2);

    protected abstract Rectangle getPreferredBounds(Rectangle var1);

    protected abstract URI getSFBounds();

    protected abstract URI getSFSize();

    protected abstract URI getSFLocation();

    private class TransactionEndCommand
    extends Command {
        public int type;

        public TransactionEndCommand(int type) {
            this.type = type;
        }

        public void execute() {
            ModelChangeController mc = (ModelChangeController)NullLayoutConstraintCommand.this.domain.getData((Object)"org.eclipse.ve.internal.cde.core.ModelChangeController");
            mc.execAtEndOfTransaction(new Runnable(this){
                final /* synthetic */ TransactionEndCommand this$1;
                {
                    this.this$1 = transactionEndCommand;
                }

                public void run() {
                    RuledCommandBuilder cb = new RuledCommandBuilder(TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).domain);
                    switch (this.this$1.type) {
                        case 0: {
                            int height;
                            int width;
                            int y;
                            int x;
                            if (XYLayoutUtility.constraintContainsPreferredSettings((Rectangle)TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).constraint, (boolean)true, (boolean)true)) {
                                Rectangle b = TransactionEndCommand.access$0(this.this$1).getPreferredBounds(TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).constraint);
                                x = b.x;
                                y = b.y;
                                width = b.width;
                                height = b.height;
                            } else if (XYLayoutUtility.constraintContainsPreferredSettings((Rectangle)TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).constraint, (boolean)true, (boolean)false)) {
                                Point p = TransactionEndCommand.access$0(this.this$1).getPreferredLoc();
                                x = p.x;
                                y = p.y;
                                width = TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).constraint.width;
                                height = TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).constraint.height;
                            } else {
                                Dimension s = TransactionEndCommand.access$0(this.this$1).getPreferredSize(TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).constraint.width, TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).constraint.height);
                                x = TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).constraint.x;
                                y = TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).constraint.y;
                                width = s.width;
                                height = s.height;
                            }
                            IJavaInstance bounds = TransactionEndCommand.access$0(this.this$1).createBoundsInstance(x, y, width, height);
                            cb.applyAttributeSetting((EObject)TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).target, (EStructuralFeature)JavaInstantiation.getReference((IJavaObjectInstance)TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).target, (URI)TransactionEndCommand.access$0(this.this$1).getSFBounds()), (Object)bounds);
                            break;
                        }
                        case 1: {
                            Point p = TransactionEndCommand.access$0(this.this$1).getPreferredLoc();
                            int x = p.x;
                            int y = p.y;
                            IJavaInstance loc = TransactionEndCommand.access$0(this.this$1).createLocationInstance(x, y);
                            cb.applyAttributeSetting((EObject)TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).target, (EStructuralFeature)JavaInstantiation.getReference((IJavaObjectInstance)TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).target, (URI)TransactionEndCommand.access$0(this.this$1).getSFLocation()), (Object)loc);
                            break;
                        }
                        case 2: {
                            Dimension s = TransactionEndCommand.access$0(this.this$1).getPreferredSize(TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).constraint.width, TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).constraint.height);
                            int width = s.width;
                            int height = s.height;
                            IJavaInstance size = TransactionEndCommand.access$0(this.this$1).createSizeInstance(width, height);
                            cb.applyAttributeSetting((EObject)TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).target, (EStructuralFeature)JavaInstantiation.getReference((IJavaObjectInstance)TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).target, (URI)TransactionEndCommand.access$0(this.this$1).getSFSize()), (Object)size);
                            break;
                        }
                        case 3: {
                            Point p = TransactionEndCommand.access$0(this.this$1).getPreferredLoc();
                            int x = p.x;
                            int y = p.y;
                            IJavaInstance loc = TransactionEndCommand.access$0(this.this$1).createLocationInstance(x, y);
                            cb.applyAttributeSetting((EObject)TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).target, (EStructuralFeature)JavaInstantiation.getReference((IJavaObjectInstance)TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).target, (URI)TransactionEndCommand.access$0(this.this$1).getSFLocation()), (Object)loc);
                            Dimension s = TransactionEndCommand.access$0(this.this$1).getPreferredSize(TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).constraint.width, TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).constraint.height);
                            int width = s.width;
                            int height = s.height;
                            IJavaInstance size = TransactionEndCommand.access$0(this.this$1).createSizeInstance(width, height);
                            cb.applyAttributeSetting((EObject)TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).target, (EStructuralFeature)JavaInstantiation.getReference((IJavaObjectInstance)TransactionEndCommand.access$0((TransactionEndCommand)this.this$1).target, (URI)TransactionEndCommand.access$0(this.this$1).getSFSize()), (Object)size);
                        }
                    }
                    cb.getCommand().execute();
                }
            });
        }

        static /* synthetic */ NullLayoutConstraintCommand access$0(TransactionEndCommand transactionEndCommand) {
            return transactionEndCommand.NullLayoutConstraintCommand.this;
        }
    }
}

