/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt.targetvm;

import org.eclipse.jem.internal.proxy.common.IVMServer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ve.internal.swt.targetvm.TargetVMMessages;

public abstract class Environment {
    private Display display;
    private Thread t;
    private Shell freeFormHost;
    private int freeFormHostRefCount = 0;
    public Color lightGray;
    private static final String ENVIRONMENT_KEY = "ve.swt.Environment";
    private boolean shutdownRequested;
    private static final String LAYOUT_DATA = "ve.LAYOUT_DATA";
    private static final String DISPOSE_ADDED = "ve.DISPOSE ADDED";
    private static final Layout FF_LAYOUT = new Layout(){

        private boolean getUseSetSize(Composite composite) {
            return (Boolean)composite.getData(Environment.LAYOUT_DATA);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            if (children.length == 0) {
                return;
            }
            if (composite.getData(Environment.DISPOSE_ADDED) == null) {
                children[0].addDisposeListener((DisposeListener)new FreeFormDisposeListener(composite));
                composite.setData(Environment.DISPOSE_ADDED, (Object)Boolean.TRUE);
            }
            if (!this.getUseSetSize(composite)) {
                Point cSize = composite.getSize();
                children[0].setBounds(0, 0, cSize.x, cSize.y);
            } else {
                children[0].setLocation(0, 0);
            }
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            if (children.length != 1) {
                return new Point(0, 0);
            }
            return this.getUseSetSize(composite) ? children[0].getSize() : children[0].computeSize(wHint, hHint);
        }
    };

    public static Environment getEnvironment(Display display) {
        return (Environment)display.getData(ENVIRONMENT_KEY);
    }

    public Environment(IVMServer vmserver) {
        this.initialize(vmserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize(IVMServer vmserver) {
        this.t = new Thread("SWT UI Thread for VE"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread thread = Thread.currentThread();
                synchronized (thread) {
                    Environment.this.display = new Display();
                    Environment.this.display.setData(Environment.ENVIRONMENT_KEY, (Object)Environment.this);
                    Environment.this.lightGray = new Color((Device)Environment.this.display, 220, 220, 220);
                    Thread.currentThread().notifyAll();
                }
                while (true) {
                    try {
                        if (Environment.this.shutdownRequested) break;
                        if (Environment.this.display.readAndDispatch()) continue;
                        Environment.this.display.sleep();
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
                Environment.this.display.dispose();
            }
        };
        vmserver.addShutdownListener(new Runnable(){

            public void run() {
                Environment.this.shutdownRequested = true;
                Environment.this.display.asyncExec(null);
                try {
                    Environment.this.t.join(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        });
        Thread thread = this.t;
        synchronized (thread) {
            this.t.start();
            while (true) {
                try {
                    this.t.wait();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public Display getDisplay() {
        return this.display;
    }

    public Shell getFreeFormHost() {
        return this.freeFormHost;
    }

    public Point getOffScreenLocation() {
        Rectangle bounds = this.getDisplay().getBounds();
        return new Point(bounds.width + 1000, bounds.height + 1000);
    }

    public Shell initializeFreeFormHost(int x, int y) {
        ++this.freeFormHostRefCount;
        if (this.freeFormHost == null) {
            Shell dialogParent = new Shell(this.display);
            this.freeFormHost = new Shell(dialogParent, 1264);
            this.freeFormHost.setLocation(x, y);
            this.freeFormHost.setLayout((Layout)new RowLayout());
            this.freeFormHost.addShellListener(this.getPreventShellCloseListener());
            this.freeFormHost.open();
        }
        return this.freeFormHost;
    }

    public void disposeFreeFormHost() {
        if (this.freeFormHost != null && --this.freeFormHostRefCount <= 0) {
            final Shell ffh = this.freeFormHost;
            this.freeFormHost = null;
            this.display.asyncExec(new Runnable(){

                public void run() {
                    if (Environment.this.freeFormHostRefCount <= 0) {
                        Environment.this.freeFormHostRefCount = 0;
                        Composite parent = ffh.getParent();
                        ffh.dispose();
                        parent.dispose();
                    }
                }
            });
        }
    }

    public Composite addToFreeFormParent(boolean useSetSize) {
        Composite container = new Composite((Composite)this.freeFormHost, 0);
        container.setData(LAYOUT_DATA, (Object)useSetSize);
        container.setLayout(FF_LAYOUT);
        return container;
    }

    public void setUseSetSize(Control control, boolean useSetSize) {
        Composite parent = control.getParent();
        if (parent.getData(LAYOUT_DATA) != null) {
            parent.setData(LAYOUT_DATA, (Object)useSetSize);
        }
    }

    protected abstract ShellListener getPreventShellCloseListener();

    public static String getFontLabel(Font aFont) {
        FontData fontData = aFont.getFontData()[0];
        StringBuffer fontLabelBuffer = new StringBuffer();
        fontLabelBuffer.append(fontData.getName());
        fontLabelBuffer.append(',');
        boolean styleUsed = false;
        if ((fontData.getStyle() & 1) != 0) {
            fontLabelBuffer.append(TargetVMMessages.getString("Environment.FontLabel.Style.Bold"));
            styleUsed = true;
        }
        if ((fontData.getStyle() & 2) != 0) {
            if (styleUsed) {
                fontLabelBuffer.append(' ');
            }
            fontLabelBuffer.append(TargetVMMessages.getString("Environment.FontLabel.Style.Italic"));
            styleUsed = true;
        }
        if (styleUsed) {
            fontLabelBuffer.append(',');
        }
        fontLabelBuffer.append(String.valueOf(fontData.getHeight()));
        return fontLabelBuffer.toString();
    }

    private static class FreeFormDisposeListener
    implements DisposeListener {
        private final Composite ffContainer;

        public FreeFormDisposeListener(Composite ffContainer) {
            this.ffContainer = ffContainer;
        }

        public void widgetDisposed(DisposeEvent e) {
            if (!this.ffContainer.isDisposed()) {
                this.ffContainer.getDisplay().asyncExec(new Runnable(this){
                    final /* synthetic */ FreeFormDisposeListener this$1;
                    {
                        this.this$1 = freeFormDisposeListener;
                    }

                    public void run() {
                        if (!FreeFormDisposeListener.access$0(this.this$1).isDisposed()) {
                            FreeFormDisposeListener.access$0(this.this$1).dispose();
                        }
                    }
                });
            }
        }

        static /* synthetic */ Composite access$0(FreeFormDisposeListener freeFormDisposeListener) {
            return freeFormDisposeListener.ffContainer;
        }
    }
}

