/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.core;

import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ve.internal.cde.core.EditDomain;
import org.eclipse.ve.internal.cde.emf.EMFEditDomainHelper;
import org.eclipse.ve.internal.cdm.CDMFactory;
import org.eclipse.ve.internal.cdm.Diagram;
import org.eclipse.ve.internal.java.codegen.core.IVEModelInstance;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.VEModelCacheUtility;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.BeanSubclassComposition;
import org.eclipse.ve.internal.jcm.JCMFactory;

public class VEModelInstance
implements IVEModelInstance {
    Resource fResource = null;
    BeanSubclassComposition fRoot = null;
    String fUri;
    EditDomain fEDomain;
    IFile fInputFile;
    boolean isFromCache = false;

    public VEModelInstance(IFile file, EditDomain domain) {
        this.fInputFile = file;
        this.fUri = VEModelCacheUtility.getCacheURI(file).toString();
        this.fEDomain = domain;
    }

    public BeanSubclassComposition getModelRoot() {
        return this.fRoot;
    }

    public Resource getModelResource() {
        return this.fResource;
    }

    public ResourceSet getModelResourceSet() {
        return EMFEditDomainHelper.getResourceSet((EditDomain)this.fEDomain);
    }

    public void clearModel() {
        this.fResource = null;
        if (this.fRoot != null) {
            this.fRoot.eAdapters().clear();
        }
        this.fRoot = null;
        this.fUri = null;
    }

    public EObject createComposition(boolean ignoreCache) throws CodeGenException {
        if (this.fUri == null) {
            throw new CodeGenException("Model URI is not set");
        }
        ResourceSet rs = this.getModelResourceSet();
        Resource cr = rs.getResource(URI.createURI((String)this.fUri), false);
        if (cr != null) {
            rs.getResources().remove((Object)cr);
        }
        if (!ignoreCache && (this.fResource = VEModelCacheUtility.doLoadFromCache(this, null)) != null) {
            this.fRoot = (BeanSubclassComposition)this.fResource.getEObject("/");
            this.fUri = this.fResource.getURI().toString();
            JavaVEPlugin.log((Object)"Loading EMF model from cache", (Level)Level.FINE);
            this.isFromCache = true;
        } else {
            this.fResource = rs.createResource(URI.createURI((String)this.fUri));
            this.fRoot = JCMFactory.eINSTANCE.createBeanSubclassComposition();
            Diagram d = CDMFactory.eINSTANCE.createDiagram();
            d.setId("org.eclipse.ve.internal.cdm.primarydiagram");
            this.fRoot.getDiagrams().add((Object)d);
            this.fResource.getContents().add((Object)this.fRoot);
            this.isFromCache = false;
        }
        return this.fRoot;
    }

    public Diagram getDiagram() {
        if (this.fRoot == null) {
            return null;
        }
        EList diagrams = this.fRoot.getDiagrams();
        int i = 0;
        while (i < diagrams.size()) {
            Diagram element = (Diagram)diagrams.get(i);
            if ("org.eclipse.ve.internal.cdm.primarydiagram".equals(element.getId())) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public String getURI() {
        return this.fUri;
    }

    public IFile getFile() {
        return this.fInputFile;
    }

    public boolean isFromCache() {
        return this.isFromCache;
    }

    public void loadFromCacheComplete() {
        if (this.isFromCache) {
            VEModelCacheUtility.removeCacheAnnotationFromEMFModel(this);
            this.isFromCache = false;
        }
    }
}

