/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.editorpart;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ve.internal.cde.core.CDEPlugin;
import org.eclipse.ve.internal.java.codegen.editorpart.CodegenEditorPartMessages;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;

class JavaVisualEditorReloadActionController {
    private static final String JVE_STATUS_MSG_ERROR = CodegenEditorPartMessages.JVE_STATUS_MSG_ERROR;
    private static final String JVE_STATUS_BAR_MSG_PARSE_ERROR = CodegenEditorPartMessages.JVE_STATUS_BAR_MSG_PARSE_ERROR_;
    private static final String JVE_STATUS_MSG_PAUSE = CodegenEditorPartMessages.JVE_STATUS_MSG_PAUSE;
    private static final String JVE_STATUS_MSG_RELOAD = CodegenEditorPartMessages.JVE_STATUS_MSG_RELOAD;
    public static final ImageDescriptor PLAY_IMAGE_DESCRIPTOR = CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/refresh_obj.gif");
    public static final ImageDescriptor PAUSE_IMAGE_DESCRIPTOR = CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/pause.gif");
    public static final ImageDescriptor ERROR_IMAGE_DESCRIPTOR = CDEPlugin.getImageDescriptorFromPlugin((Plugin)JavaVEPlugin.getPlugin(), (String)"icons/full/cview16/error_obj.gif");
    public static final String RELOAD_ACTION_ID = "org.eclipse.ve.java.core.Reload";
    private GraphicalViewer viewer;
    private Boolean pauseType;
    private Figure pauseFigure;
    private Label pauseLabelFigure;
    private IReloadCallback reloadCallback;
    private Action reloadAction = new Action("", 2){

        public void run() {
            if (this.isChecked()) {
                JavaVisualEditorReloadActionController.this.showPause();
                JavaVisualEditorReloadActionController.this.reloadCallback.pause();
            } else {
                JavaVisualEditorReloadActionController.this.removeParseFigure();
                JavaVisualEditorReloadActionController.this.reloadCallback.reload(true);
            }
        }
    };
    private FigureListener rootFigureListener = new FigureListener(){

        public void figureMoved(IFigure source) {
            JavaVisualEditorReloadActionController.this.pauseFigure.revalidate();
            JavaVisualEditorReloadActionController.this.pauseLabelFigure.revalidate();
        }
    };
    private PropertyChangeListener scrolledListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            if ("value".equals(evt.getPropertyName())) {
                JavaVisualEditorReloadActionController.this.pauseFigure.revalidate();
                JavaVisualEditorReloadActionController.this.pauseLabelFigure.revalidate();
            }
        }
    };

    public JavaVisualEditorReloadActionController(IReloadCallback reloadCallback) {
        this.reloadCallback = reloadCallback;
        this.reloadAction.setId(RELOAD_ACTION_ID);
        this.setupAction();
        this.reloadAction.setEnabled(false);
    }

    private void setupAction() {
        if (this.pauseType == Boolean.TRUE) {
            this.reloadAction.setToolTipText(JVE_STATUS_BAR_MSG_PARSE_ERROR);
            this.reloadAction.setText(JVE_STATUS_MSG_ERROR);
            this.reloadAction.setHoverImageDescriptor(ERROR_IMAGE_DESCRIPTOR);
            this.reloadAction.setChecked(true);
        } else if (this.pauseType == Boolean.FALSE) {
            this.reloadAction.setToolTipText(JVE_STATUS_MSG_RELOAD);
            this.reloadAction.setText(JVE_STATUS_MSG_RELOAD);
            this.reloadAction.setHoverImageDescriptor(PLAY_IMAGE_DESCRIPTOR);
            this.reloadAction.setChecked(true);
        } else {
            this.reloadAction.setToolTipText(JVE_STATUS_MSG_PAUSE);
            this.reloadAction.setText(JVE_STATUS_MSG_PAUSE);
            this.reloadAction.setHoverImageDescriptor(PAUSE_IMAGE_DESCRIPTOR);
            this.reloadAction.setChecked(false);
        }
        this.reloadAction.setEnabled(false);
        this.reloadAction.setEnabled(true);
    }

    public Action getReloadAction() {
        return this.reloadAction;
    }

    public void startListening(GraphicalViewer viewer) {
        this.viewer = viewer;
        this.pauseFigure = new Figure(){
            Locator locator = new Locator(this){
                final /* synthetic */ 4 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void relocate(IFigure target) {
                    Rectangle b = JavaVisualEditorReloadActionController.access$3(4.access$0(this.this$1), target).getClientArea().getCopy();
                    target.translateToRelative((Translatable)b);
                    target.setBounds(b);
                }
            };

            protected void paintFigure(Graphics graphics) {
                try {
                    graphics.setAlpha(125);
                    graphics.setBackgroundColor(Display.getCurrent().getSystemColor(15));
                    graphics.fillRectangle(this.getClientArea());
                }
                catch (SWTException sWTException) {}
            }

            public void validate() {
                if (!this.isValid()) {
                    this.locator.relocate((IFigure)this);
                }
                super.validate();
            }

            static /* synthetic */ JavaVisualEditorReloadActionController access$0(4 var0) {
                return var0.JavaVisualEditorReloadActionController.this;
            }
        };
        this.pauseLabelFigure = new Label(){
            Locator locator = new Locator(this){
                final /* synthetic */ 6 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void relocate(IFigure target) {
                    Dimension canvasSize = JavaVisualEditorReloadActionController.access$3(6.access$0(this.this$1), target).getSize();
                    Dimension prefSize = target.getPreferredSize();
                    int newX = (canvasSize.width - prefSize.width) / 2;
                    int newY = (canvasSize.height - prefSize.height) / 2;
                    Rectangle b = new Rectangle(newX, newY, prefSize.width, prefSize.height).expand(new Insets(10, 25, 10, 25));
                    target.translateToRelative((Translatable)b);
                    target.setBounds(b);
                }
            };

            public void validate() {
                if (!this.isValid()) {
                    this.locator.relocate((IFigure)this);
                }
                super.validate();
            }

            static /* synthetic */ JavaVisualEditorReloadActionController access$0(6 var0) {
                return var0.JavaVisualEditorReloadActionController.this;
            }
        };
        this.pauseFigure.setEnabled(false);
        this.pauseLabelFigure.setEnabled(true);
        this.pauseLabelFigure.setOpaque(true);
        if (this.pauseType != null) {
            this.showPauseFigure(this.pauseType);
        }
    }

    public void showParseError() {
        if (this.pauseType != Boolean.TRUE) {
            this.showPauseFigure(Boolean.TRUE);
            this.setupAction();
        }
    }

    public void showPause() {
        if (this.pauseType != Boolean.FALSE) {
            this.showPauseFigure(Boolean.FALSE);
            this.setupAction();
        }
    }

    public void runPause() {
        if (this.pauseType != Boolean.FALSE) {
            this.showPause();
            this.reloadCallback.pause();
        }
    }

    public void dispose() {
        this.removeParseFigure();
        this.viewer = null;
    }

    protected Layer getLoadingLayer() {
        return (Layer)LayerManager.Helper.find((EditPart)this.viewer.getRootEditPart()).getLayer((Object)"Handle Layer");
    }

    private void showPauseFigure(Boolean pauseType) {
        this.pauseType = pauseType;
        if (pauseType.booleanValue()) {
            return;
        }
        if (this.viewer != null) {
            String label;
            Image image = this.pauseLabelFigure.getIcon();
            if (image != null) {
                image.dispose();
                image = null;
            }
            if (pauseType.booleanValue()) {
                image = ERROR_IMAGE_DESCRIPTOR.createImage();
                label = CodegenEditorPartMessages.JavaVisualEditorReloadActionController_PARSE_ERROR;
            } else {
                image = PLAY_IMAGE_DESCRIPTOR.createImage();
                label = CodegenEditorPartMessages.JavaVisualEditorReloadActionController_PAUSED;
            }
            this.pauseLabelFigure.setText(label);
            this.pauseLabelFigure.setIcon(image);
            Layer loadingLayer = this.getLoadingLayer();
            loadingLayer.add((IFigure)this.pauseFigure);
            loadingLayer.add((IFigure)this.pauseLabelFigure);
            Viewport vp = this.getViewport((IFigure)loadingLayer);
            if (vp != null) {
                vp.getHorizontalRangeModel().addPropertyChangeListener(this.scrolledListener);
                vp.getVerticalRangeModel().addPropertyChangeListener(this.scrolledListener);
            }
            this.getRootFigure((IFigure)loadingLayer).addFigureListener(this.rootFigureListener);
            this.pauseFigure.revalidate();
            this.pauseLabelFigure.revalidate();
        }
    }

    public void removeParseFigure() {
        if (this.pauseType == null) {
            return;
        }
        this.pauseType = null;
        if (this.viewer != null && this.pauseFigure.getParent() != null) {
            Layer layer = this.getLoadingLayer();
            layer.remove((IFigure)this.pauseFigure);
            layer.remove((IFigure)this.pauseLabelFigure);
            Image image = this.pauseLabelFigure.getIcon();
            this.pauseLabelFigure.setIcon(null);
            image.dispose();
            Viewport vp = this.getViewport((IFigure)layer);
            if (vp != null) {
                vp.getHorizontalRangeModel().removePropertyChangeListener(this.scrolledListener);
                vp.getVerticalRangeModel().removePropertyChangeListener(this.scrolledListener);
            }
            this.getRootFigure((IFigure)layer).removeFigureListener(this.rootFigureListener);
        }
        this.setupAction();
    }

    private Viewport getViewport(IFigure figure) {
        IFigure f = figure;
        while (f != null && !(f instanceof Viewport)) {
            f = f.getParent();
        }
        return (Viewport)f;
    }

    private IFigure getRootFigure(IFigure target) {
        IFigure parent = target.getParent();
        while (parent.getParent() != null) {
            parent = parent.getParent();
        }
        return parent;
    }

    static /* synthetic */ IFigure access$3(JavaVisualEditorReloadActionController javaVisualEditorReloadActionController, IFigure iFigure) {
        return javaVisualEditorReloadActionController.getRootFigure(iFigure);
    }

    public static interface IReloadCallback {
        public void pause();

        public void reload(boolean var1);
    }
}

