/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.ve.internal.cdm.Annotation;
import org.eclipse.ve.internal.java.codegen.java.BeanPartFactory;
import org.eclipse.ve.internal.java.codegen.java.ChildRelationshipDecoderHelper;
import org.eclipse.ve.internal.java.codegen.java.ExpressionRefFactory;
import org.eclipse.ve.internal.java.codegen.java.rules.IThisReferenceRule;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.BeanPartDecleration;
import org.eclipse.ve.internal.java.codegen.model.CodeCallBackRef;
import org.eclipse.ve.internal.java.codegen.model.CodeEventHandlerRef;
import org.eclipse.ve.internal.java.codegen.model.CodeEventRef;
import org.eclipse.ve.internal.java.codegen.model.CodeExpressionRef;
import org.eclipse.ve.internal.java.codegen.model.CodeMethodRef;
import org.eclipse.ve.internal.java.codegen.model.CodeTypeRef;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;
import org.eclipse.ve.internal.java.codegen.util.CodeGenException;
import org.eclipse.ve.internal.java.codegen.util.CodeGenUtil;
import org.eclipse.ve.internal.java.codegen.util.TypeResolver;
import org.eclipse.ve.internal.java.core.JavaVEPlugin;
import org.eclipse.ve.internal.jcm.BeanSubclassComposition;

public class BDMMerger {
    protected IBeanDeclModel mainModel = null;
    protected IBeanDeclModel newModel = null;
    protected List changedHandles = null;
    protected IProgressMonitor monitor;
    protected List needToRedecodeExpressions = new ArrayList();
    protected HashMap newBDMToMainBDMBeanPartMap = new HashMap();
    protected HashMap expressionEquivalencyMap = new HashMap();

    public BDMMerger(IBeanDeclModel mainModel, IBeanDeclModel newModel, List changedHandles, IProgressMonitor mon) {
        this.mainModel = mainModel;
        this.newModel = newModel;
        this.changedHandles = changedHandles;
        this.needToRedecodeExpressions.clear();
        this.monitor = mon != null ? mon : new NullProgressMonitor();
    }

    public boolean merge() throws CodeGenException {
        boolean merged = true;
        if (this.mainModel != null && this.newModel != null) {
            if (this.mainModel.isStateSet(1) || this.monitor.isCanceled()) {
                return true;
            }
            boolean bl = merged = merged && this.updateTypeRef();
            if (this.mainModel.isStateSet(1) || this.monitor.isCanceled()) {
                return true;
            }
            boolean bl2 = merged = merged && this.activateDeactivatedBeans();
            if (this.mainModel.isStateSet(1) || this.monitor.isCanceled()) {
                return true;
            }
            boolean bl3 = merged = merged && this.removeDeletedBeans();
            if (this.mainModel.isStateSet(1) || this.monitor.isCanceled()) {
                return true;
            }
            boolean bl4 = merged = merged && this.removeDeletedMethods();
            if (this.mainModel.isStateSet(1) || this.monitor.isCanceled()) {
                return true;
            }
            boolean bl5 = merged = merged && this.updateEventHandlers();
            if (this.mainModel.isStateSet(1) || this.monitor.isCanceled()) {
                return true;
            }
            boolean bl6 = merged = merged && this.addNewBeans();
            if (this.mainModel.isStateSet(1) || this.monitor.isCanceled()) {
                return true;
            }
            boolean bl7 = merged = merged && this.addThisMethod();
            if (this.mainModel.isStateSet(1) || this.monitor.isCanceled()) {
                return true;
            }
            boolean bl8 = merged = merged && this.updateMethods();
            if (this.mainModel.isStateSet(1) || this.monitor.isCanceled()) {
                return true;
            }
            boolean bl9 = merged = merged && this.mergeAllBeans();
            if (this.mainModel.isStateSet(1) || this.monitor.isCanceled()) {
                return true;
            }
            boolean bl10 = merged = merged && this.deactivateUnreferencedBeans();
            if (this.mainModel.isStateSet(1) || this.monitor.isCanceled()) {
                return true;
            }
            boolean bl11 = merged = merged && this.updateFreeForm();
            if (this.mainModel.isStateSet(1) || this.monitor.isCanceled()) {
                return true;
            }
            CodeGenUtil.markSameLineExpressions(this.mainModel);
            if (this.mainModel.isStateSet(1) || this.monitor.isCanceled()) {
                return true;
            }
            merged = merged && this.clean();
        }
        this.needToRedecodeExpressions.clear();
        this.expressionEquivalencyMap.clear();
        this.newBDMToMainBDMBeanPartMap.clear();
        return merged;
    }

    private boolean updateTypeRef() {
        CodeTypeRef mainType = this.mainModel.getTypeRef();
        CodeTypeRef newType = this.newModel.getTypeRef();
        if (mainType != null && newType != null) {
            mainType.refresh(newType);
        }
        this.mainModel.setTypeDecleration(this.newModel.getTypeDecleration());
        return true;
    }

    private boolean deactivateUnreferencedBeans() {
        BeanPart[] unreferencedBPs = this.mainModel.getUnreferencedBeanParts();
        int bpCount = 0;
        while (bpCount < unreferencedBPs.length) {
            unreferencedBPs[bpCount].deactivate();
            ++bpCount;
        }
        return true;
    }

    private boolean activateDeactivatedBeans() {
        Iterator mainBeansItr = this.mainModel.getBeans().iterator();
        while (mainBeansItr.hasNext()) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            BeanPart mainBean = (BeanPart)mainBeansItr.next();
            if (mainBean == null || mainBean.isActive()) continue;
            mainBean.activate();
        }
        return true;
    }

    private int determineEquivalency(CodeExpressionRef exp1, CodeExpressionRef exp2) throws CodeGenException {
        int equivalency;
        HashMap exp2Map;
        HashMap exp1Map;
        boolean exp1_exp2_cacheFound = false;
        boolean exp2_exp1_cacheFound = false;
        if (this.expressionEquivalencyMap.containsKey(exp1) && (exp1Map = (HashMap)this.expressionEquivalencyMap.get(exp1)) != null && exp1Map.containsKey(exp2)) {
            exp1_exp2_cacheFound = true;
        }
        if (!exp2_exp1_cacheFound && this.expressionEquivalencyMap.containsKey(exp2) && (exp2Map = (HashMap)this.expressionEquivalencyMap.get(exp2)) != null && exp2Map.containsKey(exp1)) {
            exp2_exp1_cacheFound = true;
        }
        if (exp1_exp2_cacheFound || exp2_exp1_cacheFound) {
            HashMap map = (HashMap)(exp1_exp2_cacheFound ? this.expressionEquivalencyMap.get(exp1) : this.expressionEquivalencyMap.get(exp2));
            Integer eqInt = (Integer)map.get(exp1_exp2_cacheFound ? exp2 : exp1);
            equivalency = eqInt;
        } else {
            HashMap<CodeExpressionRef, Integer> map = (HashMap<CodeExpressionRef, Integer>)this.expressionEquivalencyMap.get(exp1);
            if (map == null) {
                map = new HashMap<CodeExpressionRef, Integer>();
                this.expressionEquivalencyMap.put(exp1, map);
            }
            equivalency = exp1.isEquivalent(exp2);
            map.put(exp2, new Integer(equivalency));
        }
        return equivalency;
    }

    private boolean clean() {
        boolean cleaned = true;
        if (this.mainModel.getBeans() != null) {
            Iterator beanItr = this.mainModel.getBeans().iterator();
            while (beanItr.hasNext()) {
                BeanPart bp = (BeanPart)beanItr.next();
                bp.getParentExpressons().clear();
                List badExpressions = bp.getBadExpressions();
                if (badExpressions == null || badExpressions.size() <= 0) continue;
                int badExpCount = 0;
                while (badExpCount < badExpressions.size()) {
                    CodeExpressionRef exp = (CodeExpressionRef)badExpressions.get(badExpCount);
                    badExpressions.remove(exp);
                    exp.dispose();
                    --badExpCount;
                    ++badExpCount;
                }
            }
        }
        return cleaned;
    }

    protected boolean updateMethods() {
        if (this.newModel.getTypeRef() != null) {
            Iterator newMethodsItr = this.newModel.getTypeRef().getMethods();
            while (newMethodsItr.hasNext()) {
                if (this.monitor.isCanceled()) {
                    return false;
                }
                CodeMethodRef updMethod = (CodeMethodRef)newMethodsItr.next();
                CodeMethodRef mainMethod = this.mainModel.getMethod(updMethod.getMethodHandle());
                if (mainMethod == null) {
                    this.createNewMainMethodRef(updMethod);
                    continue;
                }
                this.updateMethodOffsetAndContent(mainMethod, updMethod);
            }
        }
        return true;
    }

    protected boolean updateFreeForm() {
        try {
            Iterator itr = this.mainModel.getBeans().iterator();
            while (itr.hasNext()) {
                if (this.monitor.isCanceled()) {
                    return false;
                }
                if (this.mainModel.isStateSet(1)) {
                    return true;
                }
                BeanPart bean = (BeanPart)itr.next();
                if (!bean.isActive()) continue;
                CodeGenUtil.addBeanToBSC(bean, this.mainModel.getCompositionModel().getModelRoot(), true);
                if (bean.getFFDecoder() == null) continue;
                this.monitor.subTask(bean.getSimpleName());
                bean.getFFDecoder().decode();
            }
        }
        catch (CodeGenException e) {
            JavaVEPlugin.log((Throwable)((Object)e), (Level)Level.WARNING);
            return false;
        }
        return true;
    }

    protected boolean removeMethodRef(CodeMethodRef m) {
        if (m != null) {
            Collection initBPs = this.mainModel.getBeansInitilizedByMethod(m);
            BeanPart retBP = this.mainModel.getBeanReturned(m.getMethodName());
            Iterator iter = initBPs.iterator();
            while (iter.hasNext()) {
                BeanPart bp = (BeanPart)iter.next();
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Disposing init bean " + bp.getSimpleName() + " when disposing method " + m.getMethodHandle()), (Level)Level.FINER);
                }
                if ("this".equals(bp.getSimpleName())) continue;
                bp.dispose();
            }
            if (retBP != null && !initBPs.contains(retBP)) {
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Disposing return bean " + retBP.getSimpleName() + " when disposing method " + m.getMethodHandle()), (Level)Level.FINER);
                }
                if (!"this".equals(retBP.getSimpleName())) {
                    retBP.dispose();
                }
            }
            m.dispose();
            return true;
        }
        return false;
    }

    protected boolean removeDeletedMethods() {
        boolean removed = true;
        Iterator methods = this.mainModel.getAllMethods();
        while (methods.hasNext()) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            CodeMethodRef m = (CodeMethodRef)methods.next();
            if (this.newModel.getMethod(m.getMethodHandle()) != null) continue;
            this.monitor.subTask(m.getMethodName());
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                JavaVEPlugin.log((Object)("BDM Merger >> Removing method " + m.getMethodHandle() + "since it is not found in update"), (Level)Level.FINER);
            }
            boolean bl = removed = removed && this.removeMethodRef(m);
        }
        return removed;
    }

    protected boolean updateMethodOffsetAndContent(CodeMethodRef mainMethod, CodeMethodRef updatedMethod) {
        if (mainMethod == null || updatedMethod == null) {
            return false;
        }
        return mainMethod.refresh(updatedMethod);
    }

    protected void updateReturnMethod(BeanPart mainBP, BeanPart updatedBP) {
        CodeMethodRef retMainBP = mainBP.getReturnedMethod();
        CodeMethodRef retUpdatedBP = updatedBP.getReturnedMethod();
        if (retMainBP == null && retUpdatedBP == null) {
            return;
        }
        if (retMainBP == null && retUpdatedBP != null) {
            CodeMethodRef mainRetM = this.mainModel.getMethod(retUpdatedBP.getMethodHandle());
            if (mainRetM != null) {
                mainBP.addReturnMethod(mainRetM);
            }
            return;
        }
        if (retMainBP != null && retUpdatedBP == null) {
            mainBP.removeReturnMethod(retMainBP);
            return;
        }
        if (!retMainBP.getMethodHandle().equals(retUpdatedBP.getMethodHandle())) {
            mainBP.removeReturnMethod(retMainBP);
            CodeMethodRef mainRetM = this.mainModel.getMethod(retUpdatedBP.getMethodHandle());
            if (mainRetM != null) {
                mainBP.addReturnMethod(mainRetM);
            }
            return;
        }
    }

    protected boolean removeDeletedCallBackExpression(CodeCallBackRef mainExp) {
        mainExp.dispose();
        return true;
    }

    protected void checkEventExpNeedsRedecoding(CodeCallBackRef mainCBExp) {
        if (mainCBExp != null && mainCBExp.getBean() != null) {
            Collection eventExps = mainCBExp.getBean().getRefEventExpressions();
            Iterator iter = eventExps.iterator();
            while (iter.hasNext()) {
                CodeExpressionRef exp = (CodeExpressionRef)iter.next();
                if (this.needToRedecodeExpressions.contains(exp)) continue;
                this.needToRedecodeExpressions.add(exp);
            }
        }
    }

    protected boolean processSameCallBackExpression(CodeCallBackRef main, CodeCallBackRef updExp) {
        if (main.getOffset() != updExp.getOffset()) {
            main.setOffset(updExp.getOffset());
        }
        main.setContent(updExp.getContentParser());
        main.setExprStmt(updExp.getExprStmt());
        return true;
    }

    protected boolean addNewCallBackExpression(CodeCallBackRef newExp) {
        boolean added = false;
        CodeMethodRef newMethodRef = newExp.getMethod();
        BeanPart newBean = newExp.getBean();
        if (newMethodRef != null && newExp != null) {
            CodeMethodRef mainMethod = this.mainModel.getMethod(newMethodRef.getMethodHandle());
            BeanPart mainBean = this.determineCorrespondingBeanPart(newBean, this.mainModel);
            if (mainMethod != null && mainBean != null) {
                CodeCallBackRef callBack = new CodeCallBackRef(newExp.getExprStmt(), mainMethod);
                callBack.setBean(mainBean);
                this.checkEventExpNeedsRedecoding(callBack);
                added = true;
            }
        }
        return added;
    }

    protected boolean updateCallBackExpressions(BeanPart mainBeanPart, BeanPart updatedBeanPart) {
        boolean processed = true;
        ArrayList mainCallBackExpressions = new ArrayList(mainBeanPart.getRefCallBackExpressions());
        ArrayList updatedCallBackExpressions = new ArrayList(updatedBeanPart.getRefCallBackExpressions());
        int mainExpCount = 0;
        while (mainExpCount < mainCallBackExpressions.size()) {
            CodeCallBackRef mainExp = (CodeCallBackRef)mainCallBackExpressions.get(mainExpCount);
            boolean equivalentExpFound = false;
            int updatedExpCount = 0;
            while (updatedExpCount < updatedCallBackExpressions.size()) {
                CodeCallBackRef updExp = (CodeCallBackRef)updatedCallBackExpressions.get(updatedExpCount);
                if (mainExp != null && updExp != null && !updExp.isStateSet(256)) {
                    boolean contentSame = false;
                    contentSame = mainExp.getContent().equals(updExp.getContent());
                    if (contentSame) {
                        equivalentExpFound = true;
                        processed = processed && this.processSameCallBackExpression(mainExp, updExp);
                        mainCallBackExpressions.remove(mainCallBackExpressions.indexOf(mainExp));
                        updatedCallBackExpressions.remove(updatedCallBackExpressions.indexOf(updExp));
                        --mainExpCount;
                        --updatedExpCount;
                        break;
                    }
                }
                ++updatedExpCount;
            }
            if (!equivalentExpFound) {
                mainCallBackExpressions.remove(mainCallBackExpressions.indexOf(mainExp));
                --mainExpCount;
                this.checkEventExpNeedsRedecoding(mainExp);
                this.removeDeletedCallBackExpression(mainExp);
            }
            ++mainExpCount;
        }
        int newExpCount = 0;
        while (newExpCount < updatedCallBackExpressions.size()) {
            CodeCallBackRef exp = (CodeCallBackRef)updatedCallBackExpressions.get(newExpCount);
            processed = processed && this.addNewCallBackExpression(exp);
            ++newExpCount;
        }
        return processed;
    }

    protected boolean updateEventExpressions(BeanPart mainBeanPart, BeanPart updatedBeanPart) {
        ArrayList allMainBPExpressions = new ArrayList(mainBeanPart.getRefEventExpressions());
        ArrayList allUpdateBPExpressions = new ArrayList(updatedBeanPart.getRefEventExpressions());
        return this.processExpressions(allMainBPExpressions, allUpdateBPExpressions);
    }

    protected boolean updateNonRegularBeanPartExpressions(BeanPart mainBeanPart, BeanPart updatedBeanPart) {
        this.updateMethodOffsetAndContent(mainBeanPart.getInitMethod(), updatedBeanPart.getInitMethod());
        this.updateReturnMethod(mainBeanPart, updatedBeanPart);
        boolean update = this.updateCallBackExpressions(mainBeanPart, updatedBeanPart);
        update = update && this.updateParentExpressions(mainBeanPart, updatedBeanPart);
        update = update && this.updateEventExpressions(mainBeanPart, updatedBeanPart);
        return update;
    }

    protected boolean updateParentExpressions(BeanPart mainBeanPart, BeanPart updatedBeanPart) {
        boolean updated = true;
        ArrayList updatedParentExpressions = new ArrayList(updatedBeanPart.getParentExpressons());
        int uc = 0;
        while (uc < updatedParentExpressions.size()) {
            CodeMethodRef newExpMethod;
            CodeExpressionRef updateParentExpression = (CodeExpressionRef)updatedParentExpressions.get(uc);
            if (updateParentExpression != null && updateParentExpression.getExprStmt() != null && updateParentExpression.getMethod() != null && updateParentExpression.getMethod().getMethodHandle() != null && (newExpMethod = this.mainModel.getMethod(updateParentExpression.getMethod().getMethodHandle())) != null) {
                CodeExpressionRef mainParentExp = null;
                if (updateParentExpression.getCodeContent() != null) {
                    Iterator exps = newExpMethod.getAllExpressions();
                    while (exps.hasNext()) {
                        CodeExpressionRef mainExp = (CodeExpressionRef)exps.next();
                        if (mainExp.isStateSet(8) || !updateParentExpression.getCodeContent().equals(mainExp.getCodeContent())) continue;
                        mainParentExp = mainExp;
                        break;
                    }
                }
                if (mainParentExp == null) {
                    CodeExpressionRef newExp = new CodeExpressionRef(updateParentExpression.getExprStmt(), newExpMethod);
                    mainBeanPart.addParentExpression(newExp);
                    this.needToRedecodeExpressions.add(mainBeanPart.getInitExpression());
                } else {
                    this.processEquivalentExpressions(mainParentExp, updateParentExpression, 1);
                }
            }
            ++uc;
        }
        return updated;
    }

    protected boolean processEquivalentExpressions(CodeExpressionRef mainExp, CodeExpressionRef newExp, int equivalencyLevel) {
        if (newExp.getBean() != null) {
            newExp.getBean().setProxy(mainExp.getBean());
        }
        switch (equivalencyLevel) {
            case 0: {
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Updating changed expression " + newExp.getCodeContent()), (Level)Level.FINER);
                }
                if (mainExp.isStateSet(4)) break;
                if (mainExp.getOffset() != newExp.getOffset()) {
                    mainExp.setOffset(newExp.getOffset());
                }
                mainExp.refreshFromJOM(newExp);
                break;
            }
            case 1: {
                if (mainExp.getOffset() == newExp.getOffset()) {
                    mainExp.setContent(newExp.getContentParser());
                    mainExp.setExprStmt(newExp.getExprStmt());
                    if (!this.needToRedecodeExpressions.contains(mainExp)) break;
                    mainExp.refreshFromJOM(newExp);
                    break;
                }
                mainExp.setOffset(newExp.getOffset());
                mainExp.setExprStmt(newExp.getExprStmt());
                if (newExp instanceof CodeEventRef && !this.needToRedecodeExpressions.contains(mainExp)) break;
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Updating because of changed offset " + newExp.getCodeContent()), (Level)Level.FINER);
                }
                mainExp.refreshFromJOM(newExp);
            }
        }
        if (newExp.getBean() != null) {
            newExp.getBean().setProxy(null);
        }
        return true;
    }

    protected void removeDeletedExpression(CodeExpressionRef deletedExp) {
        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
            JavaVEPlugin.log((Object)("BDM Merger >> Remove deleted expression " + deletedExp.getCodeContent()), (Level)Level.FINER);
        }
        EObject o = deletedExp.getBean().getEObject();
        deletedExp.dispose();
        CodeGenUtil.snoozeAlarm(o, this.mainModel.getCompositionModel().getModelResourceSet(), new HashMap());
    }

    protected void updateChangedOffsetsAndMarkExpressions(Collection mainExpressions, Collection updatedExpressions) {
        ArrayList mainExpTobeProcessed = new ArrayList(mainExpressions);
        ArrayList updatedExpTobeProcessed = new ArrayList(updatedExpressions);
        int updatedExpCount = 0;
        while (updatedExpCount < updatedExpTobeProcessed.size()) {
            CodeExpressionRef updExp = (CodeExpressionRef)updatedExpTobeProcessed.get(updatedExpCount);
            boolean equivalentExpFound = false;
            int mainExpCount = 0;
            while (mainExpCount < mainExpTobeProcessed.size()) {
                CodeExpressionRef mainExp = (CodeExpressionRef)mainExpTobeProcessed.get(mainExpCount);
                if (mainExp != null && updExp != null && !updExp.isStateSet(256)) {
                    int equivalency = -1;
                    try {
                        equivalency = this.determineEquivalency(mainExp, updExp);
                    }
                    catch (CodeGenException codeGenException) {}
                    if (equivalency >= 0) {
                        equivalentExpFound = true;
                        switch (equivalency) {
                            case 0: {
                                if (mainExp.isStateSet(4)) break;
                                if (mainExp.getOffset() != updExp.getOffset()) {
                                    mainExp.setOffset(updExp.getOffset());
                                }
                                this.needToRedecodeExpressions.add(mainExp);
                                break;
                            }
                            case 1: {
                                if (mainExp.getOffset() == updExp.getOffset()) break;
                                mainExp.setOffset(updExp.getOffset());
                                this.needToRedecodeExpressions.add(mainExp);
                            }
                        }
                        mainExpTobeProcessed.remove(mainExpTobeProcessed.indexOf(mainExp));
                        updatedExpTobeProcessed.remove(updatedExpTobeProcessed.indexOf(updExp));
                        --mainExpCount;
                        --updatedExpCount;
                        break;
                    }
                }
                ++mainExpCount;
            }
            if (!equivalentExpFound) {
                updatedExpTobeProcessed.remove(updatedExpTobeProcessed.indexOf(updExp));
                --updatedExpCount;
            }
            ++updatedExpCount;
        }
    }

    protected int isSpecialEquivalent(CodeExpressionRef mainExp, CodeExpressionRef updExp) throws CodeGenException {
        if (mainExp.isStateSet(4096) && updExp.isStateSet(4096)) {
            if (mainExp.equals(updExp)) {
                return 1;
            }
            BeanPart mainBP = mainExp.getBean();
            BeanPart updBP = updExp.getBean();
            if (mainBP == null && updBP != null) {
                return -1;
            }
            if (mainBP != null && updBP == null) {
                return -1;
            }
            if (mainBP.getSimpleName().equals(updBP.getSimpleName()) && mainBP.getType().equals(updBP.getType())) {
                if (!mainExp.isStateSet(8) && !updExp.isStateSet(8)) {
                    if (mainExp.getCodeContent().equals(updExp.getCodeContent())) {
                        return 1;
                    }
                    return 0;
                }
                return 1;
            }
            return -1;
        }
        return this.determineEquivalency(mainExp, updExp);
    }

    protected boolean processExpressions(Collection mainExpressions, Collection updatedExpressions) {
        this.updateChangedOffsetsAndMarkExpressions(mainExpressions, updatedExpressions);
        boolean processed = true;
        ArrayList mainExpTobeProcessed = new ArrayList(mainExpressions);
        ArrayList updatedExpTobeProcessed = new ArrayList(updatedExpressions);
        int updatedExpCount = 0;
        while (updatedExpCount < updatedExpTobeProcessed.size()) {
            CodeExpressionRef updExp = (CodeExpressionRef)updatedExpTobeProcessed.get(updatedExpCount);
            boolean equivalentExpFound = false;
            int mainExpCount = 0;
            while (mainExpCount < mainExpTobeProcessed.size()) {
                CodeExpressionRef mainExp = (CodeExpressionRef)mainExpTobeProcessed.get(mainExpCount);
                if (mainExp != null && updExp != null && !updExp.isStateSet(256)) {
                    int equivalency = -1;
                    try {
                        equivalency = this.determineEquivalency(mainExp, updExp);
                    }
                    catch (CodeGenException codeGenException) {}
                    if (equivalency >= 0) {
                        equivalentExpFound = true;
                        processed = processed && this.processEquivalentExpressions(mainExp, updExp, equivalency);
                        mainExpTobeProcessed.remove(mainExpTobeProcessed.indexOf(mainExp));
                        updatedExpTobeProcessed.remove(updatedExpTobeProcessed.indexOf(updExp));
                        --mainExpCount;
                        --updatedExpCount;
                        break;
                    }
                }
                ++mainExpCount;
            }
            if (!equivalentExpFound) {
                updatedExpTobeProcessed.remove(updatedExpTobeProcessed.indexOf(updExp));
                --updatedExpCount;
                processed = processed && this.addNewExpression(updExp);
            }
            ++updatedExpCount;
        }
        int delExpCount = 0;
        while (delExpCount < mainExpTobeProcessed.size()) {
            CodeExpressionRef mainExp = (CodeExpressionRef)mainExpTobeProcessed.get(delExpCount);
            CodeExpressionRef parentExpression = null;
            Iterator newBeansItr = this.newModel.getBeans().iterator();
            block5: while (newBeansItr.hasNext() && parentExpression == null) {
                BeanPart newBean = (BeanPart)newBeansItr.next();
                List newBPParentExps = newBean.getParentExpressons();
                if (newBPParentExps == null || newBPParentExps.size() <= 0) continue;
                int ec = 0;
                while (ec < newBPParentExps.size()) {
                    String newExpInMethod;
                    CodeExpressionRef newParentExp = (CodeExpressionRef)newBPParentExps.get(ec);
                    String mainExpMethodName = mainExp.getMethodNameContent();
                    String mainExpInMethod = mainExp.getMethod() == null ? null : mainExp.getMethod().getMethodName();
                    String string = newExpInMethod = newParentExp.getMethod() == null ? null : newParentExp.getMethod().getMethodName();
                    if (mainExpMethodName != null && mainExpMethodName.equals(newParentExp.getMethodNameContent()) && mainExpInMethod != null && newExpInMethod != null && mainExpInMethod.equals(newExpInMethod)) {
                        parentExpression = newParentExp;
                        continue block5;
                    }
                    ++ec;
                }
            }
            if (parentExpression == null) {
                this.removeDeletedExpression(mainExp);
            } else {
                this.processEquivalentExpressions(mainExp, parentExpression, 1);
            }
            ++delExpCount;
        }
        return processed;
    }

    private List getExpressions(CodeMethodRef m) {
        ArrayList l = new ArrayList();
        Iterator itr = m.getAllExpressions();
        while (itr.hasNext()) {
            l.add(itr.next());
        }
        return l;
    }

    private CodeExpressionRef getMainBDMExpression(CodeExpressionRef exp) throws CodeGenException {
        if (exp == null || exp.getMethod() == null) {
            return null;
        }
        CodeMethodRef m = this.mainModel.getMethod(exp.getMethod().getMethodHandle());
        if (m == null) {
            return null;
        }
        Iterator itr = this.getExpressions(m).iterator();
        CodeExpressionRef result = null;
        while (itr.hasNext()) {
            CodeExpressionRef e = (CodeExpressionRef)itr.next();
            if (e == exp) {
                result = e;
                break;
            }
            int eqv = this.determineEquivalency(e, exp);
            if (eqv < 0) continue;
            if (eqv == 1) {
                result = e;
                break;
            }
            if (result != null) continue;
            result = e;
        }
        if (result != null) {
            this.getExpressions(m).remove(result);
            return result;
        }
        return null;
    }

    private CodeEventRef createNewEventExpression(CodeEventRef e, CodeMethodRef m, boolean decode) throws CodeGenException {
        BeanPart b = this.getMainBDMBean(e.getBean());
        if (b == null) {
            throw new CodeGenException("No Bean Part");
        }
        CodeEventRef newe = new CodeEventRef(m, b);
        newe.setState(4, e.isStateSet(4));
        newe.setState(4096, e.isStateSet(4096));
        newe.setState(128, true);
        newe.setExprStmt(e.getExprStmt());
        newe.setContent(e.getContentParser());
        newe.setOffset(e.getOffset());
        newe.setEventInvocation(e.getEventInvocation());
        if (decode && !newe.decodeExpression()) {
            newe.dispose();
            newe = null;
        }
        return newe;
    }

    private CodeExpressionRef createNewExpression(CodeExpressionRef e, CodeMethodRef m, boolean decode) throws CodeGenException {
        if (this.getMainBDMExpression(e) != null) {
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                JavaVEPlugin.log((Object)("BDM Merger >> Ignoring creation of duplicate Expression" + e.getCodeContent()), (Level)Level.FINER);
            }
            return null;
        }
        BeanPart b = this.getMainBDMBean(e.getBean());
        if (b == null) {
            throw new CodeGenException("No Bean Part");
        }
        ExpressionRefFactory gen = new ExpressionRefFactory(b, null);
        CodeExpressionRef newe = gen.createFromSource(e, m);
        newe.setState(4, e.isStateSet(4));
        newe.setState(4096, e.isStateSet(4096));
        if (decode) {
            if (!newe.decodeExpression()) {
                newe.dispose();
                newe = null;
            } else {
                CodeGenUtil.snoozeAlarm(b.getEObject(), this.mainModel.getCompositionModel().getModelResourceSet(), new HashMap());
            }
        }
        return newe;
    }

    protected boolean addNewExpression(CodeExpressionRef updateExp) {
        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
            JavaVEPlugin.log((Object)("BDM Merger >> Adding new expression " + updateExp.getCodeContent()), (Level)Level.FINER);
        }
        try {
            if (updateExp == null || updateExp.getMethod() == null) {
                return true;
            }
            CodeMethodRef mainMethod = this.mainModel.getMethod(updateExp.getMethod().getMethodHandle());
            if (mainMethod == null) {
                return true;
            }
            CodeExpressionRef newExp = this.createNewExpression(updateExp, mainMethod, !updateExp.isStateSet(4));
            if (newExp == null && updateExp instanceof CodeEventRef) {
                newExp = this.createNewEventExpression((CodeEventRef)updateExp, mainMethod, !updateExp.isStateSet(4));
            }
        }
        catch (CodeGenException e) {
            JavaVEPlugin.log((Throwable)((Object)e), (Level)Level.WARNING);
            return false;
        }
        return true;
    }

    private BeanPart getMainBDMBean(BeanPart b) {
        return this.determineCorrespondingBeanPart(b, this.mainModel);
    }

    protected boolean mergeAllBeans() {
        boolean merge = true;
        merge = merge && this.updateNonRegularBeanPartExpressions();
        merge = merge && this.updateRegularBeanPartExpressions();
        return merge;
    }

    protected boolean updateNonRegularBeanPartExpressions() {
        boolean merge = true;
        List mainModelBeans = this.mainModel.getBeans();
        mainModelBeans = this.orderBeansToMerge(mainModelBeans);
        Iterator mainModelBeansItr = mainModelBeans.iterator();
        while (mainModelBeansItr.hasNext()) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            BeanPart mainBP = (BeanPart)mainModelBeansItr.next();
            if (mainBP.getModel() == null) continue;
            BeanPart updateBP = this.determineCorrespondingBeanPart(mainBP, this.newModel);
            if (updateBP != null) {
                merge = merge && this.updateNonRegularBeanPartExpressions(mainBP, updateBP);
                continue;
            }
            JavaVEPlugin.log((Object)"BDM Merger: Unable to find main BDM bean in new BDM at this point", (Level)Level.WARNING);
        }
        return merge;
    }

    protected void orderBeanPartExpressions(BeanPart bp, List orderedList) {
        if (bp == null || bp.getRefExpressions() == null) {
            return;
        }
        Iterator bpExpItr = bp.getRefExpressions().iterator();
        while (bpExpItr.hasNext()) {
            CodeExpressionRef bpExp = (CodeExpressionRef)bpExpItr.next();
            int index = 0;
            index = 0;
            while (index < orderedList.size()) {
                CodeExpressionRef orderedExp = (CodeExpressionRef)orderedList.get(index);
                if (orderedExp.getOffset() > bpExp.getOffset()) break;
                ++index;
            }
            if (index < orderedList.size()) {
                orderedList.add(index, bpExp);
                continue;
            }
            orderedList.add(bpExp);
        }
    }

    protected boolean updateRegularBeanPartExpressions() {
        boolean update = true;
        HashMap beansInMethodMap = new HashMap();
        Iterator mainModelBeansItr = this.mainModel.getBeans().iterator();
        while (mainModelBeansItr.hasNext()) {
            BeanPart bp = (BeanPart)mainModelBeansItr.next();
            String key = "null";
            if (bp.getInitMethod() != null && bp.getInitMethod().getMethodHandle() != null) {
                key = bp.getInitMethod().getMethodHandle();
            }
            if (!beansInMethodMap.containsKey(key)) {
                beansInMethodMap.put(key, new ArrayList());
            }
            List list = (List)beansInMethodMap.get(key);
            list.add(bp);
        }
        Iterator methodHandleItr = beansInMethodMap.keySet().iterator();
        while (methodHandleItr.hasNext()) {
            ArrayList orderedMainExpressions = new ArrayList();
            ArrayList orderedUpdatedExpressions = new ArrayList();
            String key = (String)methodHandleItr.next();
            List beans = (List)beansInMethodMap.get(key);
            Iterator mainBeansItr = beans.iterator();
            while (mainBeansItr.hasNext()) {
                BeanPart mainBP = (BeanPart)mainBeansItr.next();
                if (mainBP.isDisposed() || mainBP.getModel() == null) continue;
                BeanPart updateBP = this.determineCorrespondingBeanPart(mainBP, this.newModel);
                if (updateBP != null) {
                    this.orderBeanPartExpressions(mainBP, orderedMainExpressions);
                    this.orderBeanPartExpressions(updateBP, orderedUpdatedExpressions);
                    continue;
                }
                JavaVEPlugin.log((Object)"BDM Merger: Unable to find main BDM bean in new BDM at this point", (Level)Level.WARNING);
            }
            update = update && this.processInitExpressions(orderedMainExpressions, orderedUpdatedExpressions);
            boolean bl = update = update && this.processExpressions(orderedMainExpressions, orderedUpdatedExpressions);
        }
        return update;
    }

    protected boolean processInitExpressions(List orderedMainExpressions, List orderedUpdatedExpressions) {
        CodeExpressionRef exp;
        boolean processed = true;
        ArrayList<CodeExpressionRef> mainInitExpressions = new ArrayList<CodeExpressionRef>();
        ArrayList<CodeExpressionRef> updateInitExpressions = new ArrayList<CodeExpressionRef>();
        int i = 0;
        while (i < orderedMainExpressions.size()) {
            exp = (CodeExpressionRef)orderedMainExpressions.get(i);
            if (exp.isStateSet(4096)) {
                orderedMainExpressions.remove(exp);
                --i;
                mainInitExpressions.add(exp);
            }
            ++i;
        }
        i = 0;
        while (i < orderedUpdatedExpressions.size()) {
            exp = (CodeExpressionRef)orderedUpdatedExpressions.get(i);
            if (exp.isStateSet(4096)) {
                orderedUpdatedExpressions.remove(exp);
                --i;
                updateInitExpressions.add(exp);
            }
            ++i;
        }
        int updatedExpCount = 0;
        while (updatedExpCount < updateInitExpressions.size()) {
            CodeExpressionRef updExp = (CodeExpressionRef)updateInitExpressions.get(updatedExpCount);
            boolean equivalentExpFound = false;
            int mainExpCount = 0;
            while (mainExpCount < mainInitExpressions.size()) {
                CodeExpressionRef mainExp = (CodeExpressionRef)mainInitExpressions.get(mainExpCount);
                if (mainExp != null && updExp != null && !updExp.isStateSet(256)) {
                    int equivalency = -1;
                    try {
                        equivalency = this.isSpecialEquivalent(mainExp, updExp);
                    }
                    catch (CodeGenException codeGenException) {}
                    if (equivalency >= 0) {
                        equivalentExpFound = true;
                        processed = processed && this.processEquivalentExpressions(mainExp, updExp, equivalency);
                        mainInitExpressions.remove(mainInitExpressions.indexOf(mainExp));
                        updateInitExpressions.remove(updateInitExpressions.indexOf(updExp));
                        --mainExpCount;
                        --updatedExpCount;
                        break;
                    }
                }
                ++mainExpCount;
            }
            if (!equivalentExpFound) {
                updateInitExpressions.remove(updateInitExpressions.indexOf(updExp));
                --updatedExpCount;
                processed = processed && this.addNewExpression(updExp);
            }
            ++updatedExpCount;
        }
        int delExpCount = 0;
        while (delExpCount < mainInitExpressions.size()) {
            CodeExpressionRef mainExp = (CodeExpressionRef)mainInitExpressions.get(delExpCount);
            this.removeDeletedExpression(mainExp);
            ++delExpCount;
        }
        return processed;
    }

    protected BeanPart determineCorrespondingBeanPart(BeanPart otherModelBP, IBeanDeclModel model) {
        BeanPart modelBP = null;
        if (this.newBDMToMainBDMBeanPartMap.size() > 0) {
            if (this.newBDMToMainBDMBeanPartMap.containsKey(otherModelBP)) {
                modelBP = (BeanPart)this.newBDMToMainBDMBeanPartMap.get(otherModelBP);
            } else if (this.newBDMToMainBDMBeanPartMap.containsValue(otherModelBP)) {
                Iterator keysItr = this.newBDMToMainBDMBeanPartMap.keySet().iterator();
                while (keysItr.hasNext()) {
                    BeanPart keyBP = (BeanPart)keysItr.next();
                    if (this.newBDMToMainBDMBeanPartMap.get(keyBP) != otherModelBP) continue;
                    modelBP = keyBP;
                }
            }
        }
        if (modelBP == null) {
            BeanPart[] modelBPs;
            BeanPartDecleration otherModelBPDecl = otherModelBP.getDecleration();
            BeanPartDecleration modelBPDecl = model.getModelDecleration(otherModelBPDecl);
            this.updateBPDeclAST(otherModelBPDecl, modelBPDecl);
            BeanPart[] beanPartArray = modelBPs = modelBPDecl == null ? null : modelBPDecl.getBeanParts();
            if (modelBPs != null && modelBPs.length > 0) {
                int i = 0;
                while (i < modelBPs.length) {
                    if (otherModelBP.isEquivalent(modelBPs[i])) {
                        modelBP = modelBPs[i];
                        break;
                    }
                    ++i;
                }
            } else {
                modelBP = model.getABean(otherModelBP.getUniqueName());
            }
            if (modelBP != null && (this.newBDMToMainBDMBeanPartMap.containsValue(modelBP) || this.newBDMToMainBDMBeanPartMap.containsKey(modelBP))) {
                modelBP = null;
            }
        }
        return modelBP;
    }

    private void updateBPDeclAST(BeanPartDecleration otherModelBPDecl, BeanPartDecleration mainModelBPDecl) {
        if (otherModelBPDecl != null && mainModelBPDecl != null) {
            if (otherModelBPDecl.getFieldDeclHandle() != null && mainModelBPDecl.getFieldDeclHandle() != null && otherModelBPDecl.getFieldDeclHandle().equals(mainModelBPDecl.getFieldDeclHandle())) {
                mainModelBPDecl.setFieldDecl(otherModelBPDecl.getFieldDecl());
            } else if (otherModelBPDecl.getDeclerationHandle() != null && mainModelBPDecl.getDeclerationHandle() != null && otherModelBPDecl.getDeclerationHandle().equals(mainModelBPDecl.getDeclerationHandle())) {
                mainModelBPDecl.setFieldDecl(otherModelBPDecl.getFieldDecl());
            }
        }
    }

    protected List orderBeansToMerge(List mainModelBeans) {
        ArrayList<BeanPart> orderedBeans = new ArrayList<BeanPart>();
        if (mainModelBeans != null && mainModelBeans.size() > 0 && this.changedHandles != null && this.changedHandles.size() > 0) {
            Iterator mBeans = mainModelBeans.iterator();
            while (mBeans.hasNext()) {
                BeanPart mainBean = (BeanPart)mBeans.next();
                if (mainBean == null) continue;
                if (this.changedHandles.contains(mainBean.getFieldDeclHandle()) || mainBean.getInitMethod() != null && this.changedHandles.contains(mainBean.getInitMethod().getMethodHandle()) || mainBean.getReturnedMethod() != null && this.changedHandles.contains(mainBean.getReturnedMethod().getMethodHandle())) {
                    orderedBeans.add(0, mainBean);
                    continue;
                }
                orderedBeans.add(mainBean);
            }
        } else {
            orderedBeans.addAll(mainModelBeans);
        }
        return orderedBeans;
    }

    protected ISourceRange createSourceRange(final int offset, final int len) {
        return new ISourceRange(){

            public int getLength() {
                return len;
            }

            public int getOffset() {
                return offset;
            }
        };
    }

    protected List createNewBeanJavaInstance(BeanPart newBP) {
        ArrayList<BeanPart> err;
        block13: {
            err = new ArrayList<BeanPart>();
            try {
                BeanSubclassComposition comp = this.mainModel.getCompositionModel().getModelRoot();
                EObject obj = newBP.createEObject();
                String annotatedName = newBP.getSimpleName();
                if (!newBP.getSimpleName().equals("this")) {
                    if (!(obj instanceof IJavaObjectInstance)) {
                        obj = null;
                        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                            JavaVEPlugin.log((Object)("Bad Object: " + newBP.getType() + ": " + newBP.getUniqueName()), (Level)Level.FINE);
                        }
                    }
                } else if (obj != null) {
                    ((XMIResource)comp.eResource()).setID(obj, "this");
                    annotatedName = null;
                }
                if (obj == null) {
                    if (JavaVEPlugin.isLoggingLevel((Level)Level.FINE)) {
                        JavaVEPlugin.log((Object)("Could not create a JavaObjectInstance for: " + newBP.getType() + ": " + newBP.getUniqueName()), (Level)Level.FINE);
                    }
                    err.add(newBP);
                    Iterator bItr = newBP.getChildren();
                    if (bItr != null) {
                        while (bItr.hasNext()) {
                            err.add((BeanPart)bItr.next());
                        }
                    }
                    newBP.setEObject(null);
                } else {
                    Annotation an = CodeGenUtil.addAnnotation(obj);
                    if (annotatedName != null) {
                        CodeGenUtil.addAnnotatedName(an, annotatedName);
                    }
                    comp.getAnnotations().add((Object)an);
                }
            }
            catch (CodeGenException e) {
                if (!JavaVEPlugin.isLoggingLevel((Level)Level.WARNING)) break block13;
                JavaVEPlugin.log((Object)("Exception when creating EObject for BeanPart " + newBP.getType() + " with message " + e.getMessage()), (Level)Level.WARNING);
            }
        }
        return err;
    }

    protected boolean addNewBean(BeanPart referenceBP) {
        CodeMethodRef retMethod;
        String refBPHandle = referenceBP.getDecleration().getDeclerationHandle();
        BeanPartDecleration decl = this.mainModel.getModelDecleration(refBPHandle);
        int uniqueIndex = 0;
        if (decl == null) {
            ASTNode fd = referenceBP.getFieldDecl();
            decl = fd != null ? (referenceBP.getFieldDecl() instanceof FieldDeclaration ? new BeanPartDecleration((FieldDeclaration)referenceBP.getFieldDecl()) : new BeanPartDecleration((VariableDeclarationStatement)referenceBP.getFieldDecl())) : new BeanPartDecleration(referenceBP.getDecleration().getName(), referenceBP.getDecleration().getType());
        } else {
            uniqueIndex = Integer.MAX_VALUE;
            BeanPart[] bps = decl.getBeanParts();
            int uniqueNum = 0;
            while (uniqueNum <= bps.length) {
                boolean used = false;
                int i = 0;
                while (i < bps.length) {
                    if (bps[i].getUniqueIndex() == uniqueNum) {
                        used = true;
                        break;
                    }
                    ++i;
                }
                if (!used) {
                    uniqueIndex = uniqueNum;
                    break;
                }
                ++uniqueNum;
            }
            if (uniqueIndex == Integer.MAX_VALUE) {
                JavaVEPlugin.log((Object)"Should be having an unique number!", (Level)Level.FINE);
                uniqueIndex = bps.length;
            }
        }
        BeanPart newBP = new BeanPart(decl);
        newBP.setInstanceInstantiation(referenceBP.isInstanceInstantiation());
        newBP.setUniqueIndex(uniqueIndex);
        newBP.setIsInJVEModel(false);
        if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
            JavaVEPlugin.log((Object)("BDM Merger >> Created new BP " + newBP.getSimpleName()), (Level)Level.FINER);
        }
        CodeMethodRef initMethod = null;
        initMethod = this.mainModel.getMethod(referenceBP.getInitMethod().getMethodHandle());
        if (initMethod == null) {
            initMethod = this.createNewMainMethodRef(referenceBP.getInitMethod());
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                JavaVEPlugin.log((Object)("BDM Merger >> Created new init method " + initMethod.getMethodHandle() + " for new bean part" + newBP.getSimpleName()), (Level)Level.FINER);
            }
        }
        newBP.addInitMethod(initMethod);
        if (referenceBP.getDecleration().isInstanceVar()) {
            decl.setDeclaringMethod(null);
        } else {
            decl.setDeclaringMethod(initMethod);
        }
        newBP.setModel(this.mainModel);
        this.mainModel.addBean(newBP);
        CodeMethodRef referenceReturnMethod = referenceBP.getReturnedMethod();
        if (referenceReturnMethod != null && (retMethod = this.mainModel.getMethod(referenceReturnMethod.getMethodHandle())) != null) {
            newBP.addReturnMethod(retMethod);
        }
        try {
            newBP.addToJVEModel();
        }
        catch (CodeGenException e) {
            JavaVEPlugin.log((Throwable)((Object)e));
            newBP.dispose();
            return false;
        }
        List errorBeans = this.createNewBeanJavaInstance(newBP);
        if (errorBeans.size() > 0) {
            Iterator iter = errorBeans.iterator();
            while (iter.hasNext()) {
                BeanPart errBP = (BeanPart)iter.next();
                errBP.dispose();
            }
        }
        this.newBDMToMainBDMBeanPartMap.put(referenceBP, newBP);
        return true;
    }

    protected boolean createThisBean(BeanPart referenceBP) {
        this.mainModel.setTypeDecleration(referenceBP.getModel().getTypeDecleration());
        IThisReferenceRule thisRule = (IThisReferenceRule)CodeGenUtil.getEditorStyle(this.mainModel).getRule("ruleIThisReference");
        TypeResolver resolver = referenceBP.getModel().getResolver();
        String typeName = resolver.resolveMain().getName();
        TypeResolver.ResolvedType superResolve = null;
        if (referenceBP.getModel().getTypeRef().getTypeDecl().getSuperclass() != null) {
            superResolve = resolver.resolveType(referenceBP.getModel().getTypeRef().getTypeDecl().getSuperclass());
        }
        ResourceSet rs = this.mainModel.getCompositionModel().getModelResourceSet();
        if (superResolve != null && thisRule.useInheritance(((TypeResolver.Resolved)superResolve).getName(), rs) || thisRule.useInheritance(typeName, rs)) {
            BeanPartFactory bpg = new BeanPartFactory(this.mainModel, null);
            BeanPart thisBP = bpg.createThisBeanPartIfNeeded(null);
            if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                JavaVEPlugin.log((Object)("BDM Merger >> Successfully created this bean part : " + thisBP.getSimpleName()), (Level)Level.FINER);
            }
            CodeMethodRef initMethod = null;
            initMethod = this.mainModel.getMethod(referenceBP.getInitMethod().getMethodHandle());
            if (initMethod == null) {
                CodeMethodRef updatedMethodRef = referenceBP.getInitMethod();
                initMethod = new CodeMethodRef(updatedMethodRef.getDeclMethod(), this.mainModel.getTypeRef(), updatedMethodRef.getMethodHandle(), this.createSourceRange(updatedMethodRef.getOffset(), updatedMethodRef.getLen()), updatedMethodRef.getContent());
                initMethod.setModel(this.mainModel);
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Successfully created init method for this bean part " + initMethod.getMethodHandle()), (Level)Level.FINER);
                }
            }
            thisBP.addInitMethod(initMethod);
            List errorBeans = this.createNewBeanJavaInstance(thisBP);
            if (errorBeans.size() > 0) {
                Iterator iter = errorBeans.iterator();
                while (iter.hasNext()) {
                    BeanPart errBP = (BeanPart)iter.next();
                    if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                        JavaVEPlugin.log((Object)("BDM Merger >> Disposing bean part " + errBP.getSimpleName() + " when createing java instance for " + referenceBP.getSimpleName()), (Level)Level.FINER);
                    }
                    errBP.dispose();
                }
            }
        }
        return true;
    }

    protected boolean addNewBeans() {
        boolean add = true;
        Iterator newBeansItr = this.newModel.getBeans().iterator();
        while (newBeansItr.hasNext()) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            BeanPart beanPart = (BeanPart)newBeansItr.next();
            if (this.determineCorrespondingBeanPart(beanPart, this.mainModel) != null || beanPart.getInitMethod() == null) continue;
            this.monitor.subTask(beanPart.getSimpleName());
            if (beanPart.getSimpleName().equals("this")) {
                add = add && this.createThisBean(beanPart);
                continue;
            }
            boolean bl = add = add && this.addNewBean(beanPart);
        }
        return add;
    }

    protected boolean removeDeletedBean(BeanPart b) {
        boolean remove = false;
        if (b != null) {
            EObject eObject = b.getEObject();
            ArrayList<CodeExpressionRef> toDeleteExpressions = new ArrayList<CodeExpressionRef>();
            Iterator expItr = b.getInitMethod().getAllExpressions();
            while (expItr.hasNext()) {
                CodeExpressionRef exp = (CodeExpressionRef)expItr.next();
                if (b.equals(exp.getBean())) continue;
                Object[] addedInstances = exp.getAddedInstances();
                int i = 0;
                while (addedInstances != null && i < addedInstances.length) {
                    if (eObject == addedInstances[i] && !ChildRelationshipDecoderHelper.isChildRelationship(exp.getSF()) && !toDeleteExpressions.contains(exp)) {
                        toDeleteExpressions.add(exp);
                    }
                    ++i;
                }
            }
            Iterator iter = toDeleteExpressions.iterator();
            while (iter.hasNext()) {
                CodeExpressionRef exp = (CodeExpressionRef)iter.next();
                exp.dispose();
            }
            b.dispose();
            remove = true;
        }
        return remove;
    }

    protected boolean removeDeletedBeans() {
        boolean removed = true;
        ArrayList<BeanPartDecleration> visitedDecls = new ArrayList<BeanPartDecleration>();
        Iterator mainBeansItr = this.mainModel.getBeans().iterator();
        while (mainBeansItr.hasNext()) {
            int i;
            BeanPart[] newBPs;
            BeanPartDecleration mainBeanDecl;
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            BeanPart mainBean = (BeanPart)mainBeansItr.next();
            if (mainBean.isDisposed() || visitedDecls.contains(mainBeanDecl = mainBean.getDecleration())) continue;
            visitedDecls.add(mainBeanDecl);
            BeanPart[] mainBPs = mainBeanDecl.getBeanParts();
            if (mainBPs == null || mainBPs.length < 1) {
                JavaVEPlugin.log((Object)"BDMMerger: BPDecl with no BPs - shouldnt be so", (Level)Level.WARNING);
            }
            ArrayList<BeanPart> toDeleteBeansList = new ArrayList<BeanPart>();
            BeanPartDecleration newBPDecl = this.newModel.getModelDecleration(mainBeanDecl);
            BeanPart[] beanPartArray = newBPs = newBPDecl == null ? new BeanPart[]{} : newBPDecl.getBeanParts();
            if (mainBPs.length != newBPs.length) {
                i = 0;
                while (i < mainBPs.length) {
                    toDeleteBeansList.add(mainBPs[i]);
                    ++i;
                }
            } else {
                i = 0;
                while (i < mainBPs.length) {
                    if (this.shouldRemoveMainBean(mainBPs[i], newBPs[i])) {
                        toDeleteBeansList.add(mainBPs[i]);
                    }
                    ++i;
                }
            }
            Iterator toDeleteBPItr = toDeleteBeansList.iterator();
            while (toDeleteBPItr.hasNext()) {
                BeanPart bp = (BeanPart)toDeleteBPItr.next();
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Removing deleted bean " + bp.getSimpleName()), (Level)Level.FINER);
                }
                this.monitor.subTask(bp.getSimpleName());
                boolean bl = removed = removed && this.removeDeletedBean(bp);
            }
        }
        return removed;
    }

    protected boolean shouldRemoveMainBean(BeanPart mainBean, BeanPart newBean) {
        boolean typeChanged;
        TypeResolver.ResolvedType resolveType;
        boolean shouldRemove = false;
        boolean isMainBeanThisPart = mainBean.getSimpleName().equals("this");
        boolean isNewBeanThisPart = newBean.getSimpleName().equals("this");
        Name mainBeanExtendsName = isMainBeanThisPart && mainBean.getModel().getTypeDecleration() != null ? mainBean.getModel().getTypeDecleration().getSuperclass() : null;
        Name newBeanExtendsName = isNewBeanThisPart && newBean.getModel().getTypeDecleration() != null ? newBean.getModel().getTypeDecleration().getSuperclass() : null;
        TypeResolver resolver = mainBean.getModel().getResolver();
        String mainType = isMainBeanThisPart && mainBeanExtendsName != null ? ((resolveType = resolver.resolveType(mainBeanExtendsName)) != null ? resolveType.getName() : null) : mainBean.getType();
        String newType = isNewBeanThisPart && newBeanExtendsName != null ? ((resolveType = resolver.resolveType(newBeanExtendsName)) != null ? resolveType.getName() : null) : newBean.getType();
        boolean bl = typeChanged = mainType == null || newType == null || !mainType.equals(newType);
        if (typeChanged) {
            this.monitor.subTask(mainBean.getSimpleName());
            if (isMainBeanThisPart) {
                if (newBeanExtendsName == null) {
                    if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                        JavaVEPlugin.log((Object)"BDM Merger >> Removing THIS bean ", (Level)Level.FINER);
                    }
                    shouldRemove = true;
                } else {
                    if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                        JavaVEPlugin.log((Object)"BDM Merger >> This part's type has changed - will need to reload", (Level)Level.FINER);
                    }
                    shouldRemove = true;
                }
            } else {
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Removing changed type bean " + mainBean.getSimpleName()), (Level)Level.FINER);
                }
                shouldRemove = true;
            }
        } else {
            CodeMethodRef mainMethod = mainBean.getInitMethod();
            CodeMethodRef newMethod = newBean.getInitMethod();
            if (mainMethod != null && newMethod != null) {
                String mainMethodHandle = mainMethod.getMethodHandle();
                String newMethodHandle = newMethod.getMethodHandle();
                if (mainMethodHandle == null || newMethodHandle == null || !mainMethodHandle.equals(newMethodHandle)) {
                    if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                        JavaVEPlugin.log((Object)("BDM Merger >> Removing changed init method bean " + mainBean.getSimpleName()), (Level)Level.FINER);
                    }
                    shouldRemove = true;
                }
            }
        }
        return shouldRemove;
    }

    protected CodeMethodRef createNewMainMethodRef(CodeMethodRef newMethodRef) {
        BeanPart mainReturnedBP;
        CodeMethodRef mainMethodRef = new CodeMethodRef(newMethodRef.getDeclMethod(), this.mainModel.getTypeRef(), newMethodRef.getMethodHandle(), this.createSourceRange(newMethodRef.getOffset(), newMethodRef.getLen()), newMethodRef.getContent());
        mainMethodRef.setModel(this.mainModel);
        BeanPart updateReturnedBP = this.newModel.getBeanReturned(newMethodRef.getMethodName());
        if (updateReturnedBP != null && (mainReturnedBP = this.determineCorrespondingBeanPart(updateReturnedBP, this.mainModel)) != null) {
            mainReturnedBP.addReturnMethod(mainMethodRef);
        }
        return mainMethodRef;
    }

    protected boolean addThisMethod() {
        boolean add = true;
        Iterator newBeansItr = this.newModel.getBeans().iterator();
        while (newBeansItr.hasNext()) {
            BeanPart mainBP;
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (this.mainModel.isStateSet(1)) {
                return true;
            }
            BeanPart beanPart = (BeanPart)newBeansItr.next();
            if (!"this".equals(beanPart.getSimpleName()) || this.mainModel.getABean(beanPart.getSimpleName()) == null || (mainBP = this.mainModel.getABean(beanPart.getSimpleName())).getInitMethod() != null || beanPart.getInitMethod() == null) continue;
            CodeMethodRef initMethod = this.mainModel.getMethod(beanPart.getInitMethod().getMethodHandle());
            this.monitor.subTask(initMethod.getMethodName());
            if (initMethod == null) {
                initMethod = this.createNewMainMethodRef(beanPart.getInitMethod());
                if (JavaVEPlugin.isLoggingLevel((Level)Level.FINER)) {
                    JavaVEPlugin.log((Object)("BDM Merger >> Created new init method " + initMethod.getMethodHandle() + " for THIS part"), (Level)Level.FINER);
                }
            }
            mainBP.addInitMethod(initMethod);
        }
        return add;
    }

    protected boolean updateEventHandler(CodeEventHandlerRef mainEH, CodeEventHandlerRef updatedEH) {
        ArrayList mainEHMethods = new ArrayList();
        ArrayList updatedEHMethods = new ArrayList();
        Iterator iter = mainEH.getMethods();
        while (iter.hasNext()) {
            mainEHMethods.add(iter.next());
        }
        iter = updatedEH.getMethods();
        while (iter.hasNext()) {
            updatedEHMethods.add(iter.next());
        }
        int mainMtdCount = 0;
        while (mainMtdCount < mainEHMethods.size()) {
            CodeMethodRef mainMethod = (CodeMethodRef)mainEHMethods.get(mainMtdCount);
            boolean suitableMethodFound = false;
            int updMtdCount = 0;
            while (updMtdCount < updatedEHMethods.size()) {
                CodeMethodRef updMethod = (CodeMethodRef)updatedEHMethods.get(updMtdCount);
                if (mainMethod.getMethodName().equals(updMethod.getMethodName())) {
                    suitableMethodFound = true;
                    mainEHMethods.remove(mainMethod);
                    --mainMtdCount;
                    updatedEHMethods.remove(updMethod);
                    --updMtdCount;
                    this.updateMethodOffsetAndContent(mainMethod, updMethod);
                }
                ++updMtdCount;
            }
            if (!suitableMethodFound) {
                mainEHMethods.remove(mainMethod);
                --mainMtdCount;
                mainMethod.dispose();
            }
            ++mainMtdCount;
        }
        int updMtdCount = 0;
        while (updMtdCount < updatedEHMethods.size()) {
            CodeMethodRef updMethod = (CodeMethodRef)updatedEHMethods.get(updMtdCount);
            new CodeMethodRef(updMethod.getDeclMethod(), mainEH, updMethod.getMethodHandle(), this.createSourceRange(updMethod.getOffset(), updMethod.getLen()), updMethod.getContent());
            ++updMtdCount;
        }
        return true;
    }

    protected boolean updateEventHandlers() {
        ArrayList mainEventHandlers = new ArrayList(this.mainModel.getEventHandlers());
        ArrayList updatedEventHandlers = new ArrayList(this.newModel.getEventHandlers());
        int mainEHC = 0;
        while (mainEHC < mainEventHandlers.size()) {
            if (this.monitor.isCanceled()) {
                return false;
            }
            CodeEventHandlerRef mainEventHandler = (CodeEventHandlerRef)mainEventHandlers.get(mainEHC);
            String mainEventHanlderName = mainEventHandler.getName();
            boolean suitableEventHandlerFound = false;
            int updEHC = 0;
            while (updEHC < updatedEventHandlers.size()) {
                CodeEventHandlerRef updEventHandler = (CodeEventHandlerRef)updatedEventHandlers.get(updEHC);
                if (mainEventHanlderName.equals(updEventHandler.getName())) {
                    suitableEventHandlerFound = true;
                    mainEventHandlers.remove(mainEventHandler);
                    --mainEHC;
                    updatedEventHandlers.remove(updEventHandler);
                    --updEHC;
                    this.updateEventHandler(mainEventHandler, updEventHandler);
                    break;
                }
                ++updEHC;
            }
            if (!suitableEventHandlerFound) {
                this.monitor.subTask(mainEventHanlderName);
                mainEventHandlers.remove(mainEventHandler);
                --mainEHC;
                mainEventHandler.dispose();
            }
            ++mainEHC;
        }
        int updEHC = 0;
        while (updEHC < updatedEventHandlers.size()) {
            CodeEventHandlerRef newEventHandler = (CodeEventHandlerRef)updatedEventHandlers.get(updEHC);
            this.createNewEventHandler(newEventHandler);
            ++updEHC;
        }
        return true;
    }

    private void createNewEventHandler(CodeEventHandlerRef updateEventHandler) {
        CodeEventHandlerRef newEventHandler = new CodeEventHandlerRef(updateEventHandler.getTypeDecl(), this.mainModel);
        this.mainModel.getEventHandlers().add(newEventHandler);
        Iterator iter = updateEventHandler.getMethods();
        while (iter.hasNext()) {
            CodeMethodRef updateEventHandlerMethod = (CodeMethodRef)iter.next();
            new CodeMethodRef(updateEventHandlerMethod.getDeclMethod(), newEventHandler, updateEventHandlerMethod.getMethodHandle(), this.createSourceRange(updateEventHandlerMethod.getOffset(), updateEventHandlerMethod.getLen()), updateEventHandlerMethod.getContent());
        }
    }
}

