/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.java.codegen.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.internal.instantiation.InitStringAllocation;
import org.eclipse.jem.internal.instantiation.JavaAllocation;
import org.eclipse.jem.internal.instantiation.PTInstanceReference;
import org.eclipse.jem.internal.instantiation.ParseTreeAllocation;
import org.eclipse.jem.internal.instantiation.ParseVisitor;
import org.eclipse.jem.internal.instantiation.base.IJavaObjectInstance;
import org.eclipse.jem.internal.instantiation.impl.NaiveExpressionFlattener;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.ve.internal.java.codegen.model.BeanPart;
import org.eclipse.ve.internal.java.codegen.model.IBeanDeclModel;

public class CodeGenExpFlattener
extends NaiveExpressionFlattener {
    IBeanDeclModel fmodel;
    List fimportList;
    List frefList;
    List visitedList = new ArrayList();

    public CodeGenExpFlattener(IBeanDeclModel model) {
        this(model, null, null);
    }

    public CodeGenExpFlattener(IBeanDeclModel model, List importList, List refList) {
        this.fmodel = model;
        this.fimportList = importList;
        this.frefList = refList;
    }

    public boolean visit(PTInstanceReference node) {
        BeanPart bp;
        IJavaObjectInstance obj = node.getObject();
        if (this.frefList != null && !this.frefList.contains(obj)) {
            this.frefList.add(obj);
        }
        if ((bp = this.fmodel.getABean((EObject)obj)) != null) {
            if (bp.getReturnedMethod() != null) {
                this.getStringBuffer().append(String.valueOf(bp.getReturnedMethod().getMethodName()) + "()");
            } else {
                this.getStringBuffer().append(bp.getSimpleName());
            }
        } else if (obj != null && obj.eContainer() != null) {
            if (obj.isSetAllocation() && !this.visitedList.contains(obj)) {
                JavaAllocation alloc = obj.getAllocation();
                if (alloc instanceof InitStringAllocation) {
                    this.getStringBuffer().append(((InitStringAllocation)alloc).getInitString());
                } else if (alloc instanceof ParseTreeAllocation) {
                    this.visitedList.add(obj);
                    ((ParseTreeAllocation)alloc).getExpression().accept((ParseVisitor)this);
                }
            } else {
                this.getStringBuffer().append("new ");
                this.getStringBuffer().append(this.handleQualifiedName(obj.getJavaType().getJavaName()));
                this.getStringBuffer().append("()");
            }
        }
        return false;
    }

    protected String handleQualifiedName(String qName) {
        if (this.fimportList != null) {
            JavaHelpers clazz = JavaRefFactory.eINSTANCE.reflectType(qName, (EObject)this.fmodel.getCompositionModel().getModelRoot());
            if (!this.fimportList.contains(clazz.getJavaName())) {
                this.fimportList.add(clazz.getJavaName());
            }
            return clazz.getName();
        }
        return qName;
    }
}

